/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

public class ArchiveURIConverterImpl
extends URIConverterImpl {
    protected static final String fileProtocol = "file";
    protected static final String platformProtocol = "platform";
    private String inFilepath;
    private String outFilepath;
    protected Archive archive;
    protected String resourcesPath;

    public ArchiveURIConverterImpl(Archive anArchive, String resourcesPath) {
        LoadStrategy l;
        this.setArchive(anArchive);
        this.resourcesPath = resourcesPath;
        this.setInputFilepath(resourcesPath);
        String outpath = resourcesPath;
        if (outpath == null && (l = anArchive.getLoadStrategy()) != null && l.isDirectory()) {
            try {
                outpath = l.getAbsolutePath();
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        this.setOutputFilepath(outpath);
    }

    public Archive getArchive() {
        return this.archive;
    }

    public InputStream createInputStream(URI uri) throws IOException {
        InputStream in = null;
        if (this.resourcesPath != null) {
            in = this.makeInputStream(uri);
        }
        if (in != null) {
            return in;
        }
        return this.getArchive().getInputStream(uri.toString());
    }

    public void setArchive(Archive newArchive) {
        this.archive = newArchive;
    }

    public String getResourcesPath() {
        return this.resourcesPath;
    }

    public void setResourcesPath(String resourcesPath) {
        this.resourcesPath = resourcesPath;
        this.setInputFilepath(resourcesPath);
        this.setOutputFilepath(resourcesPath);
    }

    public URI normalize(URI uri) {
        return this.getInternalURIMap().getURI(uri);
    }

    public String getInputFilepath() {
        return this.inFilepath;
    }

    public void setInputFilepath(String filepath) {
        this.inFilepath = filepath;
    }

    public String getOutputFilepath() {
        return this.outFilepath;
    }

    public void setOutputFilepath(String filepath) {
        this.outFilepath = filepath;
    }

    public InputStream makeInputStream(URI uri) throws IOException {
        URI converted = uri;
        if ((fileProtocol.equals(converted.scheme()) || converted.scheme() == null) && this.inFilepath != null) {
            return this.searchFilePath(converted.toString());
        }
        URL url = this.createURL(converted.toString());
        URLConnection urlConnection = url.openConnection();
        return urlConnection.getInputStream();
    }

    protected InputStream searchFilePath(String filename) throws IOException {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return new FileInputStream(file);
        }
        StringTokenizer st = new StringTokenizer(this.inFilepath, ";");
        while (st.hasMoreTokens()) {
            String f = st.nextToken();
            ZipFile zf = null;
            try {
                zf = new ZipFile(f);
            }
            catch (Exception exception) {}
            InputStream in = null;
            if (zf != null) {
                in = this.searchZipFile(zf, filename);
                if (in == null) {
                    try {
                        zf.close();
                    }
                    catch (Exception exception) {}
                }
            } else {
                in = this.searchDirectory(f, filename);
            }
            if (in == null) continue;
            return in;
        }
        return null;
    }

    protected InputStream searchDirectory(String dir, String filename) throws IOException {
        File f;
        if (dir.equals(".")) {
            dir = System.getProperty("user.dir");
        }
        if (!(f = new File(String.valueOf(dir) + System.getProperty("file.separator") + filename.replace('/', File.separatorChar))).exists()) {
            return null;
        }
        return new FileInputStream(f);
    }

    protected InputStream searchZipFile(ZipFile zip, String filename) throws IOException {
        ZipEntry entry = zip.getEntry(filename);
        if (entry == null) {
            return null;
        }
        return zip.getInputStream(entry);
    }

    public URL createURL(String uri) throws MalformedURLException {
        MalformedURLException m = null;
        if (uri == null) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (Exception e) {
            m = (MalformedURLException)e;
        }
        if (url != null) {
            return url;
        }
        int index = uri.indexOf(":");
        if (index == -1 || index == 1) {
            uri = "file:" + uri;
        } else if (index > 0) {
            uri = "file:" + uri.substring(index + 1);
        }
        try {
            url = new URL(uri);
        }
        catch (Exception exception) {}
        if (url != null) {
            return url;
        }
        throw m;
    }

    public OutputStream createOutputStream(URI uri) throws IOException {
        URL resolvedURL;
        URI converted = uri;
        if (platformProtocol.equals(converted.scheme()) && (resolvedURL = this.resolvePlatform(new URL(converted.toString()))) != null) {
            converted = URI.createFileURI(resolvedURL.getFile());
        }
        if (fileProtocol.equals(converted.scheme()) || converted.scheme() == null) {
            return this.openFileOutputStream(converted);
        }
        URL url = this.createURL(converted.toString());
        URLConnection urlConnection = url.openConnection();
        urlConnection.setDoOutput(true);
        return urlConnection.getOutputStream();
    }

    protected URL resolvePlatform(URL url) throws IOException {
        return null;
    }

    protected OutputStream openFileOutputStream(URI uri) throws IOException {
        String parent;
        File file = new File(uri.toFileString());
        if (!file.isAbsolute() && this.outFilepath != null) {
            file = new File(String.valueOf(this.outFilepath) + File.separator + uri.toFileString());
        }
        if ((parent = file.getParent()) != null) {
            new File(parent).mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        return outputStream;
    }
}

