/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEUtilityJarImportAssistantOperation;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class CopyArchiveIntoProjectOperation
extends J2EEUtilityJarImportAssistantOperation {
    public CopyArchiveIntoProjectOperation(File utilityJar) {
        super(NLS.bind(EARCreationResourceHandler.CopyArchiveIntoProjectOperation_Copying_archive_into_selected_proje_, utilityJar.getName()), utilityJar);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        MultiStatus status = new MultiStatus("org.eclipse.jst.j2ee", 0, NLS.bind(EARCreationResourceHandler.CopyArchiveIntoProjectOperation_Copying_archive_into_selected_proje_, this.getUtilityJar().getName()), null);
        try {
            IFile copiedJarFile = null;
            IProject associatedEARProject = this.getWorkspaceRoot().getProject(this.getAssociatedEARProjectName());
            IVirtualComponent earComponent = ComponentCore.createComponent((IProject)associatedEARProject);
            IContainer underlyingFolder = earComponent.getRootFolder().getUnderlyingFolder();
            copiedJarFile = underlyingFolder.isAccessible() ? underlyingFolder.getFile((IPath)new Path(this.getUtilityJar().getName())) : associatedEARProject.getFile(this.getUtilityJar().getName());
            if (copiedJarFile.exists()) {
                if (!this.isOverwriteIfNecessary()) {
                    status.add(J2EEPlugin.createErrorStatus(0, NLS.bind(EARCreationResourceHandler.CopyArchiveIntoProjectOperation_Found_existing_file_0_, copiedJarFile), null));
                    return status;
                }
                copiedJarFile.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            FileInputStream fileInputStream = null;
            ByteArrayOutputStream bos = null;
            ByteArrayInputStream jarFileInputStream = null;
            try {
                try {
                    block18: {
                        fileInputStream = new FileInputStream(this.getUtilityJar());
                        bos = new ByteArrayOutputStream();
                        byte[] data = new byte[4096];
                        try {
                            int bytesRead = 0;
                            while (true) {
                                block19: {
                                    if ((bytesRead = fileInputStream.read(data)) > 0) break block19;
                                    data = null;
                                    break;
                                }
                                bos.write(data, 0, bytesRead);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_19 = null;
                            if (fileInputStream == null) throw throwable;
                            fileInputStream.close();
                            throw throwable;
                        }
                        {
                            Object var13_20 = null;
                            if (fileInputStream == null) break block18;
                        }
                        fileInputStream.close();
                    }
                    jarFileInputStream = new ByteArrayInputStream(bos.toByteArray());
                    copiedJarFile.create((InputStream)jarFileInputStream, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.addLibraryToClasspath(associatedEARProject, copiedJarFile, monitor);
                    this.createVirtualArchiveComponent(associatedEARProject, this.getUtilityJar().getName(), copiedJarFile, monitor);
                }
                catch (FileNotFoundException e) {
                    status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
                    J2EEPlugin.logError(0, e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
                    J2EEPlugin.logError(0, e.getMessage(), e);
                }
                catch (InterruptedException e) {
                    status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
                    J2EEPlugin.logError(0, e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                if (bos != null) {
                    bos.close();
                }
                if (jarFileInputStream == null) throw throwable;
                jarFileInputStream.close();
                throw throwable;
            }
            {
                Object var15_23 = null;
                if (bos != null) {
                    bos.close();
                }
                if (jarFileInputStream == null) return status;
                jarFileInputStream.close();
                return status;
            }
        }
        catch (IOException e) {
            status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
            J2EEPlugin.logError(0, e.getMessage(), e);
            return status;
        }
        catch (CoreException e) {
            status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
            J2EEPlugin.logError(0, e.getMessage(), e);
        }
        return status;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }
}

