/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.deployment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Identity;
import javax.ejb.deployment.SerializableMethod;

public class AccessControlEntry
implements Serializable {
    private transient Method method;
    private Identity[] allowedIdentities;
    private SerializableMethod serializableMethod;

    public AccessControlEntry() {
    }

    public AccessControlEntry(Method method2) {
        this.method = method2;
    }

    public AccessControlEntry(Method method2, Identity[] identityArray) {
        this.method = method2;
        this.allowedIdentities = identityArray;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method2) {
        this.method = method2;
    }

    public Identity[] getAllowedIdentities() {
        return this.allowedIdentities;
    }

    public void setAllowedIdentities(Identity[] identityArray) {
        this.allowedIdentities = identityArray;
    }

    public Identity getAllowedIdentities(int n) {
        return this.allowedIdentities[n];
    }

    public void setAllowedIdentities(int n, Identity identity) {
        if (this.allowedIdentities == null || n >= this.allowedIdentities.length) {
            Identity[] identityArray = new Identity[n + 1];
            if (this.allowedIdentities != null) {
                int n2 = 0;
                while (n2 < this.allowedIdentities.length) {
                    identityArray[n2] = this.allowedIdentities[n2];
                    ++n2;
                }
            }
            this.allowedIdentities = identityArray;
        }
        this.allowedIdentities[n] = identity;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.serializableMethod = new SerializableMethod(this.method);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, NoSuchMethodException {
        objectInputStream.defaultReadObject();
        this.method = this.serializableMethod.getMethod();
    }
}

