/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.KeyLocatorConfig;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.File;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class KeyStoreKeyLocator
implements KeyLocator {
    private static final TraceComponent tc = Tr.register((Class)KeyStoreKeyLocator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyStoreKeyLocator.class.getName();
    private static final int ITSHA1_OCTETS = 20;
    private static final int IT60SHA1_OCTETS = 8;
    private static final String OID_KEYIDENTIFIER = "2.5.29.14";
    private static final byte BER_SEQUENCE = 48;
    private static final byte BER_BITSTRING = 3;
    private static final long DAYS_IN_MS = 86400000L;
    private static final long DEFAULT_DAYS_IN_MS_BEFORE_EXPIRE_WARNING = 5184000000L;
    private KeyLocatorConfig _config = null;
    private long _daysInMSBeforeExpireWarning = 5184000000L;
    protected final Map _keylist = new HashMap();
    private final Map _b64KeyId2KeyName = new HashMap();
    private final Map _b64KeyId602KeyName = new HashMap();
    private final Map _hexKeyId2KeyName = new HashMap();
    private final Map _hexKeyId602KeyName = new HashMap();
    private final Map _subject2KeyName = new HashMap();
    private final Map _issuer2KeyName = new HashMap();
    private final Map _cert2KeyName = new HashMap();
    protected volatile boolean _initialized = false;
    private static final int STATUS_OK = 0;
    private static final int STATUS_CERT_ERROR = 1;
    private static final int STATUS_KEYID_ERROR = 2;
    private static final int STATUS_KEY_ERROR = 4;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        this._config = (KeyLocatorConfig)map.get("com.ibm.wsspi.wssecurity.config.keyLocator.configKey");
        if (this._config.getProperties() != null) {
            String string = ConfigUtil.trim((String)((String)this._config.getProperties().get(Constants.WSSECURITY_DAYS_BEFORE_EXPIRE_WARNING_KEYS)));
            if (string != null && string.length() > 0) {
                long l = 0L;
                try {
                    l = Long.parseLong(string);
                    this._daysInMSBeforeExpireWarning = l * 86400000L;
                }
                catch (NumberFormatException numberFormatException) {
                    Tr.processException((Throwable)numberFormatException, (String)(clsName + ".init"), (String)"148", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5190W", (Object)new Object[]{Constants.WSSECURITY_DAYS_BEFORE_EXPIRE_WARNING_KEYS, string, new Long(60L)});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No value define for: " + Constants.WSSECURITY_DAYS_BEFORE_EXPIRE_WARNING_KEYS));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    protected synchronized void doInit() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doInit()");
        }
        if (this._initialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"doInit()");
            }
            return;
        }
        KeyLocatorConfig.KeyStoreConfig keyStoreConfig = this._config.getKeyStore();
        Set set = this._config.getKeyInformationList();
        if (keyStoreConfig != null && set != null) {
            KeyStore keyStore = KeyStoreKeyLocator.loadKeyStore(keyStoreConfig);
            Iterator iterator = set.iterator();
            try {
                while (iterator.hasNext()) {
                    KeyLocatorConfig.KeyInformationConfig keyInformationConfig = (KeyLocatorConfig.KeyInformationConfig)iterator.next();
                    String string = KeyInfo.X509Data.encodeDName((String)keyInformationConfig.getName());
                    if (string == null || string.length() == 0) {
                        string = keyInformationConfig.getName();
                    }
                    Certificate certificate = keyStore.getCertificate(keyInformationConfig.getAlias());
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    String string9 = null;
                    String string10 = null;
                    Key key = null;
                    Key key2 = null;
                    int n = 0;
                    long l = -1L;
                    String string11 = null;
                    if (certificate != null && certificate instanceof X509Certificate) {
                        X509Certificate x509Certificate = (X509Certificate)certificate;
                        this._cert2KeyName.put(certificate, string);
                        string2 = x509Certificate.getSubjectDN().getName();
                        string3 = KeyInfo.X509Data.encodeDName((String)string2);
                        this._subject2KeyName.put(string3, string);
                        string4 = x509Certificate.getIssuerDN().getName();
                        string5 = KeyInfo.X509Data.encodeDName((String)string4);
                        string6 = x509Certificate.getSerialNumber().toString();
                        this._issuer2KeyName.put(string5 + ":" + string6, string);
                        try {
                            x509Certificate.checkValidity();
                        }
                        catch (CertificateExpiredException certificateExpiredException) {
                            ++n;
                            Tr.processException((Throwable)certificateExpiredException, (String)(clsName + ".doInit"), (String)"220", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5181E", (Object)new Object[]{string2, keyInformationConfig.getAlias(), keyStoreConfig.getPath(), certificateExpiredException});
                            string11 = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5181E", (String[])new String[]{string2, keyInformationConfig.getAlias(), keyStoreConfig.getPath(), certificateExpiredException.getClass().getName() + ": " + certificateExpiredException.getMessage()});
                        }
                        catch (CertificateException certificateException) {
                            ++n;
                            Tr.processException((Throwable)certificateException, (String)(clsName + ".doInit"), (String)"227", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5182E", (Object)new Object[]{string2, keyInformationConfig.getAlias(), keyStoreConfig.getPath(), certificateException});
                            string11 = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5182E", (String[])new String[]{string2, keyInformationConfig.getAlias(), keyStoreConfig.getPath(), certificateException.getClass().getName() + ": " + certificateException.getMessage()});
                        }
                        l = x509Certificate.getNotAfter().getTime();
                        if (string11 == null && l - System.currentTimeMillis() < this._daysInMSBeforeExpireWarning) {
                            long l2 = l - System.currentTimeMillis();
                            long l3 = l2 / 86400000L;
                            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5189W", (Object)new Object[]{string2, keyInformationConfig.getAlias(), keyStoreConfig.getPath(), new Long(l3)});
                        }
                        if (n == 0) {
                            try {
                                byte[] byArray = KeyStoreKeyLocator.makeIdentifier(certificate, null);
                                string7 = Base64.encode((byte[])byArray);
                                this._b64KeyId2KeyName.put(string7, string);
                                string9 = Hex.encode((byte[])byArray);
                                this._hexKeyId2KeyName.put(string9, string);
                                byArray = KeyStoreKeyLocator.makeIdentifier(certificate, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1);
                                string8 = Base64.encode((byte[])byArray);
                                this._b64KeyId602KeyName.put(string8, string);
                                string10 = Hex.encode((byte[])byArray);
                                this._hexKeyId602KeyName.put(string10, string);
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                n += 2;
                                Tr.processException((Throwable)noSuchAlgorithmException, (String)(clsName + ".doInit"), (String)"256", (Object)this);
                                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", (Object)new Object[]{noSuchAlgorithmException});
                                string11 = ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + noSuchAlgorithmException.getClass().getName() + ": " + noSuchAlgorithmException.getMessage();
                            }
                            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                                n += 2;
                                Tr.processException((Throwable)invalidAlgorithmParameterException, (String)(clsName + ".doInit"), (String)"262", (Object)this);
                                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", (Object)new Object[]{invalidAlgorithmParameterException});
                                string11 = ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ":" + invalidAlgorithmParameterException.getClass().getName() + ": " + invalidAlgorithmParameterException.getMessage();
                            }
                            catch (Exception exception) {
                                n += 2;
                                Tr.processException((Throwable)exception, (String)(clsName + ".doInit"), (String)"268", (Object)this);
                                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", (Object)new Object[]{exception});
                                string11 = ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ":" + exception.getClass().getName() + ": " + exception.getMessage();
                            }
                            key = certificate.getPublicKey();
                            if (keyInformationConfig.getKeyPass() != null) {
                                try {
                                    key2 = keyStore.getKey(keyInformationConfig.getAlias(), keyInformationConfig.getKeyPass().toCharArray());
                                    if (key2 == null && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("The key with alias \"" + keyInformationConfig.getAlias() + "\" of keystore \"" + keyStoreConfig.getPath() + "\" is not key entry."));
                                        Tr.debug((TraceComponent)tc, (String)("Or alias \"" + keyInformationConfig.getAlias() + "\" is not found in keystore \"" + keyStoreConfig.getPath() + "\"."));
                                    }
                                }
                                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                    n += 4;
                                    Tr.processException((Throwable)noSuchAlgorithmException, (String)(clsName + ".doInit"), (String)"286", (Object)this);
                                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5183E", (Object)new Object[]{keyInformationConfig.getAlias(), keyStoreConfig.getPath(), noSuchAlgorithmException});
                                    string11 = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5183E", (String[])new String[]{keyInformationConfig.getAlias(), keyStoreConfig.getPath(), noSuchAlgorithmException.getClass().getName() + ": " + noSuchAlgorithmException.getMessage()});
                                }
                                catch (UnrecoverableKeyException unrecoverableKeyException) {
                                    n += 4;
                                    Tr.processException((Throwable)unrecoverableKeyException, (String)(clsName + ".doInit"), (String)"293", (Object)this);
                                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5184E", (Object)new Object[]{keyInformationConfig.getAlias(), keyStoreConfig.getPath(), unrecoverableKeyException});
                                    string11 = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5184E", (String[])new String[]{keyInformationConfig.getAlias(), keyStoreConfig.getPath(), unrecoverableKeyException.getClass().getName() + ": " + unrecoverableKeyException.getMessage()});
                                }
                            }
                        }
                        this._keylist.put(string, new KeyInformation(keyStoreConfig.getPath(), keyInformationConfig.getAlias(), keyInformationConfig.getName(), key, key2, certificate, string2, string3, string4, string5, string6, string7, string8, string9, string10, n, l, this._daysInMSBeforeExpireWarning, string11));
                        continue;
                    }
                    if (keyInformationConfig.getKeyPass() == null) continue;
                    string2 = string;
                    string3 = KeyInfo.X509Data.encodeDName((String)string2);
                    if (string3 == null || string3.length() == 0) {
                        string3 = string2;
                    }
                    this._subject2KeyName.put(string3, string);
                    try {
                        key = key2 = keyStore.getKey(keyInformationConfig.getAlias(), keyInformationConfig.getKeyPass().toCharArray());
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        n += 4;
                        Tr.processException((Throwable)noSuchAlgorithmException, (String)(clsName + ".doInit"), (String)"323", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5183E", (Object)new Object[]{keyInformationConfig.getAlias(), keyStoreConfig.getPath(), noSuchAlgorithmException});
                        string11 = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5183E", (String[])new String[]{keyInformationConfig.getAlias(), keyStoreConfig.getPath(), noSuchAlgorithmException.getMessage()});
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        n = 4;
                        Tr.processException((Throwable)unrecoverableKeyException, (String)(clsName + ".init"), (String)"329", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC5184E", (Object)new Object[]{keyInformationConfig.getAlias(), keyStoreConfig.getPath(), unrecoverableKeyException});
                        string11 = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5184E", (String[])new String[]{keyInformationConfig.getAlias(), keyStoreConfig.getPath(), unrecoverableKeyException.getMessage()});
                    }
                    this._keylist.put(string, new KeyInformation(keyStoreConfig.getPath(), keyInformationConfig.getAlias(), keyInformationConfig.getName(), key, key2, certificate, string2, string3, string4, string5, string6, string7, string8, string9, string10, n, l, this._daysInMSBeforeExpireWarning, string11));
                }
            }
            catch (KeyStoreException keyStoreException) {
                Tr.processException((Throwable)keyStoreException, (String)(clsName + ".init"), (String)"345", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.KeyStoreKeyLocator.exception", (Object)new Object[]{keyStoreConfig.getPath(), keyStoreException});
                throw new SoapSecurityException(keyStoreException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyLocatorConfig [" + this._config + "], " + "KeyInformationList [" + this._keylist + "]."));
        }
        this._initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doInit()");
        }
    }

    private static KeyStore loadKeyStore(KeyLocatorConfig.KeyStoreConfig keyStoreConfig) throws SoapSecurityException {
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadKeyStore(KeyStoreConfig config)");
        }
        KeyStore keyStore = null;
        String string = keyStoreConfig.getType();
        String string2 = keyStoreConfig.getPath();
        String string3 = keyStoreConfig.getPassword();
        String string4 = keyStoreConfig.getKsRef();
        if (string4 != null && string4.length() != 0) {
            keyStore = ConfigUtil.getKeyStore((String)string4);
        } else if (string != null && string2 != null && string3 != null && (file = ConfigUtil.fixPath((String)string2, null)) != null) {
            keyStore = ConfigUtil.getKeyStore((String)string, (File)file, (char[])string3.toCharArray());
        }
        if (keyStore == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.loadKeyStore01");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("loadKeyStore(KeyStoreConfig config) returns KeyStore[" + keyStore + "]"));
        }
        return keyStore;
    }

    public Key getKey(Map map, Map map2) throws SoapSecurityException {
        Object object;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        boolean bl9;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKey(Map type,Map context)");
        }
        if (!this._initialized) {
            this.doInit();
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map2.get("com.ibm.wsspi.wssecurity.core.messageContext");
        String string = (String)map.get(Constants.WSSECURITY_KEYINFO_TYPE);
        if (string == null) {
            bl9 = false;
            bl8 = false;
            bl7 = false;
            bl6 = false;
            bl5 = false;
        } else {
            bl5 = ConfigUtil.isKeyInfoKeyname((String)string);
            bl6 = ConfigUtil.isKeyInfoKeyid((String)string);
            bl7 = ConfigUtil.isKeyInfoStrref((String)string);
            bl8 = ConfigUtil.isKeyInfoEmb((String)string);
            bl9 = ConfigUtil.isKeyInfoX509issuer((String)string);
        }
        String string2 = (String)map.get(Constants.WSSECURITY_KEY_TYPE);
        if (string2 == null) {
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = false;
        } else {
            bl = "SigningKey".equals(string2);
            bl2 = "VerifyingKey".equals(string2);
            bl3 = "EncryptingKey".equals(string2);
            bl4 = "DecryptingKey".equals(string2);
        }
        String string3 = (String)map.get(Constants.WSSECURITY_KEY_NAMEREF);
        if (string3 != null && (object = KeyInfo.X509Data.encodeDName((String)string3)) != null && ((String)object).length() > 0) {
            string3 = object;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoType [" + string + "]."));
            Tr.debug((TraceComponent)tc, (String)("KeyInfoType: isKeyName, isKeyId, isStrref, isEmb, isX509: " + bl5 + ", " + bl6 + ", " + bl7 + ", " + bl8 + ", " + bl9 + "."));
            Tr.debug((TraceComponent)tc, (String)("KeyType [" + string2 + "]."));
            Tr.debug((TraceComponent)tc, (String)("keyType: isSigning, isVerifying, isEncrypting, isDecrypting: " + bl + ", " + bl2 + ", " + bl3 + ", " + bl4 + "."));
            Tr.debug((TraceComponent)tc, (String)("Reference name of a key [" + string3 + "]."));
        }
        object = null;
        if (bl) {
            if (string3 == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getKey01");
            }
            object = this.getSigningKey(string3, bl5, bl6, bl7, bl8, bl9, map, map2);
        } else if (bl2) {
            object = this.getVerifyingKey(bl5, bl6, bl7, bl8, bl9, map, map2);
        } else if (bl3) {
            if (string3 == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getKey01");
            }
            object = this.getEncryptingKey(string3, bl5, bl6, bl7, bl8, bl9, map, map2);
        } else if (bl4) {
            object = this.getDecryptingKey(bl5, bl6, bl7, bl8, bl9, map, map2);
        } else {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getKey02", string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Map type,Map context) returns Key[" + object + "]"));
        }
        return object;
    }

    private Key getSigningKey(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Map map, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSigningKey(String  keyNameRef[" + string + "]," + "boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "Map type," + "Map context)"));
        }
        Key key = null;
        Token token = KeyStoreKeyLocator.getToken(bl, bl2, bl3, bl4, bl5, map, map2);
        KeyInformation keyInformation = (KeyInformation)this._keylist.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Key information [" + keyInformation + "]"));
        }
        if (keyInformation == null) {
            if (string != null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey02", string);
            }
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey03");
        }
        key = keyInformation.getPrivateOrSecretKey();
        if (key == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey01");
        }
        if (token == null) {
            KeyStoreKeyLocator.setInfo(bl, bl2, bl3, bl4, bl5, keyInformation, map2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSigningKey(String knameRef,boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private Key getVerifyingKey(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Map map, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getVerifyingKey(boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "Map type," + "Map context)"));
        }
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)map.remove(Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        Key key = (Key)map2.remove(this.getClass());
        if (key == null) {
            KeyInformation keyInformation = this.getInfo(tokenConsumerConfig, bl, bl2, bl3, bl4, bl5, map, map2);
            key = keyInformation.getPublicOrSecretKey();
            map2.put("com.ibm.wsspi.wssecurity.token.x509.certificate", keyInformation.getCertificate());
            if (keyInformation.getCertificate() != null) {
                map2.put(key, keyInformation.getCertificate());
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"(key, certificate) from kinfo put in context");
                }
            }
            map2.put(this.getClass(), key);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getVerifyingKey(boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private Key getEncryptingKey(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Map map, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncryptingKey(String knameRef[" + string + "]," + "boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "Map type," + "Map context)"));
        }
        Key key = null;
        Token token = KeyStoreKeyLocator.getToken(bl, bl2, bl3, bl4, bl5, map, map2);
        KeyInformation keyInformation = (KeyInformation)this._keylist.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Key information [" + keyInformation + "]"));
        }
        if (keyInformation == null) {
            if (string != null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey02", string);
            }
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey03");
        }
        key = keyInformation.getPublicOrSecretKey();
        if (key == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey01");
        }
        Certificate certificate = null;
        if (token == null) {
            KeyStoreKeyLocator.setInfo(bl, bl2, bl3, bl4, bl5, keyInformation, map2);
        } else if (token instanceof X509BSToken) {
            certificate = ((X509BSToken)token).getCert();
        }
        if (certificate == null) {
            certificate = keyInformation.getCertificate();
        }
        if (certificate != null) {
            map2.put(key, certificate);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"(key, certificate) put in context");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncryptingKey(String knameRef,boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private Key getDecryptingKey(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Map map, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDecryptingKey(boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "Map type," + "Map context)"));
        }
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)map.remove(Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        Key key = (Key)map2.remove(this.getClass());
        if (key == null) {
            KeyInformation keyInformation = this.getInfo(tokenConsumerConfig, bl, bl2, bl3, bl4, bl5, map, map2);
            key = keyInformation.getPrivateOrSecretKey();
            map2.put("com.ibm.wsspi.wssecurity.token.x509.certificate", keyInformation.getCertificate());
            map2.put(this.getClass(), key);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDecryptingKey(boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyInformation getInfo(TokenConsumerConfig tokenConsumerConfig, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Map map, Map map2) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInfo(TokenConsumerConfig tconfig[" + tokenConsumerConfig + "]," + "boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "Map type," + "Map context)"));
        }
        String string = null;
        if (bl) {
            object = (String)map.get(Constants.WSSECURITY_KEY_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SubjectDN is [" + (String)object + "]."));
            }
            if (object == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyNameContentConsumer.getKeyName01");
            }
            string = (String)this._subject2KeyName.get(object);
        } else if (bl2) {
            object = (String)map.get(Constants.WSSECURITY_KEY_ID);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The key identifier is [" + (String)object + "]"));
            }
            if (object == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyIdContentConsumer.getKey01");
            }
            QName qName = (QName)map.get(Constants.WSSECURITY_KEY_IDTYPE);
            QName qName2 = (QName)map.get(Constants.WSSECURITY_KEY_ENCODING);
            QName qName3 = (QName)map.get(Constants.WSSECURITY_KEY_VALUETYPE);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Calcuration method of key identifier is [" + qName + "]."));
                Tr.debug((TraceComponent)tc, (String)("Encoding type of key identifier is [" + qName2 + "]."));
                Tr.debug((TraceComponent)tc, (String)("Value type of key identifier is [" + qName3 + "]."));
            }
            if (qName3 == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.generateIdentifier02");
            }
            if (!com.ibm.ws.webservices.wssecurity.Constants.X509_SKI.equals(qName3) && !com.ibm.ws.webservices.wssecurity.Constants.X509_SKI_OLD.equals(qName3)) {
                throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.generateIdentifier03", com.ibm.ws.webservices.wssecurity.Constants.X509_SKI.toString() + ", " + com.ibm.ws.webservices.wssecurity.Constants.X509_SKI_OLD.toString(), qName3.toString());
            }
            if (qName2 == null || NamespaceUtil.equals(qName2, com.ibm.ws.webservices.wssecurity.Constants.BASE64_BINARY)) {
                if (qName == null || NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                    string = (String)this._b64KeyId2KeyName.get(object);
                } else {
                    if (!NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + qName);
                    string = (String)this._b64KeyId602KeyName.get(object);
                }
            } else {
                if (!NamespaceUtil.equals(qName2, com.ibm.ws.webservices.wssecurity.Constants.HEX_BINARY)) throw SoapSecurityException.format("security.wssecurity.BinaryTokenReceiver.token15", qName2.toString());
                if (qName == null || NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                    string = (String)this._hexKeyId2KeyName.get(object);
                } else {
                    if (!NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + qName);
                    string = (String)this._hexKeyId602KeyName.get(object);
                }
            }
        } else if (bl3) {
            object = (String)map.get(Constants.WSSECURITY_KEY_REFERENCE);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The referene URI to a token is [" + (String)object + "]."));
            }
            if (object == null) {
                throw SoapSecurityException.format("security.wssecurity.STRReferenceContentConsumer.getKey01");
            }
            Token token = TokenManager.getToken(map2, tokenConsumerConfig, (String)object);
            if (token == null || !(token instanceof X509BSToken)) {
                throw SoapSecurityException.format("security.wssecurity.SignatureReceiver.dsig10", (String)object);
            }
            X509Certificate x509Certificate = ((X509BSToken)token).getCert();
            if (x509Certificate == null) {
                throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurity.WSSConsumer.s32") + ": " + token);
            }
            string = (String)this._cert2KeyName.get(x509Certificate);
        } else if (bl4) {
            object = (String)map.get(Constants.WSSECURITY_KEY_EMBID);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The embedded token identifier is [" + (String)object + "]."));
            }
            if (object == null) {
                throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getEmbeddedToken02");
            }
            Token token = TokenManager.getToken(map2, tokenConsumerConfig, (String)object);
            if (token == null || !(token instanceof X509BSToken)) {
                throw SoapSecurityException.format("security.wssecurity.SignatureReceiver.dsig10", (String)object);
            }
            X509Certificate x509Certificate = ((X509BSToken)token).getCert();
            if (x509Certificate == null) {
                throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurity.WSSConsumer.s32") + ": " + token);
            }
            string = (String)this._cert2KeyName.get(x509Certificate);
        } else if (bl5) {
            object = (String)map.get(Constants.WSSECURITY_KEY_ISSUERNAME);
            String string2 = (String)map.get(Constants.WSSECURITY_KEY_ISSUERSERIAL);
            if ((object == null || string2 == null) && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: Unable to get issuer name or issuer serial.");
            }
            String string3 = (String)object + ":" + string2;
            string = (String)this._issuer2KeyName.get(string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The key name is [" + string + "]."));
        }
        object = null;
        if (string != null) {
            object = (KeyInformation)this._keylist.get(string);
        }
        if (object == null) {
            if (string == null) throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey03");
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getPrivateKey02", string);
        }
        if (!tc.isEntryEnabled()) return object;
        Tr.exit((TraceComponent)tc, (String)("getInfo(TokenConsumerConfig tconfig,boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,Map type,Map context) returns KeyInformation[" + object + "]"));
        return object;
    }

    protected static Token getToken(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Map map, Map map2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getToken(boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "Map type," + "Map context)"));
        }
        Token token = null;
        String string = null;
        if (bl) {
            string = (String)map.get(Constants.WSSECURITY_KEY_NAME);
        } else if (bl2) {
            string = (String)map.get(Constants.WSSECURITY_KEY_ID);
        } else if (bl3) {
            string = (String)map.get(Constants.WSSECURITY_KEY_REFERENCE);
        } else if (bl4) {
            string = (String)map.get(Constants.WSSECURITY_KEY_EMBID);
        } else if (bl5) {
            String string2 = (String)map.get(Constants.WSSECURITY_KEY_ISSUERNAME);
            String string3 = (String)map.get(Constants.WSSECURITY_KEY_ISSUERSERIAL);
            if (string2 != null && string3 != null) {
                string = string2 + ":" + string3;
            }
        }
        if (string != null) {
            token = TokenManager.getToken(map2, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken(boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "Map type," + "Map context)" + " returns Token[" + token + "]"));
        }
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setInfo(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, KeyInformation keyInformation, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setInfo(boolean isKeyName[" + bl + "]," + "boolean isKeyId[" + bl2 + "]," + "boolean isStrref[" + bl3 + "]," + "boolean isEmb[" + bl4 + "]," + "boolean isX509[" + bl5 + "]," + "KeyInformation kinfo[" + keyInformation + "]," + "Map context)"));
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (bl) {
            string = keyInformation.getSubjectDN();
        } else if (bl2) {
            QName qName = (QName)map.remove(Constants.WSSECURITY_KEY_ENCODING);
            QName qName2 = (QName)map.remove(Constants.WSSECURITY_KEY_IDTYPE);
            if (qName == null || NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.BASE64_BINARY)) {
                if (qName2 == null || NamespaceUtil.equals(qName2, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                    string2 = keyInformation.getB64KeyId();
                } else {
                    if (!NamespaceUtil.equals(qName2, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + qName2);
                    string2 = keyInformation.getB64KeyId60();
                }
            } else {
                if (!NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.HEX_BINARY)) throw SoapSecurityException.format("security.wssecurity.BinaryTokenReceiver.token15", qName.toString());
                if (qName2 == null || NamespaceUtil.equals(qName2, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                    string2 = keyInformation.getHexKeyId();
                } else {
                    if (!NamespaceUtil.equals(qName2, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurityKeyStoreKeyLocator.generateIdentifier01") + ": " + qName2);
                    string2 = keyInformation.getHexKeyId60();
                }
            }
        } else if (bl3) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: TokenGenerator is responsible to set a X509 token to the Subject in case of STRREF.");
            }
        } else if (bl4) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: TokenGenerator is responsible to set a X509 token to the Subject in case of EMB.");
            }
        } else if (bl5) {
            string3 = keyInformation.getIssuerDN();
            string4 = keyInformation.getIssuerSerial();
        }
        if (string != null) {
            map.put(Constants.WSSECURITY_KEY_NAME, string);
        } else {
            map.remove(Constants.WSSECURITY_KEY_NAME);
        }
        if (string2 != null) {
            map.put(Constants.WSSECURITY_KEY_ID, string2);
        } else {
            map.remove(Constants.WSSECURITY_KEY_ID);
        }
        if (string3 != null) {
            map.put(Constants.WSSECURITY_KEY_ISSUERNAME, string3);
        } else {
            map.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
        }
        if (string4 != null) {
            map.put(Constants.WSSECURITY_KEY_ISSUERSERIAL, string4);
        } else {
            map.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
        }
        map.remove(Constants.WSSECURITY_KEY_EMBID);
        map.remove(Constants.WSSECURITY_KEY_REFERENCE);
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"setInfo(boolean isKeyName,boolean isKeyId,boolean isStrref,boolean isEmb,boolean isX509,KeyInformation kinfo,Map context)");
    }

    private static byte[] certToIdentifier(Certificate certificate) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
        }
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        byte[] byArray = ((X509Certificate)certificate).getExtensionValue(OID_KEYIDENTIFIER);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray.length - 4);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"certToIdentifier(Certificate cert)");
        }
        return byArray2;
    }

    private static byte[] pubkeyToIdentifier(Certificate certificate, QName qName) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("pubkeyToIdentifier(Certificate cert,QName idty[" + qName + "])"));
        }
        byte[] byArray = null;
        if (certificate != null) {
            byte[] byArray2 = certificate.getPublicKey().getEncoded();
            if (byArray2[0] != 48) {
                throw new RuntimeException("Unknown encoded key: " + Hex.encode((byte[])byArray2));
            }
            int n = byArray2[1] & 0xFF;
            int n2 = (n & 0x80) == 0 ? 2 : 2 + (n & 0x7F);
            n = byArray2[n2 + 1] & 0xFF;
            if ((n & 0x80) == 0) {
                n2 += 2;
            } else {
                int n3 = n2 + 2;
                n2 += 2 + (n & 0x7F);
                switch (n & 0x7F) {
                    case 1: {
                        n = byArray2[n3] & 0xFF;
                        break;
                    }
                    case 2: {
                        n = ((byArray2[n3] & 0xFF) << 8) + (byArray2[n3 + 1] & 0xFF);
                        break;
                    }
                    case 3: {
                        n = ((byArray2[n3] & 0xFF) << 16) + ((byArray2[n3 + 1] & 0xFF) << 8) + (byArray2[n3 + 2] & 0xFF);
                        break;
                    }
                    case 4: {
                        n = ((byArray2[n3] & 0xFF) << 24) + ((byArray2[n3 + 1] & 0xFF) << 16) + ((byArray2[n3 + 2] & 0xFF) << 8) + (byArray2[n3 + 3] & 0xFF);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Integer overflow: " + Hex.encode((byte[])byArray2));
                    }
                }
            }
            if (byArray2[n2 += n] != 3) {
                throw new RuntimeException("Non BIT STRING: 0x" + Integer.toString(byArray2[n2] & 0xFF, 16));
            }
            n2 += ((n = byArray2[n2 + 1] & 0xFF) & 0x80) == 0 ? 3 : 3 + (n & 0x7F);
            AlgorithmFactory algorithmFactory = AlgorithmFactory.getInstance();
            MessageDigest messageDigest = algorithmFactory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            if (NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1) || qName == null) {
                messageDigest.update(byArray2, n2, byArray2.length - n2);
                byArray = messageDigest.digest();
                algorithmFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
            } else if (NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
                messageDigest.update(byArray2, n2, byArray2.length - n2);
                byte[] byArray3 = messageDigest.digest();
                algorithmFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
                byArray = new byte[8];
                byArray[0] = (byte)(64 + (byArray3[byArray3.length - 8] & 0xF));
                System.arraycopy(byArray3, byArray3.length - 8 + 1, byArray, 1, byArray.length - 1);
            } else {
                algorithmFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
                throw new IllegalArgumentException("Internal Error: " + qName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"pubkeyToIdentifier(Certificate cert,QName idty)");
        }
        return byArray;
    }

    private static byte[] makeIdentifier(Certificate certificate, QName qName) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("makeIdentifier(Certificate cert,QName idty[" + qName + "])"));
        }
        byte[] byArray = null;
        if (certificate != null && ((byArray = KeyStoreKeyLocator.certToIdentifier(certificate)) == null || qName != null)) {
            if (qName == null || NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.ITSHA1)) {
                if (byArray == null || byArray.length != 20) {
                    byArray = KeyStoreKeyLocator.pubkeyToIdentifier(certificate, qName);
                }
            } else if (NamespaceUtil.equals(qName, com.ibm.ws.webservices.wssecurity.Constants.IT60SHA1)) {
                if (byArray == null || byArray.length != 8) {
                    byArray = KeyStoreKeyLocator.pubkeyToIdentifier(certificate, qName);
                }
            } else {
                throw new IllegalArgumentException("Internal Error: " + qName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"makeIdentifier(Certificate cert,QName idty)");
        }
        return byArray;
    }

    protected static class KeyInformation {
        private String _kspath;
        private String _alias;
        private String _name;
        private Key _publicOrSecretKey;
        private Key _privateOrSecretKey;
        private Certificate _certificate;
        private String _subjectDN;
        private String _encSubjectDN;
        private String _issuerDN;
        private String _encIssuerDN;
        private String _issuerSerial;
        private String _b64KeyId;
        private String _b64KeyId60;
        private String _hexKeyId;
        private String _hexKeyId60;
        private int _status;
        private long _expiration;
        private long _daysInMSBeforeExpireWarning;
        private String _errorMes;

        protected KeyInformation(String string, String string2, String string3, Key key, Key key2, Certificate certificate, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, int n, long l, long l2, String string13) {
            this._kspath = string;
            this._alias = string2;
            this._name = string3;
            this._publicOrSecretKey = key;
            this._privateOrSecretKey = key2;
            this._certificate = certificate;
            this._subjectDN = string4;
            this._encSubjectDN = string5;
            this._issuerDN = string6;
            this._encIssuerDN = string7;
            this._issuerSerial = string8;
            this._b64KeyId = string9;
            this._b64KeyId60 = string10;
            this._hexKeyId = string11;
            this._hexKeyId60 = string12;
            this._status = n;
            this._expiration = l;
            this._daysInMSBeforeExpireWarning = l2;
            this._errorMes = string13;
        }

        protected String getName() {
            return this._name;
        }

        protected Key getPublicOrSecretKey() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._publicOrSecretKey;
        }

        protected Key getPrivateOrSecretKey() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 4) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._privateOrSecretKey;
        }

        protected Certificate getCertificate() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._certificate;
        }

        protected String getSubjectDN() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._encSubjectDN;
        }

        protected String getIssuerDN() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._encIssuerDN;
        }

        protected String getIssuerSerial() throws SoapSecurityException {
            if ((this._status & 1) == 1) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._issuerSerial;
        }

        protected String getB64KeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._b64KeyId;
        }

        protected String getB64KeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._b64KeyId60;
        }

        protected String getHexKeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._hexKeyId;
        }

        protected String getHexKeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 4) {
                throw new SoapSecurityException(this._errorMes);
            }
            this.checkExpiration();
            return this._hexKeyId60;
        }

        private void checkExpiration() throws SoapSecurityException {
            if (this._expiration >= 0L) {
                long l = this._expiration - System.currentTimeMillis();
                if (l < 0L) {
                    ++this._status;
                    this._errorMes = ConfigUtil.getMessage((String)"security.wssecurity.WSEC5181E", (String[])new String[]{this._subjectDN, this._alias, this._kspath, "expiration time - current system time = " + l + " ms."});
                    throw new SoapSecurityException(this._errorMes);
                }
                if (l < this._daysInMSBeforeExpireWarning) {
                    long l2 = l / 86400000L;
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5189W", (Object)new Object[]{this._subjectDN, this._alias, this._kspath, new Long(l2)});
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("keystorePath=[").append(this._kspath).append("], ");
            stringBuffer.append("alias=[").append(this._alias).append("], ");
            stringBuffer.append("name=[").append(this._name).append("], ");
            stringBuffer.append("status=[").append(this._status).append("], ");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

