/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.module.BSTokenLoginModule;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import javax.security.auth.login.LoginException;

public class PkiPathLoginModule
extends BSTokenLoginModule {
    private static final TraceComponent tc = Tr.register((Class)PkiPathLoginModule.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PkiPathLoginModule.class.getName();

    public boolean login() throws LoginException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login()");
        }
        if (bl = super.login()) {
            Object object;
            CertPath certPath = null;
            Provider provider = (Provider)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.provider");
            try {
                certPath = CertificateUtil.generateCertPath((byte[])this._binary, (String)"X.509", (String)"PkiPath", (Provider)provider);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Succeeded to generate cert path.");
                }
                this._cert = (X509Certificate)certPath.getCertificates().get(0);
                if (this._cert == null) {
                    throw new CertificateException(ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.setCertToSubject01"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Succeeded to get a X509 certificate [" + this._cert + "]"));
                }
            }
            catch (CertificateException certificateException) {
                throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathLoginModule.s01", (String[])new String[]{certificateException.toString()}));
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathLoginModule.s01", (String[])new String[]{noSuchProviderException.toString()}));
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Checking the validity of X509 certificate...");
                }
                this._cert.checkValidity();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Succeeded to check the validity of X509 certificate.");
                }
            }
            catch (Exception exception) {
                throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.X509LoginModule.s02", (String[])new String[]{exception.toString()}));
            }
            boolean bl2 = false;
            String string = (String)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.trustAny");
            if (string != null && string.length() > 0) {
                bl2 = ConfigUtil.isTrue((String)string);
                if (tc.isDebugEnabled() && bl2) {
                    Tr.debug((TraceComponent)tc, (String)"This login module trusts any certificate.");
                }
            }
            if (!bl2) {
                string = (String)this._properties.get(Constants.WSSECURITY_ISSUER_NAME);
                String string2 = (String)this._properties.get(Constants.WSSECURITY_ISSUER_SERIAL);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Issuer name of its own certificate is [" + string + "]."));
                    Tr.debug((TraceComponent)tc, (String)("Serial number of its own certificate is [" + string2 + "]."));
                }
                if (string != null && string2 != null) {
                    String string3;
                    object = this._cert.getIssuerDN().getName();
                    if (((String)(object = KeyInfo.X509Data.encodeDName((String)object))).equals(string3 = KeyInfo.X509Data.encodeDName((String)string))) {
                        BigInteger bigInteger = this._cert.getSerialNumber();
                        BigInteger bigInteger2 = null;
                        try {
                            bigInteger2 = CertificateUtil.convertSerialNumber((String)string2);
                        }
                        catch (ParseException parseException) {
                            throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.X509LoginModule.s04", (String[])new String[]{string2, parseException.toString()}));
                        }
                        if (bigInteger.equals(bigInteger2)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"The cert is its own certificate, so this login module trusts it.");
                            }
                            bl2 = true;
                        }
                    }
                } else if (string != null) {
                    Tr.debug((TraceComponent)tc, (String)"There is issuer name, but not serial number.");
                } else if (string2 != null) {
                    Tr.debug((TraceComponent)tc, (String)"There is serial number, but not issur name.");
                }
            }
            if (!bl2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This login module doesn't trust all certificate, so starts checking the cert path.");
                }
                if ((object = (PKIXBuilderParameters)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.pkixBuilderParam")) == null) {
                    throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.X509LoginModule.s05"));
                }
                object = (PKIXBuilderParameters)((PKIXParameters)object).clone();
                ((PKIXParameters)object).setRevocationEnabled(false);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Provider [" + provider + "], PKIBuilderParameters [" + object + "]."));
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Checking the cert path...");
                    }
                    CertificateUtil.validateCertPath((CertPath)certPath, (PKIXParameters)object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Succeeded to validate the cert path.");
                    }
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathLoginModule.s02", (String[])new String[]{certPathValidatorException.toString()}));
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathLoginModule.s02", (String[])new String[]{invalidAlgorithmParameterException.toString()}));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathLoginModule.s02", (String[])new String[]{noSuchAlgorithmException.toString()}));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login()");
        }
        return true;
    }
}

