/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.token.UserRegistryProcessor;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class IDAssertionUsernameLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register((Class)IDAssertionUsernameLoginModule.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private String comp = "security.wssecurity";
    private static final String clsName = IDAssertionUsernameLoginModule.class.getName();
    private Subject _subject;
    private CallbackHandler _handler;
    private Map _sharedState;
    private Map _options;
    private String _username;
    private char[] _password;
    private Map _properties = null;
    private SOAPMessageContext _messageContext = null;
    private boolean _isUsernameOnly = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this._subject = subject;
        this._handler = callbackHandler;
        this._sharedState = map;
        this._options = map2;
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login()");
        }
        boolean bl = true;
        NameCallback nameCallback = new NameCallback("username: ");
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{nameCallback, propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            throw new LoginException(ConfigUtil.getMessage((String)(this.comp + ".BSTokenLoginModule.s01"), (String[])new String[]{exception.toString()}));
        }
        this._username = nameCallback.getName();
        this._properties = propertyCallback.getProperties();
        if (this._properties != null) {
            this._messageContext = (SOAPMessageContext)this._properties.get("com.ibm.wsspi.wssecurity.core.messageContext");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("usernameCB [" + nameCallback + "]"));
            Tr.debug((TraceComponent)tc, (String)("username [" + this._username + "]"));
        }
        if (this._username != null && this._username.length() > 0) {
            boolean bl2 = UserRegistryProcessor.checkUsername(this._username);
            if (!bl2) {
                throw new LoginException(ConfigUtil.getMessage((String)(this.comp + ".UserRegistryProcessor.s02"), (String[])new String[]{this._username, "UserRegistryProcessor.checkUsername()=" + bl2}));
            }
        } else {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login()");
        }
        return bl;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit()");
        }
        boolean bl = true;
        boolean bl2 = false;
        UsernameToken usernameToken = new UsernameToken(null, null, null);
        if (this._username != null && this._username.length() > 0) {
            final UsernameToken usernameToken2 = usernameToken;
            final String string = this._username;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    usernameToken2.setUsername(string);
                    return null;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added Username [" + this._username + "]."));
            }
            bl2 = true;
        } else {
            bl = false;
        }
        if (!bl2) {
            throw new LoginException(ConfigUtil.getMessage((String)(this.comp + ".LoginProcessor.s11")));
        }
        if (this._properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: Can't return username and user password because properties parameter is null.");
            }
        } else {
            this._properties.put(Constants.WSSECURITY_TOKEN_LOGININFO, usernameToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit()");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logout()");
        }
        return true;
    }
}

