/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.xml;

import com.ibm.wsdl.spi.AttributeExtensible;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOM2Writer;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDLWriterImpl
implements WSDLWriter {
    public void setFeature(String string, boolean bl) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        throw new IllegalArgumentException("Feature name '" + string + "' not recognized.");
    }

    public boolean getFeature(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        throw new IllegalArgumentException("Feature name '" + string + "' not recognized.");
    }

    protected void printDefinition(Definition definition, PrintWriter printWriter) throws WSDLException {
        String string;
        if (definition == null) {
            return;
        }
        if (definition.getPrefix("http://schemas.xmlsoap.org/wsdl/") == null) {
            string = "wsdl";
            int n = 0;
            while (definition.getNamespace(string) != null) {
                string = "wsdl" + n++;
            }
            definition.addNamespace(string, "http://schemas.xmlsoap.org/wsdl/");
        }
        string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "definitions", definition);
        printWriter.print('<' + string);
        QName qName = definition.getQName();
        String string2 = definition.getTargetNamespace();
        Map map = definition.getNamespaces();
        if (qName != null) {
            DOMUtils.printAttribute("name", qName.getLocalPart(), printWriter);
        }
        DOMUtils.printAttribute("targetNamespace", string2, printWriter);
        this.printNamespaceDeclarations(map, printWriter);
        printWriter.println('>');
        this.printDocumentation(definition.getDocumentationElement(), printWriter);
        this.printImports(definition.getImports(), definition, printWriter);
        this.printTypes(definition.getTypes(), definition, printWriter);
        this.printMessages(definition.getMessages(), definition, printWriter);
        this.printPortTypes(definition.getPortTypes(), definition, printWriter);
        this.printBindings(definition.getBindings(), definition, printWriter);
        this.printServices(definition.getServices(), definition, printWriter);
        List list = definition.getExtensibilityElements();
        this.printExtensibilityElements(Definition.class, list, definition, printWriter);
        printWriter.println("</" + string + '>');
        printWriter.flush();
    }

    protected void printServices(Map map, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (map != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "service", definition);
            for (Service service : map.values()) {
                printWriter.print("  <" + string);
                QName qName = service.getQName();
                if (qName != null) {
                    DOMUtils.printAttribute("name", qName.getLocalPart(), printWriter);
                }
                if (service instanceof AttributeExtensible) {
                    this.printExtensibilityAttributes(Service.class, (AttributeExtensible)((Object)service), definition, printWriter);
                }
                printWriter.println('>');
                this.printDocumentation(service.getDocumentationElement(), printWriter);
                this.printPorts(service.getPorts(), definition, printWriter);
                List list = service.getExtensibilityElements();
                this.printExtensibilityElements(Service.class, list, definition, printWriter);
                printWriter.println("  </" + string + '>');
            }
        }
    }

    protected void printPorts(Map map, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (map != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "port", definition);
            for (Port port : map.values()) {
                printWriter.print("    <" + string);
                DOMUtils.printAttribute("name", port.getName(), printWriter);
                Binding binding = port.getBinding();
                if (binding != null) {
                    DOMUtils.printQualifiedAttribute("binding", binding.getQName(), definition, printWriter);
                }
                if (port instanceof AttributeExtensible) {
                    this.printExtensibilityAttributes(Port.class, (AttributeExtensible)((Object)port), definition, printWriter);
                }
                printWriter.println('>');
                this.printDocumentation(port.getDocumentationElement(), printWriter);
                List list = port.getExtensibilityElements();
                this.printExtensibilityElements(Port.class, list, definition, printWriter);
                printWriter.println("    </" + string + '>');
            }
        }
    }

    protected void printBindings(Map map, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (map != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "binding", definition);
            for (Binding binding : map.values()) {
                PortType portType;
                if (binding.isUndefined()) continue;
                printWriter.print("  <" + string);
                QName qName = binding.getQName();
                if (qName != null) {
                    DOMUtils.printAttribute("name", qName.getLocalPart(), printWriter);
                }
                if ((portType = binding.getPortType()) != null) {
                    DOMUtils.printQualifiedAttribute("type", portType.getQName(), definition, printWriter);
                }
                if (binding instanceof AttributeExtensible) {
                    this.printExtensibilityAttributes(Binding.class, (AttributeExtensible)((Object)binding), definition, printWriter);
                }
                printWriter.println('>');
                this.printDocumentation(binding.getDocumentationElement(), printWriter);
                List list = binding.getExtensibilityElements();
                this.printExtensibilityElements(Binding.class, list, definition, printWriter);
                this.printBindingOperations(binding.getBindingOperations(), definition, printWriter);
                printWriter.println("  </" + string + '>');
            }
        }
    }

    protected void printBindingOperations(List list, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (list != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "operation", definition);
            for (BindingOperation bindingOperation : list) {
                printWriter.print("    <" + string);
                DOMUtils.printAttribute("name", bindingOperation.getName(), printWriter);
                if (bindingOperation instanceof AttributeExtensible) {
                    this.printExtensibilityAttributes(BindingOperation.class, (AttributeExtensible)((Object)bindingOperation), definition, printWriter);
                }
                printWriter.println('>');
                this.printDocumentation(bindingOperation.getDocumentationElement(), printWriter);
                List list2 = bindingOperation.getExtensibilityElements();
                this.printExtensibilityElements(BindingOperation.class, list2, definition, printWriter);
                this.printBindingInput(bindingOperation.getBindingInput(), definition, printWriter);
                this.printBindingOutput(bindingOperation.getBindingOutput(), definition, printWriter);
                this.printBindingFaults(bindingOperation.getBindingFaults(), definition, printWriter);
                printWriter.println("    </" + string + '>');
            }
        }
    }

    protected void printBindingInput(BindingInput bindingInput, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (bindingInput != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "input", definition);
            printWriter.print("      <" + string);
            DOMUtils.printAttribute("name", bindingInput.getName(), printWriter);
            if (bindingInput instanceof AttributeExtensible) {
                this.printExtensibilityAttributes(BindingInput.class, (AttributeExtensible)((Object)bindingInput), definition, printWriter);
            }
            printWriter.println('>');
            this.printDocumentation(bindingInput.getDocumentationElement(), printWriter);
            List list = bindingInput.getExtensibilityElements();
            this.printExtensibilityElements(BindingInput.class, list, definition, printWriter);
            printWriter.println("      </" + string + '>');
        }
    }

    protected void printBindingOutput(BindingOutput bindingOutput, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (bindingOutput != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "output", definition);
            printWriter.print("      <" + string);
            DOMUtils.printAttribute("name", bindingOutput.getName(), printWriter);
            if (bindingOutput instanceof AttributeExtensible) {
                this.printExtensibilityAttributes(BindingOutput.class, (AttributeExtensible)((Object)bindingOutput), definition, printWriter);
            }
            printWriter.println('>');
            this.printDocumentation(bindingOutput.getDocumentationElement(), printWriter);
            List list = bindingOutput.getExtensibilityElements();
            this.printExtensibilityElements(BindingOutput.class, list, definition, printWriter);
            printWriter.println("      </" + string + '>');
        }
    }

    protected void printBindingFaults(Map map, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (map != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "fault", definition);
            for (BindingFault bindingFault : map.values()) {
                printWriter.print("      <" + string);
                DOMUtils.printAttribute("name", bindingFault.getName(), printWriter);
                if (bindingFault instanceof AttributeExtensible) {
                    this.printExtensibilityAttributes(BindingFault.class, (AttributeExtensible)((Object)bindingFault), definition, printWriter);
                }
                printWriter.println('>');
                this.printDocumentation(bindingFault.getDocumentationElement(), printWriter);
                List list = bindingFault.getExtensibilityElements();
                this.printExtensibilityElements(BindingFault.class, list, definition, printWriter);
                printWriter.println("      </" + string + '>');
            }
        }
    }

    protected void printPortTypes(Map map, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (map != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "portType", definition);
            for (PortType portType : map.values()) {
                if (portType.isUndefined()) continue;
                printWriter.print("  <" + string);
                QName qName = portType.getQName();
                if (qName != null) {
                    DOMUtils.printAttribute("name", qName.getLocalPart(), printWriter);
                }
                if (portType instanceof AttributeExtensible) {
                    this.printExtensibilityAttributes(PortType.class, (AttributeExtensible)((Object)portType), definition, printWriter);
                }
                printWriter.println('>');
                this.printDocumentation(portType.getDocumentationElement(), printWriter);
                this.printOperations(portType.getOperations(), definition, printWriter);
                printWriter.println("  </" + string + '>');
            }
        }
    }

    protected void printOperations(List list, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (list != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "operation", definition);
            for (Operation operation : list) {
                if (operation.isUndefined()) continue;
                printWriter.print("    <" + string);
                DOMUtils.printAttribute("name", operation.getName(), printWriter);
                DOMUtils.printAttribute("parameterOrder", StringUtils.getNMTokens(operation.getParameterOrdering()), printWriter);
                if (operation instanceof AttributeExtensible) {
                    this.printExtensibilityAttributes(Operation.class, (AttributeExtensible)((Object)operation), definition, printWriter);
                }
                printWriter.println('>');
                this.printDocumentation(operation.getDocumentationElement(), printWriter);
                OperationType operationType = operation.getStyle();
                if (operationType == OperationType.ONE_WAY) {
                    this.printInput(operation.getInput(), definition, printWriter);
                } else if (operationType == OperationType.SOLICIT_RESPONSE) {
                    this.printOutput(operation.getOutput(), definition, printWriter);
                    this.printInput(operation.getInput(), definition, printWriter);
                } else if (operationType == OperationType.NOTIFICATION) {
                    this.printOutput(operation.getOutput(), definition, printWriter);
                } else {
                    this.printInput(operation.getInput(), definition, printWriter);
                    this.printOutput(operation.getOutput(), definition, printWriter);
                }
                this.printFaults(operation.getFaults(), definition, printWriter);
                printWriter.println("    </" + string + '>');
            }
        }
    }

    protected void printInput(Input input, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (input != null) {
            Element element;
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "input", definition);
            printWriter.print("      <" + string);
            DOMUtils.printAttribute("name", input.getName(), printWriter);
            Message message = input.getMessage();
            if (message != null) {
                DOMUtils.printQualifiedAttribute("message", message.getQName(), definition, printWriter);
            }
            if (input instanceof AttributeExtensible) {
                this.printExtensibilityAttributes(Input.class, (AttributeExtensible)((Object)input), definition, printWriter);
            }
            if ((element = input.getDocumentationElement()) == null) {
                printWriter.println("/>");
            } else {
                printWriter.println('>');
                this.printDocumentation(element, printWriter);
                printWriter.println("      </" + string + '>');
            }
        }
    }

    protected void printOutput(Output output, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (output != null) {
            Element element;
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "output", definition);
            printWriter.print("      <" + string);
            DOMUtils.printAttribute("name", output.getName(), printWriter);
            Message message = output.getMessage();
            if (message != null) {
                DOMUtils.printQualifiedAttribute("message", message.getQName(), definition, printWriter);
            }
            if (output instanceof AttributeExtensible) {
                this.printExtensibilityAttributes(Output.class, (AttributeExtensible)((Object)output), definition, printWriter);
            }
            if ((element = output.getDocumentationElement()) == null) {
                printWriter.println("/>");
            } else {
                printWriter.println('>');
                this.printDocumentation(element, printWriter);
                printWriter.println("      </" + string + '>');
            }
        }
    }

    protected void printFaults(Map map, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (map != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "fault", definition);
            for (Fault fault : map.values()) {
                Element element;
                printWriter.print("      <" + string);
                DOMUtils.printAttribute("name", fault.getName(), printWriter);
                Message message = fault.getMessage();
                if (message != null) {
                    DOMUtils.printQualifiedAttribute("message", message.getQName(), definition, printWriter);
                }
                if (fault instanceof AttributeExtensible) {
                    this.printExtensibilityAttributes(Fault.class, (AttributeExtensible)((Object)fault), definition, printWriter);
                }
                if ((element = fault.getDocumentationElement()) == null) {
                    printWriter.println("/>");
                    continue;
                }
                printWriter.println('>');
                this.printDocumentation(element, printWriter);
                printWriter.println("      </" + string + '>');
            }
        }
    }

    protected void printMessages(Map map, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (map != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "message", definition);
            for (Message message : map.values()) {
                if (message.isUndefined()) continue;
                printWriter.print("  <" + string);
                QName qName = message.getQName();
                if (qName != null) {
                    DOMUtils.printAttribute("name", qName.getLocalPart(), printWriter);
                }
                if (message instanceof AttributeExtensible) {
                    this.printExtensibilityAttributes(Message.class, (AttributeExtensible)((Object)message), definition, printWriter);
                }
                printWriter.println('>');
                this.printDocumentation(message.getDocumentationElement(), printWriter);
                this.printParts(message.getOrderedParts(null), definition, printWriter);
                printWriter.println("  </" + string + '>');
            }
        }
    }

    protected void printParts(List list, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (list != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "part", definition);
            for (Part part : list) {
                Element element;
                printWriter.print("    <" + string);
                DOMUtils.printAttribute("name", part.getName(), printWriter);
                DOMUtils.printQualifiedAttribute("element", part.getElementName(), definition, printWriter);
                DOMUtils.printQualifiedAttribute("type", part.getTypeName(), definition, printWriter);
                if (part instanceof AttributeExtensible) {
                    this.printExtensibilityAttributes(Part.class, (AttributeExtensible)((Object)part), definition, printWriter);
                }
                if ((element = part.getDocumentationElement()) == null) {
                    printWriter.println("/>");
                    continue;
                }
                printWriter.println('>');
                this.printDocumentation(element, printWriter);
                printWriter.println("      </" + string + '>');
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void printExtensibilityAttributes(Class clazz, AttributeExtensible attributeExtensible, Definition definition, PrintWriter printWriter) throws WSDLException {
        Map map = attributeExtensible.getExtensionAttributes();
        for (QName qName : map.keySet()) {
            Object v = map.get(qName);
            String string = null;
            QName qName2 = null;
            if (v instanceof String) {
                string = (String)v;
            } else if (v instanceof QName) {
                qName2 = (QName)v;
            } else {
                if (!(v instanceof List)) throw new WSDLException("CONFIGURATION_ERROR", "Unknown type of extension attribute '" + qName + "': " + v.getClass().getName());
                List list = (List)v;
                int n = list.size();
                if (n > 0) {
                    Object e = list.get(0);
                    if (e instanceof String) {
                        string = StringUtils.getNMTokens(list);
                    } else {
                        if (!(e instanceof QName)) throw new WSDLException("CONFIGURATION_ERROR", "Unknown type of extension attribute '" + qName + "': " + e.getClass().getName());
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < n; ++i) {
                            QName qName3 = (QName)list.get(i);
                            stringBuffer.append((i > 0 ? " " : "") + DOMUtils.getQualifiedValue(qName3.getNamespaceURI(), qName3.getLocalPart(), definition));
                        }
                        string = stringBuffer.toString();
                    }
                } else {
                    string = "";
                }
            }
            if (qName2 != null) {
                DOMUtils.printQualifiedAttribute(qName, qName2, definition, printWriter);
                continue;
            }
            DOMUtils.printQualifiedAttribute(qName, string, definition, printWriter);
        }
    }

    protected void printDocumentation(Element element, PrintWriter printWriter) throws WSDLException {
        if (element != null) {
            DOM2Writer.serializeAsXML(element, printWriter);
            printWriter.println();
        }
    }

    protected void printTypes(Types types2, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (types2 != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "types", definition);
            printWriter.print("  <" + string);
            if (types2 instanceof AttributeExtensible) {
                this.printExtensibilityAttributes(Types.class, (AttributeExtensible)((Object)types2), definition, printWriter);
            }
            printWriter.println('>');
            this.printDocumentation(types2.getDocumentationElement(), printWriter);
            List list = types2.getExtensibilityElements();
            this.printExtensibilityElements(Types.class, list, definition, printWriter);
            printWriter.println("  </" + string + '>');
        }
    }

    protected void printImports(Map map, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (map != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/", "import", definition);
            for (List list : map.values()) {
                for (Import import_ : list) {
                    Element element;
                    printWriter.print("  <" + string);
                    DOMUtils.printAttribute("namespace", import_.getNamespaceURI(), printWriter);
                    DOMUtils.printAttribute("location", import_.getLocationURI(), printWriter);
                    if (import_ instanceof AttributeExtensible) {
                        this.printExtensibilityAttributes(Import.class, (AttributeExtensible)((Object)import_), definition, printWriter);
                    }
                    if ((element = import_.getDocumentationElement()) == null) {
                        printWriter.println("/>");
                        continue;
                    }
                    printWriter.println('>');
                    this.printDocumentation(element, printWriter);
                    printWriter.println("      </" + string + '>');
                }
            }
        }
    }

    protected void printNamespaceDeclarations(Map map, PrintWriter printWriter) throws WSDLException {
        if (map != null) {
            Set set = map.keySet();
            for (String string : set) {
                if (string == null) {
                    string = "";
                }
                DOMUtils.printAttribute("xmlns" + (!string.equals("") ? ":" + string : ""), (String)map.get(string), printWriter);
            }
        }
    }

    protected void printExtensibilityElements(Class clazz, List list, Definition definition, PrintWriter printWriter) throws WSDLException {
        if (list != null) {
            for (ExtensibilityElement extensibilityElement : list) {
                QName qName = extensibilityElement.getElementType();
                ExtensionRegistry extensionRegistry = definition.getExtensionRegistry();
                if (extensionRegistry == null) {
                    throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Definition, so unable to serialize a '" + qName + "' element in the context of a '" + clazz.getName() + "'.");
                }
                ExtensionSerializer extensionSerializer = extensionRegistry.querySerializer(clazz, qName);
                extensionSerializer.marshall(clazz, qName, extensibilityElement, printWriter, definition, extensionRegistry);
            }
        }
    }

    private static Document getDocument(InputSource inputSource, String string) throws WSDLException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (Throwable throwable) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + string + "'.", throwable);
        }
    }

    public Document getDocument(Definition definition) throws WSDLException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.writeWSDL(definition, printWriter);
        StringReader stringReader = new StringReader(stringWriter.toString());
        InputSource inputSource = new InputSource(stringReader);
        return WSDLWriterImpl.getDocument(inputSource, "- WSDL Document -");
    }

    public void writeWSDL(Definition definition, Writer writer) throws WSDLException {
        PrintWriter printWriter = new PrintWriter(writer);
        String string = writer instanceof OutputStreamWriter ? ((OutputStreamWriter)writer).getEncoding() : null;
        String string2 = DOM2Writer.java2XMLEncoding(string);
        if (string2 == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "Unsupported Java encoding for writing wsdl file: '" + string + "'.");
        }
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>");
        this.printDefinition(definition, printWriter);
    }

    public void writeWSDL(Definition definition, OutputStream outputStream) throws WSDLException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            outputStreamWriter = new OutputStreamWriter(outputStream);
        }
        this.writeWSDL(definition, outputStreamWriter);
    }

    public static void main(String[] stringArray) throws WSDLException {
        if (stringArray.length == 1) {
            WSDLFactory wSDLFactory = WSDLFactory.newInstance();
            WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
            WSDLWriter wSDLWriter = wSDLFactory.newWSDLWriter();
            wSDLWriter.writeWSDL(wSDLReader.readWSDL(null, stringArray[0]), System.out);
        } else {
            System.err.println("Usage:");
            System.err.println();
            System.err.println("  java " + WSDLWriterImpl.class.getName() + " filename|URL");
            System.err.println();
            System.err.println("This test driver simply reads a WSDL document into a model (using a WSDLReader), and then serializes it back to standard out. In effect, it performs a round-trip test on the specified WSDL document.");
        }
    }
}

