/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class WebServicesSecurityAlgorithmHelper {
    private static final TraceComponent tc = Tr.register(WebServicesSecurityAlgorithmHelper.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String FFDC_SOURCE_ID = "com.ibm.ws.webservices.wssecurity.util.WebServicesSecurityAlgorithmHelper";
    private static final String clsName = WebServicesSecurityAlgorithmHelper.class.getName();
    private static final String comp = "security.wssecurity";
    protected static Set _transforms = new HashSet();
    protected static Set _canonicalizationMethods = new HashSet();
    protected static Set _signatureMethods = new HashSet();
    protected static Set _digestMethods = new HashSet();
    protected static Set _encryptionMethods = new HashSet();
    protected static Set _keyEncryptionMethods = new HashSet();
    protected static Set _fipsSignatureMethods = new HashSet();
    protected static Set _fipsDigestMethods = new HashSet();
    protected static Set _fipsEncryptionMethods = new HashSet();
    protected static Set _fipsKeyEncryptionMethods = new HashSet();
    protected static Set _canonicalizationMethods5 = new HashSet();
    protected static Set _signatureMethods5 = new HashSet();
    protected static Set _digestMethods5 = new HashSet();
    protected static Set _encryptionMethods5 = new HashSet();
    protected static Set _keyEncryptionMethods5 = new HashSet();
    protected static Set _fipsSignatureMethods5 = new HashSet();
    protected static Set _fipsDigestMethods5 = new HashSet();
    protected static Set _fipsEncryptionMethods5 = new HashSet();
    protected static Set _fipsKeyEncryptionMethods5 = new HashSet();
    protected static boolean _init_failed = false;
    protected static boolean _init_called = false;
    protected static SoapSecurityException _sse = null;

    public WebServicesSecurityAlgorithmHelper() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebServicesSecurityAlgorithmHelper");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebServicesSecurityAlgorithmHelper");
        }
    }

    private static synchronized void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        if (!_init_called) {
            try {
                Document document = DOMUtil.getPrivateConfig();
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document, "Transform", "algorithm", _transforms);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document, "canonicalizationMethod", "algorithm", _canonicalizationMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document, "signatureMethod", "algorithm", _signatureMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document, "digestMethod", "algorithm", _digestMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document, "encryptionMethod", "algorithm", _encryptionMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document, "keyEncryptionMethod", "algorithm", _keyEncryptionMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document, "fipsSignatureMethod", "algorithm", _fipsSignatureMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document, "fipsDigestMethod", "algorithm", _fipsDigestMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document, "fipsEncryptionMethod", "algorithm", _fipsEncryptionMethods);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document, "fipsKeyEncryptionMethod", "algorithm", _fipsKeyEncryptionMethods);
                Document document2 = com.ibm.xml.soapsec.util.DOMUtil.getConfigValidation();
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document2, "canonicalizationMethod", "algorithm", _canonicalizationMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document2, "signatureMethod", "algorithm", _signatureMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document2, "digestMethod", "algorithm", _digestMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document2, "encryptionMethod", "algorithm", _encryptionMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document2, "keyEncryptionMethod", "algorithm", _keyEncryptionMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document2, "fipsSignatureMethod", "algorithm", _fipsSignatureMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document2, "fipsDigestMethod", "algorithm", _fipsDigestMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document2, "fipsEncryptionMethod", "algorithm", _fipsEncryptionMethods5);
                WebServicesSecurityAlgorithmHelper.addAlgorithmsToSet(document2, "fipsKeyEncryptionMethod", "algorithm", _fipsKeyEncryptionMethods5);
            }
            catch (SoapSecurityException soapSecurityException) {
                FFDCFilter.processException(soapSecurityException, clsName + ".init", "129");
                Tr.error(tc, "Exception while retrieving available algorithms: " + soapSecurityException);
                _init_failed = true;
                _sse = soapSecurityException;
            }
            _init_called = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    private static void addAlgorithmsToSet(Document document, String string, String string2, Set set) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAlgorithmsToSet(doc = " + document + ", tag = " + string + ", attribute = " + string2 + ", set = " + set + ")");
        }
        NodeList nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", string);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string3 = DOMUtil.getAttribute((Element)((Element)nodeList.item(i)), (String)string2);
            if (ConfigValidation.isAlgoSupportedByRuntime(string3)) {
                set.add(string3);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Algorithm " + string3 + " not supported by runtime.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Set of " + string + " algorithms: " + set);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAlgorithmsToSet");
        }
    }

    public Set getFipsDataEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFipsDataEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFipsDataEncryptionAlgorithms");
        }
        return _fipsEncryptionMethods;
    }

    public Set getFipsKeyEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFipsKeyEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFipsKeyEncryptionAlgorithms");
        }
        return _fipsKeyEncryptionMethods;
    }

    public Set getFipsSignatureAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFipsSignatureAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFipsSignatureAlgorithms");
        }
        return _fipsSignatureMethods;
    }

    public Set getFipsDigestAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFipsDigestAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFipsDigestAlgorithms");
        }
        return _fipsDigestMethods;
    }

    public Set getDataEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataEncryptionAlgorithms");
        }
        return _encryptionMethods;
    }

    public Set getKeyEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyEncryptionAlgorithms");
        }
        return _keyEncryptionMethods;
    }

    public Set getSignatureAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignatureAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignatureAlgorithms");
        }
        return _signatureMethods;
    }

    public Set getDigestAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDigestAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDigestAlgorithms");
        }
        return _digestMethods;
    }

    public Set getCanonicalizationAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCanonicalizationAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCanonicalizationAlgorithms");
        }
        return _canonicalizationMethods;
    }

    public Set getTransformAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransformAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransformAlgorithms");
        }
        return _transforms;
    }

    public Set get5xFipsDataEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xFipsDataEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xFipsDataEncryptionAlgorithms");
        }
        return _fipsEncryptionMethods5;
    }

    public Set get5xFipsKeyEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xFipsKeyEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xFipsKeyEncryptionAlgorithms");
        }
        return _fipsKeyEncryptionMethods5;
    }

    public Set get5xFipsSignatureAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xFipsSignatureAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xFipsSignatureAlgorithms");
        }
        return _fipsSignatureMethods5;
    }

    public Set get5xFipsDigestAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xFipsDigestAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xFipsDigestAlgorithms");
        }
        return _fipsDigestMethods5;
    }

    public Set get5xDataEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xDataEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xDataEncryptionAlgorithms");
        }
        return _encryptionMethods5;
    }

    public Set get5xKeyEncryptionAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xKeyEncryptionAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xKeyEncryptionAlgorithms");
        }
        return _keyEncryptionMethods5;
    }

    public Set get5xSignatureAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xSignatureAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xSignatureAlgorithms");
        }
        return _signatureMethods5;
    }

    public Set get5xDigestAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xDigestAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xDigestAlgorithms");
        }
        return _digestMethods5;
    }

    public Set get5xCanonicalizationAlgorithms() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get5xCanonicalizationAlgorithms");
        }
        WebServicesSecurityAlgorithmHelper.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get5xCanonicalizationAlgorithms");
        }
        return _canonicalizationMethods5;
    }
}

