/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.XPathElementSelector;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSPFunctionElementSelector
extends XPathElementSelector {
    private static final TraceComponent tc = Tr.register((Class)WSPFunctionElementSelector.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String WSP_BODY = "wsp:Body";
    private static final String WSP_HEADER = "wsp:Header";
    private static final String[] BODY_TEMPLATE = new String[]{"/*[namespace-uri()='", "' and local-name()='Envelope']/*[namespace-uri()='", "' and local-name()='Body']"};
    private static final String[] HEADER_TEMPLATE = new String[]{"/*[namespace-uri()='", "' and local-name()='Envelope']/*[namespace-uri()='", "' and local-name()='Header']/*[name()='", "']"};

    public void init(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map properties)");
        }
        super.init(map);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map properties)");
        }
    }

    public NodeList getElements(Node node, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElements(Node node[" + DOMUtil.getDisplayName((Node)node) + "]," + "Map context)"));
        }
        String string = (String)map.get("com.ibm.ws.webservices.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Expression [" + string + "]"));
        }
        int n = 0;
        Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        String string2 = Constants.NAMESPACES[2][n];
        if (string != null) {
            string = WSPFunctionElementSelector.convert2XPath(string2, string);
            map.put("com.ibm.ws.webservices.wssecurity.util.selector.keyword", string);
        }
        NodeList nodeList = super.getElements(node, map);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getElements(Node node,Map context) returns NodeList[" + nodeList + "]"));
        }
        return nodeList;
    }

    protected static String convert2XPath(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convert2XPath(String nsSoap[" + string + "]," + "String exp[" + string2 + "])"));
        }
        string2 = string2.trim();
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.startsWith(WSP_BODY)) {
            stringBuffer.append(BODY_TEMPLATE[0]).append(string);
            stringBuffer.append(BODY_TEMPLATE[1]).append(string);
            stringBuffer.append(BODY_TEMPLATE[2]);
            int n = string2.indexOf(41) + 1;
            if (n != string2.length()) {
                stringBuffer.append(string2.substring(n));
            }
        } else if (string2.startsWith(WSP_HEADER)) {
            stringBuffer.append(HEADER_TEMPLATE[0]).append(string);
            stringBuffer.append(HEADER_TEMPLATE[1]).append(string);
            stringBuffer.append(HEADER_TEMPLATE[2]);
            int n = string2.indexOf(40) + 1;
            int n2 = string2.indexOf(41);
            stringBuffer.append(string2.substring(n, n2));
            stringBuffer.append(HEADER_TEMPLATE[3]);
            if (n2 != string2.length() - 1) {
                stringBuffer.append(string2.substring(n2 + 1));
            }
        }
        String string3 = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("convert2XPath(String nsSoap,String exp) returns String[" + string3 + "]"));
        }
        return string3;
    }
}

