/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.core.WSSGenerator;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimestampDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register((Class)TimestampDialectElementSelector.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    public static final String MOVE_MODE = "move";
    public static final String CHECK_MODE = "check";
    public static final int SECURITYFIRST = 0;
    public static final int SECURITYLAST = 1;
    public static final int SOAPHEADERFIRST = 2;
    public static final int SOAPHEADERLAST = 3;
    public static final int SECURITY_GENERATOR_DEFAULT = 1;
    public static final int SOAPHEADER_GENERATOR_DEFAULT = 3;
    public static final int SECURITY_CONSUMER_DEFAULT = 4;
    public static final int SOAPHEADER_CONSUMER_DEFAULT = 5;
    public static final String[] WASDIALECTS = new String[]{"SecurityFirst".intern(), "SecurityLast".intern(), "SOAPHeaderFirst".intern(), "SOAPHeaderLast".intern(), "SecurityConsumerDefault".intern(), "SOAPHeaderConsumerDefault".intern()};

    public void init(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map properties)");
        }
    }

    public NodeList getElements(Node node, Map map) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElements(Node node[" + DOMUtil.getDisplayName((Node)node) + "]," + "Map context)"));
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        if (!(node instanceof Document)) {
            throw SoapSecurityException.format("security.wssecurity.IntegralDialectElementSelector.s01", node.getClass().getName(), "Document");
        }
        String string = (String)map.get("com.ibm.ws.webservices.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Expression [" + string + "]"));
        }
        if (string == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object v = map.get("com.ibm.ws.webservices.wssecurity.util.selector.operation");
        boolean bl = MOVE_MODE.equals((String)v);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Mode [" + v + "]"));
        }
        v = map.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int n = 0;
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int n2 = 0;
        if (v != null && v instanceof Integer) {
            n2 = (Integer)v;
        }
        String string2 = Constants.NAMESPACES[1][n2];
        String string3 = null;
        if (map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey") == null) {
            object = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
            if (object != null) {
                string3 = object.getMyActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got consumer actor " + string3));
            }
        } else {
            object = (WSSGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            if (object != null) {
                string3 = object.getTargetActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got generator actor " + string3));
            }
        }
        object = (Document)node;
        Element element = WSSGenerator.getHeader((Document)object, false);
        Element element2 = WSSGenerator.getSecurityHeader(element, n, n2, string3, false);
        NodeList nodeList = null;
        nodeList = bl ? TimestampDialectElementSelector.moveTimestamp(element, element2, string, string2, map) : TimestampDialectElementSelector.getElements(element, element2, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getElements(Node node,Map context)");
        }
        return nodeList;
    }

    private static NodeList moveTimestamp(Element element, Element element2, String string, String string2, Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("moveTimestamp(Element header[" + DOMUtil.getDisplayName((Node)element) + "]," + "Element security[" + DOMUtil.getDisplayName((Node)element2) + "]," + "String keyword[" + string + "]," + "String nsWsu[" + string2 + "]," + "Map context)"));
        }
        Node node = null;
        Object[] objectArray = (Object[])map.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
        if (objectArray != null && objectArray.length > 0) {
            node = (Node)objectArray[0];
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.TimestampDialectElementSelector.s01");
        }
        node.getParentNode().removeChild(node);
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        if (WASDIALECTS[0].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Moving to the first of the Security element.");
            }
            node = element2.insertBefore(node, element2.getFirstChild());
        } else if (WASDIALECTS[1].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Moving to the last of the Security element.");
            }
            node = element2.appendChild(node);
        } else if (WASDIALECTS[2].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Moving to the first of the SOAP header element.");
            }
            node = element.insertBefore(node, element.getFirstChild());
        } else if (WASDIALECTS[3].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Moving to the last of the Security element.");
            }
            node = element.appendChild(node);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unknown keyword[" + string + "], so applying the default."));
                Tr.debug((TraceComponent)tc, (String)"Moving to the last of the Security element.");
            }
            node = element2.appendChild(node);
        }
        objectArray[0] = node;
        map.put("com.ibm.ws.webservices.wssecurity.util.selector.element", objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("moveTimestamp(Element header,Element security,String keyword,String nsWsu,Map context) returns NodeList[" + nodeListImpl + "]"));
        }
        return nodeListImpl;
    }

    private static NodeList getElements(Element element, Element element2, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElements(Element header[" + DOMUtil.getDisplayName((Node)element) + "]," + "Element security[" + DOMUtil.getDisplayName((Node)element2) + "]," + "String keyword[" + string + "]," + "String nsWsu[" + string2 + "])"));
        }
        XPathCanonicalizer.NodeListImpl nodeListImpl = new XPathCanonicalizer.NodeListImpl();
        Element element3 = null;
        if (WASDIALECTS[0].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the first child element in the Security element.");
            }
            element3 = DOMUtil.getFirstElement((Node)element2);
        } else if (WASDIALECTS[1].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the last child element in the Security element.");
            }
            element3 = DOMUtil.getLastElement((Node)element2);
        } else if (WASDIALECTS[2].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the first child element in the SOAP header element.");
            }
            element3 = DOMUtil.getFirstElement((Node)element);
        } else if (WASDIALECTS[3].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the last child element in the SOAP header element.");
            }
            element3 = DOMUtil.getLastElement((Node)element);
        } else if (WASDIALECTS[4].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the immediate child element in the Security element.");
            }
            element3 = DOMUtil.getFirstElement((Node)element2, (String)string2, (String)"Timestamp");
        } else if (WASDIALECTS[5].equals(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the immediate child element in the SOAP header element.");
            }
            element3 = DOMUtil.getFirstElement((Node)element, (String)string2, (String)"Timestamp");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unknown keyword[" + string + "], so applying the default."));
                Tr.debug((TraceComponent)tc, (String)"Getting the last child element in the Security element.");
            }
            element3 = DOMUtil.getLastElement((Node)element2);
        }
        nodeListImpl.add((Node)element3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getElements(Element header,Element security,String keyword,String nsWsu, returns NodeList[" + nodeListImpl + "]"));
        }
        return nodeListImpl;
    }
}

