/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.token.UTC;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NonceUtil {
    private static final TraceComponent tc = Tr.register((Class)NonceUtil.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = NonceUtil.class.getName();
    private static final long minForwardClockSkew = 90000L;
    private static final String HTTP_STR = "http://".intern();

    public static Element getTimestamp(Element element, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestamp(Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsu[" + string + "])"));
        }
        Element element2 = null;
        element2 = DOMUtil.equals((Node)element, (String)string, (String)"Timestamp") ? element : DOMUtil.getLastElement((Node)element, (String)string, (String)"Timestamp");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTimestamp(Element parent,String nsWsu) returns Element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
        }
        return element2;
    }

    public static Element getNonce(Element element, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNonce(Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsse[" + string + "])"));
        }
        Element element2 = null;
        element2 = DOMUtil.equals((Node)element, (String)string, (String)"Nonce") ? element : DOMUtil.getLastElement((Node)element, (String)string, (String)"Nonce");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNonce(Element parent,String nsWsse) returns Element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
        }
        return element2;
    }

    public static Element getChildTimestamp(Element element, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestamp(Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsu[" + string + "])"));
        }
        Element element2 = DOMUtil.getOneChildElement((Element)element, (String)string, (String)"Timestamp");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTimestamp(Element parent,String nsWsu) returns Element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
        }
        return element2;
    }

    public static Element getChildNonce(Element element, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNonce(Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsse[" + string + "])"));
        }
        Element element2 = DOMUtil.getOneChildElement((Element)element, (String)string, (String)"Nonce");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNonce(Element parent,String nsWsse) returns Element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
        }
        return element2;
    }

    public static Element createTimestamp(Document document, Element element, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createTimestamp(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsu[" + string + "]," + "String extType[" + string2 + "])"));
        }
        String string3 = DOMUtil.getNamespacePrefix((Element)element, (String)string);
        Element element2 = null;
        if (string3 == null) {
            element2 = document.createElementNS(string, "wsu:Timestamp");
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", string);
        } else {
            element2 = document.createElementNS(string, string3 + ":Timestamp");
        }
        if ("wedsig".equals(string2) || "weenc".equals(string2)) {
            element2.setAttribute("wasextention", string2);
        }
        element2 = (Element)element.appendChild(element2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createTimestamp(Document doc,Element parent,String nsWsu,boolean extention) returns Element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
        }
        return element2;
    }

    public static Element addCreated(Document document, Element element, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addCreated(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsu[" + string + "])"));
        }
        boolean bl = false;
        String string2 = DOMUtil.getNamespacePrefix((Element)element, (String)string);
        if (string2 == null) {
            bl = true;
            string2 = "wsu:";
        } else if (string2.length() > 0) {
            string2 = string2 + ":";
        }
        Date date = new Date();
        String string3 = UTC.format((Date)date);
        Element element2 = document.createElementNS(string, string2 + "Created");
        element2.appendChild(document.createTextNode(string3));
        element2 = (Element)element.appendChild(element2);
        if (bl) {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addCreated(Document doc,Element parent,String nsWsu) returns Element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
        }
        return element2;
    }

    public static Element addExpires(Document document, Element element, Duration duration, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addExpires(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "Duration duration[" + duration + "]," + "String nsWsu[" + string + "])"));
        }
        boolean bl = false;
        String string2 = DOMUtil.getNamespacePrefix((Element)element, (String)string);
        if (string2 == null) {
            bl = true;
            string2 = "wsu:";
        } else if (string2.length() > 0) {
            string2 = string2 + ":";
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        duration.addTo(calendar);
        String string3 = UTC.format((Date)calendar.getTime());
        Element element2 = document.createElementNS(string, string2 + "Expires");
        element2.appendChild(document.createTextNode(string3));
        element2 = (Element)element.appendChild(element2);
        if (bl) {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addExpires(Document doc,Element parent,Duration duration,String nsWsu) returns Element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
        }
        return element2;
    }

    public static Element createNonce(Document document, Element element, String string, NonceManager nonceManager, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createNonce(Document doc[" + DOMUtil.getDisplayName((Node)document) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsse[" + string + "]," + "NonceManager nmanager[" + nonceManager + "]," + "String extType[" + string2 + "])"));
        }
        boolean bl = false;
        String string3 = DOMUtil.getNamespacePrefix((Element)element, (String)string);
        if (string3 == null) {
            bl = true;
            string3 = "wsse:";
        } else if (string3.length() > 0) {
            string3 = string3 + ":";
        }
        Element element2 = document.createElementNS(string, string3 + "Nonce");
        if (bl) {
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", string);
        }
        if ("wedsig".equals(string2) || "weenc".equals(string2)) {
            element2.setAttribute("wasextention", string2);
        }
        element2.appendChild(document.createTextNode(NonceUtil.generateNonce(nonceManager)));
        element2 = (Element)element.appendChild(element2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createNonce(Document doc,Element parent,String nsWsse,String nmanager) returns Element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
        }
        return element2;
    }

    public static String generateNonce(NonceManager nonceManager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("generateNonce(NonceManager nmanager[" + nonceManager + "])"));
        }
        byte[] byArray = nonceManager.generate();
        String string = Base64.encode((byte[])byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateNonce(NonceManager nmanager) returns String[" + string + "]"));
        }
        return string;
    }

    public static void checkNonce(Element element, String string, NonceManager nonceManager) throws SoapSecurityException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkNonce(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsse[" + string + "]," + "NonceManager nmanager[" + nonceManager + "])"));
        }
        if (element == null) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s06");
        }
        String string3 = element.getLocalName();
        String string4 = element.getNamespaceURI();
        if (!string.equals(string4) || !"Nonce".equals(string3)) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtil.getQualifiedName((Node)element));
        }
        QName qName = Constants.BASE64_BINARY;
        if (element.hasAttribute("EncodingType")) {
            string2 = element.getAttribute("EncodingType");
            qName = DOMUtil.getQName((Element)element, (String)string2);
        }
        string2 = DOMUtil.getStringValue((Node)element);
        byte[] byArray = null;
        if (Constants.BASE64_BINARY.equals(qName)) {
            byArray = Base64.decode((String)string2);
        } else if (Constants.HEX_BINARY.equals(qName)) {
            try {
                byArray = Hex.decode((String)string2);
            }
            catch (ParseException parseException) {
                Tr.processException((Throwable)parseException, (String)(clsName + ".checkNonce"), (String)"371");
                throw SoapSecurityException.format("security.wssecurity.NonceUtil.s01", parseException);
            }
        }
        if (!nonceManager.validate(byArray)) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s02", string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkNonce(Element element,String nsWsse,NonceManager nmanager)");
        }
    }

    public static void checkTimestamp(Node node, String string, int n, int n2, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkTimestamp(Node node[" + DOMUtil.getDisplayName((Node)node) + "]," + "String nsWsu[" + string + "]," + "int maxAge[" + n + "]," + "int clockSkew[" + n2 + "]," + "boolean logError[" + bl + "])"));
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s07");
        }
        String string2 = node.getLocalName();
        String string3 = node.getNamespaceURI();
        if (node.getNodeType() != 1 || !string.equals(string3) || !"Timestamp".equals(string2)) {
            if (bl) {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s03", (Object)new Object[]{DOMUtil.getQualifiedName((Node)node)});
            }
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtil.getQualifiedName((Node)node));
        }
        Element element = (Element)node;
        Date date = null;
        Date date2 = null;
        try {
            Element element2;
            Element element3 = DOMUtil.getFirstElement((Node)element, (String)string, (String)"Created");
            if (element3 != null) {
                NonceUtil.checkType(element3);
                date = UTC.parse((String)DOMUtil.getStringValue((Node)element3));
            }
            if ((element2 = DOMUtil.getFirstElement((Node)element, (String)string, (String)"Expires")) != null) {
                NonceUtil.checkType(element2);
                date2 = UTC.parse((String)DOMUtil.getStringValue((Node)element2));
            }
        }
        catch (ParseException parseException) {
            Tr.processException((Throwable)parseException, (String)(clsName + ".checkTimestamp"), (String)"437");
            if (bl) {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.NonceUtil.s03", (Object)new Object[]{parseException});
            }
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s03", parseException);
        }
        long l = System.currentTimeMillis();
        Date date3 = new Date(l);
        if (date2 != null && date3.after(date2)) {
            String string4 = date != null ? date.toString() : "";
            String string5 = date2 != null ? date2.toString() : "";
            String string6 = date3.toString();
            if (bl) {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.NonceUtil.s04", (Object)new Object[]{string4, string5, string6});
            }
            throw SoapSecurityException.format(Constants.MESSAGE_EXPIRED, "security.wssecurity.NonceUtil.s04", new String[]{string4, string5, string6});
        }
        if (date != null) {
            Long l2 = new Long(l);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("current time = " + l + " ms"));
            }
            if (n < 0) {
                n = 300;
            }
            long l3 = n * 1000;
            long l4 = l - l3;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Max age = " + l3 + " ms, (current - max age) = " + l4 + " ms"));
            }
            if (n2 < 0) {
                n2 = 0;
            }
            long l5 = n2 * 1000;
            l4 -= l5;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Clock skew = " + l5 + " ms, (current - clock skew) = " + l4 + " ms"));
            }
            long l6 = date.getTime();
            Long l7 = new Long(l6);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Created time (timestamp) = " + l6 + " ms"));
            }
            if (l6 < l4) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Timestamp is not fresh, creation timestamp " + UTC.format((Date)date) + " too old"));
                }
                String string7 = "security.wssecurity.WSEC5205E";
                String string8 = "security.wssecurity.WSEC5206E";
                Tr.error((TraceComponent)tc, (String)string8, (Object)new Object[]{l2.toString(), l7.toString()});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, string7);
            }
            if (l5 < 90000L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Clock skew increased to 90000ms for forward timestamp check.");
                }
                l5 = 90000L;
            }
            long l8 = l + l5;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Clock skew = " + l5 + " ms, (current + clock skew) = " + l8 + " ms"));
            }
            if (l6 > l8) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Timestamp is not valid, creation timestamp " + UTC.format((Date)date) + " too far in future"));
                }
                String string9 = "security.wssecurity.WSEC5208E";
                String string10 = "security.wssecurity.WSEC5206E";
                Tr.error((TraceComponent)tc, (String)string10, (Object)new Object[]{l2.toString(), l7.toString()});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, string9);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Timestamp is fresh");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTimestamp(Node node,String nsWsu,int maxAge,int clockSkew,boolean logError)");
        }
    }

    private static void checkType(Element element) throws SoapSecurityException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkType(Element timestamp[" + DOMUtil.getDisplayName((Node)element) + "])"));
        }
        if ((string = element.getAttribute("ValueType")) != null && string.length() > 0) {
            if (string.startsWith(HTTP_STR)) {
                if (!string.equals(Constants.XSD_DATETIME)) {
                    throw SoapSecurityException.format("security.wssecurity.NonceUtil.s05", string);
                }
            } else {
                QName qName = DOMUtil.getQName((Element)element, (String)string);
                if (!qName.equals(Constants.DATETIME)) {
                    throw SoapSecurityException.format("security.wssecurity.NonceUtil.s05", qName.toString());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkType(Element timestamp)");
        }
    }

    public static boolean isNonceFirst(Element element, Element element2, Element element3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isNonceFirst(Element parent[" + DOMUtil.getDisplayName((Node)element) + "]," + "Element nonce[" + DOMUtil.getDisplayName((Node)element2) + "]," + "Element timestamp[" + DOMUtil.getDisplayName((Node)element3) + "])"));
        }
        boolean bl = false;
        if (element2 != null) {
            if (element3 == null) {
                bl = true;
            } else {
                Element element4 = DOMUtil.getFirstElement((Node)element);
                while (element4 != null) {
                    if (element4.equals(element2)) {
                        bl = true;
                        break;
                    }
                    if (element4.equals(element3)) break;
                    element4 = DOMUtil.getNextElement((Node)element4);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isNonceFirst(Element parent,Element nonce,Element timestamp) return boolean[" + bl + "]"));
        }
        return bl;
    }

    public static Date checkNonceTimestamp(Element element, String string, int n, int n2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkNonceTimestamp(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsu[" + string + "]," + "int maxAge[" + n + "]," + "int clockSkew[" + n2 + "])"));
        }
        if (element == null) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s08");
        }
        String string2 = element.getLocalName();
        String string3 = element.getNamespaceURI();
        if (!string.equals(string3) || !"Created".equals(string2)) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtil.getQualifiedName((Node)element));
        }
        Date date = null;
        try {
            NonceUtil.checkType(element);
            date = UTC.parse((String)DOMUtil.getStringValue((Node)element));
        }
        catch (ParseException parseException) {
            Tr.processException((Throwable)parseException, (String)(clsName + ".checkNonceTimestamp"), (String)"626");
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s03", parseException);
        }
        long l = System.currentTimeMillis();
        Date date2 = new Date(l);
        Long l2 = new Long(l);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current time = " + l + " ms"));
        }
        if (n < 0) {
            n = 300;
        }
        long l3 = n * 1000;
        long l4 = l - l3;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce max age = " + l3 + " ms, (current - Nonce max age) = " + l4 + " ms"));
        }
        if (n2 < 0) {
            n2 = 0;
        }
        long l5 = n2 * 1000;
        l4 -= l5;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce clock skew = " + l5 + " ms, (current - Nonce clock skew) = " + l4 + " ms"));
        }
        long l6 = date.getTime();
        Long l7 = new Long(l6);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce created time (timestamp) = " + l6 + " ms"));
        }
        if (l6 < l4) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nonce timestamp is not fresh, creation timestamp " + UTC.format((Date)date) + " too old"));
            }
            String string4 = "security.wssecurity.WSEC5193E";
            String string5 = "security.wssecurity.WSEC5200E";
            Tr.error((TraceComponent)tc, (String)string5, (Object)new Object[]{l2.toString(), l7.toString()});
            throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, string4);
        }
        if (l5 < 90000L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Clock skew increased to 90000ms for forward timestamp check.");
            }
            l5 = 90000L;
        }
        long l8 = l + l5;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Clock skew = " + l5 + " ms, (current + clock skew) = " + l8 + " ms"));
        }
        if (l6 > l8) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nonce timestamp is not valid, creation timestamp " + UTC.format((Date)date) + " too far in advance"));
            }
            String string6 = "security.wssecurity.WSEC5209E";
            String string7 = "security.wssecurity.WSEC5200E";
            Tr.error((TraceComponent)tc, (String)string7, (Object)new Object[]{l2.toString(), l7.toString()});
            throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, string6);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Nonce Timestamp is fresh");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkNonceTimestamp(Element element,String nsWsu,int maxAge,int clockSkew) returns Date[" + date + "]"));
        }
        return date;
    }
}

