/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.LoginBinding;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKey;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluatorRef;
import com.ibm.etools.webservice.wscommonext.AuthMethod;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.ConfidentialPartPart;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.IDAssertion;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wscommonext.ReferencePart;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wsext.LoginConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import java.io.File;
import java.security.AlgorithmParameters;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ConfigValidation {
    private VariableMap varMap = null;
    private WSSecurityDefaultConfiguration config = null;
    private static String isFipsEnabled = null;
    private static boolean rsaoaepInitialized = false;
    private static boolean rsaoaepSupported = false;
    private static byte[] lock = new byte[0];
    protected final Set allowedEncAlgos = new HashSet();
    protected final Set allowedKeyEncAlgos = new HashSet();
    protected final Set allowedC14nAlgos = new HashSet();
    protected final Set allowedSignAlgos = new HashSet();
    protected final Set allowedDigestAlgos = new HashSet();
    private static final String comp = "security.wssecurity";
    private static final String clsName = ConfigValidation.class.getName();
    private static final TraceComponent tc = Tr.register(ConfigValidation.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public ConfigValidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigValidation()");
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigValidation()");
        }
    }

    public ConfigValidation(VariableMap variableMap, WSSecurityService wSSecurityService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigValidation(VariableMap, WSSecurityService):", new Object[]{variableMap, wSSecurityService});
        }
        this.init();
        this.varMap = variableMap;
        this.config = wSSecurityService != null ? (WSSecurityDefaultConfiguration)wSSecurityService.getConfig() : null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigValidation()");
        }
    }

    public ConfigValidation(VariableMap variableMap, WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigValidation(VariableMap, WSSecurityDefaultConfiguration):", new Object[]{variableMap, wSSecurityDefaultConfiguration});
        }
        this.init();
        this.varMap = variableMap;
        this.config = wSSecurityDefaultConfiguration;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigValidation()");
        }
    }

    private void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        this.processAllowedAlgorithms(DOMUtil.getConfigValidation());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public void initVarMap(VariableMap variableMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initVarMap(VariableMap):", new Object[]{variableMap});
        }
        this.varMap = variableMap;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initVarMap()");
        }
    }

    public void initDefaultConfig(WSSecurityDefaultConfiguration wSSecurityDefaultConfiguration) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initDefaultConfig(WSSecurityDefaultConfiguration):", new Object[]{wSSecurityDefaultConfiguration});
        }
        this.config = wSSecurityDefaultConfiguration;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initDefaultConfig()");
        }
    }

    public void initWsService(WSSecurityService wSSecurityService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initWsService(WSSecurityService):", new Object[]{wSSecurityService});
        }
        if (wSSecurityService != null) {
            this.config = (WSSecurityDefaultConfiguration)wSSecurityService.getConfig();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initWsService()");
        }
    }

    public boolean requiredIntegrityValid(RequiredIntegrity requiredIntegrity) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requiredIntegrityValid(" + requiredIntegrity + ")");
        }
        String string = null;
        boolean bl = true;
        if (requiredIntegrity != null) {
            int n = requiredIntegrity.getReferences().size();
            for (int i = 0; i < n; ++i) {
                Reference reference = (Reference)requiredIntegrity.getReferences().get(i);
                ReferencePart referencePart = reference.getPart();
                String string2 = null;
                if (referencePart != null) {
                    string2 = referencePart.getName();
                }
                if ("body".equals(string2) || "timestamp".equals(string2) || "securitytoken".equals(string2)) continue;
                bl = false;
                String string3 = "security.wssecurity.ConfigValidation.required.integrity.invalid";
                Tr.error(tc, string3, new Object[]{string2});
                String string4 = MessageFormat.format(ConfigConstants.getMessage(string3), string2);
                string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requiredIntegrityValid() returns " + bl);
        }
        return bl;
    }

    public boolean requiredConfidentialityValid(RequiredConfidentiality requiredConfidentiality) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requiredConfidentialityValid(" + requiredConfidentiality + ")");
        }
        String string = null;
        boolean bl = true;
        if (requiredConfidentiality != null) {
            int n = requiredConfidentiality.getConfidentialParts().size();
            for (int i = 0; i < n; ++i) {
                ConfidentialPart confidentialPart = (ConfidentialPart)requiredConfidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confidentialPartPart = confidentialPart.getPart();
                String string2 = null;
                if (confidentialPartPart != null) {
                    string2 = confidentialPartPart.getName();
                }
                if ("bodycontent".equals(string2) || "usernametoken".equals(string2)) continue;
                bl = false;
                String string3 = "security.wssecurity.ConfigValidation.required.conf.invalid";
                Tr.error(tc, string3, new Object[]{string2});
                String string4 = MessageFormat.format(ConfigConstants.getMessage(string3), string2);
                string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requiredConfidentialityValid() returns " + bl);
        }
        return bl;
    }

    public boolean integrityValid(Integrity integrity) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "integrityValid(" + integrity + ")");
        }
        String string = null;
        boolean bl = true;
        if (integrity != null) {
            int n = integrity.getReferences().size();
            for (int i = 0; i < n; ++i) {
                Reference reference = (Reference)integrity.getReferences().get(i);
                ReferencePart referencePart = reference.getPart();
                String string2 = null;
                if (referencePart != null) {
                    string2 = referencePart.getName();
                }
                if ("body".equals(string2) || "timestamp".equals(string2) || "securitytoken".equals(string2)) continue;
                bl = false;
                String string3 = "security.wssecurity.ConfigValidation.integrity.invalid";
                Tr.error(tc, string3, new Object[]{string2});
                String string4 = MessageFormat.format(ConfigConstants.getMessage(string3), string2);
                string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "integrityValid() returns " + bl);
        }
        return bl;
    }

    public boolean confidentialityValid(Confidentiality confidentiality) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "confidentialityValid(" + confidentiality + ")");
        }
        String string = null;
        boolean bl = true;
        if (confidentiality != null) {
            int n = confidentiality.getConfidentialParts().size();
            for (int i = 0; i < n; ++i) {
                ConfidentialPart confidentialPart = (ConfidentialPart)confidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confidentialPartPart = confidentialPart.getPart();
                String string2 = null;
                if (confidentialPartPart != null) {
                    string2 = confidentialPartPart.getName();
                }
                if ("bodycontent".equals(string2) || "usernametoken".equals(string2)) continue;
                bl = false;
                String string3 = "security.wssecurity.ConfigValidation.conf.invalid";
                Tr.error(tc, string3, new Object[]{string2});
                String string4 = MessageFormat.format(ConfigConstants.getMessage(string3), string2);
                string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "confidentialityValid() returns " + bl);
        }
        return bl;
    }

    public boolean idAssertionValid(IDAssertion iDAssertion) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "idAssertionValid(" + iDAssertion + ")");
        }
        String string = null;
        boolean bl = true;
        if (iDAssertion != null) {
            String string2;
            String string3;
            String string4 = iDAssertion.getIdType();
            if (!("Username".equals(string4) || "DN".equals(string4) || "X509Certificate".equals(string4))) {
                bl = false;
                string3 = "security.wssecurity.ConfigValidation.idassertion.type.invalid";
                Tr.error(tc, string3, new Object[]{string4});
                string2 = MessageFormat.format(ConfigConstants.getMessage(string3), string4);
                string = string == null || string.length() == 0 ? new String(string2) : new String(string + " ; " + string2);
            }
            if ((string3 = iDAssertion.getTrustMode()) != null && !"Signature".equals(string3) && !"BasicAuth".equals(string3)) {
                bl = false;
                string2 = "security.wssecurity.ConfigValidation.idassertion.mode.invalid";
                Tr.error(tc, string2, new Object[]{string3});
                String string5 = MessageFormat.format(ConfigConstants.getMessage(string2), string3);
                string = string == null || string.length() == 0 ? new String(string5) : new String(string + " ; " + string5);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "idAssertionValid() returns " + bl);
        }
        return bl;
    }

    public boolean scopeValid(String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scopeValid(" + string + ")");
        }
        String string2 = null;
        boolean bl = true;
        if (!(string == null || "Session".equals(string) || "Request".equals(string) || "Application".equals(string))) {
            bl = false;
            String string3 = "security.wssecurity.ConfigValidation.scope.invalid";
            Tr.error(tc, string3, new Object[]{string});
            String string4 = MessageFormat.format(ConfigConstants.getMessage(string3), string);
            string2 = string2 == null || string2.length() == 0 ? new String(string4) : new String(string2 + " ; " + string4);
        }
        if (!bl) {
            throw new SoapSecurityException(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scopeValid() returns " + bl);
        }
        return bl;
    }

    private boolean signingInfoValid(SigningInfo signingInfo, EList eList, CertStoreList certStoreList, boolean bl, boolean bl2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signingInfoValid(" + signingInfo + ", " + eList + ", " + certStoreList + ", " + (bl ? "receiver" : "sender") + ", " + "signingInfoRequired=" + bl2 + ")");
        }
        String string = null;
        boolean bl3 = true;
        if (signingInfo != null) {
            Object object;
            String string2;
            Object object2;
            Object object3;
            int n;
            Object object4;
            String string3;
            String string4;
            Object object5;
            Object object6;
            TrustAnchorRef trustAnchorRef = null;
            CertStoreRef certStoreRef = null;
            TrustAnyCertificate trustAnyCertificate = null;
            CanonicalizationMethod canonicalizationMethod = signingInfo.getCanonicalizationMethod();
            String string5 = null;
            if (canonicalizationMethod != null) {
                string5 = canonicalizationMethod.getAlgorithm();
            }
            DigestMethod digestMethod = signingInfo.getDigestMethod();
            String string6 = null;
            if (digestMethod != null) {
                string6 = digestMethod.getAlgorithm();
            }
            SignatureMethod signatureMethod = signingInfo.getSignatureMethod();
            String string7 = null;
            if (signatureMethod != null) {
                string7 = signatureMethod.getAlgorithm();
            }
            if (canonicalizationMethod != null && !this.canonicalizationMethodValid(string5)) {
                bl3 = false;
                object6 = "security.wssecurity.ConfigValidation.canon.method.invalid";
                Tr.error(tc, (String)object6, new Object[]{string5});
                object5 = MessageFormat.format(ConfigConstants.getMessage((String)object6), string5);
                string = string == null || string.length() == 0 ? new String((String)object5) : new String(string + " ; " + (String)object5);
            }
            if (digestMethod != null && !this.digestMethodValid(string6)) {
                bl3 = false;
                object6 = "security.wssecurity.ConfigValidation.digest.method.invalid";
                Tr.error(tc, (String)object6, new Object[]{string6});
                object5 = MessageFormat.format(ConfigConstants.getMessage((String)object6), string6);
                string = string == null || string.length() == 0 ? new String((String)object5) : new String(string + " ; " + (String)object5);
            }
            if (signatureMethod != null && !this.signatureMethodValid(string7)) {
                bl3 = false;
                object6 = "security.wssecurity.ConfigValidation.sign.method.invalid";
                Tr.error(tc, (String)object6, new Object[]{string7});
                object5 = MessageFormat.format(ConfigConstants.getMessage((String)object6), string7);
                string = string == null || string.length() == 0 ? new String((String)object5) : new String(string + " ; " + (String)object5);
            }
            if ((object6 = signingInfo.getCertPathSettings()) != null) {
                trustAnchorRef = object6.getTrustAnchorRef();
                certStoreRef = object6.getCertStoreRef();
                trustAnyCertificate = object6.getTrustAnyCertificate();
                if (trustAnyCertificate == null && trustAnchorRef == null) {
                    bl3 = false;
                    object5 = "security.wssecurity.ConfigValidation.cps.missing.refs";
                    Tr.error(tc, (String)object5);
                    string4 = ConfigConstants.getMessage((String)object5);
                    string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
                }
            } else if (bl) {
                bl3 = false;
                object5 = "security.wssecurity.ConfigValidation.cps.missing";
                Tr.error(tc, (String)object5);
                string4 = ConfigConstants.getMessage((String)object5);
                string = string == null || string.length() == 0 ? new String(string4) : new String(string + " ; " + string4);
            }
            if ((object5 = signingInfo.getSigningKey()) != null) {
                String string8;
                string4 = object5.getName();
                string3 = object5.getLocatorRef();
                if (string4 == null || string4.length() == 0) {
                    bl3 = false;
                    object4 = "security.wssecurity.ConfigValidation.sk.missing.name";
                    Tr.error(tc, (String)object4);
                    string8 = ConfigConstants.getMessage((String)object4);
                    string = string == null || string.length() == 0 ? new String(string8) : new String(string + " ; " + string8);
                }
                if (string3 == null || string3.length() == 0) {
                    bl3 = false;
                    object4 = "security.wssecurity.ConfigValidation.sk.missing.ref";
                    Tr.error(tc, (String)object4);
                    string8 = ConfigConstants.getMessage((String)object4);
                    string = string == null || string.length() == 0 ? new String(string8) : new String(string + " ; " + string8);
                }
            } else if (!bl) {
                bl3 = false;
                string4 = "security.wssecurity.ConfigValidation.sk.missing";
                Tr.error(tc, string4);
                string3 = ConfigConstants.getMessage(string4);
                string = string == null || string.length() == 0 ? new String(string3) : new String(string + " ; " + string3);
            }
            if (trustAnyCertificate != null) {
                string4 = null;
                if (trustAnchorRef != null) {
                    string4 = trustAnchorRef.getRef();
                }
                if (string4 != null && string4.length() != 0) {
                    boolean bl4 = false;
                    if (eList != null && !eList.isEmpty()) {
                        object4 = null;
                        int n2 = eList.size();
                        for (n = 0; n < n2; ++n) {
                            object3 = (TrustAnchor)eList.get(n);
                            if (!string4.equals(object3.getName())) continue;
                            bl4 = true;
                            object2 = object3.getKeyStore();
                            string2 = object2.getKeyStoreRef();
                            if (string2 != null) {
                                object4 = ConfigUtil.getKeyStore((String)string2);
                            } else {
                                object = null;
                                object = this.varMap == null ? new File(object2.getPath()) : new File(this.varMap.expand(object2.getPath()));
                                try {
                                    object4 = ConfigUtil.getKeyStore((String)object2.getType(), (File)object, (char[])object2.getStorepass().toCharArray());
                                }
                                catch (SoapSecurityException soapSecurityException) {
                                    // empty catch block
                                }
                            }
                            if (object4 != null || !tc.isDebugEnabled()) break;
                            Tr.debug(tc, "Unable to open keystore \"" + object2.getPath() + "\".");
                            break;
                        }
                        if (object4 == null && this.config != null) {
                            object4 = this.config.getTrustAnchor(string4);
                        }
                        if (object4 == null) {
                            bl3 = false;
                            String string9 = "security.wssecurity.ConfigValidation.keystore.taref.open";
                            Tr.error(tc, string9, new Object[]{string4});
                            object3 = MessageFormat.format(ConfigConstants.getMessage(string9), string4);
                            string = string == null || string.length() == 0 ? new String((String)object3) : new String(string + " ; " + (String)object3);
                        }
                    }
                    if (!bl4 && bl) {
                        bl3 = false;
                        object4 = "security.wssecurity.ConfigValidation.taref.notfound";
                        Tr.error(tc, (String)object4, new Object[]{string4});
                        String string10 = MessageFormat.format(ConfigConstants.getMessage((String)object4), string4);
                        string = string == null || string.length() == 0 ? new String(string10) : new String(string + " ; " + string10);
                    }
                }
            }
            if (trustAnyCertificate != null) {
                string4 = null;
                if (certStoreRef != null) {
                    string4 = certStoreRef.getRef();
                }
                if (string4 != null && string4.length() != 0) {
                    boolean bl5 = false;
                    if (certStoreList != null) {
                        EList eList2;
                        String string11;
                        Object object7;
                        Object object8;
                        object4 = certStoreList.getCollectionCertStores();
                        if (object4 != null && !object4.isEmpty()) {
                            int n3 = object4.size();
                            for (n = 0; n < n3; ++n) {
                                object3 = (CollectionCertStore)object4.get(n);
                                object2 = object3.getName();
                                if (!string4.equals(object2)) continue;
                                bl5 = true;
                                string2 = object3.getName();
                                if (string2 == null || string2.length() == 0) {
                                    bl3 = false;
                                    object = "security.wssecurity.ConfigValidation.ccs.missing.name";
                                    Tr.error(tc, (String)object);
                                    object8 = ConfigConstants.getMessage((String)object);
                                    string = string == null || string.length() == 0 ? new String((String)object8) : new String(string + " ; " + (String)object8);
                                }
                                if ((object = object3.getProvider()) == null || ((String)object).length() == 0) {
                                    bl3 = false;
                                    object8 = "security.wssecurity.ConfigValidation.ccs.missing.provider";
                                    Tr.error(tc, (String)object8);
                                    object7 = ConfigConstants.getMessage((String)object8);
                                    string = string == null || string.length() == 0 ? new String((String)object7) : new String(string + " ; " + (String)object7);
                                }
                                if ((object8 = object3.getX509Certificates()) != null && object8.size() >= 1) break;
                                bl3 = false;
                                object7 = "security.wssecurity.ConfigValidation.ccs.missing.cert";
                                Tr.error(tc, (String)object7);
                                string11 = ConfigConstants.getMessage((String)object7);
                                if (string == null || string.length() == 0) {
                                    string = new String(string11);
                                    break;
                                }
                                string = new String(string + " ; " + string11);
                                break;
                            }
                        }
                        if ((eList2 = certStoreList.getLdapCertStores()) != null && !eList2.isEmpty()) {
                            n = eList2.size();
                            for (int i = 0; i < n; ++i) {
                                String string12;
                                String string13;
                                object2 = (LDAPCertStore)eList2.get(i);
                                string2 = object2.getName();
                                if (!string4.equals(string2)) continue;
                                bl5 = true;
                                object = object2.getName();
                                if (object == null || ((String)object).length() == 0) {
                                    bl3 = false;
                                    object8 = "security.wssecurity.ConfigValidation.lcs.missing.name";
                                    Tr.error(tc, (String)object8);
                                    object7 = ConfigConstants.getMessage((String)object8);
                                    string = string == null || string.length() == 0 ? new String((String)object7) : new String(string + " ; " + (String)object7);
                                }
                                if ((object8 = object2.getProvider()) == null || ((String)object8).length() == 0) {
                                    bl3 = false;
                                    object7 = "security.wssecurity.ConfigValidation.lcs.missing.provider";
                                    Tr.error(tc, (String)object7);
                                    string11 = ConfigConstants.getMessage((String)object7);
                                    string = string == null || string.length() == 0 ? new String(string11) : new String(string + " ; " + string11);
                                }
                                if ((object7 = object2.getLdapServer()) == null) {
                                    bl3 = false;
                                    string11 = "security.wssecurity.ConfigValidation.lcs.missing.server";
                                    Tr.error(tc, string11);
                                    String string14 = ConfigConstants.getMessage(string11);
                                    if (string == null || string.length() == 0) {
                                        string = new String(string14);
                                        break;
                                    }
                                    string = new String(string + " ; " + string14);
                                    break;
                                }
                                string11 = object7.getHost();
                                if (string11 == null || string11.length() == 0) {
                                    bl3 = false;
                                    string13 = "security.wssecurity.ConfigValidation.ldap.missing.host";
                                    Tr.error(tc, string13);
                                    string12 = ConfigConstants.getMessage(string13);
                                    string = string == null || string.length() == 0 ? new String(string12) : new String(string + " ; " + string12);
                                }
                                if ((string13 = object7.getPort()) != null && string13.length() != 0) break;
                                bl3 = false;
                                string12 = "security.wssecurity.ConfigValidation.ldap.missing.port";
                                Tr.error(tc, string12);
                                String string15 = ConfigConstants.getMessage(string12);
                                if (string == null || string.length() == 0) {
                                    string = new String(string15);
                                    break;
                                }
                                string = new String(string + " ; " + string15);
                                break;
                            }
                        }
                    }
                    if (!bl5 && this.config != null && (object4 = this.config.getCertStore(string4)) != null) {
                        bl5 = true;
                    }
                    if (!bl5 && bl) {
                        bl3 = false;
                        object4 = "security.wssecurity.ConfigValidation.csref.notfound";
                        Tr.error(tc, (String)object4, new Object[]{string4});
                        String string16 = MessageFormat.format(ConfigConstants.getMessage((String)object4), string4);
                        string = string == null || string.length() == 0 ? new String(string16) : new String(string + " ; " + string16);
                    }
                }
            }
        } else if (bl2) {
            bl3 = false;
            String string17 = "security.wssecurity.ConfigValidation.sign.info.required";
            Tr.error(tc, string17);
            String string18 = ConfigConstants.getMessage(string17);
            string = string == null || string.length() == 0 ? new String(string18) : new String(string + " ; " + string18);
        }
        if (!bl3) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signingInfoValid() returns " + bl3);
        }
        return bl3;
    }

    public boolean receiverSigningInfoValid(EList eList, EList eList2, CertStoreList certStoreList, RequiredIntegrity requiredIntegrity) throws SoapSecurityException {
        Object object;
        Object object2;
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiverSigningInfoValid(" + eList + ", " + eList2 + ", " + certStoreList + ", " + requiredIntegrity + ")");
        }
        String string = null;
        boolean bl = false;
        if (requiredIntegrity != null) {
            n2 = requiredIntegrity.getReferences().size();
            for (n = 0; n < n2; ++n) {
                object2 = (Reference)requiredIntegrity.getReferences().get(n);
                ReferencePart referencePart = object2.getPart();
                object = null;
                if (referencePart != null) {
                    object = referencePart.getName();
                }
                if (object == null || ((String)object).length() == 0) continue;
                bl = true;
                break;
            }
        }
        n2 = 1;
        if (eList != null && !eList.isEmpty()) {
            n = 0;
            int n3 = eList.size();
            for (int i = 0; i < n3; ++i) {
                object = (SigningInfo)eList.get(i);
                boolean bl2 = this.signingInfoValid((SigningInfo)object, eList2, certStoreList, true, bl);
                if (!bl2) {
                    n2 = 0;
                }
                if (!bl || object == null || object.getSignatureMethod() == null || object.getDigestMethod() == null || object.getCanonicalizationMethod() == null) continue;
                n = 1;
            }
            if (bl && n == 0) {
                n2 = 0;
                String string2 = "security.wssecurity.ConfigValidation.sign.algos.required";
                Tr.error(tc, string2);
                object = ConfigConstants.getMessage(string2);
                string = string == null || string.length() == 0 ? new String((String)object) : new String(string + " ; " + (String)object);
            }
        } else if (bl) {
            n2 = 0;
            String string3 = "security.wssecurity.ConfigValidation.sign.info.required";
            Tr.error(tc, string3);
            object2 = ConfigConstants.getMessage(string3);
            string = string == null || string.length() == 0 ? new String((String)object2) : new String(string + " ; " + (String)object2);
        }
        if (n2 == 0) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiverSigningInfoValid() returns " + (n2 != 0));
        }
        return n2 != 0;
    }

    public boolean senderSigningInfoValid(SigningInfo signingInfo, EList eList, CertStoreList certStoreList, Integrity integrity) throws SoapSecurityException {
        Object object;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "senderSigningInfoValid(" + signingInfo + ", " + eList + ", " + certStoreList + ", " + integrity + ")");
        }
        String string = null;
        boolean bl = false;
        if (integrity != null) {
            n = integrity.getReferences().size();
            for (int i = 0; i < n; ++i) {
                object = (Reference)integrity.getReferences().get(i);
                ReferencePart referencePart = object.getPart();
                String string2 = null;
                if (referencePart != null) {
                    string2 = referencePart.getName();
                }
                if (string2 == null || string2.length() == 0) continue;
                bl = true;
                break;
            }
        }
        n = this.signingInfoValid(signingInfo, eList, certStoreList, false, bl) ? 1 : 0;
        if (bl && signingInfo != null && (signingInfo.getSignatureMethod() == null || signingInfo.getDigestMethod() == null || signingInfo.getCanonicalizationMethod() == null)) {
            n = 0;
            String string3 = "security.wssecurity.ConfigValidation.sign.algos.required";
            Tr.error(tc, string3);
            object = ConfigConstants.getMessage(string3);
            string = string == null || string.length() == 0 ? new String((String)object) : new String(string + " ; " + (String)object);
        }
        if (n == 0) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "senderSigningInfoValid() returns " + (n != 0));
        }
        return n != 0;
    }

    public boolean encryptionInfosValid(EList eList, EList eList2, RequiredConfidentiality requiredConfidentiality) throws SoapSecurityException {
        Object object;
        Object object2;
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptionInfosValid(" + eList + ", " + eList2 + ", " + requiredConfidentiality + ")");
        }
        String string = null;
        boolean bl = false;
        if (requiredConfidentiality != null) {
            n2 = requiredConfidentiality.getConfidentialParts().size();
            for (n = 0; n < n2; ++n) {
                object2 = (ConfidentialPart)requiredConfidentiality.getConfidentialParts().get(n);
                object = object2.getPart();
                String string2 = null;
                if (object != null) {
                    string2 = ((AbstractEnumerator)object).getName();
                }
                if (string2 == null || string2.length() == 0) continue;
                bl = true;
                break;
            }
        }
        n2 = 1;
        if (eList != null && !eList.isEmpty()) {
            n = eList.size();
            for (int i = 0; i < n; ++i) {
                object = (EncryptionInfo)eList.get(i);
                boolean bl2 = this.privateEncInfoValid((EncryptionInfo)object, eList2, bl);
                if (bl2) continue;
                n2 = 0;
            }
        } else if (bl) {
            n2 = 0;
            String string3 = "security.wssecurity.ConfigValidation.enc.info.required";
            Tr.error(tc, string3);
            object2 = ConfigConstants.getMessage(string3);
            string = string == null || string.length() == 0 ? new String((String)object2) : new String(string + " ; " + (String)object2);
        }
        if (n2 == 0) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptionInfosValid() returns " + (n2 != 0));
        }
        return n2 != 0;
    }

    public boolean encryptionInfoValid(EncryptionInfo encryptionInfo, EList eList, Confidentiality confidentiality) throws SoapSecurityException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptionInfoValid(" + encryptionInfo + ", " + eList + ", " + confidentiality + ")");
        }
        boolean bl = false;
        if (confidentiality != null) {
            n = confidentiality.getConfidentialParts().size();
            for (int i = 0; i < n; ++i) {
                ConfidentialPart confidentialPart = (ConfidentialPart)confidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confidentialPartPart = confidentialPart.getPart();
                String string = null;
                if (confidentialPartPart != null) {
                    string = confidentialPartPart.getName();
                }
                if (string == null || string.length() == 0) continue;
                bl = true;
                break;
            }
        }
        n = 1;
        n = this.privateEncInfoValid(encryptionInfo, eList, bl) ? 1 : 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptionInfoValid() returns " + (n != 0));
        }
        return n != 0;
    }

    private boolean privateEncInfoValid(EncryptionInfo encryptionInfo, EList eList, boolean bl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "privateEncInfoValid(" + encryptionInfo + ", " + eList + ", " + bl + ")");
        }
        ClassLoader classLoader = null;
        String string = null;
        boolean bl2 = true;
        if (encryptionInfo != null) {
            String string2;
            String string3;
            String string4;
            String string5 = null;
            EncryptionKey encryptionKey = encryptionInfo.getEncryptionKey();
            DataEncryptionMethod dataEncryptionMethod = encryptionInfo.getEncryptionMethod();
            KeyEncryptionMethod keyEncryptionMethod = encryptionInfo.getKeyEncryptionMethod();
            if (encryptionKey == null) {
                bl2 = false;
                string4 = "security.wssecurity.ConfigValidation.ei.missing.key";
                Tr.error(tc, string4);
                string3 = ConfigConstants.getMessage(string4);
                string = string == null || string.length() == 0 ? new String(string3) : new String(string + " ; " + string3);
            } else {
                string5 = encryptionKey.getLocatorRef();
                if (string5 == null || string5.length() == 0) {
                    bl2 = false;
                    string4 = "security.wssecurity.ConfigValidation.ei.missing.key.loc.ref";
                    Tr.error(tc, string4);
                    string3 = ConfigConstants.getMessage(string4);
                    string = string == null || string.length() == 0 ? new String(string3) : new String(string + " ; " + string3);
                }
            }
            if (dataEncryptionMethod == null) {
                bl2 = false;
                string4 = "security.wssecurity.ConfigValidation.ei.missing.enc.method";
                Tr.error(tc, string4);
                string3 = ConfigConstants.getMessage(string4);
                string = string == null || string.length() == 0 ? new String(string3) : new String(string + " ; " + string3);
            } else {
                string4 = dataEncryptionMethod.getAlgorithm();
                if (!this.encryptionMethodValid(string4)) {
                    bl2 = false;
                    string3 = "security.wssecurity.ConfigValidation.enc.method.invalid";
                    Tr.error(tc, string3, new Object[]{string4});
                    string2 = MessageFormat.format(ConfigConstants.getMessage(string3), string4);
                    string = string == null || string.length() == 0 ? new String(string2) : new String(string + " ; " + string2);
                }
            }
            if (keyEncryptionMethod != null && !this.keyEncryptionMethodValid(string4 = keyEncryptionMethod.getAlgorithm())) {
                bl2 = false;
                string3 = "security.wssecurity.ConfigValidation.keyenc.method.invalid";
                Tr.error(tc, string3, new Object[]{string4});
                string2 = MessageFormat.format(ConfigConstants.getMessage(string3), string4);
                string = string == null || string.length() == 0 ? new String(string2) : new String(string + " ; " + string2);
            }
            if (string5 != null && string5.length() > 0) {
                com.ibm.wsspi.wssecurity.config.KeyLocator keyLocator;
                boolean bl3 = false;
                if (eList != null && !eList.isEmpty()) {
                    int n = eList.size();
                    for (int i = 0; i < n; ++i) {
                        Object object;
                        Object object2;
                        Object object3;
                        KeyLocator keyLocator2 = (KeyLocator)eList.get(i);
                        if (!string5.equals(keyLocator2.getName())) continue;
                        bl3 = true;
                        if (keyLocator2.getClassname() == null || keyLocator2.getClassname().length() == 0) {
                            bl2 = false;
                            object3 = "security.wssecurity.ConfigValidation.keyloc.missing.classname";
                            Tr.error(tc, (String)object3);
                            object2 = ConfigConstants.getMessage((String)object3);
                            string = string == null || string.length() == 0 ? new String((String)object2) : new String(string + " ; " + (String)object2);
                        }
                        object3 = keyLocator2.getKeyStore();
                        object2 = null;
                        if (object3 != null) {
                            Object object4;
                            object = object3.getKeyStoreRef();
                            if (object != null) {
                                object2 = ConfigUtil.getKeyStore((String)object);
                            } else {
                                object4 = null;
                                object4 = this.varMap == null ? new File(object3.getPath()) : new File(this.varMap.expand(object3.getPath()));
                                try {
                                    object2 = ConfigUtil.getKeyStore((String)object3.getType(), (File)object4, (char[])object3.getStorepass().toCharArray());
                                }
                                catch (SoapSecurityException soapSecurityException) {
                                    // empty catch block
                                }
                            }
                            if (object2 == null) {
                                bl2 = false;
                                object4 = "security.wssecurity.ConfigValidation.keystore.open";
                                Tr.error(tc, (String)object4, new Object[]{object3.getPath()});
                                String string6 = MessageFormat.format(ConfigConstants.getMessage((String)object4), object3.getPath());
                                string = string == null || string.length() == 0 ? new String(string6) : new String(string + " ; " + string6);
                            }
                        }
                        if ((object = keyLocator2.getKeys()) == null || object.isEmpty()) break;
                        int n2 = object.size();
                        for (int j = 0; j < n2; ++j) {
                            String string7;
                            String string8;
                            Key key = (Key)object.get(j);
                            String string9 = key.getAlias();
                            String string10 = key.getKeypass();
                            String string11 = key.getName();
                            if (string9 == null || string9.length() == 0) {
                                bl2 = false;
                                string8 = "security.wssecurity.ConfigValidation.key.missing.alias";
                                Tr.error(tc, string8);
                                string7 = ConfigConstants.getMessage(string8);
                                string = string == null || string.length() == 0 ? new String(string7) : new String(string + " ; " + string7);
                            }
                            if (string10 == null || string10.length() == 0) {
                                bl2 = false;
                                string8 = "security.wssecurity.ConfigValidation.key.missing.keypass";
                                Tr.error(tc, string8);
                                string7 = ConfigConstants.getMessage(string8);
                                string = string == null || string.length() == 0 ? new String(string7) : new String(string + " ; " + string7);
                            }
                            if (string11 != null && string11.length() != 0) continue;
                            bl2 = false;
                            string8 = "security.wssecurity.ConfigValidation.key.missing.name";
                            Tr.error(tc, string8);
                            string7 = ConfigConstants.getMessage(string8);
                            string = string == null || string.length() == 0 ? new String(string7) : new String(string + " ; " + string7);
                        }
                        break;
                    }
                }
                if (!bl3 && this.config != null && (keyLocator = this.config.getKeyLocator(string5).getKeyLocator5(classLoader)) != null) {
                    bl3 = true;
                }
                if (!bl3) {
                    bl2 = false;
                    String string12 = "security.wssecurity.ConfigValidation.keylocref.notfound";
                    Tr.error(tc, string12, new Object[]{string5});
                    String string13 = MessageFormat.format(ConfigConstants.getMessage(string12), string5);
                    string = string == null || string.length() == 0 ? new String(string13) : new String(string + " ; " + string13);
                }
            }
        } else if (bl) {
            bl2 = false;
            String string14 = "security.wssecurity.ConfigValidation.enc.info.required";
            Tr.error(tc, string14);
            String string15 = ConfigConstants.getMessage(string14);
            string = string == null || string.length() == 0 ? new String(string15) : new String(string + " ; " + string15);
        }
        if (!bl2) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "privateEncInfoValid() returns " + bl2);
        }
        return bl2;
    }

    public boolean loginMappingValid(EList eList, LoginConfig loginConfig) throws SoapSecurityException {
        Object object;
        Object object2;
        Object object3;
        String string;
        EObject eObject;
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loginMappingValid(" + eList + ", " + loginConfig + ")");
        }
        String string2 = null;
        boolean bl = true;
        if (loginConfig != null) {
            EList eList2 = loginConfig.getAuthMethods();
            if (eList2 != null && !eList2.isEmpty()) {
                n2 = eList2.size();
                for (n = 0; n < n2; ++n) {
                    com.ibm.xml.soapsec.token.LoginMapping loginMapping;
                    eObject = (AuthMethod)eList2.get(n);
                    string = null;
                    if (eObject != null) {
                        string = eObject.getText();
                    }
                    if (string == null || string.length() == 0) {
                        bl = false;
                        object3 = "security.wssecurity.ConfigValidation.lc.missing.authmethod";
                        Tr.error(tc, (String)object3);
                        object2 = ConfigConstants.getMessage((String)object3);
                        if (string2 == null || string2.length() == 0) {
                            string2 = new String((String)object2);
                            continue;
                        }
                        string2 = new String(string2 + " ; " + (String)object2);
                        continue;
                    }
                    boolean bl2 = false;
                    if (eList != null && !eList.isEmpty()) {
                        int n3 = eList.size();
                        for (int i = 0; i < n3; ++i) {
                            object = (LoginMapping)eList.get(i);
                            if (!string.equals(object.getAuthMethod())) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    if (!bl2 && this.config != null && (loginMapping = this.config.getLoginMapping(string)) != null) {
                        bl2 = true;
                    }
                    if (bl2) continue;
                    bl = false;
                    String string3 = "security.wssecurity.ConfigValidation.lc.authmethod.invalid";
                    Tr.error(tc, string3, new Object[]{string});
                    String string4 = MessageFormat.format(ConfigConstants.getMessage(string3), string);
                    string2 = string2 == null || string2.length() == 0 ? new String(string4) : new String(string2 + " ; " + string4);
                }
            } else {
                bl = false;
                String string5 = "security.wssecurity.ConfigValidation.lc.missing.authmethod";
                Tr.error(tc, string5);
                String string6 = ConfigConstants.getMessage(string5);
                string2 = string2 == null || string2.length() == 0 ? new String(string6) : new String(string2 + " ; " + string6);
            }
        }
        if (eList != null && !eList.isEmpty()) {
            int n4 = eList.size();
            for (n2 = 0; n2 < n4; ++n2) {
                String string7;
                String string8;
                n = 0;
                eObject = (LoginMapping)eList.get(n2);
                string = eObject.getAuthMethod();
                if (string == null || string.length() == 0) {
                    bl = false;
                    object3 = "security.wssecurity.ConfigValidation.lm.missing.authmethod";
                    Tr.error(tc, (String)object3);
                    object2 = ConfigConstants.getMessage((String)object3);
                    string2 = string2 == null || string2.length() == 0 ? new String((String)object2) : new String(string2 + " ; " + (String)object2);
                } else if (this.authMethodValid(string)) {
                    if (!this.authMethodKnown(string)) {
                        n = 1;
                    }
                } else {
                    bl = false;
                    object3 = "security.wssecurity.ConfigValidation.lm.authmethod.invalid";
                    Tr.error(tc, (String)object3, new Object[]{string});
                    object2 = MessageFormat.format(ConfigConstants.getMessage((String)object3), string);
                    string2 = string2 == null || string2.length() == 0 ? new String((String)object2) : new String(string2 + " ; " + (String)object2);
                }
                if (n != 0) {
                    object3 = eObject.getTokenValueType();
                    if (object3 == null) {
                        bl = false;
                        object2 = "security.wssecurity.ConfigValidation.lm.missing.tokvaltype";
                        Tr.error(tc, (String)object2);
                        string8 = ConfigConstants.getMessage((String)object2);
                        string2 = string2 == null || string2.length() == 0 ? new String(string8) : new String(string2 + " ; " + string8);
                    } else {
                        object2 = object3.getUri();
                        string8 = object3.getLocalName();
                        if (object2 == null || ((String)object2).length() == 0) {
                            bl = false;
                            object = "security.wssecurity.ConfigValidation.tvt.missing.uri";
                            Tr.error(tc, (String)object);
                            string7 = ConfigConstants.getMessage((String)object);
                            string2 = string2 == null || string2.length() == 0 ? new String(string7) : new String(string2 + " ; " + string7);
                        }
                        if (string8 == null || string8.length() == 0) {
                            bl = false;
                            object = "security.wssecurity.ConfigValidation.tvt.missing.localname";
                            Tr.error(tc, (String)object);
                            string7 = ConfigConstants.getMessage((String)object);
                            string2 = string2 == null || string2.length() == 0 ? new String(string7) : new String(string2 + " ; " + string7);
                        }
                    }
                }
                if ((object3 = eObject.getConfigName()) == null || ((String)object3).length() == 0) {
                    bl = false;
                    object2 = "security.wssecurity.ConfigValidation.lm.missing.configname";
                    Tr.error(tc, (String)object2);
                    string8 = ConfigConstants.getMessage((String)object2);
                    string2 = string2 == null || string2.length() == 0 ? new String(string8) : new String(string2 + " ; " + string8);
                }
                if ((object2 = eObject.getCallbackHandlerFactory()) == null) {
                    bl = false;
                    string8 = "security.wssecurity.ConfigValidation.lm.missing.ch.factory";
                    Tr.error(tc, string8);
                    object = ConfigConstants.getMessage(string8);
                    if (string2 == null || string2.length() == 0) {
                        string2 = new String((String)object);
                        continue;
                    }
                    string2 = new String(string2 + " ; " + (String)object);
                    continue;
                }
                string8 = object2.getClassname();
                if (string8 != null && string8.length() != 0) continue;
                bl = false;
                object = "security.wssecurity.ConfigValidation.lm.missing.ch.classname";
                Tr.error(tc, (String)object);
                string7 = ConfigConstants.getMessage((String)object);
                string2 = string2 == null || string2.length() == 0 ? new String(string7) : new String(string2 + " ; " + string7);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loginMappingValid() returns " + bl);
        }
        return bl;
    }

    public boolean trustedIDEvaluatorRefValid(TrustedIDEvaluatorRef trustedIDEvaluatorRef) throws SoapSecurityException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trustedIDEvaluatorRefValid(" + trustedIDEvaluatorRef + ")");
        }
        String string2 = null;
        boolean bl = true;
        if (trustedIDEvaluatorRef != null && ((string = trustedIDEvaluatorRef.getRef()) == null || string.length() == 0)) {
            bl = false;
            String string3 = "security.wssecurity.ConfigValidation.tier.missing.ref";
            Tr.error(tc, string3);
            String string4 = ConfigConstants.getMessage(string3);
            string2 = string2 == null || string2.length() == 0 ? new String(string4) : new String(string2 + " ; " + string4);
        }
        if (!bl) {
            throw new SoapSecurityException(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trustedIDEvaluatorRefValid() returns " + bl);
        }
        return bl;
    }

    public boolean trustedIDEvaluatorValid(TrustedIDEvaluator trustedIDEvaluator) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trustedIDEvaluatorValid(" + trustedIDEvaluator + ")");
        }
        String string = null;
        boolean bl = true;
        if (trustedIDEvaluator != null) {
            String string2;
            String string3;
            String string4 = trustedIDEvaluator.getClassname();
            String string5 = trustedIDEvaluator.getName();
            if (string4 == null || string4.length() == 0) {
                bl = false;
                string3 = "security.wssecurity.ConfigValidation.tie.missing.classname";
                Tr.error(tc, string3);
                string2 = ConfigConstants.getMessage(string3);
                string = string == null || string.length() == 0 ? new String(string2) : new String(string + " ; " + string2);
            }
            if (string5 == null || string5.length() == 0) {
                bl = false;
                string3 = "security.wssecurity.ConfigValidation.tie.missing.name";
                Tr.error(tc, string3);
                string2 = ConfigConstants.getMessage(string3);
                string = string == null || string.length() == 0 ? new String(string2) : new String(string + " ; " + string2);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trustedIDEvaluatorValid() returns " + bl);
        }
        return bl;
    }

    public boolean loginBindingValid(LoginBinding loginBinding, com.ibm.etools.webservice.wscext.LoginConfig loginConfig) throws SoapSecurityException {
        String string;
        Object object;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loginBindingValid(" + loginBinding + ", " + loginConfig + ")");
        }
        String string3 = null;
        boolean bl = true;
        if (loginConfig != null) {
            string2 = loginConfig.getAuthMethod();
            if (string2 == null || string2.length() == 0) {
                bl = false;
                String string4 = "security.wssecurity.ConfigValidation.lc.missing.authmethod";
                Tr.error(tc, string4);
                object = ConfigConstants.getMessage(string4);
                string3 = string3 == null || string3.length() == 0 ? new String((String)object) : new String(string3 + " ; " + (String)object);
            } else {
                boolean bl2 = false;
                if (loginBinding != null && string2.equals(loginBinding.getAuthMethod())) {
                    bl2 = true;
                }
                if (!bl2) {
                    bl = false;
                    object = "security.wssecurity.ConfigValidation.lc.authmethod.invalid";
                    Tr.error(tc, (String)object, new Object[]{string2});
                    string = MessageFormat.format(ConfigConstants.getMessage((String)object), string2);
                    string3 = string3 == null || string3.length() == 0 ? new String(string) : new String(string3 + " ; " + string);
                }
            }
        }
        if (loginBinding != null) {
            String string5;
            string2 = loginBinding.getAuthMethod();
            boolean bl3 = false;
            if (string2 == null || string2.length() == 0) {
                bl = false;
                object = "security.wssecurity.ConfigValidation.lb.missing.authmethod";
                Tr.error(tc, (String)object);
                string = ConfigConstants.getMessage((String)object);
                string3 = string3 == null || string3.length() == 0 ? new String(string) : new String(string3 + " ; " + string);
            } else if (this.authMethodValid(string2)) {
                if (!this.authMethodKnown(string2)) {
                    bl3 = true;
                }
            } else {
                bl = false;
                object = "security.wssecurity.ConfigValidation.lb.authmethod.invalid";
                Tr.error(tc, (String)object, new Object[]{string2});
                string = MessageFormat.format(ConfigConstants.getMessage((String)object), string2);
                string3 = string3 == null || string3.length() == 0 ? new String(string) : new String(string3 + " ; " + string);
            }
            if (bl3) {
                object = loginBinding.getTokenValueType();
                if (object == null) {
                    bl = false;
                    string = "security.wssecurity.ConfigValidation.lb.missing.tokvaltype";
                    Tr.error(tc, string, new Object[]{string2});
                    string5 = MessageFormat.format(ConfigConstants.getMessage(string), string2);
                    string3 = string3 == null || string3.length() == 0 ? new String(string5) : new String(string3 + " ; " + string5);
                } else {
                    String string6;
                    String string7;
                    string = object.getUri();
                    string5 = object.getLocalName();
                    if (string == null || string.length() == 0) {
                        bl = false;
                        string7 = "security.wssecurity.ConfigValidation.tvt.missing.uri";
                        Tr.error(tc, string7);
                        string6 = ConfigConstants.getMessage(string7);
                        string3 = string3 == null || string3.length() == 0 ? new String(string6) : new String(string3 + " ; " + string6);
                    }
                    if (string5 == null || string5.length() == 0) {
                        bl = false;
                        string7 = "security.wssecurity.ConfigValidation.tvt.missing.localname";
                        Tr.error(tc, string7);
                        string6 = ConfigConstants.getMessage(string7);
                        string3 = string3 == null || string3.length() == 0 ? new String(string6) : new String(string3 + " ; " + string6);
                    }
                }
            }
            if ((object = loginBinding.getCallbackHandler()) == null || ((String)object).length() == 0) {
                bl = false;
                string = "security.wssecurity.ConfigValidation.lb.missing.callbackhandler";
                Tr.error(tc, string);
                string5 = ConfigConstants.getMessage(string);
                string3 = string3 == null || string3.length() == 0 ? new String(string5) : new String(string3 + " ; " + string5);
            }
        }
        if (!bl) {
            throw new SoapSecurityException(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loginBindingValid() returns " + bl);
        }
        return bl;
    }

    private boolean authMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authMethodValid(" + string + ")");
        }
        boolean bl = false;
        bl = string != null && string.length() != 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authMethodValid() returns " + bl);
        }
        return bl;
    }

    private boolean authMethodKnown(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authMethodKnown(" + string + ")");
        }
        boolean bl = false;
        bl = string == null || string.length() == 0 ? false : "BasicAuth".equals(string) || "IDAssertion".equals(string) || "Signature".equals(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authMethodKnown() returns " + bl);
        }
        return bl;
    }

    private void addToSet(Document document, String string, Set set) {
        NodeList nodeList;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSet(" + document + ", " + string + ", " + set + ")");
        }
        if ((n = (nodeList = document.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", string)).getLength()) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No allowed " + string + " elements found.");
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                try {
                    set.add(DOMUtil.getAttribute((Element)element, (String)"algorithm"));
                    continue;
                }
                catch (SoapSecurityException soapSecurityException) {
                    FFDCFilter.processException((Throwable)soapSecurityException, clsName + ".addToSet", "1867", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "\"algorithm\" attribute not found in \"" + string + "\" element.");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Allowed " + string + " set: ", new Object[]{set});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSet()");
        }
    }

    protected void processAllowedAlgorithms(Document document) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processAllowedAlgorithms(" + document + ")");
        }
        if (document == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Allowed Algorithms Document is null, exiting.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processAllowedAlgorithms()");
            }
            return;
        }
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is true; getting FIPS algorithms");
            }
            this.addToSet(document, "fipsEncryptionMethod", this.allowedEncAlgos);
            this.addToSet(document, "fipsKeyEncryptionMethod", this.allowedKeyEncAlgos);
            this.addToSet(document, "fipsSignatureMethod", this.allowedSignAlgos);
            this.addToSet(document, "fipsDigestMethod", this.allowedDigestAlgos);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            this.addToSet(document, "encryptionMethod", this.allowedEncAlgos);
            this.addToSet(document, "keyEncryptionMethod", this.allowedKeyEncAlgos);
            this.addToSet(document, "signatureMethod", this.allowedSignAlgos);
            this.addToSet(document, "digestMethod", this.allowedDigestAlgos);
        }
        this.addToSet(document, "canonicalizationMethod", this.allowedC14nAlgos);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processAllowedAlgorithms()");
        }
    }

    protected boolean encryptionMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptionMethodValid(" + string + ")");
        }
        boolean bl = this.allowedEncAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptionMethodValid() returns " + bl);
        }
        return bl;
    }

    protected boolean keyEncryptionMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyEncryptionMethodValid(" + string + ")");
        }
        boolean bl = this.allowedKeyEncAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyEncryptionMethodValid() returns " + bl);
        }
        return bl;
    }

    protected boolean canonicalizationMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canonicalizationMethodValid(" + string + ")");
        }
        boolean bl = this.allowedC14nAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canonicalizationMethodValid() returns " + bl);
        }
        return bl;
    }

    protected boolean signatureMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signatureMethodValid(" + string + ")");
        }
        boolean bl = this.allowedSignAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signatureMethodValid() returns " + bl);
        }
        return bl;
    }

    protected boolean digestMethodValid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "digestMethodValid(" + string + ")");
        }
        boolean bl = this.allowedDigestAlgos.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "digestMethodValid() returns " + bl);
        }
        return bl;
    }

    public static boolean isFipsEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFipsEnabled");
        }
        if (isFipsEnabled == null) {
            isFipsEnabled = Security.getProperty("com.ibm.websphere.security.fips.enabled");
            if (isFipsEnabled != null && isFipsEnabled.equalsIgnoreCase("true")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Read java.security.Security property; FIPS mode is enabled");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Read java.security.Security property; FIPS mode is not enabled");
            }
        }
        if (isFipsEnabled != null && isFipsEnabled.equalsIgnoreCase("true")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFipsEnabled -> true");
            }
            return true;
        }
        isFipsEnabled = "false";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFipsEnabled -> false");
        }
        return false;
    }

    public static boolean isAlgoSupportedByRuntime(String string) {
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAlgoSupportedByRuntime(String algo[" + string + "])");
        }
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(string)) {
            bl = ConfigValidation.isRsaoaepSupported(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAlgoSupportedByRuntime returns " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isRsaoaepSupported(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRsaoaepSupported");
        }
        if (rsaoaepInitialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRsaoaepSupported returns " + rsaoaepSupported);
            }
            return rsaoaepSupported;
        }
        byte[] byArray = lock;
        synchronized (lock) {
            block16: {
                String string2 = "OAEP";
                StringTokenizer stringTokenizer = null;
                if ("true".equalsIgnoreCase(Security.getProperty("com.ibm.websphere.security.fips.enabled"))) {
                    stringTokenizer = new StringTokenizer(Security.getProperty("com.ibm.websphere.security.fips.jceProviders"), "|");
                }
                if (stringTokenizer == null || !stringTokenizer.hasMoreTokens()) {
                    try {
                        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string2);
                        AlgorithmParameterSpec algorithmParameterSpec = (AlgorithmParameterSpec)Class.forName("javax.crypto.spec.OAEPParameterSpec").getField("DEFAULT").get(null);
                        rsaoaepSupported = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Successfully got instance of " + string2 + " cipher algorithm with default provider");
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "Received exception " + exception.getMessage() + " while getting instance of " + string2 + " cipher algorithm with default provider");
                    }
                } else {
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        try {
                            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string2, string3);
                            AlgorithmParameterSpec algorithmParameterSpec = (AlgorithmParameterSpec)Class.forName("javax.crypto.spec.OAEPParameterSpec").getField("DEFAULT").get(null);
                            rsaoaepSupported = true;
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "Successfully got instance of " + string2 + " cipher algorithm with provider " + string3);
                            break;
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Received exception " + exception.getMessage() + " while getting instance of " + string2 + " cipher algorithm with provider " + string3);
                        }
                    }
                }
            }
            if (!rsaoaepSupported) {
                Tr.warning(tc, "security.wssecurity.WSEC0157W", string);
            }
            rsaoaepInitialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRsaoaepSupported returns " + rsaoaepSupported);
            }
            return rsaoaepSupported;
        }
    }
}

