/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.token;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.TokenId;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public class TokenManager {
    private static final String TOKENID_TABLE = "com.ibm.websphere.wssecurity.tokenIdTable";
    private static final TraceComponent tc = Tr.register((Class)TokenManager.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    static /* synthetic */ Class class$com$ibm$wsspi$wssecurity$auth$token$Token;
    static /* synthetic */ Class class$com$ibm$websphere$security$auth$WSPrincipal;

    public static void initializeSubject(Map map) throws SoapSecurityException {
        Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeSubject(Map context)");
        }
        if ((v = map.get("com.ibm.wsspi.wssecurity.core.subject")) == null || !(v instanceof Subject)) {
            Subject subject = new Subject();
            map.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeSubject(Map context)");
        }
    }

    public static void finalizeSubject(Map map) throws SoapSecurityException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finalizeSubject(Map context)");
        }
        if (bl = WSSecurityPlatformContextFactory.getInstance().isServer()) {
            String string;
            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
            Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (contextManager == null) {
                throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject01");
            }
            Subject subject2 = null;
            try {
                subject2 = contextManager.getCallerSubject();
            }
            catch (WSSecurityException wSSecurityException) {
                throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject02", wSSecurityException);
            }
            if (subject2 == null) {
                sOAPMessageContext.removeProperty("com.ibm.ws.webservices.wssecurity.constants.callerSubject");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The caller subject is null.");
                }
            } else {
                sOAPMessageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.callerSubject", (Object)subject2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Stored the caller subject.");
                }
            }
            Subject subject3 = null;
            try {
                subject3 = contextManager.getInvocationSubject();
            }
            catch (WSSecurityException wSSecurityException) {
                throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject03", wSSecurityException);
            }
            if (subject3 == null) {
                sOAPMessageContext.removeProperty("com.ibm.ws.webservices.wssecurity.constants.invocationSubject");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The invocation subject is null.");
                }
            } else {
                sOAPMessageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.invocationSubject", (Object)subject3);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Stored the invocation subject.");
                }
            }
            try {
                contextManager.setCallerSubject(subject);
            }
            catch (WSSecurityException wSSecurityException) {
                throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject04", wSSecurityException);
            }
            if (tc.isDebugEnabled()) {
                string = subject == null ? "null" : "not null";
                Tr.debug((TraceComponent)tc, (String)("Replaced the caller subject [" + string + "]"));
            }
            try {
                contextManager.setInvocationSubject(subject);
            }
            catch (WSSecurityException wSSecurityException) {
                throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject05", wSSecurityException);
            }
            if (tc.isDebugEnabled()) {
                string = subject == null ? "null" : "not null";
                Tr.debug((TraceComponent)tc, (String)("Replaced the invocation subject [" + string + "]"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finalizeSubject(Map context)");
        }
    }

    public static void setToken(final Map map, final Token token) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setToken(Map context,Token token[" + token + "])"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    subject.getPrivateCredentials().add(token);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setToken(Map context,Token token)");
        }
    }

    public static Token getToken(Map map, TokenConsumerConfig tokenConsumerConfig, String string) {
        Object object;
        block9: {
            Object object2;
            Object object3;
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("getToken(Map context,TokenConsumerConfig tconfig[" + tokenConsumerConfig + "]," + "String id[" + string + "])"));
                }
                object = null;
                if (tokenConsumerConfig != null) break block8;
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)"Since TokenConsumerConfig is null, the runtime can't identify a token.");
                break block9;
            }
            Iterator iterator = TokenManager.getTokens(map).iterator();
            while (iterator.hasNext()) {
                object3 = (Token)iterator.next();
                object2 = object3.getId();
                if (object2 == null || !((String)object2).equals(string) || !tokenConsumerConfig.equals(object3.getUsedTokenConsumer())) continue;
                object = object3;
                break;
            }
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Did not find exact token match with token consumer; try matching consumer class.");
                }
                iterator = TokenManager.getTokens(map).iterator();
                object3 = null;
                if (tokenConsumerConfig != null) {
                    object3 = tokenConsumerConfig.getClass();
                }
                while (iterator.hasNext()) {
                    object2 = (Token)iterator.next();
                    String string2 = object2.getId();
                    if (string2 == null || !string2.equals(string)) continue;
                    Class<?> clazz = null;
                    if (object2.getUsedTokenConsumer() != null) {
                        clazz = object2.getUsedTokenConsumer().getClass();
                    }
                    if (object3 == null || clazz == null || !object3.equals(clazz)) continue;
                    object = object2;
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken(Map context,TokenConsumerConfig tconfig,String id) returns Token[" + object + "]"));
        }
        return object;
    }

    public static Token getToken(Map map, TokenId tokenId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getToken(Map context,TokenId tokenId[" + tokenId + "])"));
        }
        Token token = null;
        if (tokenId != null) {
            token = TokenManager.getToken(map, tokenId.getId());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken(Map context,TokenId tokenId) returns Token[" + token + "]"));
        }
        return token;
    }

    public static Token getToken(Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getToken(Map context,String id[" + string + "])"));
        }
        Token token = null;
        if (string != null) {
            Iterator iterator = TokenManager.getTokens(map).iterator();
            while (iterator.hasNext()) {
                Token token2 = (Token)iterator.next();
                String string2 = token2.getId();
                if (string2 == null || !string2.equals(string) || token2.getError() != null) continue;
                token = token2;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken(Map context,TokenId tokenId) returns Token[" + token + "]"));
        }
        return token;
    }

    public static Token getUnprocessedToken(Map map) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUnprocessedToken(Map context");
        }
        Iterator iterator = TokenManager.getTokens(map).iterator();
        Token token = null;
        while (iterator.hasNext()) {
            object = (Token)iterator.next();
            if (object.isProcessed()) continue;
            token = object;
            break;
        }
        if (tc.isEntryEnabled()) {
            object = token == null ? "null" : token.getClass().getName() + ":" + token.getUniqueID();
            Tr.exit((TraceComponent)tc, (String)("getUnprocessedToken(Map context) returns Token[" + (String)object + "]"));
        }
        return token;
    }

    public static void setTokens(final Map map, final Collection collection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setTokens(Map context,Collection tokens[" + collection + "])"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    subject.getPrivateCredentials().addAll(collection);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTokens(Map context,Collection tokens)");
        }
    }

    public static Set getTokens(final Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTokens(Map context)");
        }
        Set set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Set set = null;
                Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    set = subject.getPrivateCredentials(class$com$ibm$wsspi$wssecurity$auth$token$Token == null ? (class$com$ibm$wsspi$wssecurity$auth$token$Token = TokenManager.class$("com.ibm.wsspi.wssecurity.auth.token.Token")) : class$com$ibm$wsspi$wssecurity$auth$token$Token);
                }
                return set;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTokens(context) returns Set[" + set + "]"));
        }
        return set;
    }

    public static Set getTokens(Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTokens(Map context,String id[" + string + "])"));
        }
        Set set = TokenManager.getTokens(map);
        HashSet<Token> hashSet = new HashSet<Token>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            String string2 = token.getId();
            if (string2 == null || !string2.equals(string)) continue;
            hashSet.add(token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTokens(Map context,String id) returns Set[" + hashSet + "]"));
        }
        return hashSet;
    }

    public static void removeToken(final Map map, final Token token) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeToken(Map context,Token token[" + token + "])"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    subject.getPrivateCredentials().remove(token);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeToken(Map context,Token token)");
        }
    }

    public static void removeTokens(final Map map, final Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeTokens(Map context,Set tokens[" + set + "])"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    subject.getPrivateCredentials().removeAll(set);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeTokens(Map context,Set tokens)");
        }
    }

    public static void removeAllTokens(final Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAllTokens(Map context)");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject subject = (Subject)map.get("com.ibm.wsspi.wssecurity.core.subject");
                Set set = subject.getPrivateCredentials(class$com$ibm$wsspi$wssecurity$auth$token$Token == null ? (class$com$ibm$wsspi$wssecurity$auth$token$Token = TokenManager.class$("com.ibm.wsspi.wssecurity.auth.token.Token")) : class$com$ibm$wsspi$wssecurity$auth$token$Token);
                if (subject == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    subject.getPrivateCredentials().removeAll(set);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAllTokens(Map context)");
        }
    }

    public static void setTokenId(TokenId tokenId) {
        MessageContext messageContext;
        Hashtable hashtable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setTokenId(Tokenid tokenId[" + tokenId + "])"));
        }
        if ((hashtable = (Hashtable)(messageContext = MessageContext.getCurrentThreadsContext()).getProperty(TOKENID_TABLE)) == null) {
            TokenManager.initTokenIdTable(messageContext);
        }
        hashtable.put(tokenId.getId(), tokenId);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTokenId(TokenId tokenId)");
        }
    }

    public static Hashtable getTokenIdsTable() {
        MessageContext messageContext;
        Hashtable hashtable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTokenIdsTable()");
        }
        if ((hashtable = (Hashtable)(messageContext = MessageContext.getCurrentThreadsContext()).getProperty(TOKENID_TABLE)) == null) {
            TokenManager.initTokenIdTable(messageContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTokenIdsTable() returns Hashtable[" + hashtable + "]"));
        }
        return hashtable;
    }

    private static void initTokenIdTable(SOAPMessageContext sOAPMessageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initTokenIdTable(SOAPMessageContext mcontext)");
        }
        if (!sOAPMessageContext.containsProperty(TOKENID_TABLE) || sOAPMessageContext.getProperty(TOKENID_TABLE) == null) {
            sOAPMessageContext.setProperty(TOKENID_TABLE, new Hashtable());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initTokenIdTable(SOAPMessageContext mcontext)");
        }
    }

    public static String getRunAsIdentity(final boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRunAsIdentity(boolean sendRealm[" + bl + "])"));
        }
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Iterator iterator;
                Set set;
                Subject subject = null;
                String string = null;
                ContextManager contextManager = ContextManagerFactory.getInstance();
                if (contextManager == null) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.finalizeSubject01");
                }
                try {
                    subject = contextManager.getInvocationSubject();
                    if (subject == null) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.finalizeSubject03");
                    }
                }
                catch (WSSecurityException wSSecurityException) {
                    Tr.error((TraceComponent)tc, (String)"security.wssecurity.TokenManager.finalizeSubject03", (Object)new Object[]{wSSecurityException});
                }
                if (subject != null && (set = subject.getPrincipals(class$com$ibm$websphere$security$auth$WSPrincipal == null ? (class$com$ibm$websphere$security$auth$WSPrincipal = TokenManager.class$("com.ibm.websphere.security.auth.WSPrincipal")) : class$com$ibm$websphere$security$auth$WSPrincipal)) != null && (iterator = set.iterator()).hasNext()) {
                    WSPrincipal wSPrincipal = (WSPrincipal)iterator.next();
                    string = bl ? wSPrincipal.getName() : RealmSecurityName.getSecurityName(wSPrincipal.getName());
                }
                return string;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRunAsIdentity(boolean sendRealm) returns String[" + string + "]"));
        }
        return string;
    }
}

