/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.handler.token.ByteArray;
import com.ibm.ws.webservices.wssecurity.handler.token.NonceCache;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;

public class WSNonceManagerImpl
implements NonceManager {
    private static final TraceComponent tc = Tr.register((Class)WSNonceManagerImpl.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = WSNonceManagerImpl.class.getName();
    private static final String comp = "security.wssecurity";
    private static final String DEFAULT_JCE_PROVIDER = "DEFAULT_JCE_PROVIDER";
    private static final String IBMJCE = "IBMJCE";
    private static final String IBMSEC_RANDOM = "IBMSecureRandom";
    private static final String NONCE_CACHE_SIZE_KEY = "com.ibm.websphere.wssecurity.util.nonceCacheSize";
    private static final String NONCE_LENGTH_KEY = "com.ibm.websphere.wssecurity.util.nonceLength";
    private SecureRandom _random = null;
    private boolean _bServer = false;
    private NonceCache _cache = null;
    private int _nonceLength = 128;

    public WSNonceManagerImpl(String string, int n, int n2, int n3, boolean bl) {
        int n4;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("WSNonceManagerImpl(String cacheName[" + string + "]," + "int cacheSize[" + n + "]," + "int cacheTimeout[" + n2 + "]," + "int nonceLength[" + n3 + "]," + "boolean cacheDistributed[" + bl + "])"));
        }
        this._bServer = WSSecurityPlatformContextFactory.getInstance().isServer();
        if (this._bServer) {
            string2 = System.getProperty(NONCE_CACHE_SIZE_KEY);
            n4 = n;
            if (string2 != null && (string2 = string2.trim()).length() != 0) {
                try {
                    int n5 = Integer.parseInt(string2);
                    if (n5 <= 16) {
                        Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0124W", (Object)new Object[]{string2, new Integer(16), new Integer(n)});
                        n4 = n;
                    } else {
                        n4 = n5;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Nonce cache size from system property (com.ibm.websphere.wssecurity.util.nonceCacheSize) = " + n4));
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, WSNonceManagerImpl.class.getName() + ".WSNonceManagerImpl", "89", this);
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5190W", (Object)new Object[]{NONCE_CACHE_SIZE_KEY, string2, new Integer(n)});
                    n4 = n;
                }
            }
            if (string == null || string.length() == 0) {
                string = "NonceDistributionCacheMap";
            }
            this._cache = new NonceCache(string, n4, n2, true, bl);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Server process: enabled NonceCache");
            }
        }
        this._nonceLength = n3;
        string2 = System.getProperty(NONCE_LENGTH_KEY);
        if (string2 != null && (string2 = string2.trim()).length() != 0) {
            try {
                n4 = Integer.parseInt(string2);
                if (n4 <= 16) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC0127W", (Object)new Object[]{string2, new Integer(16), new Integer(n3)});
                    this._nonceLength = n3;
                } else {
                    this._nonceLength = n4;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Nonce length from system property (com.ibm.websphere.wssecurity.util.nonceLength) = " + this._nonceLength));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, WSNonceManagerImpl.class.getName() + ".WSNonceManagerImpl", "124", this);
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSEC5190W", (Object)new Object[]{NONCE_LENGTH_KEY, string2, new Integer(n3)});
                this._nonceLength = n3;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce length = " + this._nonceLength));
        }
        this.initSecureRandom();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSNonceManagerImpl(String cacheName, int cacheSize, int cacheTimeout,int nonceLength, boolean cacheDistributed)");
        }
    }

    public boolean validate(byte[] byArray) throws SoapSecurityException {
        boolean bl;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate");
        }
        if (byArray == null || byArray.length == 0) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSEC0121E");
            throw SoapSecurityException.format("security.wssecurity.WSEC0121E");
        }
        if (this._cache == null) {
            String string = this._bServer ? ".WSEC0122E" : ".WSEC0123E";
            Tr.error((TraceComponent)tc, (String)(comp + string));
            throw SoapSecurityException.format(comp + string);
        }
        if (tc.isDebugEnabled()) {
            object = new ByteArrayOutputStream();
            ((ByteArrayOutputStream)object).write(byArray, 0, byArray.length);
            Tr.debug((TraceComponent)tc, (String)"validating ", (Object)((ByteArrayOutputStream)object).toString());
        }
        boolean bl2 = bl = !this._cache.contains(object = new ByteArray(byArray));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("validate returns " + bl));
        }
        return bl;
    }

    public byte[] generate() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generate()");
        }
        byte[] byArray = null;
        if (this._random != null) {
            byArray = new byte[this._nonceLength];
            this._random.nextBytes(byArray);
            if (tc.isEntryEnabled()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                Tr.exit((TraceComponent)tc, (String)"generate", (Object)byteArrayOutputStream.toString());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No random number generator");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"generate returns null");
            }
        }
        return byArray;
    }

    private void initSecureRandom() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initSecureRandom()");
        }
        String string = Security.getProperty(DEFAULT_JCE_PROVIDER);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JCE Default Provider is " + string));
        }
        if (string == null || string.length() == 0) {
            string = IBMJCE;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JCE Default Provider is null, force to use: " + string));
            }
        }
        try {
            this._random = SecureRandom.getInstance(IBMSEC_RANDOM, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string2 = "security.wssecurity.WSEC5195E";
            Tr.warning((TraceComponent)tc, (String)string2, (Object)new Object[]{IBMSEC_RANDOM, string, noSuchAlgorithmException});
        }
        catch (NoSuchProviderException noSuchProviderException) {
            String string3 = "security.wssecurity.WSEC5195E";
            Tr.warning((TraceComponent)tc, (String)string3, (Object)new Object[]{IBMSEC_RANDOM, string, noSuchProviderException});
        }
        byte[] byArray = new byte[this._nonceLength];
        this._random.nextBytes(byArray);
        this._random.setSeed(SecurityUIDGenerator.createUID().getBytes());
        this._random.nextBytes(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initSecureRandom()");
        }
    }

    public String toString() {
        return clsName;
    }
}

