/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.webservices.wssecurity.dsig.XMLDTKeyInfoResolver;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class STRDTKeyInfoResolver {
    private static final TraceComponent tc = Tr.register((Class)STRDTKeyInfoResolver.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = STRDTKeyInfoResolver.class.getName();
    private IDResolver _idResolver;
    private Set _tokenSet;
    private Set _dsigKinfoSet;
    private Set _encKinfoSet;
    private boolean _generation = false;
    private Map _context;
    private Map _selectors;
    private Set _stokens = null;
    private Result[] _results = null;
    private boolean _storedToken = false;

    protected STRDTKeyInfoResolver() {
    }

    protected void setDsigKeyInfoSet(Set set) {
        this._dsigKinfoSet = set;
    }

    protected void setEncKeyInfoSet(Set set) {
        this._encKinfoSet = set;
    }

    protected void setGeneration(boolean bl) {
        this._generation = bl;
    }

    protected void setContext(Map map) {
        this._context = map;
    }

    protected void setSelectors(Map map) {
        this._selectors = map;
    }

    protected void setIdResolver(IDResolver iDResolver) {
        this._idResolver = iDResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element resolve(Element element, String string) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolve(Element secTokenRef[" + DOMUtil.getDisplayName((Node)element) + "]," + "String keyInfoType[" + string + "])"));
        }
        Element element2 = null;
        try {
            HashMap hashMap = new HashMap();
            int n = 0;
            Object v = this._context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
            if (v != null && v instanceof Integer) {
                n = (Integer)v;
            }
            String string2 = Constants.NAMESPACES[0][n];
            if (this._generation) {
                element2 = STRDTKeyInfoResolver.getElementInSubject(element, string, string2, this._context);
            } else {
                if (!this._storedToken) {
                    this._stokens = XMLDTKeyInfoResolver.storeSubject(this._context);
                    this._results = XMLDTKeyInfoResolver.storeResult(this._context);
                    this._storedToken = true;
                }
                if ((element2 = STRDTKeyInfoResolver.getElementInSubject(element, string, string2, this._context)) == null) {
                    element2 = STRDTKeyInfoResolver.getElement(element, this._dsigKinfoSet, this._encKinfoSet, hashMap, this._selectors, this._context);
                }
            }
        }
        finally {
            if (this._storedToken) {
                XMLDTKeyInfoResolver.restoreSubject(this._context, this._stokens);
                XMLDTKeyInfoResolver.restoreResult(this._context, this._results);
                this._storedToken = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resolve(Element secTokenRef,String keyInfoType) returns Element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
        }
        return element2;
    }

    private static Element getElementInSubject(Element element, String string, String string2, Map map) throws SoapSecurityException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElementInSubject(Element secTokenRef[" + DOMUtil.getDisplayName((Node)element) + "]," + "String keyInfoType[" + string + "]," + "String nsWsse[" + string2 + "]," + "Map context)"));
        }
        Element element2 = null;
        Set set = TokenManager.getTokens(map);
        if (set != null && (string3 = STRDTKeyInfoResolver.getIdInSubject(element, string, string2)) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Token token = (Token)iterator.next();
                if (!string3.equals(token.getId())) continue;
                element2 = token.getElement();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getElementInSubject(Element secTokenRef,String keyInfoType,String nsWsse", (Object)("Map context) returns Element[" + DOMUtil.getDisplayName(element2) + "]"));
        }
        return element2;
    }

    private static String getIdInSubject(Element element, String string, String string2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getIdInSubject(Element secTokenRef[" + DOMUtil.getDisplayName((Node)element) + "]," + "String keyInfoType[" + string + "]," + "String nsWsse[" + string2 + "])"));
        }
        String string3 = null;
        Element element2 = null;
        if (ConfigUtil.isKeyInfoKeyid((String)string)) {
            element2 = DOMUtil.getOneElement((Element)element, (String)string2, (String)"KeyIdentifier");
            string3 = DOMUtil.getStringValue((Node)element2);
        } else if (ConfigUtil.isKeyInfoX509issuer((String)string)) {
            String string4;
            element2 = DOMUtil.getOneElement((Element)element, (String)Constants.NS_DSIG, (String)"X509IssuerName");
            String string5 = DOMUtil.getStringValue((Node)element2);
            if (string5 != null) {
                string5 = KeyInfo.X509Data.encodeDName((String)string5);
            }
            if ((string4 = DOMUtil.getStringValue((Node)(element2 = DOMUtil.getOneElement((Element)element, (String)Constants.NS_DSIG, (String)"X509SerialNumber")))) != null) {
                try {
                    BigInteger bigInteger = new BigInteger(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        BigInteger bigInteger = CertificateUtil.convertSerialNumber((String)string4);
                        string4 = bigInteger.toString();
                    }
                    catch (ParseException parseException) {
                        throw SoapSecurityException.format("security.wssecurity.X509LoginModule.s04", string4, (Throwable)parseException);
                    }
                }
            }
            string3 = string5 + ":" + string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getIdInSubject(Element secTokenRef,String keyInfoType,String nsWsse) returns String[" + string3 + "]"));
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element getElement(Element element, Set set, Set set2, Map map, Map map2, Map map3) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElement(Element secTokenRef[" + DOMUtil.getDisplayName((Node)element) + "]," + "Set dsigKinfoSet[" + set + "]," + "Set encKinfoSet[" + set2 + "]," + "Map type," + "Map properties," + "Map context)"));
        }
        Element element2 = null;
        Set set3 = STRDTKeyInfoResolver.lockTokens(map3);
        try {
            Element element3 = STRDTKeyInfoResolver.getKeyInfoElement(element);
            KeyInfoResult keyInfoResult = STRDTKeyInfoResolver.callKeyInfoConsumer(set, set2, map, map2, element3, map3);
            if (keyInfoResult == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WEARNING: Unable to get the KeyInfoResult.");
                }
            } else {
                String string = keyInfoResult.getIdInSubject();
                Token token = TokenManager.getToken(map3, keyInfoResult.getKeyInfoContentConsumer().getTokenConsumer(), string);
                if (token == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WEARNING: Unable to extract the token with the token identifier [" + string + "]."));
                    }
                } else {
                    if (token.getError() != null) {
                        throw token.getError();
                    }
                    element2 = token.getElement();
                }
            }
        }
        finally {
            STRDTKeyInfoResolver.restoreTokens(map3, set3);
            STRDTKeyInfoResolver.removeKeyInfoResults(map3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getElement(Element secTokenRef,Set dsigKinfoSet,Set encKinfoSet,Map type,Map properties,Map context) returns Element[" + DOMUtil.getDisplayName((Node)element2) + "]"));
        }
        return element2;
    }

    private static Element getKeyInfoElement(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKeyInfoElement(Node node[" + DOMUtil.getDisplayName((Node)node) + "])"));
        }
        Element element = null;
        Node node2 = node.getParentNode();
        if (node2 != null) {
            element = node2.getNodeType() == 1 && DOMUtil.equals((Node)node2, (String)Constants.NS_DSIG, (String)"KeyInfo") ? (Element)node2 : STRDTKeyInfoResolver.getKeyInfoElement(node2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyInfoElement(Node node)returns Element[" + DOMUtil.getDisplayName((Node)element) + "]"));
        }
        return element;
    }

    private static KeyInfoResult callKeyInfoConsumer(Set set, Set set2, Map map, Map map2, Element element, Map map3) throws SoapSecurityException {
        KeyInfoResult[] keyInfoResultArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callKeyInfoConsumer(Set dsigKinfoSet,Set encKinfoSet,Map type,Map properties,Element target[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map context)"));
        }
        KeyInfoResult keyInfoResult = null;
        boolean bl = false;
        Exception exception = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            keyInfoResultArray = (KeyInfoResult[])iterator.next();
            try {
                SignatureConsumer.callKeyInfoConsumer((KeyInfoConsumerConfig)keyInfoResultArray, "VerifyingKey", map, map2, element, map3);
                bl = true;
                break;
            }
            catch (Exception exception2) {
                exception = exception2;
                STRDTKeyInfoResolver.removeKeyInfoResults(map3);
            }
        }
        if (bl) {
            keyInfoResultArray = SignatureConsumer.getKeyInfoResults(map3);
            keyInfoResult = STRDTKeyInfoResolver.getProcessedResult(keyInfoResultArray, set);
        } else {
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                keyInfoResultArray = (KeyInfoConsumerConfig)iterator.next();
                try {
                    SignatureConsumer.callKeyInfoConsumer((KeyInfoConsumerConfig)keyInfoResultArray, "DecryptingKey", map, map2, element, map3);
                    bl = true;
                    break;
                }
                catch (Exception exception3) {
                    exception = exception3;
                    STRDTKeyInfoResolver.removeKeyInfoResults(map3);
                }
            }
        }
        if (!bl) {
            throw SoapSecurityException.format("security.wssecurity.DTKeyInfoResolver.s01", exception);
        }
        keyInfoResultArray = SignatureConsumer.getKeyInfoResults(map3);
        keyInfoResult = STRDTKeyInfoResolver.getProcessedResult(keyInfoResultArray, set2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("callKeyInfoConsumer(boolean signature,Set keyInfoSet,Map type,Map properties,Element target,Map context) returns KeyInfoResult[" + keyInfoResult + "]"));
        }
        return keyInfoResult;
    }

    private static KeyInfoResult getProcessedResult(KeyInfoResult[] keyInfoResultArray, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProcessedResult(KeyInfoResult[] results,Set keyInfoSet");
        }
        KeyInfoResult keyInfoResult = null;
        if (keyInfoResultArray != null) {
            for (int i = 0; i < keyInfoResultArray.length; ++i) {
                KeyInfoResult keyInfoResult2 = keyInfoResultArray[i];
                KeyInfoContentConsumerConfig keyInfoContentConsumerConfig = keyInfoResult2.getKeyInfoContentConsumer();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    KeyInfoConsumerConfig keyInfoConsumerConfig = (KeyInfoConsumerConfig)iterator.next();
                    if (!keyInfoConsumerConfig.getContentConsumers().contains(keyInfoContentConsumerConfig) || keyInfoResult2.getError() != null) continue;
                    keyInfoResult = keyInfoResult2;
                    break;
                }
                if (keyInfoResult != null) break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getProcessedResult(KeyInfoResult[] results,Set keyInfoSet) returns KeyInfoResult[" + keyInfoResult + "]"));
        }
        return keyInfoResult;
    }

    private static Set lockTokens(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lockTokens(Map context)");
        }
        HashSet hashSet = new HashSet(TokenManager.getTokens(map));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lockTokens(Map context)");
        }
        return hashSet;
    }

    private static void removeKeyInfoResults(Map map) {
        Result[] resultArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeKeyInfoResults(Map context)");
        }
        if ((resultArray = ResultPool.get((Map)map, (Class)KeyInfoResult.class)) != null && resultArray.length > 0) {
            ResultPool.remove((Map)map, (Result[])resultArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeKeyInfoResults(Map context)");
        }
    }

    private static void restoreTokens(Map map, Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreTokens(Map context,Set tokens)");
        }
        TokenManager.removeAllTokens(map);
        TokenManager.setTokens(map, set);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreResults(Map context,Set tokens)");
        }
    }
}

