/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.handler.token.WSCertCacheManagerImpl;
import com.ibm.ws.webservices.wssecurity.token.CertCacheManager;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;

public class CertManagerFactory {
    private static final TraceComponent tc = Tr.register((Class)CertManagerFactory.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = CertManagerFactory.class.getName();
    private static final String comp = "security.wssecurity";
    private static final Permission INIT_PERMISSION = new WebSphereRuntimePermission("wssecurity.CertManagerFactory.init");
    private static final Permission GET_INSTANCE_PERMISSION = new WebSphereRuntimePermission("wssecurity.CertManagerFactory.getInstance");
    private static CertCacheManager _instance;
    private static boolean _initialized;

    private CertManagerFactory() {
    }

    public static CertCacheManager getInstance() throws SoapSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInstance()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_INSTANCE_PERMISSION);
        }
        CertCacheManager certCacheManager = null;
        if (!_initialized) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: The certificate manager is not initialized.");
            }
        } else {
            certCacheManager = _instance;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInstance() returns CertManager[" + certCacheManager + "]"));
        }
        return certCacheManager;
    }

    protected static synchronized void init(boolean bl, String string, int n, int n2) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("init(boolean useCache[" + bl + "]," + "String cacheName[" + string + "]," + "int cacheSize[" + n + "]," + "int cacheTimeout[" + n2 + "])"));
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(INIT_PERMISSION);
        }
        if (!_initialized) {
            _instance = bl ? new WSCertCacheManagerImpl(string, n, n2) : null;
            _initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(boolean useCache, String cacheName, int cacheSize, int cacheTimeout)");
        }
    }

    public String toString() {
        return clsName;
    }

    static {
        _initialized = false;
    }
}

