/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.provider.ejb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.provider.ejb.stubless.EJBDII;
import com.ibm.ws.webservices.multiprotocol.provider.ejb.stubless.impl.EJBObjectFactory;
import com.ibm.ws.webservices.multiprotocol.provider.java.JavaTransport;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.rmi.RemoteException;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;

public class EJBTransport
extends JavaTransport {
    private static final TraceComponent _tc = Tr.register(EJBTransport.class, "WebServices", "com.ibm.ws.webservices.multiprotocol.resources.mpMessages");
    public static final String PROTOCOL = "wsejb";
    public static final String ADDRESS_JNDI_NAME = "jndiName";
    public static final String ADDRESS_INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    public static final String ADDRESS_JNDI_PROVIDER_URL = "jndiProviderURL";

    public EJBTransport(ServiceContext serviceContext) {
        super(serviceContext);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EJBTransport ctor(ServiceContext)", serviceContext);
        }
    }

    public Object getTargetKey(InvocationContext invocationContext) {
        return invocationContext.getEndpoint();
    }

    public void close(InvocationContext invocationContext, Object object) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "close", new Object[]{invocationContext, object});
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "close");
        }
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public Object makeTargetObject(InvocationContext invocationContext) throws RemoteException {
        Map map;
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "makeTargetObject", invocationContext);
        }
        String string2 = invocationContext.getEndpoint();
        AgnosticAddress agnosticAddress = new AgnosticAddress();
        agnosticAddress.setLocationURI(string2);
        try {
            string = agnosticAddress.getURLHost();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "EJB stub classname: " + string);
            }
        }
        catch (WSDLException wSDLException) {
            FFDCFilter.processException((Throwable)wSDLException, "com.ibm.ws.webservices.multiprotocol.provider.ejb.EJBTransport.makeTargetObject", "103", (Object)this);
            throw new JAXRPCException(Messages.getMessage((String)"errorGetEjbClass", (String)"WSDLException", (String)string2, (String)wSDLException.toString()));
        }
        try {
            map = agnosticAddress.getURLQueryProperties();
        }
        catch (WSDLException wSDLException) {
            FFDCFilter.processException((Throwable)wSDLException, "com.ibm.ws.webservices.multiprotocol.provider.ejb.EJBTransport.makeTargetObject", "117", (Object)this);
            throw new JAXRPCException(Messages.getMessage((String)"errorGetQueryProps", (String)"WSDLException", (String)string2, (String)wSDLException.toString()));
        }
        if (!map.containsKey(ADDRESS_JNDI_NAME)) {
            throw new JAXRPCException(Messages.getMessage((String)"missingUrlProp", (String)ADDRESS_JNDI_NAME, (String)string2));
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Properties contained in endpoint URL string: " + map.toString());
        }
        String string3 = (String)map.get(ADDRESS_JNDI_NAME);
        String string4 = (String)map.get(ADDRESS_INITIAL_CONTEXT_FACTORY);
        String string5 = (String)map.get(ADDRESS_JNDI_PROVIDER_URL);
        Class clazz = invocationContext.getSeiClass();
        EJBObjectFactory eJBObjectFactory = EJBObjectFactory.newInstance();
        Object object = clazz != null ? eJBObjectFactory.getStub(string, string3, clazz, string4, string5) : eJBObjectFactory.getDII(string3, string4, string5);
        return object;
    }

    public Object invoke(InvocationContext invocationContext, Object object, QName qName, Object[] objectArray, Class clazz) throws RemoteException {
        Object object2;
        if (object instanceof EJBDII) {
            EJBDII eJBDII = (EJBDII)object;
            eJBDII.setInputTypes(invocationContext.getInputParameterTypes());
            eJBDII.setReturnType(clazz);
            object2 = eJBDII.invoke(JavaUtils.xmlNameToJava(qName.getLocalPart()), objectArray);
        } else {
            object2 = super.invoke(invocationContext, object, qName, objectArray, clazz);
        }
        return object2;
    }
}

