/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployableItem;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.handlers.HandlerClassFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDHandler
extends WSDDDeployableItem
implements Comparable {
    private static Log log = LogFactory.getLog(WSDDHandler.class.getName());
    public static final String HANDLER_PARAM_PREFIX = "com.ibm.websphere.webservices.handler.";
    public static final String HANDLER_PARAM_NAME = "com.ibm.websphere.webservices.handler.name";
    public static final String HANDLER_PARAM_CATEGORY = "com.ibm.websphere.webservices.handler.category";
    public static final String HANDLER_PARAM_PRIORITY = "com.ibm.websphere.webservices.handler.priority";
    public static final String HANDLER_PARAM_POSITION = "com.ibm.websphere.webservices.handler.position";
    public static final String HANDLER_PARAM_ROLE = "com.ibm.websphere.webservices.handler.role";
    public static final String HANDLER_PARAM_FLOW = "com.ibm.websphere.webservices.handler.flow";
    public static final int MAX_PRIORITY = 1000;
    public static final int MIN_PRIORITY = 2147482647;
    public static final int INTERNAL_MAX_PRIORITY = 0;
    public static final int INTERNAL_MIN_PRIORITY = Integer.MAX_VALUE;
    public static final int DEFAULT_PRIORITY = 2147482647;
    public static final int PRIORITY_NOTSET = -1;
    private boolean loadedClass = false;
    private Class javaClass = null;
    private QName type;
    private int priority = 2147482647;

    public WSDDHandler() {
    }

    public WSDDHandler(Element element) throws WSDDException {
        super(element);
        String string;
        String string2 = element.getAttribute("type");
        if (string2 != null && !string2.equals("")) {
            this.setType(XMLUtils.getQNameFromString(string2, element));
        }
        if ((string = element.getAttribute("priority")) != null && !string.equals("")) {
            this.setPriority(string);
        }
        if (this.getType() == null && this.getClass() == WSDDHandler.class) {
            throw new WSDDException(Messages.getMessage("noTypeAttr00"));
        }
    }

    protected boolean loadableParam(String string) {
        return !string.startsWith(HANDLER_PARAM_PREFIX);
    }

    public void setName(String string) {
        super.setName(string);
        this.setParameter(HANDLER_PARAM_NAME, string, true);
    }

    protected final Handler makeNewInstance(EngineConfiguration engineConfiguration) throws ConfigurationException {
        if (this.getType() == null || "http://websphere.ibm.com/webservices/wsdd/dispatchers/java".equals(this.getType().getNamespaceURI())) {
            return this.makeNewHandler(engineConfiguration);
        }
        throw new WSDDException(Messages.getMessage("badTypeNamespace00", this.getType().getNamespaceURI(), "http://websphere.ibm.com/webservices/wsdd/dispatchers/java"));
    }

    protected Handler makeNewHandler(EngineConfiguration engineConfiguration) throws ConfigurationException {
        Class clazz = null;
        try {
            clazz = this.getJavaClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDHandler.makeNewHandler", "200", this);
            throw WSDDException.makeWSDDException(classNotFoundException);
        }
        Handler handler = null;
        if (clazz != null) {
            try {
                handler = (Handler)clazz.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDHandler.makeNewHandler", "209", this);
                throw WSDDException.makeWSDDException(exception);
            }
            if (handler != null) {
                if (this.getQName() != null) {
                    handler.setName(this.getQName().getLocalPart());
                }
                handler.setOptions((Map)this.getParametersTable());
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getJavaClass() throws ClassNotFoundException {
        if (!this.loadedClass) {
            block13: {
                try {
                    QName qName = this.getType();
                    if (qName == null || !"http://websphere.ibm.com/webservices/wsdd/dispatchers/java".equals(qName.getNamespaceURI())) {
                        this.javaClass = null;
                    } else {
                        this.javaClass = ClassUtils.forName(qName.getLocalPart());
                        if (HandlerClassFactory.class.isAssignableFrom(this.javaClass)) {
                            try {
                                HandlerClassFactory handlerClassFactory = (HandlerClassFactory)this.javaClass.newInstance();
                                Class clazz = handlerClassFactory.getHandlerClass();
                                if (log.isDebugEnabled() && clazz != this.javaClass) {
                                    if (clazz == null) {
                                        log.debug("Factory returned null class.");
                                    } else {
                                        log.debug("Factory returned alternate class '" + clazz.getName() + "'");
                                    }
                                }
                                this.javaClass = clazz;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.webservices.axis.ext.deployment.wsdd.WSDDHandler.getJavaClass", "74", this);
                                log.error(Messages.getMessage("exception00"), illegalAccessException);
                                this.javaClass = null;
                            }
                            catch (InstantiationException instantiationException) {
                                FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.webservices.axis.ext.deployment.wsdd.WSDDHandler.getJavaClass", "78", this);
                                log.error(Messages.getMessage("exception00"), instantiationException);
                                this.javaClass = null;
                            }
                        }
                    }
                    Object var5_6 = null;
                    if (this.javaClass != null || !log.isDebugEnabled()) break block13;
                    log.debug("handler \"" + (this.getQName() == null ? "<noname>" : this.getQName().getLocalPart()) + "\" unable to load \"" + (this.type == null ? "<notype>" : this.type.getLocalPart()) + "\"");
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (this.javaClass == null && log.isDebugEnabled()) {
                        log.debug("handler \"" + (this.getQName() == null ? "<noname>" : this.getQName().getLocalPart()) + "\" unable to load \"" + (this.type == null ? "<notype>" : this.type.getLocalPart()) + "\"");
                    }
                    this.loadedClass = true;
                    throw throwable;
                }
            }
            this.loadedClass = true;
            {
            }
        }
        return this.javaClass;
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName qName) {
        this.type = qName;
    }

    public int getPriority() {
        if (this.priority == -1) {
            this.setPriority(2147482647);
        }
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
        this.setParameter(HANDLER_PARAM_PRIORITY, String.valueOf(n), true);
    }

    public void setPriority(String string) {
        if (string != null) {
            try {
                this.setPriority(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.setPriority(2147482647);
            }
        }
    }

    protected QName getElementName() {
        return QNAME_HANDLER;
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (this.getQName() != null) {
            attributesImpl.addAttribute("", "name", "name", "CDATA", serializationContext.getSerializationWriter().qName2String(this.getQName()));
        }
        if (this.getPriority() != 2147482647) {
            attributesImpl.addAttribute("", "priority", "priority", "CDATA", String.valueOf(this.getPriority()));
        }
        serializationContext.getSerializationWriter().startElement(WSDDConstants.QNAME_HANDLER, attributesImpl);
        this.writeParamsToContext(serializationContext);
        serializationContext.getSerializationWriter().endElement();
    }

    public int compareTo(Object object) {
        return object instanceof WSDDHandler ? this.getPriority() - ((WSDDHandler)object).getPriority() : -1;
    }
}

