/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.websphere.webservices.soap.IBMSOAPMessage;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.SOAPPart;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.attachments.AttachmentsImpl;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.enum.MessageType;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class Message
extends IBMSOAPMessage
implements Serializable {
    protected static Log log = LogFactory.getLog(Message.class.getName());
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    public static final String MIME_APPLICATION_DIME = "application/dime";
    public static final String DEFAULT_ATTACHMENT_IMPL;
    public static final String DEFAULT_ATTACHMNET_IMPL;
    private static String mAttachmentsImplClassName;
    public static final String MIME_UNKNOWN = "  ";
    private com.ibm.ws.webservices.engine.enumtype.MessageType messageType = com.ibm.ws.webservices.engine.enumtype.MessageType.UNKNOWN;
    private SOAPPart mSOAPPart;
    private Attachments mAttachments = null;
    private MimeHeaders headers;
    private boolean saveRequired = true;
    private Properties properties = new Properties();
    private String charsetEncoding = "utf-8";
    private boolean writeXmlDeclaration = false;
    private MessageContext msgContext;
    private static Class attachImpl;
    private static Constructor attachImplConstr;
    private static boolean checkForAttchmentSupport;
    private static boolean attachmentSupportEnabled;

    public static String getAttachmentImplClassName() {
        return mAttachmentsImplClassName;
    }

    public com.ibm.ws.webservices.engine.enumtype.MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(com.ibm.ws.webservices.engine.enumtype.MessageType messageType) {
        this.messageType = messageType;
    }

    public void setMessageType(MessageType messageType) {
        if (messageType.getName().equals("unknown")) {
            this.messageType = com.ibm.ws.webservices.engine.enumtype.MessageType.UNKNOWN;
        }
        if (messageType.getName().equals("request")) {
            this.messageType = com.ibm.ws.webservices.engine.enumtype.MessageType.REQUEST;
        }
        if (messageType.getName().equals("response")) {
            this.messageType = com.ibm.ws.webservices.engine.enumtype.MessageType.RESPONSE;
        }
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.msgContext = messageContext;
        messageContext.setCharacterEncoding(this.charsetEncoding);
    }

    public Message(Object object) {
        this.setup(object, null, null, null);
    }

    public Message(Object object, MimeHeaders mimeHeaders) {
        this.setup(object, null, null, mimeHeaders);
    }

    public Message(Object object, String string, String string2) {
        this.setup(object, string, string2, null);
    }

    private static synchronized boolean isAttachmentSupportEnabled(MessageContext messageContext) {
        if (checkForAttchmentSupport) {
            checkForAttchmentSupport = false;
            try {
                WebServicesEngine webServicesEngine;
                String string = "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl";
                if (null != messageContext && null != (webServicesEngine = messageContext.getEngine())) {
                    string = (String)webServicesEngine.getOption("attachments.implementation");
                }
                if (null == string) {
                    string = "com.ibm.ws.webservices.engine.attachments.AttachmentsImpl";
                }
                ClassUtils.forName("javax.activation.DataHandler");
                ClassUtils.forName("javax.mail.internet.MimeMultipart");
                attachImpl = ClassUtils.forName(string);
                mAttachmentsImplClassName = attachImpl.getName();
                attachImplConstr = attachImpl.getConstructors()[0];
                attachmentSupportEnabled = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            log.debug(Messages.getMessage("attachEnabled") + MIME_UNKNOWN + attachmentSupportEnabled);
        }
        return attachmentSupportEnabled;
    }

    private void setup(Object object, String string, String string2, MimeHeaders mimeHeaders) {
        int n;
        Object object2;
        if (object instanceof InputStream) {
            object = WebServicesInputSource.create((InputStream)((InputStream)object));
        } else if (object instanceof byte[]) {
            object = WebServicesInputSource.create((byte[])((byte[])object));
        } else if (object instanceof String) {
            object = WebServicesInputSource.create((String)((String)object));
        }
        if (string == null && mimeHeaders != null) {
            object2 = mimeHeaders.getHeader("Content-Type");
            String string3 = string = object2 != null ? object2[0] : null;
        }
        if (string2 == null && mimeHeaders != null) {
            object2 = mimeHeaders.getHeader("Content-Location");
            String string4 = string2 = object2 != null ? object2[0] : null;
        }
        if (string != null && (n = ((String)(object2 = string.toLowerCase())).indexOf("charset=")) > 0) {
            if ((n = ((String)(object2 = ((String)object2).substring(n + "charset=".length()))).indexOf("utf-8")) == 0 || n == 1) {
                this.setCharacterEncoding("utf-8");
            }
            if ((n = ((String)object2).indexOf("utf-16")) == 0 || n == 1) {
                this.setCharacterEncoding("utf-16");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Message.setup() CharacterEncoding=" + this.getCharacterEncoding());
            log.debug("Message.setup() contentType=" + string);
        }
        if (Message.isAttachmentSupportEnabled(this.getMessageContext())) {
            if (attachImpl.equals(AttachmentsImpl.class)) {
                try {
                    this.mAttachments = new AttachmentsImpl(object, string, string2);
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.Message.setup", "369", this);
                    log.fatal(Messages.getMessage("invocationTargetException00"), webServicesFault);
                    throw new RuntimeException(webServicesFault.getMessage());
                }
                this.mSOAPPart = (SOAPPart)this.mAttachments.getRootPart();
            } else {
                try {
                    object2 = object;
                    if (object instanceof WebServicesInputSource) {
                        object2 = ((WebServicesInputSource)object).getByteStream();
                    }
                    this.mAttachments = (Attachments)attachImplConstr.newInstance(object, string, string2);
                    this.mSOAPPart = (SOAPPart)this.mAttachments.getRootPart();
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.webservices.engine.Message.setup", "360", this);
                    log.fatal(Messages.getMessage("invocationTargetException00"), invocationTargetException);
                    throw new RuntimeException(invocationTargetException.getMessage());
                }
                catch (InstantiationException instantiationException) {
                    FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.webservices.engine.Message.setup", "365", this);
                    log.fatal(Messages.getMessage("instantiationException00"), instantiationException);
                    throw new RuntimeException(instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.webservices.engine.Message.setup", "370", this);
                    log.fatal(Messages.getMessage("illegalAccessException00"), illegalAccessException);
                    throw new RuntimeException(illegalAccessException.getMessage());
                }
            }
        }
        if (null == this.mSOAPPart) {
            this.mSOAPPart = new SOAPPart(object);
        }
        this.mSOAPPart.setMessage(this);
        if (this.mAttachments != null) {
            this.mAttachments.setRootPart((Part)this.mSOAPPart);
        }
        this.headers = mimeHeaders == null ? new MimeHeaders() : mimeHeaders;
    }

    public javax.xml.soap.SOAPPart getSOAPPart() {
        return this.mSOAPPart;
    }

    public String getSOAPPartAsString() throws WebServicesFault {
        return this.mSOAPPart.getAsString();
    }

    public byte[] getSOAPPartAsBytes() throws WebServicesFault {
        return this.mSOAPPart.getAsBytes();
    }

    public SOAPEnvelope getSOAPEnvelope() throws WebServicesFault {
        return this.mSOAPPart.getAsSOAPEnvelope();
    }

    public Attachments getAttachmentsImpl() {
        return this.mAttachments;
    }

    public String getContentType(SOAPConstants sOAPConstants) throws WebServicesFault {
        int n = 1;
        if (this.msgContext != null && this.msgContext.getPortDesc() != null) {
            n = this.msgContext.getPortDesc().getSendType();
        }
        if (n != 4) {
            this.mSOAPPart.getAsWebServicesInputSource();
        }
        String string = sOAPConstants.getContentType();
        string = string + "charset=" + this.getCharacterEncoding();
        if (this.mAttachments != null && 0 != this.mAttachments.getAttachmentCount()) {
            string = this.mAttachments.getContentType();
        }
        return string;
    }

    public long getContentLength() throws WebServicesFault {
        return this.mAttachments != null && 0 < this.mAttachments.getAttachmentCount() ? this.mAttachments.getContentLength() : (long)this.mSOAPPart.getContentLength();
    }

    public long getOriginalContentLength() throws WebServicesFault {
        return this.mAttachments != null && 0 < this.mAttachments.getAttachmentCount() ? this.mAttachments.getContentLength() : this.mSOAPPart.getOriginalContentLength();
    }

    public void writeTo(OutputStream outputStream) throws SOAPException, IOException {
        if (this.mAttachments == null || 0 == this.mAttachments.getAttachmentCount()) {
            try {
                this.mSOAPPart.writeTo(outputStream, this.getCharacterEncoding());
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.Message.writeTo", "481", this);
                log.error(Messages.getMessage("javaIOException00"), iOException);
            }
        } else {
            try {
                this.mAttachments.writeContentToStream(outputStream);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.Message.writeTo", "488", this);
                log.error(Messages.getMessage("exception00"), exception);
            }
        }
    }

    public void writeTo(OutputStream outputStream, String string) throws SOAPException, IOException {
        if (string != null && string.length() > 0 && this.mAttachments != null && this.mAttachments.getAttachmentCount() > 0) {
            String string2 = "Content-Type: " + string + "\n\n";
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.getCharacterEncoding());
                outputStreamWriter.write(string2, 0, string2.length());
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.Message.writeTo", "572", this);
                log.error(Messages.getMessage("javaIOException00"), iOException);
            }
        }
        this.writeTo(outputStream);
    }

    public String getContentDescription() {
        String[] stringArray = this.headers.getHeader("Content-Description");
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public void setContentDescription(String string) {
        this.headers.setHeader("Content-Description", string);
    }

    public void saveChanges() throws SOAPException {
        if (this.mAttachments != null && 0 < this.mAttachments.getAttachmentCount()) {
            try {
                this.headers.setHeader("Content-Type", this.mAttachments.getContentType());
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.Message.saveChanges", "576", this);
                log.error(Messages.getMessage("exception00"), webServicesFault);
            }
        }
        this.saveRequired = false;
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    public MimeHeaders getMimeHeaders() {
        if (this.mAttachments != null && 0 != this.mAttachments.getAttachmentCount()) {
            try {
                this.headers.setHeader("Content-Type", this.mAttachments.getContentType());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.Message.getMimeHeaders", "608", this);
                log.debug("can not get the content type for the attachment", exception);
            }
        }
        return this.headers;
    }

    public void removeAllAttachments() {
        this.mAttachments.removeAllAttachments();
    }

    public int countAttachments() {
        return this.mAttachments == null ? 0 : this.mAttachments.getAttachmentCount();
    }

    public Iterator getAttachments() {
        try {
            return this.mAttachments.getAttachments().iterator();
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.Message.getAttachments", "601", this);
            log.error(Messages.getMessage("exception00"), webServicesFault);
            return null;
        }
    }

    public Iterator getAttachments(MimeHeaders mimeHeaders) {
        return this.mAttachments.getAttachments(mimeHeaders);
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) {
        try {
            this.mAttachments.addAttachmentPart((Part)attachmentPart);
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.Message.addAttachmentPart", "636", this);
            log.error(Messages.getMessage("exception00"), webServicesFault);
        }
    }

    public AttachmentPart createAttachmentPart() {
        try {
            return (AttachmentPart)this.mAttachments.createAttachmentPart();
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, "com.ibm.ws.webservices.engine.Message.createAttachmentPart", "655", this);
            log.error(Messages.getMessage("exception00"), webServicesFault);
            return null;
        }
    }

    public String getCharacterEncoding() {
        String string;
        if (this.msgContext != null && (string = this.msgContext.getCharacterEncoding()) != null) {
            this.charsetEncoding = string;
        }
        return this.charsetEncoding;
    }

    public void setCharacterEncoding(String string) {
        if (string != null) {
            char c = string.charAt(0);
            if (c == '\'' || c == '\"') {
                if (string.length() > 2) {
                    string = string.substring(1, string.length() - 1);
                } else {
                    throw new IllegalArgumentException(Messages.getMessage("invalidCharacterEncoding"));
                }
            }
            this.charsetEncoding = string;
            if (this.msgContext != null) {
                this.msgContext.setCharacterEncoding(this.charsetEncoding);
            }
        }
    }

    public boolean shouldWriteXMLDecl() {
        return this.writeXmlDeclaration;
    }

    public void setShouldWriteXMLDecl(String string) {
        this.writeXmlDeclaration = Boolean.valueOf(string);
    }

    public Object getProperty(String string) throws SOAPException {
        if (string.equals("javax.xml.soap.character-set-encoding")) {
            return this.getCharacterEncoding();
        }
        if (string.equals("javax.xml.soap.write-xml-declaration")) {
            return this.shouldWriteXMLDecl() ? "true" : "false";
        }
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) throws SOAPException {
        if (string.equals("javax.xml.soap.write-xml-declaration")) {
            if (!object.equals("true") && !object.equals("false")) {
                throw new SOAPException(Messages.getMessage("invalidSOAPMessageProperty01"));
            }
            this.setShouldWriteXMLDecl((String)object);
        } else if (string.equals("javax.xml.soap.character-set-encoding")) {
            this.setCharacterEncoding((String)object);
        } else {
            this.properties.put(string, object);
        }
    }

    public void ifFaultThrowSelf() throws WebServicesFault {
        WebServicesFault webServicesFault = null;
        try {
            webServicesFault = this.getFault();
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.webservices.engine.Message.ifFaultThrowSelf", "722", null);
            throw WebServicesFault.makeFault(sOAPException);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.webservices.engine.Message.ifFaultThrowSelf", "757", null);
            throw WebServicesFault.makeFault(iOException);
        }
        if (webServicesFault != null) {
            throw webServicesFault;
        }
    }

    public WebServicesFault getFault() throws SOAPException, IOException {
        return this.mSOAPPart.getFault();
    }

    static {
        DEFAULT_ATTACHMNET_IMPL = DEFAULT_ATTACHMENT_IMPL = AttachmentsImpl.class.getName();
        mAttachmentsImplClassName = DEFAULT_ATTACHMENT_IMPL;
        attachImpl = null;
        attachImplConstr = null;
        checkForAttchmentSupport = true;
        attachmentSupportEnabled = false;
    }
}

