/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.client.MapModulesToServers;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.WSBindingsFileAccessor;
import com.ibm.ws.webservices.deploy.WSDeploymentDescriptorAccessor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

class MapModulesToServersAccessor {
    private final int URI_COLUMN = 1;
    private final int SERVER_COLUMN = 2;
    private final String[][] taskData;
    private final Map moduleNameToServerNameMap = new HashMap();
    private static TraceComponent tc = Tr.register(MapModulesToServersAccessor.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    MapModulesToServersAccessor(AppDeploymentController appDeploymentController) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Constructor");
        }
        MapModulesToServers mapModulesToServers = (MapModulesToServers)appDeploymentController.getTaskByName("MapModulesToServers", false);
        this.taskData = mapModulesToServers.getTaskData();
        if (tc.isDebugEnabled()) {
            String string = "Constructor: MapModulesToservers' taskData is:\n" + DeployUtils.taskDataToString(this.taskData);
            Tr.debug(tc, string);
        }
        if (this.taskData != null) {
            for (int i = 1; i < this.taskData.length; ++i) {
                String string = this.taskData[i][1];
                String[] stringArray = util.separateUriString(string);
                this.moduleNameToServerNameMap.put(stringArray[0], this.taskData[i][2]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Constructor");
        }
    }

    void verifyThatAnEJBJARAndItsRouterAreInTheSameServer(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        Vector vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyThatAnEJBJARAndItsRouterAreInTheSameServer");
        }
        if ((vector = appDeploymentInfo.getModuleConfig("JAR_DD")) != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                String string = util.formUriString(appDeploymentInfo, eObject);
                WSDeploymentDescriptorAccessor wSDeploymentDescriptorAccessor = new WSDeploymentDescriptorAccessor(eObject, appDeploymentInfo, appDeploymentTask);
                if (!wSDeploymentDescriptorAccessor.isModuleWebServiceEnabled(appDeploymentTask)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "verifyThatAnEJBJARAndItsRouterAreInTheSameServer: the module " + string + " is not Web Services enabled");
                    continue;
                }
                String[] stringArray = util.separateUriString(string);
                String string2 = stringArray[0];
                String string3 = (String)this.moduleNameToServerNameMap.get(string2);
                ModuleFile moduleFile = appDeploymentInfo.getModuleFileForDD(eObject);
                WSBindingsFileAccessor wSBindingsFileAccessor = new WSBindingsFileAccessor(moduleFile, appDeploymentTask);
                String[] stringArray2 = wSBindingsFileAccessor.getRouterModuleNames();
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i] == null) continue;
                    String string4 = (String)this.moduleNameToServerNameMap.get(stringArray2[i]);
                    if (string4 == null) {
                        Object[] objectArray = new Object[]{stringArray2[i]};
                        String string5 = MessageFormat.format(util.getMessage(appDeploymentTask, "WSWS0012E"), objectArray);
                        Tr.error(tc, "WSWS0012E", objectArray);
                        throw new AppDeploymentException(string5, null);
                    }
                    if (string3.trim().equals(string4.trim())) continue;
                    Object[] objectArray = new Object[]{string, string3, stringArray2[i], string4};
                    String string6 = MessageFormat.format(util.getMessage(appDeploymentTask, "WSWS0024E"), objectArray);
                    Tr.error(tc, "WSWS0024E", objectArray);
                    throw new AppDeploymentException(string6, null);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyThatAnEJBJARAndItsRouterAreInTheSameServer");
        }
    }
}

