/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.util.ArrayList;

public class ListKeyStoreTypes
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListKeyStoreTypes.class, "SSL", "com.ibm.ws.ssl.commands");

    public ListKeyStoreTypes(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ListKeyStoreTypes(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ArrayList arrayList = WSKeyStore.getKeyStoreTypes();
            int n = arrayList.indexOf("PKCS11");
            String string = TraceNLSHelper.getInstance().getString("pkcs11type", "Cryptographic Token Device (PKCS11)");
            if (n != -1) {
                arrayList.set(n, string);
            } else {
                arrayList.add(string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreTypes: " + arrayList.toString());
            }
            taskCommandResultImpl.setResult(arrayList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

