/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.certificateRequests;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListCertificateRequests
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListCertificateRequests.class, "SSL", "com.ibm.ws.ssl.commands.certificateRequests");
    private String keyStoreName = null;
    private String scopeName = null;

    public ListCertificateRequests(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ListCertificateRequests(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            taskCommandResultImpl.setResult(this.certificateRequestList(session, configService, this.keyStoreName, this.scopeName));
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public List certificateRequestList(Session session, ConfigService configService, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "certificateRequestList");
        }
        KeyStoreInfo keyStoreInfo = null;
        List list = null;
        try {
            keyStoreInfo = PersonalCertificateHelper.getKsInfo(session, configService, string, string2);
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        try {
            list = this.getCertificateRequests(keyStoreInfo);
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "certificateRequestList");
        }
        return list;
    }

    public List getCertificateRequests(KeyStoreInfo keyStoreInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificateRequests");
        }
        ArrayList<AttributeList> arrayList = new ArrayList<AttributeList>();
        AttributeList attributeList = null;
        String string = null;
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        try {
            String string2 = "aliases";
            Object[] objectArray = null;
            Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
            if (objectArray2 != null) {
                for (int i = 0; i < objectArray2.length; ++i) {
                    String string3 = (String)objectArray2[i];
                    string2 = "isKeyEntry";
                    objectArray = new Object[]{string3};
                    Object[] objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
                    if (!((Boolean)objectArray3[0]).booleanValue()) continue;
                    string2 = "getCertificate";
                    objectArray = new Object[]{string3};
                    Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand(string2, objectArray);
                    X509Certificate x509Certificate = (X509Certificate)objectArray4[0];
                    string = CertificateRequestHelper.isKeyCertReq(x509Certificate, string3);
                    if (string == null) continue;
                    attributeList = CertificateRequestHelper.certReqAttrlist(string3, x509Certificate, string);
                    arrayList.add(attributeList);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Alias list from keystore is null.  The server mbean may not be availible.");
            }
        }
        catch (Exception exception) {
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "certificateRequestList");
        }
        return arrayList;
    }
}

