/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.certificateRequests;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.PkEeCertReqFactory;
import com.ibm.security.certclient.PkEeCertReqTransaction;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import javax.management.ObjectName;

public class CreateCertificateRequest
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateCertificateRequest.class, "SSL", "com.ibm.ws.ssl.commands.certificateRequests");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certLabel = null;
    private String certCommonName = null;
    private String certOrganization = null;
    private String certOrganizationalUnit = null;
    private int certSize = 0;
    private String certZip = null;
    private String certCountry = null;
    private String certLocality = null;
    private String certState = null;
    private String certReqFilePath = null;
    private String certReqFilePathExpanded = null;
    private KeyStoreInfo ksInfo = null;
    private CertReqInfo certInfo = null;
    private ObjectName keyStoreObjName = null;
    private KeyStore keyStore = null;
    private WSKeyStore wsKeyStore = null;
    private String subjectDN = null;

    public CreateCertificateRequest(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateCertificateRequest(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        Object var3_3 = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            objectName = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName2 = configService.queryConfigObjects(session, objectName3, objectName, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certLabel = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.certCommonName = (String)this.getParameter(CommandConstants.CERT_COMMON_NAME);
            this.certSize = (Integer)this.getParameter(CommandConstants.CERT_SIZE);
            this.certOrganization = (String)this.getParameter(CommandConstants.CERT_ORGANIZATION);
            this.certOrganizationalUnit = (String)this.getParameter(CommandConstants.CERT_ORGANIZATIONAL_UNIT);
            this.certLocality = (String)this.getParameter(CommandConstants.CERT_LOCALITY);
            this.certState = (String)this.getParameter(CommandConstants.CERT_STATE);
            this.certZip = (String)this.getParameter(CommandConstants.CERT_ZIP);
            this.certCountry = (String)this.getParameter(CommandConstants.CERT_COUNTRY);
            this.certReqFilePath = (String)this.getParameter(CommandConstants.CERT_REQ_FILE_PATH);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " certlabel=" + this.certLabel + " certCommonName=" + this.certCommonName + " certSize=" + this.certSize + " certOrganization=" + this.certOrganization + " certOrganizationalUnit=" + this.certOrganizationalUnit + " certLocality=" + this.certLocality + " certState=" + this.certState + " certZip=" + this.certZip + " certCountry=" + this.certCountry + " certReqFilePath=" + this.certReqFilePath);
            }
            this.subjectDN = this.makeSubjectDN(this.certCommonName, this.certOrganization, this.certOrganizationalUnit, this.certLocality, this.certState, this.certZip, this.certCountry);
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(objectName3);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, configService, this.keyStoreName, this.keyStoreScope);
            this.certReqFilePathExpanded = KeyStoreManager.getInstance().expand(this.certReqFilePath);
            File file = new File(this.certReqFilePathExpanded);
            if (!file.isAbsolute()) {
                this.certReqFilePathExpanded = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + this.certReqFilePath);
                file = new File(this.certReqFilePathExpanded);
            }
            if (!file.exists() && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            this.certInfo = new CertReqInfo(this.certLabel, this.certSize, this.subjectDN, 365, this.ksInfo, this.certReqFilePathExpanded);
        }
        catch (ConfigServiceException configServiceException) {
            String string = configServiceException.getMessage();
            throw new CommandValidationException(string);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        String string = "RSA";
        String string2 = "IBMJCE";
        String string3 = "IBMSecureRandom";
        Object var6_5 = null;
        Object var7_6 = null;
        try {
            boolean bl = this.personalCertificateCreate(this.certInfo);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public String makeSubjectDN(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws CommandValidationException {
        String string8 = null;
        if (string == null || string.length() == 0) {
            String string9 = "CommonName is missing, unable to create the Certificate.";
            throw new CommandValidationException(string9);
        }
        string8 = "CN=" + string;
        if (string3 != null && string3.length() != 0) {
            string8 = string8 + ", OU=" + string3;
        }
        if (string2 == null || string2.length() == 0) {
            String string10 = "Organization is missing, unable to create the Certificate.";
            throw new CommandValidationException(string10);
        }
        string8 = string8 + ", O=" + string2;
        if (string4 != null && string4.length() != 0) {
            string8 = string8 + ", L=" + string4;
        }
        if (string5 != null && string5.length() != 0) {
            string8 = string8 + ", ST=" + string5;
        }
        if (string6 != null && string6.length() != 0) {
            string8 = string8 + ", POSTALCODE=" + string6;
        }
        if (string7 == null || string7.length() == 0) {
            String string11 = "Country is missing, unable to create the Certificate.";
            throw new CommandValidationException(string11);
        }
        string8 = string8 + ", C=" + string7;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "DN is " + string8);
        }
        return string8;
    }

    public boolean personalCertificateCreate(CertReqInfo certReqInfo) throws Exception {
        boolean bl = false;
        String string = null;
        String string2 = null;
        int n = 0;
        boolean bl2 = false;
        KeyStoreInfo keyStoreInfo = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        string2 = certReqInfo.getSubjectDN();
        string = certReqInfo.getLabel();
        n = certReqInfo.getSize();
        string6 = certReqInfo.getFilename();
        string5 = "file://" + string6;
        keyStoreInfo = certReqInfo.getKsInfo();
        string3 = keyStoreInfo.getProvider();
        string4 = keyStoreInfo.getPassword();
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        PkSsCertificate pkSsCertificate = null;
        X509Certificate x509Certificate = null;
        PrivateKey privateKey = null;
        String string7 = string + "_certreq";
        String string8 = "RSA";
        String string9 = "IBMJCE";
        String string10 = "IBMSecureRandom";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("certreq@us.ibm.com");
        arrayList.add("CERTREQUEST");
        arrayList.add(string5);
        String string11 = string2.substring(0, string2.indexOf(","));
        String string12 = string2.substring(string2.indexOf(",") + 1);
        try {
            String string13 = "containsAlias";
            Object[] objectArray = new Object[]{string};
            Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string13, objectArray);
            if (((Boolean)objectArray2[0]).booleanValue()) {
                String string14 = string + " already exists.";
                throw new CommandValidationException(string14);
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string8, string9);
            SecureRandom secureRandom = SecureRandom.getInstance(string10, string9);
            keyPairGenerator.initialize(n, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PkEeCertReqTransaction pkEeCertReqTransaction = PkEeCertReqFactory.newCertRequest((int)n, (String)string11, (int)365, (boolean)true, (boolean)false, null, null, null, null, null, (String)string12, (KeyPair)keyPair);
            if (pkEeCertReqTransaction != null) {
                Object object;
                Date date = new Date();
                date.setTime(date.getTime() - 86400000L);
                pkSsCertificate = PkSsCertFactory.newSsCert((int)n, (String)string2, (int)365, (Date)date, (boolean)true, (boolean)true, arrayList, null, null, (String)"IBMJCE", (KeyPair)keyPair);
                if (pkSsCertificate != null) {
                    x509Certificate = pkSsCertificate.getCertificate();
                    privateKey = pkSsCertificate.getKey();
                    string13 = "setKeyEntry";
                    objectArray = new Object[]{string, privateKey, string4.toCharArray(), new X509Certificate[]{x509Certificate}};
                    wSKeyStoreRemotable.invokeKeyStoreCommand(string13, objectArray);
                    bl = true;
                    object = pkEeCertReqTransaction.getPKCS10CertReq();
                    CertificationRequest certificationRequest = new CertificationRequest(object);
                    certificationRequest.writeBASE64(string6);
                    try {
                        Tr.audit(tc, "Self Signed Certificate: notBefore time: " + x509Certificate.getNotBefore().toString() + " notAfter time: " + x509Certificate.getNotAfter().toString());
                    }
                    catch (Throwable throwable) {}
                } else {
                    String string15 = "SelfSigned create failed.";
                    throw new Exception(string15);
                }
                if (bl) {
                    object = this.getConfigSession();
                    PersonalCertificateHelper.setWorkspaceUpdated((Session)object, certReqInfo.getKsInfo().getLocation());
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            String string16 = "Failed to create certificate";
            throw new Exception(throwable.getMessage());
        }
        return bl;
    }
}

