/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSSchedule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.crypto.config.WSScheduler;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.util.Date;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateWSSchedule
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateWSSchedule.class, "SSL", "com.ibm.ws.ssl.commands");
    private String wsScheduleName = null;
    private Integer frequency = null;
    private Integer hour = null;
    private Integer minute = null;
    private Integer dayOfWeek = null;
    private Long nextStartDate = null;

    public CreateWSSchedule(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateWSSchedule(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean bl = false;
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            Cloneable cloneable;
            Object object;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.wsScheduleName = (String)this.getParameter(CommandConstants.NAME);
            this.frequency = (Integer)this.getParameter(CommandConstants.FREQUENCY);
            this.dayOfWeek = (Integer)this.getParameter(CommandConstants.DAY_OF_WEEK);
            this.hour = (Integer)this.getParameter(CommandConstants.HOUR);
            this.minute = (Integer)this.getParameter(CommandConstants.MINUTE);
            this.nextStartDate = (Long)this.getParameter(CommandConstants.NEXT_START_DATE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wsScheduleName: " + this.wsScheduleName);
            }
            if (this.frequency < 0) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.scheduler.frequency.range.CWPKI0622E", "Schedule frequency is not a positive integer.");
                throw new CommandValidationException(string);
            }
            if (this.dayOfWeek != null && (this.dayOfWeek < 1 || this.dayOfWeek > 7)) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.scheduler.dayOfWeek.range.CWPKI0624E", "Day of the week value is out of range.  It should be between 1 and 7.");
                throw new CommandValidationException(string);
            }
            if (this.minute < 0 || this.minute > 59) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.scheduler.minute.range.CWPKI0623E", "Minute value is out of range.  It should be between 0 and 60.");
                throw new CommandValidationException(string);
            }
            if (this.hour < 0 || this.hour > 23) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.scheduler.hour.range.CWPKI0625E", "Hour value is out of range.  It should be between 0 and 24.");
                throw new CommandValidationException(string);
            }
            int n = this.dayOfWeek != null ? this.dayOfWeek : 0;
            if (this.nextStartDate == null) {
                object = new WSScheduler(this.frequency, n, this.hour, this.minute);
                cloneable = ((WSScheduler)object).getNextEventDateFromNow();
                this.nextStartDate = new Long(((Date)cloneable).getTime());
            } else if (this.nextStartDate >= 0L) {
                object = new WSScheduler(this.frequency, n, this.hour, this.minute);
                cloneable = null;
                long l = System.currentTimeMillis();
                if (this.nextStartDate < l) {
                    cloneable = ((WSScheduler)object).getNextEventDateFromNow();
                } else {
                    Date date = new Date(this.nextStartDate);
                    cloneable = ((WSScheduler)object).getNextEventDateFromDate(date);
                }
                this.nextStartDate = new Long(((Date)cloneable).getTime());
            } else if (this.nextStartDate < 0L) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.schedule.nextstartdate.CWPKI0660E", "The next start date must be a positive number.");
                throw new CommandValidationException(string);
            }
            object = new CommandHelper();
            cloneable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)cloneable, CommandConstants.NAME, this.wsScheduleName);
            bl = ((CommandHelper)object).exists(configService, session, objectName, CommandConstants.WS_SCHEDULES, (AttributeList)cloneable, null);
            if (bl) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.exists.CWPKI0621E=CWPKI0621E", new Object[]{this.wsScheduleName}, this.wsScheduleName + " already exists.");
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.createWSSchedule.validate", "159", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.wsScheduleName);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.FREQUENCY, this.frequency);
            if (this.dayOfWeek != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.DAY_OF_WEEK, this.dayOfWeek);
            }
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.HOUR, this.hour);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MINUTE, this.minute);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NEXT_START_DATE, this.nextStartDate);
            ObjectName objectName4 = configService.createConfigData(session, objectName, CommandConstants.WS_SCHEDULES, null, attributeList);
            if (objectName4 != null) {
                taskCommandResultImpl.setResult(objectName4);
            }
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

