/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSCertExpMonitor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.ipc.ssl.WSCertificateExpirationMonitor;
import com.ibm.ws.crypto.config.WSNotifier;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.Serializable;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.x500.X500Principal;

public class StartCertificateExpMonitor
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(StartCertificateExpMonitor.class, "SSL", "com.ibm.ws.ssl.commands.certificateRequests");
    List expiredCerts = new ArrayList();
    List personalCerts = new ArrayList();
    List signerCerts = new ArrayList();
    StringBuffer notificationCerts = new StringBuffer();
    StringBuffer notificationSignerCerts = new StringBuffer();
    StringBuffer replaceCerts = new StringBuffer();
    StringBuffer expInfoBuffer = new StringBuffer();
    private Boolean saveConfig = Boolean.FALSE;
    WSCertificateExpirationMonitor monitor = null;
    String report = null;
    String preNotificationMsgTitle = "**** Subject:  Expiration Monitor ****";
    String preNotificationMsg1 = "The expiration monitor has recently run and discovered that the certificates listed below will be replaced within the next ";
    String preNotificationMsg2 = " days based upon the configured policy to automatically replace expiring self-signed certificates ";
    String preNotificationMsg3 = " days prior to expiration.  This notification is warning you that problems may arise when this automatic replace occurs.";
    String preNotificationWarning = "In some cases, automatic updates to the self-signed certificates can cause outages for WebServer plug-ins operating on unmanaged nodes.  In such a situation, the plugin will be unable to contact the application servers over HTTPS because it will be using signers for certificates that have been replaced by the automatic replacement process.";
    String preNotificationWarning2 = "To prevent what may be and serious outage you should act before the scheduled replacement date and replace the expiring certificates and update the plugin kdb to use the new signers.";
    String notifyNotice1 = "*** CERTIFICATES WITHIN THE ";
    String notifyNotice2 = " DAY PRE-NOTIFICATION THRESHOLD (MAY BE REPLACED WITHIN ";
    String notifyNotice3 = " DAYS)  ***";
    String replaceNotice = "*** CERTIFICATES THAT ARE BEYOND THE EXPIRATION THRESHOLD AND HAVE BEEN REPLACED ***";
    String thresholdNotice = "*** CERTIFICATES THAT ARE BEYOND THE EXPIRATION THRESHOLD ***";
    String preNotificationMsg = null;
    String notifyNotice = null;
    long notificationDays = 0L;

    public StartCertificateExpMonitor(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public StartCertificateExpMonitor(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.saveConfig = (Boolean)this.getParameter("ExpMonitorSaveConfig");
            String string = this.startExpMonitor();
            taskCommandResultImpl.setResult(string);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        this.setCommandResult(taskCommandResultImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public String startExpMonitor() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startExpMonitor");
        }
        Boolean bl = null;
        Boolean bl2 = null;
        Integer n = null;
        KeyStoreInfo keyStoreInfo = null;
        String string = System.getProperty("line.separator");
        try {
            String string2;
            Object object;
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName2 = configService.resolve(session, "Cell=:Security=")[0];
            AttributeList attributeList = (AttributeList)configService.getAttribute(session, objectName2, CommandConstants.WS_CERT_EXP_MONITOR);
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(attributeList);
            if (attributeList != null) {
                bl = (Boolean)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.DELETE_OLD);
                n = (Integer)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.DAYS_BEFORE_NOTIFICATION);
                bl2 = (Boolean)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.AUTO_REPLACE);
                this.notificationDays = this.getNotifyProperty(configService, session, objectName2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleteOld=" + bl + " daysBeforeNotify=" + n + " autoReplace=" + bl2);
                }
            } else {
                throw new Exception("certifcate expiration monitor object does not exist.");
            }
            this.preNotificationMsg = this.preNotificationMsg1 + this.notificationDays + this.preNotificationMsg2 + n + this.preNotificationMsg3;
            this.notifyNotice = this.notifyNotice1 + this.notificationDays + this.notifyNotice2 + this.notificationDays + this.notifyNotice3;
            String string3 = TraceNLSHelper.getInstance().getString("scanExpiration", "Checking for expired certificate and certificates about to expire");
            this.expInfoBuffer.append(string);
            this.expInfoBuffer.append(string3);
            this.expInfoBuffer.append(string);
            List list = (List)configService.getAttribute(session, objectName2, CommandConstants.KEY_STORES);
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                ObjectName objectName4;
                String string4;
                object = (AttributeList)object2.next();
                string2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object, "name");
                keyStoreInfo = PersonalCertificateHelper.getKsInfo(session, configService, string2, string4 = (String)configService.getAttribute(session, objectName4 = (ObjectName)ConfigServiceHelper.getAttributeValue((AttributeList)object, "managementScope"), CommandConstants.SCOPE_NAME));
                String string5 = this.checkCertsInKeyStore(keyStoreInfo, n);
                if (string5 == null) continue;
                this.expInfoBuffer.append(string5);
            }
            if (bl2.booleanValue() && this.personalCerts.size() > 0 || this.expiredCerts.size() > 0) {
                int n2;
                for (n2 = 0; n2 < this.expiredCerts.size(); ++n2) {
                    object = (CertReqInfo)this.expiredCerts.get(n2);
                    string2 = this.genNewCertsAndReplace((CertReqInfo)object, bl);
                }
                for (n2 = 0; n2 < this.personalCerts.size(); ++n2) {
                    object = (CertReqInfo)this.personalCerts.get(n2);
                    string2 = this.genNewCertsAndReplace((CertReqInfo)object, bl);
                }
            }
            this.report = this.createCertExpMonitorReport();
            if (this.saveConfig != null && this.saveConfig.booleanValue()) {
                configService.save(session, true);
            }
            this.monitor = (WSCertificateExpirationMonitor)MOFUtil.convertToEObject((Session)session, (ObjectName)objectName3);
            object2 = new WSNotifier(this.monitor.getWsNotification());
            ((WSNotifier)object2).notify(this.report);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startExpMonitor");
        }
        return this.report;
    }

    private String checkCertsInKeyStore(KeyStoreInfo keyStoreInfo, int n) throws Exception {
        StringBuffer stringBuffer;
        block28: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkCertsInKeyStore");
            }
            WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
            String string = keyStoreInfo.getName();
            Boolean bl = keyStoreInfo.getReadOnly();
            Boolean bl2 = keyStoreInfo.getFileBased();
            long l = 86400000L;
            long l2 = System.currentTimeMillis();
            long l3 = l * (long)n;
            long l4 = l * this.notificationDays;
            stringBuffer = new StringBuffer();
            CertReqInfo certReqInfo = null;
            String string2 = System.getProperty("line.separator");
            String string3 = null;
            Locale locale = this.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "locale is null, use system locale:" + locale);
                }
            }
            try {
                String string4 = "aliases";
                Object[] objectArray = null;
                Object[] objectArray2 = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray);
                if (objectArray2 != null) {
                    for (int i = 0; i < objectArray2.length; ++i) {
                        Object[] objectArray3;
                        string4 = "getCertificate";
                        String string5 = (String)objectArray2[i];
                        objectArray = new Object[]{string5};
                        Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray);
                        X509Certificate x509Certificate = (X509Certificate)objectArray4[0];
                        if (x509Certificate == null) continue;
                        boolean bl3 = this.isCertSelfSigned(x509Certificate);
                        Date date = x509Certificate.getNotAfter();
                        Date date2 = x509Certificate.getNotBefore();
                        long l5 = date.getTime();
                        long l6 = l5 - l3;
                        long l7 = l6 - l4;
                        Date date3 = new Date(l6);
                        String string6 = DateFormat.getDateInstance(1, locale).format(date3);
                        date3 = new Date(l7);
                        String string7 = DateFormat.getDateInstance(1, locale).format(date3);
                        String string8 = DateFormat.getDateInstance(1, locale).format(date);
                        try {
                            x509Certificate.checkValidity();
                        }
                        catch (CertificateExpiredException certificateExpiredException) {
                            string4 = "isKeyEntry";
                            objectArray = new Object[]{string5};
                            objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray);
                            if (((Boolean)objectArray3[0]).booleanValue()) {
                                if (bl3 && !bl.booleanValue() && bl2.booleanValue()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Alias " + string5 + " in key store " + string + " was added to the expired certs list.");
                                    }
                                    certReqInfo = this.createCertInfo(string5, x509Certificate, keyStoreInfo);
                                    this.expiredCerts.add(certReqInfo);
                                }
                                string3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.personal.expired.CWPKI0680I", new Object[]{string5, string, string8}, "Personal certificate alias \"" + string5 + "\" in KeyStore \"" + string + "\" expired on " + string8, locale);
                                stringBuffer.append(string2);
                                stringBuffer.append(string3);
                                continue;
                            }
                            if (!bl.booleanValue() && bl2.booleanValue()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Alias " + string5 + " in key store " + string + " was added to the signer certs list.");
                                }
                                certReqInfo = this.createCertInfo(string5, x509Certificate, keyStoreInfo);
                                this.signerCerts.add(certReqInfo);
                            }
                            string3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.signer.expired.CWPKI0679I", new Object[]{string5, string, string8}, "Signer certificate alias \"" + string5 + "\" in KeyStore \"" + string + "\" expired on " + string8, locale);
                            stringBuffer.append(string2);
                            stringBuffer.append(string3);
                            continue;
                        }
                        catch (CertificateNotYetValidException certificateNotYetValidException) {
                            // empty catch block
                        }
                        l2 = System.currentTimeMillis();
                        String string9 = DateFormat.getDateInstance(1, locale).format(date);
                        if (l5 - l2 <= l3) {
                            string4 = "isKeyEntry";
                            objectArray = new Object[]{string5};
                            objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray);
                            if (((Boolean)objectArray3[0]).booleanValue()) {
                                if (bl3 && !bl.booleanValue() && bl2.booleanValue()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Alias " + string5 + " in key store " + string + " was added to the personel certs list.");
                                    }
                                    certReqInfo = this.createCertInfo(string5, x509Certificate, keyStoreInfo);
                                    this.personalCerts.add(certReqInfo);
                                }
                                string3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.personal.expires.CWPKI0643I", new Object[]{string5, string, string9}, "Personal certificate alias \"" + string5 + "\" in KeyStore \"" + string + "\" expires on " + string9, locale);
                                stringBuffer.append(string2);
                                stringBuffer.append(string3);
                                continue;
                            }
                            if (!bl.booleanValue() && bl2.booleanValue()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Alias " + string5 + " in key store " + string + " was added to the signerCerts list.");
                                }
                                certReqInfo = this.createCertInfo(string5, x509Certificate, keyStoreInfo);
                                this.signerCerts.add(certReqInfo);
                            }
                            string3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.signer.expires.CWPKI0642I", new Object[]{string5, string, string9}, "Signer certificate alias \"" + string5 + "\" in KeyStore \"" + string + "\" expires on " + string9, locale);
                            stringBuffer.append(string2);
                            stringBuffer.append(string3);
                            continue;
                        }
                        if (l7 > l2 || l2 >= l6) continue;
                        string4 = "isKeyEntry";
                        objectArray = new Object[]{string5};
                        objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string4, objectArray);
                        if (((Boolean)objectArray3[0]).booleanValue()) {
                            if (bl.booleanValue() || !bl2.booleanValue()) continue;
                            if (bl3) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Alias " + string5 + " in key store " + string + " was added to the notification list.");
                                }
                                string3 = "Self-signed personal certificate \"" + string5 + "\" in the \"" + string + "\" key store is due to be replaced on " + string6 + ".";
                                this.notificationCerts.append(string3);
                                this.notificationCerts.append(string2);
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Alias " + string5 + " in key store " + string + " was added to the notification list.");
                            }
                            string3 = "Personal certificate \"" + string5 + "\" in the \"" + string + "\" key store is due to expire on " + string8 + ".";
                            this.notificationCerts.append(string3);
                            this.notificationCerts.append(string2);
                            continue;
                        }
                        if (bl.booleanValue() || !bl2.booleanValue()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Alias " + string5 + " in key store " + string + " was added to the notificationSignerCerts list.");
                        }
                        string3 = "Signer certificate \"" + string5 + "\" in the \"" + keyStoreInfo.getName() + "\" key store is due to expire on " + string8 + ".";
                        this.notificationCerts.append(string3);
                        this.notificationCerts.append(string2);
                    }
                    break block28;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Alias list is null for key store " + keyStoreInfo.getName() + " could be that the mbean is not active.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Exception(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCertsInKeyStore");
        }
        return stringBuffer.toString();
    }

    private boolean isCertSelfSigned(X509Certificate x509Certificate) {
        X500Principal x500Principal;
        boolean bl = false;
        X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
        if (x500Principal2.equals(x500Principal = x509Certificate.getIssuerX500Principal())) {
            bl = true;
        }
        return bl;
    }

    private CertReqInfo createCertInfo(String string, X509Certificate x509Certificate, KeyStoreInfo keyStoreInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCertInfo");
        }
        CertReqInfo certReqInfo = new CertReqInfo(string, 0, x509Certificate.getSubjectX500Principal().toString(), 365, keyStoreInfo, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCertInfo");
        }
        return certReqInfo;
    }

    private String genNewCertsAndReplace(CertReqInfo certReqInfo, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "genNewCertsAndReplace");
        }
        String string = certReqInfo.getSubjectDN();
        String string2 = certReqInfo.getLabel();
        int n = certReqInfo.getSize();
        int n2 = certReqInfo.getValidDays();
        KeyStoreInfo keyStoreInfo = certReqInfo.getKsInfo();
        String string3 = keyStoreInfo.getPassword();
        String string4 = keyStoreInfo.getProvider();
        String string5 = keyStoreInfo.getName();
        String string6 = keyStoreInfo.getType();
        WSKeyStoreRemotable wSKeyStoreRemotable = new WSKeyStoreRemotable(keyStoreInfo);
        Session session = this.getConfigSession();
        PkSsCertificate pkSsCertificate = null;
        X509Certificate x509Certificate = null;
        X509Certificate x509Certificate2 = null;
        String string7 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        String string8 = null;
        PrivateKey privateKey = null;
        String string9 = null;
        Key key = null;
        Certificate[] certificateArray = null;
        Locale locale = this.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "locale is null, use system locale:" + locale);
            }
        }
        if (string6 != null && (string6.equals("CMSKS") || string6.equals("IBMi5OSKeyStore"))) {
            string4 = "IBMJCE";
        }
        try {
            Object[] objectArray;
            String string10 = "getCertificate";
            Object[] objectArray2 = new Object[]{string2};
            Object[] objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray2);
            x509Certificate = (X509Certificate)objectArray3[0];
            Date date = new Date();
            date.setTime(date.getTime() - 86400000L);
            pkSsCertificate = PkSsCertFactory.newSsCert((int)n, (String)string, (int)n2, (Date)date, (boolean)true, (boolean)true, (String)string4);
            if (pkSsCertificate != null) {
                if (bl) {
                    string10 = "deleteEntry";
                    objectArray2 = new Object[]{string2};
                    wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray2);
                }
                objectArray = pkSsCertificate.getCertificate();
                privateKey = pkSsCertificate.getKey();
                string10 = "setKeyEntry";
                objectArray2 = new Object[]{string2, privateKey, string3.toCharArray(), new X509Certificate[]{objectArray}};
                wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray2);
                try {
                    Tr.audit(tc, "Self Signed Certificate: notBefore time: " + objectArray.getNotBefore().toString() + " notAfter time: " + objectArray.getNotAfter().toString());
                }
                catch (Throwable throwable) {}
            } else {
                string8 = "Unable to create the new self-signed certificate for " + string2 + ".";
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "genNewCertsAndReplace");
                }
                return string8;
            }
            string10 = "getCertificate";
            objectArray2 = new Object[]{string2};
            objectArray3 = wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray2);
            x509Certificate2 = (X509Certificate)objectArray3[0];
            string10 = "getCertificateChain";
            objectArray2 = new Object[]{string2};
            objectArray = wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray2);
            certificateArray = (Certificate[])objectArray[0];
            string10 = "getKey";
            objectArray2 = new Object[]{string2, string3.toCharArray()};
            Object[] objectArray4 = wSKeyStoreRemotable.invokeKeyStoreCommand(string10, objectArray2);
            key = (Key)objectArray4[0];
            string8 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.monitor.personal.replace.CWPKI0645I", new Object[]{string2, string5}, "Personal certificate alias \"" + string2 + "\" in KeyStore \"" + string5 + "\" was REPLACED", locale);
            this.replaceCerts.append(string7);
            this.replaceCerts.append(string8);
            string9 = PersonalCertificateHelper.replaceCerts(session, keyStoreInfo, string2, x509Certificate, null, x509Certificate2, certificateArray, key, bl, locale);
            if (string9 != null) {
                this.replaceCerts.append(string9);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "genNewCertsAndReplace");
        }
        return this.replaceCerts.toString();
    }

    private String createCertExpMonitorReport() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCertExpMonitorReport");
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        if (this.notificationCerts.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append(this.preNotificationMsgTitle);
            stringBuffer.append(string);
            stringBuffer.append(string);
            stringBuffer.append(this.notifyNotice);
            stringBuffer.append(string);
            stringBuffer.append(this.preNotificationMsg);
            stringBuffer.append(string);
            stringBuffer.append(string);
            stringBuffer.append(this.preNotificationWarning);
            stringBuffer.append(string);
            stringBuffer.append(this.preNotificationWarning2);
            stringBuffer.append(string);
            stringBuffer.append(string);
            stringBuffer.append(this.notificationCerts);
            stringBuffer.append(string);
        }
        if (this.notificationCerts.length() > 0 && this.notificationSignerCerts.length() > 0) {
            stringBuffer.append(this.notificationSignerCerts);
            stringBuffer.append(string);
        }
        if (this.expInfoBuffer.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append(this.thresholdNotice);
            stringBuffer.append(string);
            stringBuffer.append(this.expInfoBuffer);
            stringBuffer.append(string);
        }
        if (this.replaceCerts.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append(this.replaceNotice);
            stringBuffer.append(string);
            stringBuffer.append(this.replaceCerts);
            stringBuffer.append(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCertExpMonitorReport");
        }
        return stringBuffer.toString();
    }

    private long getNotifyProperty(ConfigService configService, Session session, ObjectName objectName) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNotifyProperty");
        }
        try {
            serializable = configService.getAttributes(session, objectName, new String[]{"properties"}, false);
            List list = (List)((Attribute)((ArrayList)serializable).get(0)).getValue();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator.next();
                String string = (String)configService.getAttribute(session, objectName2, "name");
                if (!string.equals("com.ibm.ws.security.expirationMonitorNotificationPeriod")) continue;
                String string2 = (String)configService.getAttribute(session, objectName2, "value");
                Long l = new Long(string2);
                return l;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNotifyProperty");
        }
        serializable = new Long("90");
        return (Long)serializable;
    }
}

