/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.WSCertExpMonitor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListWSCertExpMonitor
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListWSCertExpMonitor.class, "SSL", "com.ibm.ws.ssl.commands");
    private Boolean displayObjectName = null;

    public ListWSCertExpMonitor(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ListWSCertExpMonitor(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        this.displayObjectName = (Boolean)this.getParameter(CommandConstants.DISPLAY_OBJECT_NAME);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "displayObjectName: " + this.displayObjectName);
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        ArrayList<Comparable<ObjectName>> arrayList = new ArrayList<Comparable<ObjectName>>();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName[] objectNameArray;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            String[] stringArray = new String[]{CommandConstants.NAME};
            AttributeList attributeList = (AttributeList)configService.getAttribute(session, objectName, CommandConstants.WS_CERT_EXP_MONITOR);
            if (attributeList != null && (objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList), null)).length == 1) {
                if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                    arrayList.add(objectNameArray[0]);
                } else {
                    arrayList.add(commandHelper.getDisplayAttrs(configService, session, objectNameArray, attributeList, stringArray));
                }
            }
            taskCommandResultImpl.setResult(arrayList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        this.setCommandResult(taskCommandResultImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

