/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfigGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListSSLConfigGroups
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListSSLConfigGroups.class, "SSL", "com.ibm.ws.ssl.commands");
    private String scopeName = null;
    private String direction = null;
    private Boolean displayObjectName = null;

    public ListSSLConfigGroups(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ListSSLConfigGroups(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
        this.direction = (String)this.getParameter(CommandConstants.DIRECTION);
        this.displayObjectName = (Boolean)this.getParameter(CommandConstants.DISPLAY_OBJECT_NAME);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeName: " + this.scopeName);
            Tr.debug(tc, "direction: " + this.direction);
            Tr.debug(tc, "displayObjectName: " + this.displayObjectName);
        }
        try {
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName2 = configService.resolve(session, "Cell=")[0];
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName2);
            } else if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(string);
            }
            if (this.direction != null && !this.direction.equalsIgnoreCase("inbound") && !this.direction.equalsIgnoreCase("outbound")) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.direction.CWPKI0614E", "Direction is not valid.  Should be inbound or outbound.");
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        ArrayList<Comparable<ObjectName>> arrayList = new ArrayList<Comparable<ObjectName>>();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
            }
            String[] stringArray = new String[]{CommandConstants.NAME, CommandConstants.DIRECTION, CommandConstants.MANAGEMENT_SCOPE};
            List list = (List)configService.getAttribute(session, objectName, CommandConstants.SSL_CONFIG_GROUPS);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList = (AttributeList)iterator.next();
                String string = (String)ConfigServiceHelper.getAttributeValue(attributeList, CommandConstants.DIRECTION);
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList), null);
                if (objectNameArray.length == 1) {
                    if (this.scopeName != null) {
                        boolean bl = commandHelper.withInScope(configService, session, attributeList, this.scopeName);
                        if (!bl) continue;
                        if (this.direction != null) {
                            if (!this.direction.equalsIgnoreCase(string)) continue;
                            if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                                arrayList.add(objectNameArray[0]);
                                continue;
                            }
                            arrayList.add(commandHelper.getDisplayAttrs(configService, session, objectNameArray, attributeList, stringArray));
                            continue;
                        }
                        if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                            arrayList.add(objectNameArray[0]);
                            continue;
                        }
                        arrayList.add(commandHelper.getDisplayAttrs(configService, session, objectNameArray, attributeList, stringArray));
                        continue;
                    }
                    if (this.direction != null) {
                        if (!this.direction.equalsIgnoreCase(string)) continue;
                        if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                            arrayList.add(objectNameArray[0]);
                            continue;
                        }
                        arrayList.add(commandHelper.getDisplayAttrs(configService, session, objectNameArray, attributeList, stringArray));
                        continue;
                    }
                    if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                        arrayList.add(objectNameArray[0]);
                        continue;
                    }
                    arrayList.add(commandHelper.getDisplayAttrs(configService, session, objectNameArray, attributeList, stringArray));
                    continue;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.SSL_CONFIG_GROUPS, attributeList);
            }
            taskCommandResultImpl.setResult(arrayList);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        this.setCommandResult(taskCommandResultImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

