/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateSSLConfig
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateSSLConfig.class, "SSL", "com.ibm.ws.ssl.commands");
    private String aliasName = null;
    private String scopeName = null;
    private String clientKeyAlias = null;
    private String serverKeyAlias = null;
    private String type = null;
    private Boolean clientAuthentication = null;
    private String securityLevel = null;
    private String enabledCiphers = null;
    private String jsseProvider = null;
    private Boolean clientAuthenticationSupported = null;
    private String sslProtocol = null;
    private String trustManagerObjNames = null;
    private String keyManagerName = null;
    private String keyManagerScopeName = null;
    private String keyStoreName = null;
    private String keyStoreScopeName = null;
    private String trustStoreName = null;
    private String trustStoreScopeName = null;
    private ObjectName scopeObjName = null;
    private ObjectName trustStoreObjName = null;
    private ObjectName keyStoreObjName = null;
    private ObjectName keyManagerObjName = null;
    private boolean createMgmScope = false;
    private List trustManagerObjNameList = null;
    private String keyFileName = null;
    private Integer timeout = null;

    public CreateSSLConfig(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateSSLConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            boolean bl;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.aliasName = (String)this.getParameter(CommandConstants.ALIAS);
            this.type = (String)this.getParameter(CommandConstants.TYPE);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.clientKeyAlias = (String)this.getParameter(CommandConstants.CLIENT_KEY_ALIAS);
            this.serverKeyAlias = (String)this.getParameter(CommandConstants.SERVER_KEY_ALIAS);
            this.clientAuthentication = (Boolean)this.getParameter(CommandConstants.CLIENT_AUTHENTICATION);
            this.securityLevel = (String)this.getParameter(CommandConstants.SECURITY_LEVEL);
            this.enabledCiphers = (String)this.getParameter(CommandConstants.ENABLED_CIPHERS);
            this.jsseProvider = (String)this.getParameter(CommandConstants.JSSE_PROVIDER);
            this.clientAuthenticationSupported = (Boolean)this.getParameter(CommandConstants.CLIENT_AUTHENTICATION_SUPPORTED);
            this.sslProtocol = (String)this.getParameter(CommandConstants.SSL_PROTOCOL);
            this.trustManagerObjNames = (String)this.getParameter(CommandConstants.TRUST_MANAGER_OBJECT_NAMES);
            this.trustStoreName = (String)this.getParameter(CommandConstants.TRUST_STORE_NAME);
            this.trustStoreScopeName = (String)this.getParameter(CommandConstants.TRUST_STORE_SCOPE_NAME);
            this.keyManagerName = (String)this.getParameter(CommandConstants.KEY_MANAGER_NAME);
            this.keyManagerScopeName = (String)this.getParameter(CommandConstants.KEY_MANAGER_SCOPE_NAME);
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScopeName = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE_NAME);
            this.keyFileName = (String)this.getParameter(CommandConstants.SSSL_KEY_RING_NAME);
            this.timeout = (Integer)this.getParameter(CommandConstants.SSSL_V3_TIME_OUT);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig aliasName:  " + this.aliasName);
                Tr.debug(tc, "type:                 " + this.type);
                Tr.debug(tc, "scopeName:            " + this.scopeName);
                Tr.debug(tc, "clientKeyAlias:       " + this.clientKeyAlias);
                Tr.debug(tc, "serverKeyAlias:       " + this.serverKeyAlias);
                Tr.debug(tc, "clientAuthentication: " + this.clientAuthentication);
                Tr.debug(tc, "securityLevel:        " + this.securityLevel);
                Tr.debug(tc, "enabledCiphers:       " + this.enabledCiphers);
                Tr.debug(tc, "jsseProvider:         " + this.jsseProvider);
                Tr.debug(tc, "clientAuthSupported:  " + this.clientAuthenticationSupported);
                Tr.debug(tc, "sslProtocol:          " + this.sslProtocol);
                Tr.debug(tc, "trustManagerObjNames: " + this.trustManagerObjNames);
                Tr.debug(tc, "trustStoreName:       " + this.trustStoreName);
                Tr.debug(tc, "trustStoreScopeName:  " + this.trustStoreScopeName);
                Tr.debug(tc, "keyManagerName:       " + this.keyManagerName);
                Tr.debug(tc, "keyManagerScopeName:  " + this.keyManagerScopeName);
                Tr.debug(tc, "keyStoreName:         " + this.keyStoreName);
                Tr.debug(tc, "keyStoreScopeName:    " + this.keyStoreScopeName);
                Tr.debug(tc, "keyFileName:          " + this.keyFileName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.type != null && !commandHelper.contains(CommandConstants.SSLType, this.type)) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.type.CWPKI610E", "SSL type is not valid.  Should be SSSL or JSSE.");
                throw new CommandValidationException(string);
            }
            if (this.securityLevel != null && !commandHelper.contains(CommandConstants.SSLSecurityLevel, this.securityLevel)) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.securityLevel.CWPKI611E", "SSL security level is not valid.  Should be HIGH, MEDIUM, LOW, or CUSTOM.");
                throw new CommandValidationException(string);
            }
            if (this.sslProtocol != null && !commandHelper.contains(CommandConstants.SSLProtocol, this.sslProtocol)) {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.protocol.CWPKI612E", "SSL protocol is not valid.  Should be SSL_TLS, SSL, SSLv2, SSLv3, TLS, or TLSv1.");
                throw new CommandValidationException(string);
            }
            AttributeList attributeList = new AttributeList();
            if (this.type.equalsIgnoreCase("SSSL")) {
                if (this.keyFileName == null) {
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.missing.parameter.CWPKI0676", new Object[]{"ssslKeyRingName"}, "The \"ssslKeyRingName\" parameter is required for System SSL (SSSL) SSL configuration types.");
                    throw new CommandValidationException(string);
                }
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.aliasName);
                bl = commandHelper.exists(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList, null);
                if (bl) {
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.exists.CWPKI0621E", new Object[]{this.aliasName}, this.aliasName + " already exists.");
                    throw new CommandValidationException(string);
                }
                if (this.timeout != null && (this.timeout < 1 || this.timeout > 86400)) {
                    String string = TraceNLSHelper.getInstance().getString("ssl.command.timeout.range.CWPKI0683E", "V3 time out range is between 1 and 86400.");
                    throw new CommandValidationException(string);
                }
            }
            if (this.type.equalsIgnoreCase("JSSE")) {
                Object object;
                if (this.keyStoreName == null || this.trustStoreName == null) {
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.missing.parameters.CWPKI0677", new Object[]{"keyStoreName", "trustStoreName"}, "The \"keyStoreName\" and \"trustStoreName\" parameters are required for JSSE SSL configuration types.");
                    throw new CommandValidationException(string);
                }
                if (this.scopeName == null) {
                    this.scopeName = commandHelper.defaultCellScope(objectName3);
                } else if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                    }
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                    throw new CommandValidationException(string);
                }
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.aliasName);
                bl = commandHelper.exists(configService, session, objectName, CommandConstants.REPERTOIRE, attributeList, this.scopeName);
                if (bl) {
                    String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.aliasName, this.scopeName}, this.aliasName + " in the management scope " + this.scopeName + " already exists.");
                    throw new CommandValidationException(string);
                }
                if (this.keyManagerScopeName == null) {
                    this.keyManagerScopeName = commandHelper.defaultCellScope(objectName3);
                }
                if (this.keyStoreScopeName == null) {
                    this.keyStoreScopeName = commandHelper.defaultCellScope(objectName3);
                }
                if (this.trustStoreScopeName == null) {
                    this.trustStoreScopeName = commandHelper.defaultCellScope(objectName3);
                }
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                boolean bl2 = commandHelper.exists(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
                if (!bl2) {
                    this.createMgmScope = true;
                } else {
                    attributeList.clear();
                    ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                    this.scopeObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "scopeObjName: " + this.scopeObjName);
                    }
                }
                if (this.trustManagerObjNames != null) {
                    object = this.trustManagerObjNames.split(":");
                    this.trustManagerObjNameList = new ArrayList();
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        ObjectName objectName4;
                        if (object[i] == null) continue;
                        String string = object[i];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "trustManagers[i]: " + object[i]);
                        }
                        if (object[i].indexOf("(") != -1 && object[i].indexOf(")") != -1) {
                            string = object[i].substring(object[i].indexOf("(") + 1, object[i].indexOf(")"));
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "id: " + string);
                            }
                        }
                        if ((objectName4 = commandHelper.getObjectWithinScope(configService, session, "TrustManager", string, this.scopeName)) == null) continue;
                        this.trustManagerObjNameList.add(objectName4);
                    }
                }
                if (this.keyManagerName != null) {
                    attributeList.clear();
                    ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyManagerName);
                    this.keyManagerObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_MANAGERS, attributeList, this.keyManagerScopeName);
                }
                if (this.trustStoreName != null) {
                    attributeList.clear();
                    ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.trustStoreName);
                    this.trustStoreObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_STORES, attributeList, this.trustStoreScopeName);
                }
                if (this.keyStoreName != null) {
                    attributeList.clear();
                    ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyStoreName);
                    this.keyStoreObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_STORES, attributeList, this.keyStoreScopeName);
                    if (this.clientKeyAlias != null || this.serverKeyAlias != null) {
                        object = (KeyStore)MOFUtil.convertToEObject((Session)session, (ObjectName)this.keyStoreObjName);
                        if (this.clientKeyAlias != null && !PersonalCertificateHelper.isAliasInKeyStore(this.clientKeyAlias, (KeyStore)object)) {
                            String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{this.clientKeyAlias, this.keyStoreName}, "Alias " + this.clientKeyAlias + " is not a personal certificate in key store " + this.keyStoreName + ".");
                            throw new CommandValidationException(string);
                        }
                        if (this.serverKeyAlias != null && !PersonalCertificateHelper.isAliasInKeyStore(this.serverKeyAlias, (KeyStore)object)) {
                            String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.in.keystore.CWPKI0672E", new Object[]{this.serverKeyAlias, this.keyStoreName}, "Alias " + this.serverKeyAlias + " is not a personal certificate in key store " + this.keyStoreName + ".");
                            throw new CommandValidationException(string);
                        }
                    }
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.createSSLConfig.validate", "326", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        ObjectName objectName2 = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            objectName = configService.resolve(session, "Cell=:Security=")[0];
            if (this.type.equalsIgnoreCase("JSSE")) {
                AttributeList attributeList = new AttributeList();
                if (this.createMgmScope) {
                    ManagementScopeData managementScopeData = new ManagementScopeData(this.scopeName);
                    ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                    ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_TYPE, managementScopeData.getScopeType());
                    this.scopeObjName = configService.createConfigData(session, objectName, CommandConstants.MANAGEMENT_SCOPES, null, attributeList);
                    attributeList.clear();
                }
                objectName2 = this.createJSSEConfig(configService, session, objectName);
            } else if (this.type.equalsIgnoreCase("SSSL")) {
                objectName2 = this.createSSSLConfig(configService, session, objectName);
            } else {
                String string = TraceNLSHelper.getInstance().getString("ssl.command.SSLConfig.invalid.type.CWPKI610E", "SSL type is not valid.  Should be SSSL or JSSE.");
                throw new CommandValidationException(string);
            }
            if (objectName2 != null) {
                taskCommandResultImpl.setResult(objectName2);
            }
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private ObjectName createJSSEConfig(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJSSEConfig");
        }
        ObjectName objectName2 = null;
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.aliasName);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.TYPE, this.type);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
        objectName2 = configService.createConfigData(session, objectName, CommandConstants.REPERTOIRE, null, attributeList);
        attributeList.clear();
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.CLIENT_KEY_ALIAS, this.clientKeyAlias);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SERVER_KEY_ALIAS, this.serverKeyAlias);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.CLIENT_AUTHENTICATION, this.clientAuthentication);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SECURITY_LEVEL, this.securityLevel);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ENABLED_CIPHERS, this.enabledCiphers);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.JSSE_PROVIDER, this.jsseProvider);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.CLIENT_AUTHENTICATION_SUPPORTED, this.clientAuthenticationSupported);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SSL_PROTOCOL, this.sslProtocol);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.TRUST_MANAGER, this.trustManagerObjNameList);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.TRUST_STORE, this.trustStoreObjName);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_MANAGER, this.keyManagerObjName);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_STORE, this.keyStoreObjName);
        ObjectName objectName3 = configService.createConfigData(session, objectName2, CommandConstants.SETTING, null, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJSSEConfig");
        }
        return objectName2;
    }

    private ObjectName createSSSLConfig(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSSSLConfig");
        }
        ObjectName objectName2 = null;
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ALIAS, this.aliasName);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.TYPE, this.type);
        objectName2 = configService.createConfigData(session, objectName, CommandConstants.REPERTOIRE, null, attributeList);
        attributeList.clear();
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SSSL_KEY_FILE_NAME, this.keyFileName);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.CLIENT_AUTHENTICATION, this.clientAuthentication);
        ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SECURITY_LEVEL, this.securityLevel);
        if (this.enabledCiphers != null) {
            object = SSLConfigManager.getInstance().convertCiphersList(this.enabledCiphers);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.ENABLED_CIPHERS, object);
        }
        object = configService.createConfigData(session, objectName2, CommandConstants.SETTING, null, attributeList);
        attributeList.clear();
        attributeList.add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.contextProvider"));
        attributeList.add(new Attribute(CommandConstants.VALUE, this.jsseProvider));
        configService.createConfigData(session, (ObjectName)object, CommandConstants.PROPERTIES, null, attributeList);
        attributeList.clear();
        attributeList.add(new Attribute(CommandConstants.NAME, "com.ibm.ssl.protocol"));
        attributeList.add(new Attribute(CommandConstants.VALUE, this.sslProtocol));
        configService.createConfigData(session, (ObjectName)object, CommandConstants.PROPERTIES, null, attributeList);
        attributeList.clear();
        attributeList.add(new Attribute(CommandConstants.NAME, "was.com.ibm.ssl.sys.v3.timeout"));
        attributeList.add(new Attribute(CommandConstants.VALUE, this.timeout.toString()));
        configService.createConfigData(session, (ObjectName)object, CommandConstants.PROPERTIES, null, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSSSLConfig");
        }
        return objectName2;
    }
}

