/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySetGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateKeySetGroup
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateKeySetGroup.class, "SSL", "com.ibm.ws.ssl.commands.KeySetGroup");
    private String keySetGroupName = null;
    private Boolean autoGenerate = null;
    private String keySetObjNames = null;
    private String wsScheduleName = null;
    private String scopeName = null;
    private List keySetObjNameList = null;
    private ObjectName wsScheduleObjName = null;
    private ObjectName scopeObjName = null;
    private boolean createMgmScope = false;

    public CreateKeySetGroup(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateKeySetGroup(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.keySetGroupName = (String)this.getParameter(CommandConstants.NAME);
            this.autoGenerate = (Boolean)this.getParameter(CommandConstants.AUTO_GENERATE);
            this.keySetObjNames = (String)this.getParameter(CommandConstants.KEY_SET_OBJECT_NAMES);
            this.wsScheduleName = (String)this.getParameter(CommandConstants.WS_SCHEDULE_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySetGroupName: " + this.keySetGroupName);
                Tr.debug(tc, "autoGenerate: " + (this.autoGenerate == null ? "null" : this.autoGenerate.toString()));
                Tr.debug(tc, "keySetObjNames: " + this.keySetObjNames);
                Tr.debug(tc, "wsScheduleName: " + this.wsScheduleName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
            } else if (!ManagementScopeHelper.validScopeName(session, configService, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(string);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetGroupName);
            boolean bl = commandHelper.exists(configService, session, objectName, CommandConstants.KEY_SET_GROUPS, attributeList, this.scopeName);
            if (bl) {
                String string = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.keySetGroupName, this.scopeName}, this.keySetGroupName + " in the management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(string);
            }
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean bl2 = commandHelper.exists(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
            if (!bl2) {
                this.createMgmScope = true;
            } else {
                this.scopeObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.MANAGEMENT_SCOPES, attributeList, null);
            }
            if (this.wsScheduleName != null) {
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.wsScheduleName);
                this.wsScheduleObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.WS_SCHEDULES, attributeList, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wsScheduleObjName: " + this.wsScheduleObjName);
                }
            }
            if (this.keySetObjNames != null) {
                String[] stringArray = this.keySetObjNames.split(":");
                this.keySetObjNameList = new ArrayList();
                for (int i = 0; i < stringArray.length; ++i) {
                    ObjectName objectName4;
                    if (stringArray[i] == null) continue;
                    String string = stringArray[i];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "keySets[i]: " + stringArray[i]);
                    }
                    if (stringArray[i].indexOf("(") != -1 && stringArray[i].indexOf(")") != -1) {
                        string = stringArray[i].substring(stringArray[i].indexOf("(") + 1, stringArray[i].indexOf(")"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "id: " + string);
                        }
                    }
                    if ((objectName4 = commandHelper.getObjectWithinScope(configService, session, "KeySet", string, this.scopeName)) == null) continue;
                    this.keySetObjNameList.add(objectName4);
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.ssl.commands.createKeySetGroup.validate", "215");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            Object object;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            if (this.createMgmScope) {
                object = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.SCOPE_TYPE, ((ManagementScopeData)object).getScopeType());
                this.scopeObjName = configService.createConfigData(session, objectName, CommandConstants.MANAGEMENT_SCOPES, null, attributeList);
                attributeList.clear();
            }
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keySetGroupName);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.AUTO_GENERATE, this.autoGenerate);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.WS_SCHEDULE, this.wsScheduleObjName);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.KEY_SET, this.keySetObjNameList);
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            object = configService.createConfigData(session, objectName, CommandConstants.KEY_SET_GROUPS, null, attributeList);
            if (object != null) {
                taskCommandResultImpl.setResult(object);
            }
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

