/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeyManager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteKeyManager
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteKeyManager.class, "SSL", "com.ibm.ws.ssl.commands");
    private String keyManagerName = null;
    private String scopeName = null;
    private ObjectName keyManagerObjName = null;

    public DeleteKeyManager(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteKeyManager(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            this.keyManagerName = (String)this.getParameter(CommandConstants.NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyManagerName: " + this.keyManagerName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(objectName3);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, CommandConstants.NAME, this.keyManagerName);
            this.keyManagerObjName = commandHelper.getObjectName(configService, session, objectName, CommandConstants.KEY_MANAGERS, attributeList, this.scopeName);
            AttributeList attributeList2 = new AttributeList();
            List list = (List)configService.getAttribute(session, objectName, CommandConstants.REPERTOIRE);
            Object object = list.iterator();
            while (object.hasNext()) {
                AttributeList attributeList3 = (AttributeList)object.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "repertoire : " + attributeList3);
                }
                String string = (String)ConfigServiceHelper.getAttributeValue(attributeList3, CommandConstants.ALIAS);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "aliasName : " + string);
                }
                AttributeList attributeList4 = (AttributeList)ConfigServiceHelper.getAttributeValue(attributeList3, CommandConstants.SETTING);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting attributes : " + attributeList4);
                }
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList4), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting object : " + objectNameArray[0]);
                }
                if (objectNameArray.length != 1) continue;
                ObjectName objectName4 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList4, CommandConstants.KEY_MANAGER);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyManagerRef : " + objectName4);
                }
                if (objectName4 == null || !this.keyManagerObjName.equals(objectName4)) continue;
                attributeList2.add(new Attribute(CommandConstants.REPERTOIRE, string));
            }
            if (attributeList2.size() > 0) {
                object = "This object is referenced by " + attributeList2;
                throw new CommandValidationException((String)object);
            }
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", configServiceException.getMessage());
            }
            throw new CommandValidationException(configServiceException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.deleteKeyManager.validate", "175", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", exception.getMessage());
            }
            throw new CommandValidationException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            configService.deleteConfigData(session, this.keyManagerObjName);
        }
        catch (Exception exception) {
            taskCommandResultImpl.setException(new CommandException(exception, exception.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

