/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.template.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.template.Template;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TemplateImpl
implements Template {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(TemplateImpl.class);
    private RepositoryContext templateContext;
    private List variables = null;
    private List fileNames = null;
    private HashMap contentMap = new HashMap();

    public TemplateImpl(RepositoryContext repositoryContext) {
        this.templateContext = repositoryContext;
    }

    public RepositoryContextType getType() {
        return this.templateContext.getType();
    }

    public String getName() {
        return this.templateContext.getName();
    }

    public RepositoryContext getContext() {
        return this.templateContext;
    }

    public List getVariables() throws WorkSpaceException {
        if (this.variables == null) {
            this.init();
        }
        return this.variables;
    }

    private void init() throws WorkSpaceException {
        Tr.entry(tc, "init");
        this.variables = new ArrayList();
        this.fileNames = new ArrayList();
        List list = this.templateContext.getAllList(false);
        for (int i = 0; i < list.size(); ++i) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)list.get(i);
            List list2 = this.collect(workSpaceFile);
            if (list2.size() > 0) {
                this.variables.removeAll(list2);
                this.variables.addAll(list2);
            }
            this.fileNames.add(workSpaceFile.getName());
        }
        Tr.exit(tc, "init");
    }

    public List getFiles() throws WorkSpaceException {
        if (this.fileNames == null) {
            this.init();
        }
        return this.fileNames;
    }

    private List collect(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        return this.collect(this.getContent(workSpaceFile.getName()));
    }

    String getContent(String string) throws WorkSpaceException {
        return new String(this.getContentBytes(string));
    }

    byte[] getContentBytes(String string) throws WorkSpaceException {
        Tr.entry(tc, "getContentBytes", new Object[]{string});
        byte[] byArray = null;
        try {
            InputStream inputStream = this.getContext().getInputStream(string);
            int n = inputStream.available();
            byArray = new byte[n];
            inputStream.read(byArray, 0, n);
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Tr.exit(tc, "getContentBytes");
        return byArray;
    }

    private List collect(String string) throws WorkSpaceException {
        Tr.entry(tc, "collect");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '$') {
                if (i + 3 >= n) break;
                if (string.charAt(++i) != '{') continue;
                stringBuffer.append("${");
                continue;
            }
            if (c == '}') {
                if (stringBuffer.length() == 0) continue;
                stringBuffer.append("}");
                String string2 = stringBuffer.toString();
                if (!arrayList.contains(string2)) {
                    arrayList.add(string2);
                }
                stringBuffer = new StringBuffer();
                continue;
            }
            if (stringBuffer.length() <= 0) continue;
            stringBuffer.append(c);
        }
        Tr.exit(tc, "collect");
        return arrayList;
    }
}

