/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS.authz;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.AuthorizationTable;
import com.ibm.websphere.security.SAFRoleMapper;
import com.ibm.websphere.security.SecurityProviderException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.SAFServiceResult;
import com.ibm.ws.security.zOS.authz.SAFAuthorizationOptions;
import com.ibm.ws.security.zOS.authz.SAFRoleMapperFactory;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import javax.security.auth.Subject;

public class SAFAuthorizationTableImpl
implements AuthorizationTable {
    private static final TraceComponent tc = Tr.register(SAFAuthorizationTableImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static final String SUBJECT_KEY = "AUTHZ_SUBJECT";
    private static boolean _roleClassInactive = false;
    private SAFRoleMapper _roleMapper = null;
    private boolean _suppressMessages = false;
    private SAFAuthorizationOptions.LogOption _logOption = null;

    public SAFAuthorizationTableImpl() {
        Properties properties;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if ((string = (properties = (Properties)SecurityConfig.getConfig().getValue("security.toplevel.properties")).getProperty("com.ibm.security.SAF.Authz.Log.Option")) != null && string.length() > 0) {
            if (string.equals(SAFAuthorizationOptions.NONE.toString())) {
                this._logOption = SAFAuthorizationOptions.NONE;
            } else if (string.equals(SAFAuthorizationOptions.ASIS.toString())) {
                this._logOption = SAFAuthorizationOptions.ASIS;
            } else if (string.equals(SAFAuthorizationOptions.NOFAIL.toString())) {
                this._logOption = SAFAuthorizationOptions.NOFAIL;
            }
        }
        string = properties.getProperty("com.ibm.security.SAF.EJBROLE.Audit.Messages.Suppress");
        this._suppressMessages = "true".equalsIgnoreCase(string);
        this._roleMapper = SAFRoleMapperFactory.getSAFRoleMapper();
        Tr.audit(tc, "security.zos.saf.authz.enabled");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", this);
        }
    }

    public boolean isEveryoneGranted(HashMap hashMap, String[] stringArray) throws SecurityProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEveryoneGranted", new Object[]{hashMap, stringArray});
        }
        boolean bl = SAFAuthorizationTableImpl.isRoleClassInactive();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEveryoneGranted", new Boolean(bl));
        }
        return bl;
    }

    public boolean isGrantedRole(HashMap hashMap, String string, Principal principal) throws SecurityProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedRole", new Object[]{hashMap, string, principal});
        }
        String[] stringArray = new String[]{string};
        boolean bl = this.isGrantedAnyRole(hashMap, stringArray, principal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRole", new Boolean(bl));
        }
        return bl;
    }

    public boolean isGrantedAnyRole(HashMap hashMap, String[] stringArray, Principal principal) throws SecurityProviderException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedAnyRole", new Object[]{hashMap, stringArray, principal});
        }
        boolean bl = false;
        PlatformCredential platformCredential = null;
        try {
            object = (Subject)hashMap.get(SUBJECT_KEY);
            platformCredential = (PlatformCredential)AccessController.doPrivileged(new PrivilegedExceptionAction((Subject)object){
                private final /* synthetic */ Subject val$subject;
                {
                    this.val$subject = subject;
                }

                public Object run() throws Exception {
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(this.val$subject);
                    Object object = null;
                    if (wSCredential != null) {
                        object = wSCredential.get("com.ibm.ws.security.zos.PlatformCredential");
                    }
                    if (object == null) {
                        object = PlatformCredentialManager.instance().createDefaultCredential();
                    }
                    return object;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.zOS.authz.SAFAuthorizationTableImpl", "240", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to acquire credential for authorization", privilegedActionException.getException());
            }
            throw new SecurityProviderException("Unable to acquire credential for authorization", privilegedActionException.getException());
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Target role is required");
        }
        object = (String)hashMap.get("APPLICATION_NAME");
        boolean bl2 = "admin-authz".equals(object);
        String[] stringArray2 = this.getProfilesFromRoles(hashMap, stringArray);
        int n = this.getLogOption();
        boolean bl3 = bl2 && this._logOption == null || this._suppressMessages;
        bl = this.isCredentialInAnyRole(platformCredential, stringArray2, n, bl3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAnyRole", new Boolean(bl));
        }
        return bl;
    }

    private boolean isCredentialInAnyRole(PlatformCredential platformCredential, String[] stringArray, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCredentialInAnyRole", new Object[]{platformCredential, stringArray, new Integer(n), new Boolean(bl)});
        }
        boolean bl2 = false;
        int n2 = this.checkProfiles(platformCredential, stringArray, stringArray.length, n, bl);
        switch (n2) {
            case 0: {
                bl2 = true;
                break;
            }
            case 8: 
            case 9: {
                bl2 = false;
                break;
            }
            case 14: {
                SAFAuthorizationTableImpl.setRoleClassInactive();
                bl2 = true;
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SAF authorization unexpected rc", SAFServiceResult.getSafServiceResult());
                }
                bl2 = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCredentialInAnyRole", new Boolean(bl2));
        }
        return bl2;
    }

    protected int getLogOption() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLogOption");
        }
        int n2 = n = this._logOption == null ? 0 : this._logOption.getValue();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLogOption", new Integer(n));
        }
        return n;
    }

    protected String[] getProfilesFromRoles(HashMap hashMap, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProfilesFromRoles", new Object[]{hashMap, stringArray});
        }
        String[] stringArray2 = new String[stringArray.length];
        String string = (String)hashMap.get("APPLICATION_NAME");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this._roleMapper.getProfileFromRole(string, stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProfilesFromRoles", stringArray2);
        }
        return stringArray2;
    }

    private native int checkProfiles(PlatformCredential var1, String[] var2, int var3, int var4, boolean var5);

    private static synchronized void setRoleClassInactive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRoleClassInactive");
        }
        if (!_roleClassInactive) {
            _roleClassInactive = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRoleClassInactive");
        }
    }

    private static boolean isRoleClassInactive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRoleClassInactive");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRoleClassInactive", new Boolean(_roleClassInactive));
        }
        return _roleClassInactive;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(";_logOption=").append(this._logOption);
        stringBuffer.append(";_suppressMessages=").append(this._suppressMessages);
        stringBuffer.append(";_roleMapper=").append(this._roleMapper);
        stringBuffer.append(";_roleClassInactive").append(_roleClassInactive);
        return stringBuffer.toString();
    }
}

