/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS.authz;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.zOS.SAFAuthorizationInterface;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.SAFServiceResult;
import com.ibm.ws.security.zOS.authz.AccessLevel;
import com.ibm.ws.security.zOS.authz.AuthorizationDeniedException;
import com.ibm.ws.security.zOS.authz.InactiveClassException;
import com.ibm.ws.security.zOS.authz.InvalidCredentialException;
import com.ibm.ws.security.zOS.authz.SAFAuthorizationOptions;
import javax.security.auth.Subject;

public final class SAFAuthorizationManager
implements SAFAuthorizationInterface {
    private static final TraceComponent tc = Tr.register(SAFAuthorizationManager.class, "Security", "com.ibm.ejs.resources.security");
    private static final SAFAuthorizationManager _instance = new SAFAuthorizationManager();
    private ContextManager contextManager = null;
    private PlatformCredentialManager platformCredManager = null;

    public static SAFAuthorizationManager instance() {
        return _instance;
    }

    private SAFAuthorizationManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public boolean isCallerAuthorized(String string, String string2, String string3, boolean bl, String string4) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        Subject subject;
        PlatformCredential platformCredential;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerAuthorized5", new Object[]{string, string2, string3, bl, string4});
        }
        if ((platformCredential = this.getPlatformCredentialFromSubject(subject = this.getEffectiveSubject())) == null) {
            throw new InvalidCredentialException("Subject does not contain a PlatformCredential");
        }
        boolean bl2 = this.checkAccess(platformCredential, string, string2, null, this.getAccessLevel(string3), this.getLogOption(string4), bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerAuthorized5", new Boolean(bl2));
        }
        return bl2;
    }

    public boolean isCallerAuthorized(String string, String string2, String string3) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerAuthorized3", new Object[]{string, string2, string3});
        }
        boolean bl = this.isCallerAuthorized(string, string2, this.getAccessLevel(string3));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerAuthorized3", new Boolean(bl));
        }
        return bl;
    }

    public boolean isCallerAuthorized(String string, String string2) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerAuthorized2", new Object[]{string, string2});
        }
        boolean bl = this.isCallerAuthorized(string, string2, AccessLevel.READ);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerAuthorized2", new Boolean(bl));
        }
        return bl;
    }

    public boolean isCallerAuthorized(String string, String string2, AccessLevel accessLevel) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        Subject subject;
        PlatformCredential platformCredential;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerAuthorized3-1", new Object[]{string, string2, accessLevel});
        }
        if ((platformCredential = this.getPlatformCredentialFromSubject(subject = this.getEffectiveSubject())) == null) {
            throw new InvalidCredentialException("Subject does not contain a PlatformCredential");
        }
        boolean bl = this.isAuthorized(platformCredential, string, string2, accessLevel);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerAuthorized3-1", new Boolean(bl));
        }
        return bl;
    }

    public boolean isAuthorized(PlatformCredential platformCredential, String string, String string2) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAuthorized", new Object[]{platformCredential, string, string2});
        }
        boolean bl = this.isAuthorized(platformCredential, string, string2, AccessLevel.READ);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAuthorized", new Boolean(bl));
        }
        return bl;
    }

    public boolean isAuthorized(PlatformCredential platformCredential, String string, String string2, AccessLevel accessLevel) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAuthorized", new Object[]{platformCredential, string, string2, accessLevel});
        }
        boolean bl = this.checkAccess(platformCredential, string, string2, null, accessLevel, SAFAuthorizationOptions.NOFAIL, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAuthorized", new Boolean(bl));
        }
        return bl;
    }

    public boolean checkAccess(PlatformCredential platformCredential, String string, String string2, String string3, AccessLevel accessLevel, SAFAuthorizationOptions.LogOption logOption, boolean bl) throws AuthorizationDeniedException, InactiveClassException, InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess", new Object[]{platformCredential, string, string2, string3, accessLevel, logOption, new Boolean(bl)});
        }
        boolean bl2 = true;
        SAFServiceResult sAFServiceResult = SAFServiceResult.getSafServiceResult();
        int n = SAFAuthorizationManager.ntv_checkAccess(platformCredential, string, string2, string3, accessLevel.getValue(), logOption.getValue(), bl, false, sAFServiceResult);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Result", sAFServiceResult);
        }
        if (n != 0) {
            bl2 = false;
        } else if (sAFServiceResult.getSafReturnCode() == 4 && sAFServiceResult.getReturnCode() == 4) {
            bl2 = false;
            if (!this.isResourceClassActive(string)) {
                String string4 = string + " class is inactive";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string4);
                }
                throw new InactiveClassException(string4);
            }
        } else {
            if (sAFServiceResult.getSafReturnCode() == 8 && sAFServiceResult.getReturnCode() == 8) {
                throw new AuthorizationDeniedException("Authorization denied");
            }
            bl2 = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess", new Boolean(bl2));
        }
        return bl2;
    }

    public boolean isResourceClassActive(String string) {
        SAFServiceResult sAFServiceResult;
        int n;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isResourceClassActive", string);
        }
        boolean bl2 = bl = (n = SAFAuthorizationManager.ntv_getClassStatus(string, sAFServiceResult = SAFServiceResult.getSafServiceResult())) == 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isResourceClassActive", new Boolean(bl));
        }
        return bl;
    }

    private Subject getEffectiveSubject() throws InvalidCredentialException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEffectiveSubject");
        }
        Subject subject = null;
        try {
            this.contextManager = ContextManagerFactory.getInstance();
            subject = this.contextManager.getInvocationSubject();
            if (subject == null) {
                subject = this.contextManager.getCallerSubject();
            }
            if (subject == null) {
                subject = this.contextManager.createUnauthenticatedSubject();
            }
        }
        catch (WSSecurityException wSSecurityException) {
            InvalidCredentialException invalidCredentialException = new InvalidCredentialException("Unable to acquire subject for authorization", wSSecurityException);
            if (tc.isDebugEnabled()) {
                Tr.event(tc, "Unable to acquire subject for authorization", invalidCredentialException);
            }
            throw invalidCredentialException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEffectiveSubject", subject);
        }
        return subject;
    }

    private PlatformCredential getPlatformCredentialFromSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPlatformCredentialFromSubject", subject);
        }
        PlatformCredentialManager platformCredentialManager = PlatformCredentialManager.instance();
        PlatformCredential platformCredential = platformCredentialManager.getPlatformCredentialFromSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPlatformCredentialFromSubject", platformCredential);
        }
        return platformCredential;
    }

    private AccessLevel getAccessLevel(String string) {
        if (string.equalsIgnoreCase("NO_ACCESS")) {
            return AccessLevel.NO_ACCESS;
        }
        if (string.equalsIgnoreCase("READ")) {
            return AccessLevel.READ;
        }
        if (string.equalsIgnoreCase("UPDATE")) {
            return AccessLevel.UPDATE;
        }
        if (string.equalsIgnoreCase("CONTROL")) {
            return AccessLevel.CONTROL;
        }
        if (string.equalsIgnoreCase("ALTER")) {
            return AccessLevel.ALTER;
        }
        return AccessLevel.NO_ACCESS;
    }

    private SAFAuthorizationOptions.LogOption getLogOption(String string) {
        if (string.equalsIgnoreCase("NONE")) {
            return SAFAuthorizationOptions.NONE;
        }
        if (string.equalsIgnoreCase("ASIS")) {
            return SAFAuthorizationOptions.ASIS;
        }
        return SAFAuthorizationOptions.NOFAIL;
    }

    private static native int ntv_checkAccess(PlatformCredential var0, String var1, String var2, String var3, int var4, int var5, boolean var6, boolean var7, SAFServiceResult var8);

    private static native int ntv_getClassStatus(String var0, SAFServiceResult var1);
}

