/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.ws.security.web.WebAppCacheEntry;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebConstraintsTable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class WebAppCache
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(WebAppCache.class);
    private static Properties httpMethods = new Properties();
    private static final String VHOST_HOME = "VirtualHostHome";
    private static final String TYPE_HOME = "TypeHome";
    private static WebAttributes UNPROTECTED_WEBATTRS = new WebAttributes();
    private static HashMap cache = new HashMap();
    private boolean reload;
    private ContextManager contextManager = ContextManagerFactory.getInstance();

    public WebAppCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebAppCache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebAppCache");
        }
    }

    public void addWebApp(String string, String string2, WebApp webApp, DeployedModule deployedModule) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding webapp with context root =[" + string + ":" + string2 + "]");
        }
        if (cache.get(string + ":" + string2) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Create a WebConstraintsTable for this webApp");
            }
            WebConstraintsTable webConstraintsTable = new WebConstraintsTable(webApp, string, deployedModule);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Create WebAttributes for this webApp.");
            }
            WebAttributes webAttributes = new WebAttributes(webApp);
            WebAppCacheEntry webAppCacheEntry = new WebAppCacheEntry(string, string2, webAttributes, webConstraintsTable, webApp);
            cache.put(string + ":" + string2, webAppCacheEntry);
        }
    }

    public static void removeWebApp(String string, String string2) {
        cache.remove(string + ":" + string2);
    }

    public boolean isContained(String string, String string2) {
        return cache.containsKey(string + ":" + string2);
    }

    public WebAccessContext getWebAccessContext(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWebAccessContext", new Object[]{string, string2});
        }
        WebAppCacheEntry webAppCacheEntry = (WebAppCacheEntry)cache.get(string + ":" + string2);
        WebConstraintsTable webConstraintsTable = null;
        String string3 = null;
        if (webAppCacheEntry != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Okay, I found the entry for [" + string + ":" + string2 + "]");
            }
            string3 = webAppCacheEntry.getEnterpriseName();
            webConstraintsTable = webAppCacheEntry.getConstraints();
            if (webConstraintsTable == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "WebConstraintsTable is NULL though.");
            }
            WebAttributes webAttributes = webAppCacheEntry.getSecurityAttributes();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWebAccessContext");
            }
            return new WebAccessContext(string3, string2, webConstraintsTable, webAttributes, webAppCacheEntry.getWebApp());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NO WEB SECURITY CONTEXT INFO FOUND FOR " + string + ":" + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWebAccessContext");
        }
        return new WebAccessContext(string3, string2, null, null, null);
    }

    public WebAttributes getWebSecurityAttributes(final String string, final String string2) throws Exception {
        WebAttributes webAttributes;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWebAttributes", new Object[]{string, string2});
            }
            webAttributes = UNPROTECTED_WEBATTRS;
            try {
                webAttributes = (WebAttributes)this.contextManager.runAsSystem(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        WebAppCacheEntry webAppCacheEntry = (WebAppCacheEntry)cache.get(string + ":" + string2);
                        if (webAppCacheEntry != null) {
                            return webAppCacheEntry.getSecurityAttributes();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.WebAppCache.getWebSecurityAttributes", "155", this);
                if (!tc.isDebugEnabled()) break block5;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                Tr.debug(tc, "Exception of getting SecurityAttributes of WebApp", stringWriter.toString());
            }
        }
        if (webAttributes == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning a NULL web attributes object.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWebAttributes");
        }
        return webAttributes;
    }

    public void alarm(Object object) {
        this.mark();
    }

    private void mark() {
    }

    public PermissionRoleMap getPermissionRoleMap(String string, String string2) {
        WebAppCacheEntry webAppCacheEntry = (WebAppCacheEntry)cache.get(string + ":" + string2);
        WebConstraintsTable webConstraintsTable = null;
        if (webAppCacheEntry != null) {
            webConstraintsTable = webAppCacheEntry.getConstraints();
        }
        return webConstraintsTable;
    }

    static {
        for (int i = 0; i < Constants.HTTP_METHODS.length; ++i) {
            String string = Constants.HTTP_METHODS[i];
            httpMethods.put(string, "HTTP_" + string);
        }
    }
}

