/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.web.FormLoginInfo;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.security.web.WebCollaborator;
import com.ibm.ws.webcontainer.session.IHttpSession;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import com.ibm.wsspi.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class FormLoginExtensionProcessor
extends WebExtensionProcessor {
    private String loginPage = null;
    private String loginErrorPage = null;
    private static TraceComponent tc = Tr.register(FormLoginExtensionProcessor.class, null, "com.ibm.ejs.resources.security");
    private WebAttributes webAttrs = null;
    private static AuditHandlerImpl auditHandler = null;
    private static J2EEAuditEventFactory auditFactory = null;
    private static final String providerName = "WebSphere";
    private static final boolean providerSuccess = true;
    private static AuditService auditService = null;

    public FormLoginExtensionProcessor(IServletContext iServletContext) throws Exception {
        super(iServletContext);
        try {
            Class<?> clazz;
            String string;
            WebAppConfig webAppConfig = iServletContext.getWebAppConfig();
            WebModuleMetaData webModuleMetaData = webAppConfig.getMetaData();
            SecurityMetaData securityMetaData = (SecurityMetaData)webModuleMetaData.getSecurityMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Create WebAttributes for this webApp.");
            }
            if (securityMetaData != null) {
                this.webAttrs = securityMetaData.getWebAttributes();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In FormLoginExtensionProcessor(), security MetaData is null.");
            }
            this.loginPage = this.webAttrs.getLoginURL();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "login page is: " + this.loginPage);
            }
            this.loginErrorPage = this.webAttrs.getReloginURL();
            if (this.loginErrorPage != null && !this.loginErrorPage.startsWith("/")) {
                this.loginErrorPage = "/" + this.loginErrorPage;
            }
            if (auditService == null && (auditService = ContextManagerFactory.getInstance().getAuditService()) != null && (auditFactory = (J2EEAuditEventFactory)(auditHandler = (AuditHandlerImpl)auditService.newAuditHandler(string = "WAS.security", string)).getAuditEventFactory("J2EE")) != null && !(clazz = Class.forName("com.ibm.wsspi.security.audit.J2EEAuditEventFactory")).isInstance(auditFactory)) {
                auditFactory = null;
            }
            if (auditService == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "AuditService was not initialized");
            }
            if (auditHandler == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "AuditHandler was not initialized");
            }
            if (auditFactory == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "J2EEAuditEventFactory was not initialized");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "login error page is: " + this.loginErrorPage);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.FormLoginServlet.init", "160", (Object)this);
            Tr.error(tc, "security.web.form.noWebAppInfo", new Object[]{exception});
        }
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            this.formLogin(httpServletRequest, httpServletResponse);
        }
    }

    private void formLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        String string2;
        CharSequence charSequence;
        boolean bl = false;
        WSCredential wSCredential = null;
        Subject subject = null;
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        Boolean bl2 = (Boolean)securityConfig.getValue("com.ibm.ws.security.web.logoutOnHTTPSessionExpire");
        boolean bl3 = bl2;
        if (httpServletRequest.getRequestedSessionId() != null && !httpServletRequest.isRequestedSessionIdValid() && bl3) {
            httpServletRequest.getSession(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formLogin, WebAttributes: \n" + this.webAttrs.toString());
        }
        String string3 = null;
        if (this.loginErrorPage != null) {
            charSequence = HttpUtils.getRequestURL(httpServletRequest);
            string2 = ((StringBuffer)charSequence).toString();
            String string4 = httpServletRequest.getContextPath();
            if (string4.equals("/")) {
                string4 = "";
            }
            int n = string2.indexOf("//");
            n = string2.indexOf("/", n + 2);
            int n2 = string2.length();
            string3 = string4 + this.loginErrorPage;
            ((StringBuffer)charSequence).replace(n, n2, string3);
            string3 = ((StringBuffer)charSequence).toString();
        }
        charSequence = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
        string2 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundLoginConfig");
        boolean bl4 = false;
        Boolean bl5 = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
        if (auditHandler != null) {
            auditHandler.setAppName(this.webAttrs.getWebAppName());
        }
        if (bl5.booleanValue() && !((Boolean)SecurityConfig.getConfig().getValue("security.ltpa.sso.enabled")).booleanValue()) {
            Tr.error(tc, "security.formlogin.badconfig", new Object[]{this.webAttrs.getWebAppName()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Configuration error.  SSO Not enabled when using FormLogin. Redirecting to error page: " + string3);
            }
            httpServletResponse.setStatus(401);
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string3));
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "INVALID_CONFIG", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.formlogin.badconfig.audit", new Object[]{this.webAttrs.getWebAppName()});
            }
            return;
        }
        String string5 = httpServletRequest.getParameter("j_username");
        String string6 = httpServletRequest.getParameter("j_password");
        if (string5 == null || string6 == null || string6.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "username and/or password are not present");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Redirecting to error page: " + string3);
            }
            httpServletResponse.setStatus(401);
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string3));
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "MISSING_UIDPSWD", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string5, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string3});
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Form based login: userid/password present in the form. User is: " + string5);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        try {
            hashMap.put("WebAppName", this.webAttrs.getWebAppName());
            hashMap.put("RedirectURL", string3);
            object4 = ContextManagerFactory.getInstance().getDefaultRealm();
            object3 = string5;
            string = string6;
            String string7 = string2;
            HttpServletRequest httpServletRequest2 = httpServletRequest;
            object2 = httpServletResponse;
            object = hashMap;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction((String)object4, (String)object3, string, string7, httpServletRequest2, (HttpServletResponse)object2, (HashMap)object){
                private final /* synthetic */ String val$_realm;
                private final /* synthetic */ String val$_username;
                private final /* synthetic */ String val$_password;
                private final /* synthetic */ String val$_custom_jaas_config;
                private final /* synthetic */ HttpServletRequest val$_req;
                private final /* synthetic */ HttpServletResponse val$_res;
                private final /* synthetic */ HashMap val$_appcontext;
                {
                    this.val$_realm = string;
                    this.val$_username = string2;
                    this.val$_password = string3;
                    this.val$_custom_jaas_config = string4;
                    this.val$_req = httpServletRequest;
                    this.val$_res = httpServletResponse;
                    this.val$_appcontext = hashMap;
                }

                public Object run() throws Exception {
                    Subject subject = ContextManagerFactory.getInstance().login(this.val$_realm, this.val$_username, this.val$_password, this.val$_custom_jaas_config, this.val$_req, this.val$_res, this.val$_appcontext);
                    return subject;
                }
            };
            String string8 = null;
            try {
                subject = (Subject)AccessController.doPrivileged(privilegedExceptionAction);
                if (subject != null) {
                    wSCredential = (WSCredential)subject.getPublicCredentials(Class.forName("com.ibm.websphere.security.cred.WSCredential")).iterator().next();
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.security.web.FormLoginServlet.formLogin", "302", (Object)this);
                Tr.error(tc, "security.authn.error.foruser", new Object[]{string5});
                try {
                    string8 = (String)hashMap.get("RedirectURL");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Updating the error page to: " + string8);
                    }
                }
                catch (Throwable throwable) {
                    string8 = null;
                    Tr.error(tc, "incorrect customized error page: ", new Object[]{throwable});
                }
                if (string8 != null && string8.length() > 0) {
                    string3 = string8;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Redirecting to error page: " + string3);
                }
                httpServletResponse.setStatus(401);
                httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string3));
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "DENIED", httpServletRequest.getSession().getId(), privilegedActionException, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string5, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string3});
                }
                return;
            }
            try {
                string8 = (String)hashMap.get("RedirectURL");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updating the error page to: " + string8);
                }
            }
            catch (Throwable throwable) {
                string8 = null;
                Tr.error(tc, "incorrect customized error page: ", new Object[]{throwable});
            }
            if (string8 != null && string8.length() > 0) {
                string3 = string8;
            }
            if (subject == null || wSCredential == null) {
                Tr.audit(tc, "security.authn.failed.foruser", new Object[]{string5});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Redirecting to error page: " + string3);
                }
                httpServletResponse.setStatus(401);
                httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string3));
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                    auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "DENIED", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string5, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string3});
                }
                return;
            }
            ContextManagerFactory.getInstance().setInvocationSubject(subject);
            ContextManagerFactory.getInstance().setCallerSubject(subject);
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 0)) {
                auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string5, providerName, true, subject, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.success.audit", null);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.FormLoginServlet.formLogin", "394", (Object)this);
            Tr.error(tc, "security.authn.error.foruser", new Object[]{string5});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Redirecting to error page: " + string3);
            }
            httpServletResponse.setStatus(401);
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string3));
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                auditFactory.sendAuthnAuditEvent(auditHandler, AuditOutcome.REDIRECT, "DENIED", httpServletRequest.getSession().getId(), exception, this.loginPage, "WEB", httpServletRequest.getMethod(), ContextManagerFactory.getInstance().getDefaultRealm(), (String)charSequence, "FORM", string5, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string3});
            }
            return;
        }
        WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "FORM");
        object4 = null;
        object3 = null;
        if (((String)charSequence).equals("SWAM")) {
            object4 = httpServletRequest.getSession(true);
            if (object4 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Form based login: Store auth data in the HTTP Session");
                }
                if ((object3 = (FormLoginInfo)((IHttpSession)object4).getSecurityInfo()) == null) {
                    object3 = new FormLoginInfo(string5, string6);
                } else {
                    ((FormLoginInfo)object3).setUsername(string5);
                    ((FormLoginInfo)object3).setPassword(string6);
                }
                ((IHttpSession)object4).putSecurityInfo(object3);
            }
            bl4 = false;
        } else {
            string = null;
            boolean bl6 = false;
            bl4 = false;
            boolean bl7 = false;
            if (this.webAttrs.isSSOEnabled()) {
                bl7 = true;
                if (this.webAttrs.isSecureSSO()) {
                    bl4 = httpServletRequest.getScheme().equalsIgnoreCase("https");
                    bl6 = true;
                } else {
                    bl4 = true;
                }
            }
            if (bl4) {
                try {
                    object2 = WebAttributes.createCookies(httpServletRequest, subject);
                    this.clearCookie(httpServletRequest, httpServletResponse);
                    if (object2 != null) {
                        WebAttributes.addCookiesToResponse((List)object2, httpServletResponse);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.web.FormLoginServlet.formLogin", "489", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Redirecting to error page: " + string3);
                    }
                    httpServletResponse.setStatus(401);
                    httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string3));
                    return;
                }
            }
        }
        string = "";
        if (((String)charSequence).equals("SWAM")) {
            string = ((FormLoginInfo)object3).getRefererURL();
        } else {
            Boolean bl8;
            Cookie[] cookieArray = httpServletRequest.getCookies();
            string = WebAuthenticator.getCookieValue(cookieArray, "WASReqURL");
            if (string != null && ((bl8 = (Boolean)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.util.fullyQualifiedURL")) == null || bl8 != null && !bl8.booleanValue())) {
                object2 = HttpUtils.getRequestURL(httpServletRequest);
                object = ((StringBuffer)object2).toString();
                int n = ((String)object).indexOf("//");
                n = ((String)object).indexOf("/", n + 2);
                string = ((String)object).substring(0, n) + string;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Successful auth - redirecting to the original URL" + string);
        }
        if (string != null) {
            if (string.equals("/")) {
                string = "";
            } else if (string.startsWith("/")) {
                string = string.substring(1);
            }
        }
        if (string == null) {
            string = "";
        }
        httpServletResponse.sendRedirect(httpServletResponse.encodeURL(string));
    }

    private Cookie createCookie(String string, String string2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCookie " + string + " " + string2);
        }
        Cookie cookie = new Cookie(string, string2);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        cookie.setSecure(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCookie");
        }
        return cookie;
    }

    private void clearCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie[] cookieArray;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearCookie");
        }
        if ((string = WebAuthenticator.getCookieValue(cookieArray = httpServletRequest.getCookies(), "WASReqURL")) != null && string.length() > 0) {
            Cookie cookie = new Cookie("WASReqURL", "");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            httpServletResponse.addCookie(cookie);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cleared REFERER_URL cookie. Original value was " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearCookie");
        }
    }
}

