/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.spnego.ServerConfig;
import com.ibm.ws.security.spnego.ServerCredentialsFactory;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class ServerCredential {
    private static final Oid KRB5MECHANISMOID;
    private static final Oid SPNEGOMECHOID;
    private GSSManager gssManager;
    private GSSName gssName;
    private GSSCredential gssCred;
    private static final String ME;
    private static final Logger logger;

    public ServerCredential(ServerConfig serverConfig) throws GSSException, TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "<constructor>");
        }
        this.initialize(serverConfig);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "<constructor>");
        }
    }

    private void initialize(ServerConfig serverConfig) throws GSSException, TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "initialize");
        }
        if (serverConfig == null) {
            String string = "Service Provider Name is null.";
            logger.logp(Level.SEVERE, ME, "initialize", "security.spnego.config.error", string);
            throw new TAIConfigurationException(string);
        }
        try {
            this.gssManager = ServerCredentialsFactory.getMgr();
            String string = serverConfig.getServerName();
            if (serverConfig.getGssNameType() == GSSName.NT_USER_NAME) {
                this.gssName = this.gssManager.createName(string, GSSName.NT_USER_NAME, KRB5MECHANISMOID);
            } else {
                logger.logp(Level.WARNING, ME, "initialize", "security.spnego.warn.hostbased", string);
                this.gssName = this.gssManager.createName(string, GSSName.NT_HOSTBASED_SERVICE);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initialize", "Created GSSName for " + string);
            }
            int n = serverConfig.getGssCredType();
            int n2 = serverConfig.getGssCredDuration();
            this.gssCred = this.gssManager.createCredential(this.gssName, n2, SPNEGOMECHOID, n);
            if (logger.isLoggable(Level.FINER)) {
                String string2 = this.gssName == null ? "default" : ((Object)this.gssName).toString();
                logger.logp(Level.FINER, ME, "initialize", "Created GSSCredential " + string2 + " with lifetime of " + n2 + " seconds.");
            }
            this.gssCred.add(this.gssName, n2, n2, KRB5MECHANISMOID, n);
            int n3 = this.gssCred.getRemainingLifetime();
            Oid[] oidArray = this.gssCred.getMechs();
            int n4 = this.gssCred.getRemainingAcceptLifetime(oidArray[0]);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initialize", "Lifetime remaining on credential: " + n3 + " secs");
                logger.logp(Level.FINER, ME, "initialize", "Accept lifetime remaining on credential for mechanism " + oidArray[0] + ": " + n4 + " secs");
            }
        }
        catch (GSSException gSSException) {
            FFDCFilter.processException((Throwable)gSSException, "com.ibm.ws.security.spnego.ServerCredential.initialize", "173", this);
            logger.logp(Level.SEVERE, ME, "initialize", "security.spnego.kerberos.init.failed", new Object[]{gSSException});
            throw gSSException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.spnego.ServerCredential.initialize", "178", this);
            logger.logp(Level.SEVERE, ME, "initialize", "security.spnego.kerberos.init.error", new Object[]{throwable});
            throw new IllegalStateException("ServerCredential.initialize - unexpected exception: " + throwable);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "initialize", this.gssCred.toString());
        }
    }

    public final GSSCredential getGssCred() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getGssCred");
            logger.exiting(ME, "getGssCred", this.gssCred);
        }
        return this.gssCred;
    }

    static {
        ME = ServerCredential.class.getName();
        logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
        Oid oid = null;
        try {
            oid = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException gSSException) {
            oid = null;
        }
        KRB5MECHANISMOID = oid;
        try {
            oid = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException gSSException) {
            oid = null;
        }
        SPNEGOMECHOID = oid;
    }
}

