/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ltpaLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private WSPrincipal principal;
    private WSCredential credential;
    private ContextManager contextManager;
    private UserRegistry registry;
    protected boolean debug = false;
    private LTPAServerObject ltpaServer;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register(ltpaLoginModule.class, null, "com.ibm.ejs.resources.security");

    public ltpaLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ltpaLoginModule()");
            Tr.exit(tc, "ltpaLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")");
            }
            this.subject = subject;
            this.callbackHandler = callbackHandler;
            this.sharedState = map;
            this.options = map2;
            try {
                this.ltpaServer = LTPAServerObject.getLTPAServer();
            }
            catch (LTPAConfigException lTPAConfigException) {
                FFDCFilter.processException((Throwable)lTPAConfigException, "com.ibm.ws.security.server.lm.ltpaLoginModule.initialize", "166", this);
                if (!this.debug && !tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "ERROR: Failed to get the LTPA server object.");
            }
        }
        this.contextManager = ContextManagerFactory.getInstance();
        if (this.contextManager != null) {
            this.registry = SecurityServerImpl.getRegistryImpl(this.contextManager.getDefaultRealm());
            this.contextManager.clearRootException();
        }
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean login() throws LoginException {
        if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
            Tr.entry(ltpaLoginModule.tc, "login()");
        }
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "The login module is in funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        var1_1 = null;
        if (!this.sharedState.containsKey("Callback")) {
            if (this.callbackHandler == null) {
                var2_2 = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                this.contextManager.setRootException(var2_2);
                throw var2_2;
            }
            var1_1 = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSServletRequestCallback("HttpServletRequest: "), new WSServletResponseCallback("HttpServletResponse: "), new WSAppContextCallback("ApplicationContextCallback: "), new WSTokenHolderCallback("Authz Token List: "), new WSRealmNameCallbackImpl("Realm Name", this.contextManager.getDefaultRealm()), new WSX509CertificateChainCallback("X509Certificate[]: ")};
            try {
                this.callbackHandler.handle(var1_1);
            }
            catch (IOException var2_3) {
                FFDCFilter.processException((Throwable)var2_3, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "235", this);
                Tr.error(ltpaLoginModule.tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), var2_3});
                this.contextManager.setRootException(var2_3);
                throw new WSLoginFailedException("IOException: " + var2_3.getMessage(), var2_3);
            }
            catch (UnsupportedCallbackException var2_4) {
                FFDCFilter.processException((Throwable)var2_4, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "242", this);
                Tr.error(ltpaLoginModule.tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), var2_4.getCallback().toString(), var2_4});
                this.contextManager.setRootException(var2_4);
                throw new WSLoginFailedException(var2_4.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + var2_4.getMessage(), var2_4);
            }
            this.sharedState.put("Callback", var1_1);
        } else {
            var1_1 = (Callback[])this.sharedState.get("Callback");
        }
        var2_5 = null;
        var3_6 = null;
        var4_7 = null;
        var5_8 = null;
        var6_9 = null;
        var7_10 = null;
        var8_11 = false;
        var2_5 = ((NameCallback)var1_1[0]).getName();
        var3_6 = ((WSRealmNameCallbackImpl)var1_1[7]).getRealmName();
        var9_12 = ((PasswordCallback)var1_1[1]).getPassword();
        if (var9_12 != null && var9_12.length != 0) {
            var4_7 = new char[var9_12.length];
            System.arraycopy(var9_12, 0, var4_7, 0, var9_12.length);
        }
        if ((var10_13 = ((WSCredTokenCallbackImpl)var1_1[2]).getCredToken()) != null) {
            var5_8 = CredentialsHelper.copyCredToken(var10_13);
        }
        var6_9 = ((WSTokenHolderCallback)var1_1[6]).getTokenHolderList();
        var8_11 = ((WSServletRequestCallback)var1_1[3]).getHttpServletRequest() != null;
        var7_10 = ((WSX509CertificateChainCallback)var1_1[8]).getX509CertificateChain();
        var11_14 = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
        if (var11_14 == null) {
            try {
                var12_15 = this.subject;
                var11_14 = (Hashtable)AccessController.doPrivileged(new PrivilegedExceptionAction((Subject)var12_15){
                    private final /* synthetic */ Subject val$subjectPriv;
                    {
                        this.val$subjectPriv = subject;
                    }

                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                        Object[] objectArray = this.val$subjectPriv.getPublicCredentials().toArray();
                        if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for custom properties in public cred list.");
                        }
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in public list: " + objectArray[i]);
                            }
                            if (!(objectArray[i] instanceof Hashtable) || ((Hashtable)objectArray[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)objectArray[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                            return objectArray[i];
                        }
                        Object[] objectArray2 = this.val$subjectPriv.getPrivateCredentials().toArray();
                        if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for custom properties in private cred list.");
                        }
                        for (int i = 0; i < objectArray2.length; ++i) {
                            if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in private list: " + objectArray2[i]);
                            }
                            if (!(objectArray2[i] instanceof Hashtable) || ((Hashtable)objectArray2[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)objectArray2[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                            return objectArray2[i];
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException var12_16) {
                FFDCFilter.processException((Throwable)var12_16.getException(), "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "334", this);
                this.contextManager.setRootException(var12_16.getException());
                throw new WSLoginFailedException(var12_16.getException().getMessage(), var12_16.getException());
            }
            if (var11_14 != null) {
                this.sharedState.put("com.ibm.wsspi.security.cred.propertiesObject", var11_14);
            }
        }
        if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
            Tr.debug(ltpaLoginModule.tc, "uid = " + var2_5);
            Tr.debug(ltpaLoginModule.tc, "realm = " + var3_6);
            Tr.debug(ltpaLoginModule.tc, "password = " + (var4_7 == null ? "<null>" : "XXXXXXXX"));
            Tr.debug(ltpaLoginModule.tc, "cred token = " + Util.toString(var5_8));
            Tr.debug(ltpaLoginModule.tc, "X509 cert chain = " + var7_10);
            Tr.debug(ltpaLoginModule.tc, "authz token list = " + var6_9);
            Tr.debug(ltpaLoginModule.tc, "custom properties = " + var11_14);
            Tr.debug(ltpaLoginModule.tc, "isHTTPRequest = " + var8_11);
        }
        if (var11_14 != null && var11_14.get("com.ibm.wsspi.security.cred.uniqueId") != null && var11_14.get("com.ibm.wsspi.security.cred.userId") == null) {
            this.succeeded = true;
            if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Custom login module passing in credential properties.  Handling login outside this login module.");
                Tr.exit(ltpaLoginModule.tc, "login()");
            }
            return this.succeeded;
        }
        if (var11_14 != null && var11_14.get("com.ibm.wsspi.security.cred.userId") != null) {
            if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Setting uid and/or password from hashtable.");
            }
            var2_5 = (String)var11_14.get("com.ibm.wsspi.security.cred.userId");
            var12_15 = (String)var11_14.get("com.ibm.wsspi.security.cred.password");
            if (var12_15 != null) {
                var4_7 = var12_15.toCharArray();
            }
            if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "uid = " + var2_5);
                Tr.debug(ltpaLoginModule.tc, "password = " + (var4_7 == null ? "<null>" : "XXXXXXXX"));
            }
        }
        if ((WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled()) && var6_9 != null && (var5_8 != null || (var2_5 != null || var7_10 != null) && var4_7 == null)) {
            this.succeeded = true;
            if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Security attribute propagation data has been received.  Handling login outside this login module.");
                Tr.exit(ltpaLoginModule.tc, "login()");
            }
            return this.succeeded;
        }
        if (var7_10 == null && var2_5 == null && var4_7 == null && var5_8 == null) {
            var12_15 = new WSLoginFailedException("No authentication data.");
            this.contextManager.setRootException((Throwable)var12_15);
            throw var12_15;
        }
        if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
            Tr.debug(ltpaLoginModule.tc, "Successfully gathered authentication information");
        }
        if (var2_5 != null && var4_7 != null) {
            if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Using uid and password for authentication");
                var12_15 = new StringBuffer("Authenticating \"");
                var12_15.append(var3_6).append('/').append(var2_5).append("\"");
                Tr.debug(ltpaLoginModule.tc, var12_15.toString());
            }
            var12_15 = new String(var4_7);
            var13_19 = new BasicAuthData(var2_5, (String)var12_15);
            try {
                this.credential = this.ltpaServer.authenticate((BasicAuthData)var13_19);
            }
            catch (WSLoginFailedException var14_24) {
                FFDCFilter.processException((Throwable)var14_24, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "452", this);
                if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                    Tr.exit(ltpaLoginModule.tc, "login()", new Object[]{var14_24});
                }
                this.contextManager.setRootException(var14_24);
                throw var14_24;
            }
            catch (Exception var14_25) {
                FFDCFilter.processException((Throwable)var14_25, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "459", this);
                if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                    Tr.exit(ltpaLoginModule.tc, "login()", new Object[]{var14_25});
                }
                this.contextManager.setRootException(var14_25);
                throw new WSLoginFailedException(var14_25.getMessage(), var14_25);
            }
        }
        if (var2_5 != null || var7_10 != null) {
            var12_15 = System.getSecurityManager();
            if (var12_15 != null) {
                if (ltpaLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(ltpaLoginModule.tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(ltpaLoginModule.tc, "Expecting : " + ltpaLoginModule.MAP_CREDENTIAL.toString());
                }
                var12_15.checkPermission(ltpaLoginModule.MAP_CREDENTIAL);
            }
            if (var7_10 != null) {
                var13_19 = var7_10;
                var14_26 = new PrivilegedExceptionAction((X509Certificate[])var13_19){
                    private final /* synthetic */ X509Certificate[] val$cert_chain_final;
                    {
                        this.val$cert_chain_final = x509CertificateArray;
                    }

                    public Object run() throws Exception {
                        if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Mapping X509Certificate[] to uid.");
                        }
                        return CSIUtil.getInstance().parseCert(this.val$cert_chain_final);
                    }
                };
                try {
                    var2_5 = (String)ContextManagerFactory.getInstance().runAsSystem((PrivilegedExceptionAction)var14_26);
                    if (var2_5 == null) {
                        if (ltpaLoginModule.tc.isDebugEnabled()) {
                            Tr.debug(ltpaLoginModule.tc, "Client certificate did not map to uid.");
                        }
                        throw new WSLoginFailedException("Client certificate did not map to uid.");
                    }
                }
                catch (PrivilegedActionException var15_28) {
                    FFDCFilter.processException((Throwable)var15_28.getException(), "com.ibm.ws.security.server.ltpa.ltpaLoginModule.login", "518", this);
                    if (ltpaLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(ltpaLoginModule.tc, "Exception parsing client certificate.", new Object[]{var15_28.getException()});
                    }
                    throw new WSLoginFailedException(var15_28.getException().getMessage(), var15_28.getException());
                }
            }
            if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Using uid to mapCredential");
                var13_19 = new StringBuffer("Authenticating \"");
                var13_19.append(var3_6).append('/').append(var2_5).append("\"");
                Tr.debug(ltpaLoginModule.tc, var13_19.toString());
            }
            try {
                if (SecurityConfig.isRegTAM() && !RegistryUtil.checkValidUserifTAM(var2_5, this.registry)) {
                    throw new WSLoginFailedException("User is not valid in Access Manager");
                }
                var13_19 = SecurityConfig.getIntSvrIdIfUsed();
                if (var13_19 != null && this.contextManager.isInternalServerId(var2_5)) {
                    this.credential = this.contextManager.getServerCredential();
                    if (!ltpaLoginModule.tc.isDebugEnabled()) ** GOTO lbl201
                    Tr.debug(ltpaLoginModule.tc, "Got credential from ContextManager: " + this.credential);
                }
                var14_26 = this.registry.createCredential(var2_5);
                this.credential = this.ltpaServer.createLTPAToken((WSCredential)var14_26);
            }
            catch (TokenCreationFailedException var13_20) {
                FFDCFilter.processException((Throwable)var13_20, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "532", this);
                Tr.debug(ltpaLoginModule.tc, "Using uid to mapCredential");
                this.contextManager.setRootException(var13_20);
                throw new WSLoginFailedException(var13_20.getMessage(), var13_20);
            }
            catch (Exception var13_21) {
                FFDCFilter.processException((Throwable)var13_21, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "539", this);
                this.contextManager.setRootException(var13_21);
                throw new WSLoginFailedException(var13_21.getMessage(), var13_21);
            }
        } else if (var5_8 != null) {
            if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Using credential token for authentication");
            }
            try {
                if (var8_11) {
                    if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(ltpaLoginModule.tc, "Converting SSO token to authentication token.");
                    }
                    var12_15 = this.ltpaServer.validateToken(var5_8);
                    var13_19 = var12_15.getAttributes("u");
                    var14_27 = null;
                    if (var13_19 != null && var13_19[0] != null) {
                        var15_29 = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.authenticationTokenFactory");
                        var14_27 = this.ltpaServer.createLTPAToken((String)var13_19[0], var15_29);
                        this.credential = this.ltpaServer.validate(var14_27);
                    }
                }
                if (this.credential != null) ** GOTO lbl201
                this.credential = this.ltpaServer.validate(var5_8);
            }
            catch (WSLoginFailedException var12_17) {
                FFDCFilter.processException((Throwable)var12_17, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "578", this);
                this.contextManager.setRootException(var12_17);
                throw var12_17;
            }
            catch (Exception var12_18) {
                FFDCFilter.processException((Throwable)var12_18, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "584", this);
                this.contextManager.setRootException(var12_18);
                throw new WSLoginFailedException(var12_18.getMessage(), var12_18);
            }
        } else {
            var12_15 = new WSLoginFailedException("ltpaLoginModule: No authentication data");
            this.contextManager.setRootException((Throwable)var12_15);
            throw var12_15;
        }
lbl201:
        // 6 sources

        if (this.credential == null) {
            var12_15 = new WSLoginFailedException("ltpaLoginModule: Credential returned from SAS authentication is null");
            this.contextManager.setRootException((Throwable)var12_15);
            throw var12_15;
        }
        var12_15 = null;
        try {
            this.principal = SubjectHelper.createPrincipal(this.credential);
        }
        catch (WSSecurityException var13_22) {
            if (ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Problem creating principal.", new Object[]{var13_22});
            }
            FFDCFilter.processException((Throwable)var13_22, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "616", this);
            this.contextManager.setRootException(var13_22);
            throw new WSLoginFailedException(var13_22.getMessage(), var13_22);
        }
        catch (Exception var13_23) {
            if (ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Exception creating principal.", new Object[]{var13_23});
            }
            FFDCFilter.processException((Throwable)var13_23, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "623", this);
            this.contextManager.setRootException(var13_23);
            throw new WSLoginFailedException(var13_23.getMessage(), var13_23);
        }
        this.sharedState.put("WSPrincipal", this.principal);
        this.sharedState.put("WSCredential", this.credential);
        this.succeeded = true;
        if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
            Tr.exit(ltpaLoginModule.tc, "login()");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                Tr.debug(tc, "shared state contains: " + this.sharedState.keySet());
                this.principal = (WSPrincipal)this.sharedState.get("WSPrincipal");
                if (this.principal == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("ltpaLoginModule: WSPrincipal is null in commit (phase 2) stage");
                    this.contextManager.setRootException(wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                this.credential = (WSCredential)this.sharedState.get("WSCredential");
                if (this.credential == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("ltpaLoginModule: WSCredential is null in commit (phase 2) stage");
                    this.contextManager.setRootException(wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                                if (!ltpaLoginModule.this.subject.getPrincipals().contains(ltpaLoginModule.this.principal)) {
                                    ltpaLoginModule.this.subject.getPrincipals().add(ltpaLoginModule.this.principal);
                                }
                                if (!ltpaLoginModule.this.subject.getPublicCredentials().contains(ltpaLoginModule.this.credential)) {
                                    ltpaLoginModule.this.credential.set("wssecurity.identity_name", "ClientAuthenticationToken");
                                    ltpaLoginModule.this.credential.set("wssecurity.identity_value", StringBytesConversion.getConvertedBytes(ltpaLoginModule.this.credential.getRealmSecurityName()));
                                    ltpaLoginModule.this.subject.getPublicCredentials().add(ltpaLoginModule.this.credential);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.server.lm.ltpaLoginModule.commit", "725", this);
                        this.contextManager.setRootException(privilegedActionException.getException());
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.ltpaLoginModule.commit", "736", this);
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (ltpaLoginModule.this.principal != null && ltpaLoginModule.this.subject.getPrincipals().contains(ltpaLoginModule.this.principal)) {
                        ltpaLoginModule.this.subject.getPrincipals().remove(ltpaLoginModule.this.principal);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.ltpaLoginModule.run", "847", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                }
                try {
                    if (ltpaLoginModule.this.credential != null && ltpaLoginModule.this.subject.getPublicCredentials().contains(ltpaLoginModule.this.credential)) {
                        ltpaLoginModule.this.subject.getPublicCredentials().remove(ltpaLoginModule.this.credential);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.server.lm.ltpaLoginModule.run", "858", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                }
                if (ltpaLoginModule.this.credential == null) {
                    // empty if block
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.principal = null;
        this.credential = null;
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private void cleanupSharedState() {
        WSPrincipal wSPrincipal;
        Object object;
        Callback[] callbackArray;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSharedState()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing Callbacks, WSPrincipal, and WSCredential from the shared state.");
        }
        if ((callbackArray = (Callback[])this.sharedState.get("Callback")) != null && (object = ((PasswordCallback)callbackArray[1]).getPassword()) != null) {
            ((PasswordCallback)callbackArray[1]).clearPassword();
        }
        if (callbackArray != null) {
            this.sharedState.remove("Callback");
        }
        if ((object = (Object)((WSCredential)this.sharedState.get("WSCredential"))) != null) {
            this.sharedState.remove("WSCredential");
        }
        if ((wSPrincipal = (WSPrincipal)this.sharedState.get("WSPrincipal")) != null) {
            this.sharedState.remove("WSPrincipal");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupSharedState()");
        }
    }
}

