/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.AuthenticationNotSupportedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.ldap.LdapRegistryImpl;
import com.tivoli.mts.PDPrincipal;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Properties;

public class TAMLdapRegistryImpl
extends LdapRegistryImpl {
    private static URL propURL = null;
    private static TraceComponent tc = Tr.register(TAMLdapRegistryImpl.class, null, "com.ibm.ejs.resources.security");

    public void initialize(Properties properties) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        super.initialize(properties);
        String string = null;
        if (properties != null) {
            string = (String)properties.get("com.ibm.websphere.security.registry.TAMPropURL");
        }
        try {
            if (string != null && string.length() > 0) {
                if (string.startsWith("$")) {
                    string = SecurityConfig.expandString(string);
                }
                propURL = new File(string).toURL();
                if (tc.isDebugEnabled() && propURL != null) {
                    Tr.debug(tc, "URL is: " + propURL);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", "55", this);
            Tr.error(tc, "security.registry.ldap.initerror", new Object[]{malformedURLException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
            throw new CustomRegistryException(malformedURLException.toString(), malformedURLException);
        }
        Tr.audit(tc, "security.registry.TAM.initialize");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    protected String authenticate(String string, String string2) throws AuthenticationFailedException, AuthenticationNotSupportedException, RegistryErrorException, CustomRegistryException {
        long l = 0L;
        String string3 = LdapRegistryImpl.escapeChar(string, '*');
        try {
            l = System.currentTimeMillis();
            PDPrincipal pDPrincipal = new PDPrincipal(string, string2.toCharArray(), propURL);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authenticated the user: " + string + " using AM");
                StringBuffer stringBuffer = new StringBuffer("Time elapsed to open/close DirContext: ");
                stringBuffer = stringBuffer.append(System.currentTimeMillis() - l);
                Tr.debug(tc, stringBuffer.toString());
            }
            return string;
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.authenticate", "111", this);
            Tr.error(tc, "security.authn.error", new Object[]{string, nullPointerException});
            throw new AuthenticationFailedException(nullPointerException.getMessage(), nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.authenticate", "117", this);
            Tr.error(tc, "security.authn.error", new Object[]{string, illegalArgumentException});
            throw new AuthenticationFailedException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.authenticate", "122", this);
            Tr.error(tc, "security.authn.error", new Object[]{string, illegalStateException});
            throw new AuthenticationFailedException(illegalStateException.getMessage(), illegalStateException);
        }
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser", string);
        }
        try {
            PDPrincipal pDPrincipal = new PDPrincipal(string, propURL);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Verified the user: " + string + " using AM");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidUser", string);
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.isValidUser", "141", this);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{string, nullPointerException});
            throw new CustomRegistryException(nullPointerException.getMessage(), nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.isValidUser", "146", this);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{string, illegalArgumentException});
            throw new CustomRegistryException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.isValidUser", "151", this);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{string, illegalStateException});
            throw new CustomRegistryException(illegalStateException.getMessage(), illegalStateException);
        }
    }
}

