/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.profiletask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ApplyProfileSecuritySettings
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ApplyProfileSecuritySettings.class, "ApplyProfileSecuritySettings", "com.ibm.ws.security.profiletask");
    String enableAdmin = null;
    Boolean enableAdminSec = new Boolean(false);
    String adminUser = null;
    String adminPwd = null;
    static final String wimUR = "WIMUserRegistry";

    public ApplyProfileSecuritySettings(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ApplyProfileSecuritySettings(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return MessageFormatHelper.getFormattedMessage(resourceBundle, string, objectArray);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        this.enableAdmin = (String)this.getParameter("enableAdmin");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enableAdmin = " + this.enableAdmin);
        }
        if (this.enableAdmin.equalsIgnoreCase("true")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enableAdminSec = true");
            }
            this.enableAdminSec = new Boolean(true);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enableAdminSec = false");
            }
            this.enableAdminSec = new Boolean(false);
        }
        if (this.enableAdmin.equalsIgnoreCase("true")) {
            this.adminUser = (String)this.getParameter("adminUser");
            this.adminPwd = (String)this.getParameter("adminPwd");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enableAdmin: " + this.enableAdminSec.toString());
            if (this.adminUser != null && this.adminPwd != null) {
                Tr.debug(tc, "adminUser: " + this.adminUser);
                Tr.debug(tc, "adminPwd: " + this.adminPwd);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void afterStepsExecuted() {
        Object var2_1 = null;
        Object var3_2 = null;
        Boolean bl = new Boolean(false);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            block28: {
                CommandResult commandResult;
                AdminCommand adminCommand;
                Object object;
                Session session;
                block32: {
                    block31: {
                        Object object2;
                        block30: {
                            block29: {
                                AttributeList attributeList;
                                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Security");
                                ConfigService configService = ConfigServiceFactory.getConfigService();
                                session = this.getConfigSession();
                                ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "cell = " + objectName3.toString());
                                }
                                if (objectName3 != null) {
                                    objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
                                }
                                AttributeList attributeList2 = new AttributeList();
                                attributeList2.add(new Attribute("enabled", this.enableAdminSec));
                                configService.setAttributes(session, objectName, attributeList2);
                                if (!this.enableAdminSec.booleanValue()) break block28;
                                AttributeList attributeList3 = new AttributeList();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "enableAdminSec = true, setting application security to false");
                                }
                                attributeList3.add(new Attribute("appEnabled", bl));
                                ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "userRegistries");
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    attributeList = (AttributeList)arrayList.get(i);
                                    object2 = ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Type");
                                    if (!object2.toString().equals(wimUR)) continue;
                                    object = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList), null);
                                    attributeList3.add(new Attribute("activeUserRegistry", object[0]));
                                }
                                configService.setAttributes(session, objectName, attributeList3);
                                ObjectName objectName4 = (ObjectName)configService.getAttribute(session, objectName, "activeUserRegistry");
                                attributeList = new AttributeList();
                                attributeList.add(new Attribute("realm", "defaultWIMFileBasedRealm"));
                                configService.setAttributes(session, objectName4, attributeList);
                                object2 = wimUR;
                                object = CommandMgr.getCommandMgr();
                                adminCommand = ((CommandMgr)object).createCommand("addAdminIdToUserRegObj");
                                adminCommand.setConfigSession(session);
                                adminCommand.setParameter("adminUser", this.adminUser);
                                adminCommand.setParameter("registryType", object2);
                                adminCommand.execute();
                                commandResult = adminCommand.getCommandResult();
                                if (!commandResult.isSuccessful()) break block29;
                                if (((Boolean)commandResult.getResult()).booleanValue()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Successfully set adminId in user registry object");
                                    }
                                    break block30;
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Could not successfully set adminId in user registry object");
                                    }
                                    String string = this.getMsg(resBundle, "security.profiletask.FailedAddAdminId", null);
                                    taskCommandResultImpl.addWarnings(string);
                                    taskCommandResultImpl.setResult(new Boolean(false));
                                    return;
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Could not successfully set adminId in user registry object");
                            }
                            String string = this.getMsg(resBundle, "security.profiletask.FailedAddAdminId", null);
                            taskCommandResultImpl.addWarnings(string);
                            taskCommandResultImpl.setResult(new Boolean(false));
                            return;
                        }
                        object = CommandMgr.getCommandMgr();
                        adminCommand = ((CommandMgr)object).createCommand("setUseRegistryServerId");
                        adminCommand.setConfigSession(session);
                        adminCommand.setParameter("userRegistryType", object2);
                        adminCommand.setParameter("useRegistryServerId", new Boolean(false));
                        adminCommand.execute();
                        commandResult = adminCommand.getCommandResult();
                        if (!commandResult.isSuccessful()) break block31;
                        if (((Boolean)commandResult.getResult()).booleanValue()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Successfully set useRegistryServerId to false");
                            }
                            break block32;
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Could not successfully set useRegistryServerId to false");
                            }
                            String string = this.getMsg(resBundle, "security.admintask.ExceptionUseRegistryServerId", null);
                            taskCommandResultImpl.addWarnings(string);
                            taskCommandResultImpl.setResult(new Boolean(false));
                            return;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not successfully set useRegistryServerId to false");
                    }
                    String string = this.getMsg(resBundle, "security.admintask.ExceptionUseRegistryServerId", null);
                    taskCommandResultImpl.addWarnings(string);
                    taskCommandResultImpl.setResult(new Boolean(false));
                    return;
                }
                if (this.adminUser != null && this.adminUser.length() != 0 && this.adminPwd != null && this.adminPwd.length() != 0) {
                    try {
                        object = CommandMgr.getCommandMgr();
                        adminCommand = ((CommandMgr)object).createCommand("addFileRegistryAccount");
                        adminCommand.setConfigSession(session);
                        adminCommand.setParameter("userId", this.adminUser);
                        adminCommand.setParameter("password", this.adminPwd);
                        adminCommand.execute();
                        commandResult = adminCommand.getCommandResult();
                        if (commandResult.isSuccessful()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "user " + this.adminUser + " added to WIM UR");
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "user " + this.adminUser + " not added toWIM UR");
                            }
                            String string = this.getMsg(resBundle, "security.profiletask.failAddingAdminToWim", null);
                            taskCommandResultImpl.addWarnings(string);
                            taskCommandResultImpl.setResult(new Boolean(false));
                            return;
                        }
                        taskCommandResultImpl.setResult(new Boolean(true));
                    }
                    catch (Exception exception) {
                        taskCommandResultImpl.setResult(new Boolean(false));
                        String string = this.getMsg(resBundle, "security.profiletask.failAddingAdminToWim", null);
                        taskCommandResultImpl.setException(new CommandException(exception, string));
                        return;
                    }
                }
            }
            taskCommandResultImpl.setResult(new Boolean(true));
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, throwable.toString());
                Tr.debug(tc, throwable.getMessage());
            }
            String string = this.getMsg(resBundle, "security.profiletask.failAddingAdminToWim", null);
            taskCommandResultImpl.addWarnings(string);
            taskCommandResultImpl.setResult(new Boolean(false));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

