/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.profiletask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AddAdminIdToUserRegObj
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(AddAdminIdToUserRegObj.class, "AddAdminIdToUserRegObj", "com.ibm.ws.security.profiletask");
    private String adminUser = null;
    private String userRegistryType = null;
    ConfigService cs = null;
    Session session = null;
    static final String ldapUR = "LDAPUserRegistry";
    static final String wimUR = "WIMUserRegistry";
    static final String customUR = "CustomUserRegistry";
    static final String localOSUR = "LocalOSUserRegistry";

    public AddAdminIdToUserRegObj(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public AddAdminIdToUserRegObj(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return MessageFormatHelper.getFormattedMessage(resourceBundle, string, objectArray);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.adminUser = (String)this.getParameter("adminUser");
        this.userRegistryType = (String)this.getParameter("registryType");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName objectName = null;
        Object var2_2 = null;
        Object var3_3 = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "unsuccessful at getting TaskCommandResultImpl afterStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell = " + objectName3.toString());
            }
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            AttributeList attributeList = new AttributeList();
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "userRegistries");
            for (int i = 0; i < arrayList.size(); ++i) {
                AttributeList attributeList2 = (AttributeList)arrayList.get(i);
                Object object = ConfigServiceHelper.getAttributeValue(attributeList2, "_Websphere_Config_Data_Type");
                if (!object.toString().equals(this.userRegistryType)) continue;
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(attributeList2), null);
                attributeList.add(new Attribute("activeUserRegistry", objectNameArray[0]));
            }
            configService.setAttributes(session, objectName, attributeList);
            ObjectName objectName4 = (ObjectName)configService.getAttribute(session, objectName, "activeUserRegistry");
            attributeList = new AttributeList();
            attributeList.add(new Attribute("primaryAdminId", this.adminUser));
            configService.setAttributes(session, objectName4, attributeList);
            taskCommandResultImpl.setResult(new Boolean(true));
        }
        catch (Throwable throwable) {
            String string = this.getMsg(resBundle, "security.profiletask.FailedAddAdminId", null);
            taskCommandResultImpl.addWarnings(string);
            taskCommandResultImpl.setResult(new Boolean(false));
            taskCommandResultImpl.setException(new CommandException(string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

