/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.policy.ApplicationParserTr;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.FilePathUtil;
import com.ibm.ws.security.policy.FilterParser;
import com.ibm.ws.security.policy.FilterParserTr;
import com.ibm.ws.security.policy.Parser;
import com.ibm.ws.security.policy.PolicyTemplate;
import com.ibm.ws.security.policy.SystemExtensionParserTr;
import com.ibm.ws.security.util.ParserException;
import java.io.File;
import java.io.FilePermission;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.ResourceAdapter;
import org.eclipse.jst.j2ee.jca.SecurityPermission;

public final class WSDynamicPolicy
extends Policy
implements DynamicPolicy {
    private Policy policy;
    private boolean expandProp = true;
    private List codeSourceList = new ArrayList(256);
    private Map csPermsHashMap = new HashMap(256);
    private Map templates = new HashMap(5);
    private ArrayList staticFilterPermissions = new ArrayList();
    private ArrayList runtimeFilterPermissions = new ArrayList();
    private String cellDir;
    private String nodeDir;
    private String nodeName;
    private String cellName;
    private String srvrName;
    private final boolean debug = Boolean.getBoolean("com.ibm.ws.security.policy.DynamicPolicy.debug");
    private static boolean wccmWarningFlag = true;
    private static final String WAS_POLICY = "/META-INF/was.policy";
    private static final PrivilegedAction getUserDirAction = new PrivilegedAction(){

        public Object run() {
            String string = System.getProperty("user.dir");
            return string == null ? "" : string;
        }
    };
    private File file;
    private String newPath;
    private boolean endsWithMinus = false;
    private boolean endsWithStar = false;
    private ProtectionDomain self = null;
    private static final String MINUS_TRAIL = File.separator + "-";
    private static final String STAR_TRAIL = File.separator + "*";
    private static final TraceComponent tc = Tr.register(WSDynamicPolicy.class, null, "com.ibm.ejs.resources.security");

    public WSDynamicPolicy(Policy policy, Repository repository2) throws IOException, ParserException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSDynamicPolicy(" + policy + ", " + repository2 + ")");
        }
        final WSDynamicPolicy wSDynamicPolicy = this;
        this.self = (ProtectionDomain)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return wSDynamicPolicy.getClass().getProtectionDomain();
            }
        });
        String string = null;
        InputStreamReader inputStreamReader = null;
        try {
            string = System.getProperty("java.security.policy");
            if (string.charAt(0) == '=') {
                string = string.substring(1);
            }
            inputStreamReader = new FileReader(string);
            ApplicationParserTr applicationParserTr = new ApplicationParserTr(inputStreamReader, true);
            applicationParserTr.parse();
            if (tc.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Contents of ");
                stringBuffer.append(string).append(": ").append(Parser.NEW_LINE);
                Iterator iterator = applicationParserTr.grants.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(Parser.NEW_LINE);
                    stringBuffer.append(iterator.next().toString());
                }
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        catch (ParserException parserException) {
            Tr.error(tc, "security.policy.parser.syntax.error", new Object[]{string, parserException});
            throw parserException;
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
        this.policy = policy;
        this.cellName = repository2.getCellName();
        this.cellDir = repository2.getRootURI() + File.separator + "cells" + File.separator + this.cellName;
        this.nodeName = repository2.getNodeName();
        this.srvrName = repository2.getServerName();
        this.nodeDir = this.cellDir + File.separator + "nodes" + File.separator + this.nodeName;
        this.cellDir = this.cellDir.replace('/', File.separatorChar);
        this.nodeDir = this.nodeDir.replace('/', File.separatorChar);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellDir = " + this.cellDir);
            Tr.debug(tc, "nodeDir = " + this.nodeDir);
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSDynamicPolicy()");
        }
    }

    public final PermissionCollection getPermissions(CodeSource codeSource) {
        CodeSource codeSource2;
        if (codeSource != null && (codeSource2 = this.canonicalized(codeSource)) != null) {
            codeSource = codeSource2;
        }
        return this.getPermissions_s(codeSource);
    }

    public final ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        CodeSource codeSource2;
        ProtectionDomain protectionDomain = null;
        if (codeSource != null && (codeSource2 = this.canonicalized(codeSource)) != null) {
            protectionDomain = new ProtectionDomain(codeSource2, this.getPermissions_s(codeSource2));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created protection domain:  " + protectionDomain);
            }
        }
        return protectionDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getPermissions_s(CodeSource codeSource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissions_s", codeSource);
        }
        PermissionCollection permissionCollection = this.policy.getPermissions(codeSource);
        if (codeSource != null) {
            WSDynamicPolicy wSDynamicPolicy = this;
            synchronized (wSDynamicPolicy) {
                int n = this.codeSourceList.size();
                for (int i = 0; i < n; ++i) {
                    CodeSource codeSource2 = (CodeSource)this.codeSourceList.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cs(" + i + ") = " + codeSource2);
                    }
                    if (!codeSource2.implies(codeSource)) continue;
                    ArrayList arrayList = (ArrayList)this.csPermsHashMap.get(codeSource2);
                    int n2 = arrayList.size();
                    for (int j = 0; j < n2; ++j) {
                        permissionCollection.add((Permission)arrayList.get(j));
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, codeSource2 + " implies " + codeSource + ", permissions added " + arrayList);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Effective Policy for " + codeSource + " = " + permissionCollection);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissions_s");
        }
        return permissionCollection;
    }

    public final PermissionCollection getPermissions(CodeSource codeSource, Map map) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissions", new Object[]{codeSource, map});
        }
        if (codeSource != null && (serializable = this.canonicalized(codeSource)) != null) {
            codeSource = serializable;
        }
        serializable = this.getPermissions_s(codeSource);
        if (codeSource != null) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                CodeSource codeSource2 = (CodeSource)iterator.next();
                if (!codeSource2.implies(codeSource)) continue;
                ArrayList arrayList = (ArrayList)map.get(codeSource2);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ((PermissionCollection)serializable).add((Permission)arrayList.get(i));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, codeSource2 + " implies " + codeSource + ", permissions added " + arrayList);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Effective Policy(Application and library) for " + codeSource + " = " + serializable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissions(Map, CodeSource)");
        }
        return serializable;
    }

    public final void refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh()");
        }
        this.policy.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh()");
        }
    }

    public final void getSecurityPolicy(Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityPolicy", new Object[]{map, map2});
        }
        String string = null;
        try {
            string = (String)map.get("type");
        }
        catch (Exception exception) {
            Tr.error(tc, "security.policy.param.setupPolicy", new Object[]{exception, "type"});
            return;
        }
        if (string.equals("library")) {
            ArrayList arrayList;
            WSPolicyTemplate wSPolicyTemplate = null;
            try {
                wSPolicyTemplate = (WSPolicyTemplate)this.templates.get(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "templete for library.policy -> " + wSPolicyTemplate);
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "security.policy.sysext.param", new Object[]{exception, string});
                return;
            }
            if (wSPolicyTemplate != null && (arrayList = wSPolicyTemplate.get("${default}")) != null) {
                int n;
                ArrayList arrayList2 = (ArrayList)arrayList.clone();
                String[] stringArray = (String[])map.get("classpath");
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("classpath: [ ");
                    if (stringArray == null) {
                        stringBuffer.append("<null>");
                    } else {
                        n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            stringBuffer.append(stringArray[i]).append(" ");
                        }
                    }
                    stringBuffer.append("]");
                    Tr.debug(tc, stringBuffer.toString());
                }
                if (stringArray != null) {
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        this.updateCodeSourceRepository(stringArray[n], arrayList2, map2);
                    }
                }
            }
        } else if (string.equals("application")) {
            DynamicPolicy.Application application;
            try {
                application = (DynamicPolicy.Application)map.get("application");
            }
            catch (Exception exception) {
                Tr.error(tc, "security.policy.param.setupPolicy", new Object[]{exception, "deployedApp"});
                return;
            }
            if (application != null) {
                Object object;
                Object object2;
                String string2;
                WSPolicyTemplate wSPolicyTemplate;
                block59: {
                    wSPolicyTemplate = null;
                    string2 = application.getbinarypath();
                    String string3 = application.getpathToWasPolicy();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Load was.policy from " + string3);
                    }
                    File file = new File(string3);
                    try {
                        if (file.exists()) {
                            wSPolicyTemplate = this.loadWasPolicyTemplate(file, string3);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not load was.policy because " + file.getCanonicalPath() + " does not exist");
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block59;
                        object2 = new StringWriter();
                        object = new PrintWriter((Writer)object2);
                        exception.printStackTrace((PrintWriter)object);
                        Tr.debug(tc, "Caught an Exception while trying to load was policy file " + ((StringWriter)object2).toString());
                    }
                }
                WSPolicyTemplate wSPolicyTemplate2 = (WSPolicyTemplate)this.templates.get(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "template for app.policy -> " + wSPolicyTemplate2);
                    Tr.debug(tc, "template for was.policy -> " + wSPolicyTemplate);
                }
                if (wSPolicyTemplate != null) {
                    wSPolicyTemplate.addAll(wSPolicyTemplate2);
                } else if (wSPolicyTemplate2 != null) {
                    wSPolicyTemplate = new WSPolicyTemplate();
                    wSPolicyTemplate.addAll(wSPolicyTemplate2);
                }
                object2 = application.getbinarypath();
                if (wSPolicyTemplate != null) {
                    object = new StringBuffer((String)object2);
                    ((StringBuffer)object).append(File.separator).append("-");
                    CodeSource codeSource = this.createCodeSource(((StringBuffer)object).toString());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, (String)object2 + " --> " + codeSource);
                    }
                    this.expandAppTemplates(codeSource, wSPolicyTemplate, "${application}", null, string2, null, map2);
                }
                object = application.getmodules();
                int n = ((DynamicPolicy.Module[])object).length;
                for (int i = 0; i < n; ++i) {
                    Object object3 = object[i];
                    if (object3 == null) continue;
                    String string4 = ((DynamicPolicy.Module)object3).getmoduleName();
                    String string5 = ((DynamicPolicy.Module)object3).gettype();
                    String[] stringArray = ((DynamicPolicy.Module)object3).getclasspaths();
                    if (tc.isDebugEnabled()) {
                        int n3 = stringArray.length;
                        if (n3 == 1) {
                            Tr.debug(tc, "module[" + i + "] : " + string4 + " type:" + string5 + " path[] = " + stringArray[0]);
                        } else {
                            Tr.debug(tc, "module[" + i + "] : " + string4 + " type:" + string5);
                            for (int j = 0; j < n3; ++j) {
                                Tr.debug(tc, "                     path[ " + j + "] = " + stringArray[j]);
                            }
                        }
                    }
                    if (string5.equals("RARFile")) {
                        WSPolicyTemplate wSPolicyTemplate3 = null;
                        wSPolicyTemplate3 = this.loadRAPolicyTemplate((DynamicPolicy.Module)object3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "template for ra.xml -> " + wSPolicyTemplate3);
                        }
                        if (wSPolicyTemplate != null) {
                            wSPolicyTemplate.addAll(wSPolicyTemplate3);
                        } else if (wSPolicyTemplate3 != null) {
                            wSPolicyTemplate = wSPolicyTemplate3;
                        }
                    }
                    CodeSource codeSource = null;
                    String string6 = null;
                    String string7 = string2 + File.separator + string4;
                    if (wSPolicyTemplate == null || stringArray == null) continue;
                    int n4 = stringArray.length;
                    for (int j = 0; j < n4; ++j) {
                        String string8 = null;
                        string6 = stringArray[j];
                        try {
                            StringBuffer stringBuffer = new StringBuffer(string6);
                            if (string5.equals("web") || string5.equals("connector")) {
                                stringBuffer.append(File.separator).append("-");
                            } else if (string5.equals("ejb") || string5.equals("RARFile")) {
                                int n5 = string6.indexOf(".jar");
                                if (n5 == -1) {
                                    stringBuffer.append(File.separator).append("-");
                                } else if (n5 + 4 != string6.length()) {
                                    stringBuffer.append(File.separator).append("-");
                                }
                            }
                            codeSource = this.createCodeSource(stringBuffer.toString());
                        }
                        catch (Exception exception) {
                            Tr.warning(tc, "security.policy.module.path", (Object)new Object[]{exception, string4});
                        }
                        if (string5.equals("ejb")) {
                            this.expandAppTemplates(codeSource, wSPolicyTemplate, "${ejbcomponent}", string4, string2, string7, map2);
                            continue;
                        }
                        if (string5.equals("web")) {
                            this.expandAppTemplates(codeSource, wSPolicyTemplate, "${webcomponent}", string4, string2, string7, map2);
                            continue;
                        }
                        if (string5.equals("connector")) {
                            this.expandAppTemplates(codeSource, wSPolicyTemplate, "${connectorcomponent}", string4, string2, string7, map2);
                            continue;
                        }
                        if (string5.equals("RARFile")) {
                            this.expandAppTemplates(codeSource, wSPolicyTemplate, "${default}", string4, string2, string7, map2);
                            this.expandAppTemplates(codeSource, wSPolicyTemplate, "${connectorcomponent}", string4, string2, string7, map2);
                            continue;
                        }
                        if (!string5.equals("utility")) continue;
                        try {
                            int n6 = string6.lastIndexOf(File.separatorChar);
                            string8 = n6 + 1 <= string6.length() ? string6.substring(n6 + 1, string6.length()) : null;
                            StringBuffer stringBuffer = new StringBuffer(string6);
                            codeSource = this.createCodeSource(stringBuffer.toString());
                        }
                        catch (Exception exception) {
                            Tr.warning(tc, "security.policy.module.path", (Object)new Object[]{exception, string4});
                        }
                        this.expandAppTemplates(codeSource, wSPolicyTemplate, "${jars}", string8, string2, string6, map2);
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Incorrect type" + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityPolicy()");
        }
    }

    public final void setupPolicy(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupPolicy(" + map + ")");
        }
        String string = null;
        try {
            string = (String)map.get("type");
        }
        catch (Exception exception) {
            Tr.error(tc, "security.policy.param.setupPolicy", new Object[]{exception, "type"});
            return;
        }
        if (string.equals("spi")) {
            ArrayList arrayList;
            WSPolicyTemplate wSPolicyTemplate = null;
            try {
                wSPolicyTemplate = (WSPolicyTemplate)this.templates.get(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Policy Template[" + string + "] = " + wSPolicyTemplate);
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "security.policy.sysext.param", new Object[]{exception, string});
                return;
            }
            if (wSPolicyTemplate != null && (arrayList = wSPolicyTemplate.get("${default}")) != null) {
                int n;
                ArrayList arrayList2 = (ArrayList)arrayList.clone();
                String[] stringArray = (String[])map.get("classpath");
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("classpath: [ ");
                    if (stringArray == null) {
                        stringBuffer.append("<null>");
                    } else {
                        for (n = 0; n < stringArray.length; ++n) {
                            stringBuffer.append(stringArray[n]).append(" ");
                        }
                    }
                    stringBuffer.append("]");
                    Tr.debug(tc, stringBuffer.toString());
                }
                if (stringArray != null) {
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String string2 = stringArray[n];
                        if (string2 == null || string2.length() == 0) continue;
                        this.updateCodeSourceRepository(string2, arrayList2, null);
                    }
                }
            }
        } else if (string.equals("ra")) {
            Object object;
            RARFile rARFile = null;
            try {
                rARFile = (RARFile)map.get("RARFile");
            }
            catch (Exception exception) {
                Tr.error(tc, "security.policy.rarfile", new Object[]{exception, "RARFile"});
                return;
            }
            String string3 = null;
            try {
                if (rARFile.getEARFile() == null) {
                    string3 = rARFile.getAbsolutePath();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "rarFile.getAbsolutePath()" + rARFile);
                    }
                } else {
                    string3 = rARFile.getEARFile().getAbsolutePath() + File.separator + rARFile.getURI();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "earPath#rarPath" + string3);
                    }
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "security.policy.rarfile", new Object[]{exception, "RARFile"});
                return;
            }
            CodeSource codeSource = null;
            try {
                object = new StringBuffer(string3);
                ((StringBuffer)object).append(File.separator).append("-");
                codeSource = this.createCodeSource(((StringBuffer)object).toString());
            }
            catch (Exception exception) {
                Tr.error(tc, "security.policy.rar.path", new Object[]{exception});
                return;
            }
            object = null;
            object = this.loadRAPolicyTemplate(rARFile);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Policy Template for ra.xml -> " + object);
            }
            if (object != null) {
                this.expandAppTemplates(codeSource, (WSPolicyTemplate)object, "${default}", null, null, null, null);
            }
            WSPolicyTemplate wSPolicyTemplate = (WSPolicyTemplate)this.templates.get("application");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template for app.policy -> " + wSPolicyTemplate);
            }
            if (wSPolicyTemplate != null) {
                this.expandAppTemplates(codeSource, wSPolicyTemplate, "${connectorcomponent}", null, null, null, null);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Incorrect type" + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupPolicy()");
        }
    }

    private void expandAppTemplates(CodeSource codeSource, WSPolicyTemplate wSPolicyTemplate, String string, String string2, String string3, String string4, Map map) {
        ArrayList arrayList;
        ArrayList arrayList2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandAppTemplates(" + codeSource + ", " + wSPolicyTemplate + ", " + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + map + ")");
        }
        if ((arrayList2 = wSPolicyTemplate.get(string)) == null) {
            arrayList2 = new ArrayList(10);
        }
        if (string2 != null && (arrayList = wSPolicyTemplate.get(string2)) != null) {
            arrayList2.addAll(arrayList);
        }
        if (arrayList2 != null && arrayList2.size() != 0) {
            if (string3 == null && string4 == null) {
                this.updateCodeSourceRepository(codeSource, arrayList2, map);
            } else {
                this.updateCodeSourceRepository(codeSource, arrayList2, string3, string4, map);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandAppTemplates(CodeSource, WSPolicyTemplate, String, String, String, String, Map)");
        }
    }

    public final void removePolicy(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePolicy(" + map + ")");
        }
        String string = null;
        try {
            string = (String)map.get("type");
        }
        catch (Exception exception) {
            Tr.error(tc, "security.policy.param.setupPolicy", new Object[]{exception, "type"});
            return;
        }
        if (string.equals("spi")) {
            String[] stringArray = (String[])map.get("classpath");
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    try {
                        URL uRL = FilePathUtil.filePathToURL(new File(stringArray[i]));
                        CodeSource codeSource = new CodeSource(uRL, (Certificate[])null);
                        this.removeCodeSource(codeSource);
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        Tr.warning(tc, "security.policy.malformedURL", (Object)new Object[]{malformedURLException, stringArray[i]});
                    }
                }
            }
        } else if (string.equals("ra")) {
            RARFile rARFile = null;
            try {
                rARFile = (RARFile)map.get("RARFile");
            }
            catch (Exception exception) {
                Tr.error(tc, "security.policy.rarfile", new Object[]{exception, "RARFile"});
                return;
            }
            String string2 = null;
            try {
                if (rARFile.getEARFile() == null) {
                    string2 = rARFile.getAbsolutePath();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "rarFile.getAbsolutePath()" + rARFile);
                    }
                } else {
                    string2 = rARFile.getEARFile().getAbsolutePath() + File.separator + rARFile.getURI();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "earPath#rarPath" + string2);
                    }
                }
            }
            catch (Exception exception) {
                Tr.error(tc, "security.policy.rarfile", new Object[]{exception, "RARFile"});
                return;
            }
            CodeSource codeSource = null;
            try {
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.append(File.separator).append("-");
                codeSource = this.createCodeSource(stringBuffer.toString());
            }
            catch (Exception exception) {
                Tr.warning(tc, "security.policy.removepolicy.rarpath", (Object)new Object[]{exception, rARFile.getName()});
            }
            this.removeCodeSource(codeSource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePolicy()");
        }
    }

    public final PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissions");
        }
        PermissionCollection permissionCollection = null;
        if (this.self == protectionDomain && this.self != null) {
            permissionCollection = new Permissions();
            permissionCollection.add(new AllPermission());
        } else {
            PermissionCollection permissionCollection2;
            permissionCollection = super.getPermissions(protectionDomain);
            if (this.policy != null && (permissionCollection2 = this.policy.getPermissions(protectionDomain)) != null) {
                Enumeration<Permission> enumeration = permissionCollection2.elements();
                while (enumeration.hasMoreElements()) {
                    permissionCollection.add(enumeration.nextElement());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissions", permissionCollection);
        }
        return permissionCollection;
    }

    public final boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        boolean bl = false;
        if (this.self == protectionDomain && this.self != null) {
            bl = true;
        } else {
            bl = super.implies(protectionDomain, permission);
            if (!bl && this.policy != null) {
                bl = this.policy.implies(protectionDomain, permission);
            }
        }
        return bl;
    }

    private void init() {
        block23: {
            block22: {
                block21: {
                    String string;
                    String string2;
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "init()");
                    }
                    if ((string2 = Security.getProperty("policy.expandProperties")) != null) {
                        this.expandProp = string2.equalsIgnoreCase("true");
                    }
                    if ((string = System.getProperty("ws.filter.policy")) == null || string.length() == 0) {
                        string = this.cellDir + File.separator + "filter.policy";
                    }
                    string = string.replace('/', File.separatorChar);
                    File file = new File(string);
                    try {
                        if (file.exists()) {
                            this.setupPolicyFilterPermissions(file);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not load default filter.policy file because " + file.getCanonicalPath() + " does not exist");
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block21;
                        Tr.debug(tc, "Caught an Exception while trying to load filter policy");
                    }
                }
                String string = System.getProperty("ws.spi.policy");
                if (string == null || string.length() == 0) {
                    string = this.nodeDir + File.separator + "spi.policy";
                }
                string = string.replace('/', File.separatorChar);
                File file = new File(string);
                try {
                    if (file.exists()) {
                        this.loadSystemExtensionPolicyTemplate("spi", file);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not load spi.policy file because " + file.getCanonicalPath() + " does not exist");
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block22;
                    Tr.debug(tc, "Caught an Exception while trying to load spi policy");
                }
            }
            String string = System.getProperty("ws.library.policy");
            if (string == null || string.length() == 0) {
                string = this.nodeDir + File.separator + "library.policy";
            }
            string = string.replace('/', File.separatorChar);
            File file = new File(string);
            try {
                if (file.exists()) {
                    this.loadSystemExtensionPolicyTemplate("library", file);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not load library.policy file because " + file.getCanonicalPath() + " does not exist");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block23;
                Tr.debug(tc, "Caught an IOException while trying to load library policy");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public final void initApplicationTemplate(Boolean bl) {
        block6: {
            wccmWarningFlag = bl;
            String string = System.getProperty("ws.app.policy");
            if (string == null || string.length() == 0) {
                string = this.nodeDir + File.separator + "app.policy";
            }
            string = string.replace('/', File.separatorChar);
            File file = new File(string);
            try {
                if (file.exists()) {
                    this.loadApplicationPolicyTemplate(file, string);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not load app.policy because " + file.getCanonicalPath() + " does not exist");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Caught an Exception while trying to load app policy");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSystemExtensionPolicyTemplate(String string, File file) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            SystemExtensionParserTr systemExtensionParserTr = new SystemExtensionParserTr(fileReader, this.expandProp);
            systemExtensionParserTr.parse();
            Iterator iterator = systemExtensionParserTr.grantEntries();
            WSPolicyTemplate wSPolicyTemplate = new WSPolicyTemplate();
            while (iterator.hasNext()) {
                wSPolicyTemplate.add((Parser.GrantEntry)iterator.next());
            }
            this.templates.put(string, wSPolicyTemplate);
        }
        catch (IOException iOException) {
            Tr.error(tc, "security.policy.sysext.ioexception", new Object[]{iOException, string});
        }
        catch (ParserException parserException) {
            Tr.error(tc, "security.policy.sysext.parserexception", new Object[]{parserException, string});
        }
        finally {
            block18: {
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Error closing FileReader for SysExtPolicyTemplate");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadApplicationPolicyTemplate(File file, String string) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            ApplicationParserTr applicationParserTr = new ApplicationParserTr(fileReader, this.expandProp);
            applicationParserTr.parse();
            Iterator iterator = applicationParserTr.grantEntries();
            WSPolicyTemplate wSPolicyTemplate = new WSPolicyTemplate();
            while (iterator.hasNext()) {
                Parser.GrantEntry grantEntry = (Parser.GrantEntry)iterator.next();
                String string2 = grantEntry.codeBase;
                if (string2 == null || string2.length() == 0) {
                    grantEntry.codeBase = "${application}";
                    string2 = "${application}";
                }
                if (applicationParserTr.isStandardSymbl(string2)) {
                    wSPolicyTemplate.add(grantEntry);
                    continue;
                }
                try {
                    File file2;
                    if (string2.startsWith("file:")) {
                        string2 = string2.substring(5, string2.length());
                    }
                    if ((file2 = new File(string2)).isAbsolute()) {
                        Iterator iterator2 = grantEntry.getPermissions();
                        ArrayList<Permission> arrayList = new ArrayList<Permission>();
                        while (iterator2.hasNext()) {
                            arrayList.add(this.getPermissionInstance((Parser.PermissionEntry)iterator2.next()));
                        }
                        this.updateCodeSourceRepository(string2, arrayList, null);
                        continue;
                    }
                    wSPolicyTemplate.add(grantEntry);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unrecognized entry in the policy file" + string2);
                    }
                    wSPolicyTemplate.add(grantEntry);
                }
            }
            this.filter(wSPolicyTemplate, string);
            this.templates.put("application", wSPolicyTemplate);
        }
        catch (IOException iOException) {
            Tr.error(tc, "security.policy.app.ioexception", new Object[]{string, iOException});
        }
        catch (ParserException parserException) {
            Tr.error(tc, "security.policy.app.parserexception", new Object[]{string, parserException});
        }
        finally {
            block26: {
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block26;
                    Tr.debug(tc, "Error closing FileReader for App Policy");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WSPolicyTemplate loadWasPolicyTemplate(File file, String string) {
        WSPolicyTemplate wSPolicyTemplate = new WSPolicyTemplate();
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            ApplicationParserTr applicationParserTr = new ApplicationParserTr(fileReader, this.expandProp);
            applicationParserTr.parse();
            Iterator iterator = applicationParserTr.grantEntries();
            while (iterator.hasNext()) {
                wSPolicyTemplate.add((Parser.GrantEntry)iterator.next());
            }
            this.filter(wSPolicyTemplate, string);
        }
        catch (IOException iOException) {
            Tr.error(tc, "security.policy.was.ioexception", new Object[]{string, iOException});
        }
        catch (ParserException parserException) {
            Tr.error(tc, "security.policy.was.parserexception", new Object[]{string, parserException});
        }
        finally {
            block18: {
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Error closing FileReader for WAS Policy");
                }
            }
        }
        return wSPolicyTemplate;
    }

    private WSPolicyTemplate loadRAPolicyTemplate(RARFile rARFile) {
        Connector connector2 = rARFile.getDeploymentDescriptor();
        ResourceAdapter resourceAdapter = connector2.getResourceAdapter();
        EList eList = resourceAdapter.getSecurityPermissions();
        WSPolicyTemplate wSPolicyTemplate = this.loadRAPolicyTemplate(eList, rARFile.getName());
        return wSPolicyTemplate;
    }

    private WSPolicyTemplate loadRAPolicyTemplate(DynamicPolicy.Module module) {
        List list = module.getpermissions();
        WSPolicyTemplate wSPolicyTemplate = this.loadRAPolicyTemplate(list, module.getmoduleName());
        return wSPolicyTemplate;
    }

    private WSPolicyTemplate loadRAPolicyTemplate(List list, String string) {
        WSPolicyTemplate wSPolicyTemplate = new WSPolicyTemplate();
        for (int i = 0; i < list.size(); ++i) {
            WSPolicyTemplate wSPolicyTemplate2 = new WSPolicyTemplate();
            SecurityPermission securityPermission = (SecurityPermission)list.get(i);
            String string2 = securityPermission.getSpecification();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ra[" + i + "]=" + string2);
            }
            try {
                SystemExtensionParserTr systemExtensionParserTr = new SystemExtensionParserTr(new StringReader(string2), this.expandProp);
                systemExtensionParserTr.parse();
                Iterator iterator = systemExtensionParserTr.grantEntries();
                while (iterator.hasNext()) {
                    wSPolicyTemplate.add((Parser.GrantEntry)iterator.next());
                }
                continue;
            }
            catch (IOException iOException) {
                Tr.error(tc, "security.policy.ratemplate.io", new Object[]{iOException, string});
                continue;
            }
            catch (ParserException parserException) {
                Tr.error(tc, "security.policy.ratemplate.parser", new Object[]{string, string2, parserException});
            }
        }
        return wSPolicyTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupPolicyFilterPermissions(File file) {
        FileReader fileReader = null;
        try {
            Object object;
            Object object2;
            fileReader = new FileReader(file);
            FilterParserTr filterParserTr = new FilterParserTr(fileReader, true);
            filterParserTr.parse();
            FilterParser.FilterEntry filterEntry = filterParserTr.getFilterEntry("filterMask");
            if (filterEntry != null) {
                object2 = filterEntry.getPermissions();
                while (object2.hasNext()) {
                    object = this.getPermissionInstance((Parser.PermissionEntry)object2.next());
                    this.staticFilterPermissions.add(object);
                }
            }
            if ((object2 = filterParserTr.getFilterEntry("runtimeFilterMask")) != null) {
                object = ((FilterParser.FilterEntry)object2).getPermissions();
                while (object.hasNext()) {
                    Permission permission = this.getPermissionInstance((Parser.PermissionEntry)object.next());
                    this.runtimeFilterPermissions.add(permission);
                }
            }
        }
        catch (IOException iOException) {
            Tr.error(tc, "security.policy.filter.ioexception", new Object[]{iOException});
        }
        catch (ParserException parserException) {
            Tr.error(tc, "security.policy.filter.parserexception", new Object[]{parserException});
        }
        finally {
            block21: {
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "Error closing FileReader for filter policy");
                }
            }
        }
    }

    private ArrayList performFiltering(ArrayList arrayList, String string) {
        ArrayList<Permission> arrayList2 = new ArrayList<Permission>();
        boolean bl = true;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object;
            Permission permission = (Permission)iterator.next();
            String string2 = permission.toString();
            if (permission instanceof UnresolvedPermission) {
                Tr.warning(tc, "security.policy.unresolved.permission", (Object)new Object[]{string2, string});
                object = this.createPermission0((UnresolvedPermission)permission);
                if (object != null && !(object instanceof UnresolvedPermission)) {
                    permission = object;
                    string2 = permission.toString();
                } else {
                    Tr.warning(tc, "security.policy.invalid.permission", (Object)new Object[]{string2, string});
                }
            }
            if (!(string2 = string2.startsWith("(unresolved ") ? string2.substring("(unresolved ".length(), string2.length() - 1) : string2.substring(1, string2.length() - 1)).startsWith("java") && !string2.startsWith("javax")) {
                if (wccmWarningFlag) {
                    Tr.warning(tc, "security.policy.wccm.custom.permission", (Object)new Object[]{permission, string});
                }
                arrayList2.add(permission);
            } else if (string2.startsWith("java.security.AllPermission")) {
                Tr.warning(tc, "security.policy.all.permission", (Object)new Object[]{string});
                arrayList2.add(permission);
            } else {
                object = this.staticFilterPermissions.iterator();
                while (object.hasNext() && bl) {
                    Permission permission2 = (Permission)object.next();
                    if (permission2 instanceof UnresolvedPermission) {
                        Tr.warning(tc, "security.policy.unresolved.permission", (Object)new Object[]{permission2, "filter.policy"});
                        Permission permission3 = this.createPermission0((UnresolvedPermission)permission2);
                        if (permission3 != null && !(permission3 instanceof UnresolvedPermission)) {
                            permission2 = permission3;
                        } else {
                            Tr.warning(tc, "security.policy.invalid.filter.permission", (Object)new Object[]{permission2});
                            continue;
                        }
                    }
                    if (permission2.implies(permission)) {
                        bl = false;
                        continue;
                    }
                    if (!permission.implies(permission2)) continue;
                    Tr.audit(tc, "security.policy.imcomplete.filter.permission", new Object[]{permission, string, permission2});
                }
                if (bl) {
                    arrayList2.add(permission);
                } else {
                    Tr.audit(tc, "security.policy.filtered.permission", new Object[]{permission, string});
                }
            }
            bl = true;
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCodeSource(CodeSource codeSource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeCodeSource(" + codeSource + ")");
        }
        WSDynamicPolicy wSDynamicPolicy = this;
        synchronized (wSDynamicPolicy) {
            this.codeSourceList.remove(codeSource);
            this.csPermsHashMap.remove(codeSource);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeCodeSource");
        }
    }

    private void filter(WSPolicyTemplate wSPolicyTemplate, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filter(" + wSPolicyTemplate + ")");
        }
        String[] stringArray = wSPolicyTemplate.getSymbols();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            ArrayList arrayList = wSPolicyTemplate.get(string2);
            wSPolicyTemplate.replace(string2, this.performFiltering(arrayList, string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filter() returns " + wSPolicyTemplate);
        }
    }

    private CodeSource canonicalized(CodeSource codeSource) {
        URL uRL;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canonicalized(" + codeSource + ")");
        }
        CodeSource codeSource2 = codeSource;
        if (codeSource != null && (uRL = codeSource.getLocation()) != null && uRL.getProtocol().equalsIgnoreCase("file")) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            try {
                string = FilePathUtil.decodeFilePath(string);
                if (string == null || string.equals("")) {
                    string = (String)com.ibm.ws.security.util.AccessController.doPrivileged(getUserDirAction);
                }
                codeSource2 = this.createCodeSource(string);
            }
            catch (FilePathUtil.DecodeException decodeException) {
                Tr.error(tc, "security.policy.parser.decodeexception", new Object[]{string, decodeException});
                codeSource2 = codeSource;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canonicalized() returns " + codeSource2);
        }
        return codeSource2;
    }

    private void updateCodeSourceRepository(String string, ArrayList arrayList, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCodeSourceRepository(\"" + string + "\", " + arrayList + "," + map + ")");
        }
        CodeSource codeSource = this.createCodeSource(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Code Source for " + string + " is " + codeSource);
        }
        if (codeSource != null && arrayList != null && arrayList.size() != 0) {
            this.updateCodeSourceRepository(codeSource, arrayList, map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCodeSourceRepository(String, ArrayList, Map)");
        }
    }

    private void updateCodeSourceRepository(String string, ArrayList arrayList, String string2, String string3, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCodeSourceRepository(\"" + string + "\", " + arrayList + ", \"" + string2 + "\",\"" + string3 + "\"," + map + ")");
        }
        CodeSource codeSource = this.createCodeSource(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Code Source for " + string + " is " + codeSource);
        }
        if (codeSource != null && arrayList != null && arrayList.size() != 0) {
            this.updateCodeSourceRepository(codeSource, arrayList, string2, string3, map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCodeSourceRepository(String, ArrayList, String, String, Map)");
        }
    }

    private ArrayList expand(ArrayList arrayList, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expand(" + arrayList + ",\"" + string + "\",\"" + string2 + "\")");
        }
        int n = arrayList.size();
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>(arrayList.size());
        for (int i = 0; i < n; ++i) {
            String string3 = null;
            try {
                Permission permission = (Permission)arrayList.get(i);
                if (permission instanceof FilePermission) {
                    Serializable serializable;
                    int n2;
                    int n3;
                    int n4;
                    StringBuffer stringBuffer;
                    int n5;
                    string3 = permission.getName();
                    FilePermission filePermission = (FilePermission)permission;
                    String string4 = filePermission.getActions();
                    boolean bl = false;
                    if (string != null && (n5 = string3.indexOf("${app.installed.path}")) != -1) {
                        stringBuffer = new StringBuffer(string3.length() + 25);
                        stringBuffer.append(string3.substring(0, n5));
                        stringBuffer.append(string);
                        stringBuffer.append(string3.substring(n5 + "${app.installed.path}".length(), string3.length()));
                        string3 = stringBuffer.toString();
                        string3 = string3.replace('/', File.separatorChar);
                        bl = true;
                    }
                    n5 = string3.indexOf("${was.module.path}");
                    if (string2 == null && n5 != -1) {
                        Tr.warning(tc, "security.policy.was.key");
                        continue;
                    }
                    if (string2 != null && n5 != -1) {
                        stringBuffer = new StringBuffer(string3.length() + 25);
                        stringBuffer.append(string3.substring(0, n5));
                        stringBuffer.append(string2);
                        stringBuffer.append(string3.substring(n5 + "${was.module.path}".length(), string3.length()));
                        string3 = stringBuffer.toString();
                        string3 = string3.replace('/', File.separatorChar);
                        bl = true;
                    }
                    if ((n4 = string3.indexOf("${current.node.name}")) != -1) {
                        StringBuffer stringBuffer2 = new StringBuffer(string3.length() + 25);
                        stringBuffer2.append(string3.substring(0, n4));
                        stringBuffer2.append(this.nodeName);
                        stringBuffer2.append(string3.substring(n4 + "${current.node.name}".length(), string3.length()));
                        string3 = stringBuffer2.toString();
                        bl = true;
                    }
                    if ((n3 = string3.indexOf("${current.cell.name}")) != -1) {
                        StringBuffer stringBuffer3 = new StringBuffer(string3.length() + 25);
                        stringBuffer3.append(string3.substring(0, n3));
                        stringBuffer3.append(this.cellName);
                        stringBuffer3.append(string3.substring(n3 + "${current.cell.name}".length(), string3.length()));
                        string3 = stringBuffer3.toString();
                        bl = true;
                    }
                    if ((n2 = string3.indexOf("${current.server.name}")) != -1) {
                        serializable = new StringBuffer(string3.length() + 25);
                        ((StringBuffer)serializable).append(string3.substring(0, n2));
                        ((StringBuffer)serializable).append(this.srvrName);
                        ((StringBuffer)serializable).append(string3.substring(n2 + "${current.server.name}".length(), string3.length()));
                        string3 = ((StringBuffer)serializable).toString();
                        bl = true;
                    }
                    if (bl) {
                        serializable = new FilePermission(string3, string4);
                        arrayList2.add(serializable);
                        continue;
                    }
                    arrayList2.add(permission);
                    continue;
                }
                arrayList2.add(permission);
                continue;
            }
            catch (Exception exception) {
                Tr.error(tc, "security.policy.template.parser", new Object[]{exception, string3});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expand");
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCodeSourceRepository(CodeSource codeSource, ArrayList arrayList, String string, String string2, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCodeSourceRepository(\"" + codeSource + "\", " + arrayList + ",\"" + string + "\",\"" + string2 + "\"," + map + ")");
        }
        if (codeSource != null && arrayList != null && arrayList.size() != 0) {
            WSDynamicPolicy wSDynamicPolicy = this;
            synchronized (wSDynamicPolicy) {
                ArrayList arrayList2 = this.expand((ArrayList)arrayList.clone(), string, string2);
                ArrayList arrayList3 = null;
                if (map == null) {
                    arrayList3 = (ArrayList)this.csPermsHashMap.get(codeSource);
                    if (arrayList3 != null) {
                        arrayList3 = (ArrayList)arrayList3.clone();
                    }
                } else {
                    arrayList3 = (ArrayList)map.get(codeSource);
                }
                if (arrayList3 == null) {
                    if (map == null) {
                        this.codeSourceList.add(codeSource);
                        this.csPermsHashMap.put(codeSource, arrayList2.clone());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New entry added to code source " + codeSource + " --> " + arrayList2.toString());
                        }
                    } else {
                        map.put(codeSource, arrayList2.clone());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New entry added to tmp code source " + codeSource + " --> " + arrayList2.toString());
                        }
                    }
                } else {
                    ArrayList arrayList4 = this.expand((ArrayList)arrayList3.clone(), string, string2);
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        Permission permission = (Permission)arrayList2.get(i);
                        if (arrayList4.contains(permission)) continue;
                        arrayList4.add(permission);
                    }
                    if (map == null) {
                        this.csPermsHashMap.put(codeSource, arrayList4.clone());
                    } else {
                        map.put(codeSource, arrayList4.clone());
                    }
                    if (tc.isDebugEnabled()) {
                        if (map == null) {
                            Tr.debug(tc, "Existing entry in code source " + codeSource + " --> " + arrayList3.toString());
                        } else {
                            Tr.debug(tc, "Existing entry in tmp code source " + codeSource + " --> " + arrayList3.toString());
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    if (map == null) {
                        Tr.debug(tc, "Dynamic Policy Code Source = " + this.codeSourceList);
                        Tr.debug(tc, "Dynamic Policy Code Source to Permissions Mapping = " + this.csPermsHashMap);
                    } else {
                        Tr.debug(tc, "Dynamic Policy tmp Code Source to Permissions Mapping = " + map);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCodeSourceRepository(CodeSource, ArrayList, String, String, Map)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCodeSourceRepository(CodeSource codeSource, ArrayList arrayList, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCodeSourceRepository(\"" + codeSource + "\", " + arrayList + ")");
        }
        if (codeSource != null && arrayList != null && arrayList.size() != 0) {
            WSDynamicPolicy wSDynamicPolicy = this;
            synchronized (wSDynamicPolicy) {
                ArrayList arrayList2 = null;
                if (map == null) {
                    arrayList2 = (ArrayList)this.csPermsHashMap.get(codeSource);
                    if (arrayList2 != null) {
                        arrayList2 = (ArrayList)arrayList2.clone();
                    }
                } else {
                    arrayList2 = (ArrayList)map.get(codeSource);
                }
                if (arrayList2 == null) {
                    if (map == null) {
                        this.codeSourceList.add(codeSource);
                        this.csPermsHashMap.put(codeSource, arrayList.clone());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New entry added to code source " + codeSource + " --> " + arrayList.toString());
                        }
                    } else {
                        map.put(codeSource, arrayList.clone());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New entry added to tmp code source " + codeSource + " --> " + arrayList.toString());
                        }
                    }
                } else {
                    arrayList2.addAll((ArrayList)arrayList.clone());
                    if (map == null) {
                        this.csPermsHashMap.put(codeSource, arrayList2.clone());
                    } else {
                        map.put(codeSource, arrayList2.clone());
                    }
                    if (tc.isDebugEnabled()) {
                        if (map == null) {
                            Tr.debug(tc, "Existing entry in code source " + codeSource + " --> " + arrayList2.toString());
                        } else {
                            Tr.debug(tc, "Existing entry in tmp code source " + codeSource + " --> " + arrayList2.toString());
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    if (map == null) {
                        Tr.debug(tc, "Dynamic Policy Code Source = " + this.codeSourceList);
                        Tr.debug(tc, "Dynamic Policy Code Source to Permissions Mapping = " + this.csPermsHashMap);
                    } else {
                        Tr.debug(tc, "Dynamic Policy tmp Code Source to Permissions Mapping = " + map);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCodeSourceRepository(CodeSource, ArrayList, Map)");
        }
    }

    public final CodeSource createCodeSource(String string) {
        Object object;
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCodeSource(" + string + ")");
        }
        CodeSource codeSource = null;
        string = string.replace('/', File.separatorChar);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        if (string.endsWith("-")) {
            bl = true;
            string2 = string.substring(0, string.length() - 2);
        } else if (string.endsWith("*")) {
            bl2 = true;
            string2 = string.substring(0, string.length() - 2);
        } else {
            string2 = string;
            if (string.endsWith(File.separator)) {
                bl3 = true;
                string2 = string.substring(0, string.length() - 1);
            }
        }
        this.file = new File(string2);
        String string3 = null;
        String string4 = null;
        try {
            charSequence = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return WSDynamicPolicy.this.file.getCanonicalPath();
                }
            });
            string3 = charSequence;
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException.getException();
            Tr.warning(tc, "security.policy.fileCanonicalPath", (Object)new Object[]{object, string});
        }
        if (bl3) {
            string4 = bl ? MINUS_TRAIL : STAR_TRAIL;
        } else if (bl) {
            string4 = MINUS_TRAIL;
        } else if (bl2) {
            string4 = STAR_TRAIL;
        }
        try {
            if (string4 != null && string4.length() != 0) {
                charSequence = new StringBuffer(string3);
                ((StringBuffer)charSequence).append(string4);
                object = FilePathUtil.encodeFilePath(new File(((StringBuffer)charSequence).toString()).getAbsolutePath());
                if (!((String)object).startsWith("/")) {
                    object = "/" + (String)object;
                }
                URL uRL = new URL("file", "", (String)object);
                codeSource = new CodeSource(uRL, (Certificate[])null);
            } else {
                charSequence = FilePathUtil.encodeFilePath(new File(string3).getAbsolutePath());
                if (!((String)charSequence).startsWith("/")) {
                    charSequence = "/" + (String)charSequence;
                }
                object = new URL("file", "", (String)charSequence);
                codeSource = new CodeSource((URL)object, (Certificate[])null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Tr.warning(tc, "security.policy.parser.malformedurlexception", (Object)new Object[]{string2, malformedURLException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCodeSource() returns " + codeSource);
        }
        return codeSource;
    }

    public final List getRuntimeFilteredPermission() {
        return (List)this.runtimeFilterPermissions.clone();
    }

    private Permission getPermissionInstance(Parser.PermissionEntry permissionEntry) {
        Permission permission = null;
        if (permissionEntry.getSignatures() == null) {
            permission = this.createPermission(permissionEntry.getPermissionType(), permissionEntry.getName(), permissionEntry.getAction());
        }
        return permission;
    }

    private Permission createPermission0(UnresolvedPermission unresolvedPermission) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPermission0", unresolvedPermission);
        }
        Permission permission = unresolvedPermission;
        if (unresolvedPermission != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(unresolvedPermission.toString(), "() \t\n\r\f");
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            String string = null;
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            String string2 = null;
            if (stringTokenizer.hasMoreTokens() && "null".equals(string2 = stringTokenizer.nextToken())) {
                string2 = null;
            }
            String string3 = null;
            if (stringTokenizer.hasMoreTokens() && "null".equals(string3 = stringTokenizer.nextToken())) {
                string3 = null;
            }
            permission = this.createPermission(string, string2, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPermission0", permission);
        }
        return permission;
    }

    private Permission createPermission(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPermission(" + string + ", " + string2 + ", " + string3);
        }
        Permission permission = null;
        if (string != null && string.length() != 0) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = null;
                clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(String.class, String.class);
                permission = (Permission)constructor.newInstance(string2, string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                permission = new UnresolvedPermission(string, string2, string3, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                Tr.error(tc, "security.policy.perminstance.targetexception", new Object[]{throwable});
            }
            catch (Exception exception) {
                Tr.error(tc, "security.policy.perminstance.exception", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPermission", permission);
        }
        return permission;
    }

    private class GetCodeSourceAction
    implements PrivilegedAction {
        private File file;
        private String newPath;
        private boolean endsWithMinus = false;
        private boolean endsWithStar = false;

        public GetCodeSourceAction(String string, boolean bl, boolean bl2) {
            this.file = new File(string);
            this.newPath = string;
            this.endsWithMinus = bl;
            this.endsWithStar = bl2;
        }

        public Object run() {
            CodeSource codeSource = null;
            String string = null;
            String string2 = null;
            try {
                string = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                Tr.warning(tc, "security.policy.fileCanonicalPath", (Object)new Object[]{iOException, string});
            }
            if (this.file.isDirectory()) {
                string2 = this.endsWithMinus ? MINUS_TRAIL : STAR_TRAIL;
            } else if (this.endsWithMinus) {
                string2 = MINUS_TRAIL;
            } else if (this.endsWithStar) {
                string2 = STAR_TRAIL;
            }
            try {
                if (string2 != null && string2.length() != 0) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    stringBuffer.append(string2);
                    codeSource = new CodeSource(FilePathUtil.filePathToURL(new File(stringBuffer.toString())), (Certificate[])null);
                } else {
                    codeSource = new CodeSource(FilePathUtil.filePathToURL(new File(string)), (Certificate[])null);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Tr.warning(tc, "security.policy.parser.malformedurlexception", (Object)new Object[]{this.newPath, malformedURLException});
            }
            return codeSource;
        }
    }

    private class WSPolicyTemplate
    implements PolicyTemplate {
        private Map entries = new HashMap();

        public String[] getSymbols() {
            return this.entries.keySet().toArray(new String[this.entries.size()]);
        }

        public ArrayList get(String string) {
            ArrayList arrayList = (ArrayList)this.entries.get(string);
            if (arrayList != null) {
                arrayList = (ArrayList)arrayList.clone();
            }
            return arrayList;
        }

        public String toString() {
            return this.entries.toString();
        }

        private WSPolicyTemplate() {
        }

        private void add(Parser.GrantEntry grantEntry) {
            String string = grantEntry.codeBase;
            if (string == null || string.length() == 0) {
                string = "${default}";
            } else {
                string = grantEntry.codeBase;
                if (string.startsWith("${") && string.endsWith("}")) {
                    string = string.toLowerCase();
                }
            }
            Object v = this.entries.get(string);
            ArrayList<Permission> arrayList = null;
            if (v != null) {
                arrayList = (ArrayList<Permission>)v;
            } else {
                arrayList = new ArrayList<Permission>();
                this.entries.put(string, arrayList);
            }
            Iterator iterator = grantEntry.getPermissions();
            while (iterator.hasNext()) {
                arrayList.add(WSDynamicPolicy.this.getPermissionInstance((Parser.PermissionEntry)iterator.next()));
            }
        }

        private void addAll(WSPolicyTemplate wSPolicyTemplate) {
            if (wSPolicyTemplate == null) {
                return;
            }
            String[] stringArray = wSPolicyTemplate.getSymbols();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                this.add(string, (ArrayList)wSPolicyTemplate.entries.get(string));
            }
        }

        private void replace(String string, ArrayList arrayList) {
            this.entries.put(string, arrayList);
        }

        private void add(String string, ArrayList arrayList) {
            ArrayList arrayList2 = (ArrayList)this.entries.get(string);
            if (arrayList2 != null) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Permission permission = (Permission)arrayList.get(i);
                    if (arrayList2.contains(permission)) continue;
                    arrayList2.add(permission);
                }
            } else {
                arrayList2 = (ArrayList)arrayList.clone();
            }
            this.entries.put(string, arrayList2);
        }
    }
}

