/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ws.security.policy.Parser;
import com.ibm.ws.security.util.ParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

abstract class SystemExtensionParser
extends Parser {
    SystemExtensionParser(Reader reader, boolean bl) {
        super(reader, bl);
    }

    void parse() throws IOException, ParserException {
        super.parse();
        this.normalizeGrants();
    }

    private void normalizeGrants() {
        Iterator iterator = this.grants.iterator();
        Parser.GrantEntry grantEntry = new Parser.GrantEntry();
        while (iterator.hasNext()) {
            Parser.GrantEntry grantEntry2 = (Parser.GrantEntry)iterator.next();
            if (grantEntry2.codeBase != null || grantEntry2.signedBy != null) {
                this.warning("security.policy.sysextparser.ignoregrant", new Object[]{grantEntry2.codeBase, grantEntry2.signedBy});
                continue;
            }
            Iterator iterator2 = grantEntry2.getPermissions();
            while (iterator2.hasNext()) {
                Parser.PermissionEntry permissionEntry = (Parser.PermissionEntry)iterator2.next();
                if (permissionEntry.getSignatures() == null) {
                    grantEntry.add(permissionEntry);
                    continue;
                }
                this.warning("security.policy.sysextparser.ignoreperm", new Object[]{permissionEntry.toString()});
            }
        }
        this.grants.clear();
        this.grants.add(grantEntry);
    }
}

