/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.orbssl;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.JSSEProviderFactory;

public final class SSLCiphers {
    public static final int CONFIDENTIALITY = 1;
    public static final int INTEGRITY = 2;
    public static final int AUTHENTICITY = 3;
    public static final int HIGH = 4;
    public static final int MEDIUM = 5;
    public static final int LOW = 6;
    public static final String[] HIGH_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_RC4_128_SHA"};
    public static final String[] HIGH_CIPHER_SUITES_FIPS = new String[]{"SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA"};
    public static final String[] MEDIUM_CIPHER_SUITES = new String[]{"SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    public static final String[] MEDIUM_CIPHER_SUITES_FIPS = new String[0];
    public static final String[] LOW_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
    public static final String[] LOW_CIPHER_SUITES_FIPS = new String[0];
    public static final String[] LOW_CIPHER_SUITES_CLIENT = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
    public static final String[] LOW_CIPHER_SUITES_CLIENT_FIPS = new String[0];

    public static String[] getCipherSuites(int n, boolean bl, String string) throws IllegalArgumentException {
        String[] stringArray;
        block6: {
            stringArray = null;
            try {
                if (n == 1 || n == 4) {
                    stringArray = JSSEProviderFactory.isFipsEnabled() ? HIGH_CIPHER_SUITES_FIPS : HIGH_CIPHER_SUITES;
                    break block6;
                }
                if (n == 2 || n == 5) {
                    stringArray = JSSEProviderFactory.isFipsEnabled() ? MEDIUM_CIPHER_SUITES_FIPS : MEDIUM_CIPHER_SUITES;
                    break block6;
                }
                if (n == 2 || n == 6) {
                    stringArray = JSSEProviderFactory.isFipsEnabled() ? (bl ? LOW_CIPHER_SUITES_CLIENT_FIPS : LOW_CIPHER_SUITES_FIPS) : (bl ? LOW_CIPHER_SUITES_CLIENT : LOW_CIPHER_SUITES);
                    break block6;
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal argument for Cipher qop - Client Socket is " + bl);
                throw illegalArgumentException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException(illegalArgumentException, "com.ibm.ws.security.orbssl.SSLCiphers.getCipherSuites", "260");
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.SSLCiphers", "SSLCiphers.getCipherSuites", (Exception)illegalArgumentException);
                }
                throw illegalArgumentException;
            }
        }
        return stringArray;
    }

    public static String[] getCipherSuitesJoin(int n, int n2, boolean bl, String string) throws IllegalArgumentException {
        String[] stringArray;
        block23: {
            stringArray = null;
            try {
                if (!(n != 1 && n != 4 || n2 != 1 && n2 != 4)) {
                    stringArray = JSSEProviderFactory.isFipsEnabled() ? HIGH_CIPHER_SUITES_FIPS : HIGH_CIPHER_SUITES;
                    break block23;
                }
                if (!(n != 2 && n != 5 || n2 != 2 && n2 != 5)) {
                    stringArray = JSSEProviderFactory.isFipsEnabled() ? MEDIUM_CIPHER_SUITES_FIPS : MEDIUM_CIPHER_SUITES;
                    break block23;
                }
                if (!(n != 2 && n != 6 || n2 != 2 && n2 != 6)) {
                    stringArray = JSSEProviderFactory.isFipsEnabled() ? (bl ? LOW_CIPHER_SUITES_CLIENT_FIPS : LOW_CIPHER_SUITES_FIPS) : (bl ? LOW_CIPHER_SUITES_CLIENT : LOW_CIPHER_SUITES);
                    break block23;
                }
                if (!(n != 1 && n != 4 || n2 != 2 && n2 != 5)) {
                    if (JSSEProviderFactory.isFipsEnabled()) {
                        String[] stringArray2 = new String[HIGH_CIPHER_SUITES_FIPS.length + MEDIUM_CIPHER_SUITES_FIPS.length];
                        System.arraycopy(HIGH_CIPHER_SUITES_FIPS, 0, stringArray2, 0, HIGH_CIPHER_SUITES_FIPS.length);
                        System.arraycopy(MEDIUM_CIPHER_SUITES_FIPS, 0, stringArray2, HIGH_CIPHER_SUITES_FIPS.length, MEDIUM_CIPHER_SUITES_FIPS.length);
                        stringArray = stringArray2;
                    } else {
                        String[] stringArray3 = new String[HIGH_CIPHER_SUITES.length + MEDIUM_CIPHER_SUITES.length];
                        System.arraycopy(HIGH_CIPHER_SUITES, 0, stringArray3, 0, HIGH_CIPHER_SUITES.length);
                        System.arraycopy(MEDIUM_CIPHER_SUITES, 0, stringArray3, HIGH_CIPHER_SUITES.length, MEDIUM_CIPHER_SUITES.length);
                        stringArray = stringArray3;
                    }
                    break block23;
                }
                if (!(n != 1 && n != 4 || n2 != 2 && n2 != 6)) {
                    if (JSSEProviderFactory.isFipsEnabled()) {
                        if (bl) {
                            String[] stringArray4 = new String[HIGH_CIPHER_SUITES_FIPS.length + MEDIUM_CIPHER_SUITES_FIPS.length + LOW_CIPHER_SUITES_CLIENT_FIPS.length];
                            System.arraycopy(HIGH_CIPHER_SUITES_FIPS, 0, stringArray4, 0, HIGH_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(MEDIUM_CIPHER_SUITES_FIPS, 0, stringArray4, HIGH_CIPHER_SUITES_FIPS.length, MEDIUM_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(LOW_CIPHER_SUITES_CLIENT_FIPS, 0, stringArray4, HIGH_CIPHER_SUITES_FIPS.length + MEDIUM_CIPHER_SUITES_FIPS.length, LOW_CIPHER_SUITES_CLIENT_FIPS.length);
                            stringArray = stringArray4;
                        } else {
                            String[] stringArray5 = new String[HIGH_CIPHER_SUITES_FIPS.length + MEDIUM_CIPHER_SUITES_FIPS.length + LOW_CIPHER_SUITES_FIPS.length];
                            System.arraycopy(HIGH_CIPHER_SUITES_FIPS, 0, stringArray5, 0, HIGH_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(MEDIUM_CIPHER_SUITES_FIPS, 0, stringArray5, HIGH_CIPHER_SUITES_FIPS.length, MEDIUM_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(LOW_CIPHER_SUITES_FIPS, 0, stringArray5, HIGH_CIPHER_SUITES_FIPS.length + MEDIUM_CIPHER_SUITES_FIPS.length, LOW_CIPHER_SUITES_FIPS.length);
                            stringArray = stringArray5;
                        }
                    } else if (bl) {
                        String[] stringArray6 = new String[HIGH_CIPHER_SUITES.length + MEDIUM_CIPHER_SUITES.length + LOW_CIPHER_SUITES_CLIENT.length];
                        System.arraycopy(HIGH_CIPHER_SUITES, 0, stringArray6, 0, HIGH_CIPHER_SUITES.length);
                        System.arraycopy(MEDIUM_CIPHER_SUITES, 0, stringArray6, HIGH_CIPHER_SUITES.length, MEDIUM_CIPHER_SUITES.length);
                        System.arraycopy(LOW_CIPHER_SUITES_CLIENT, 0, stringArray6, HIGH_CIPHER_SUITES.length + MEDIUM_CIPHER_SUITES.length, LOW_CIPHER_SUITES_CLIENT.length);
                        stringArray = stringArray6;
                    } else {
                        String[] stringArray7 = new String[HIGH_CIPHER_SUITES.length + MEDIUM_CIPHER_SUITES.length + LOW_CIPHER_SUITES.length];
                        System.arraycopy(HIGH_CIPHER_SUITES, 0, stringArray7, 0, HIGH_CIPHER_SUITES.length);
                        System.arraycopy(MEDIUM_CIPHER_SUITES, 0, stringArray7, HIGH_CIPHER_SUITES.length, MEDIUM_CIPHER_SUITES.length);
                        System.arraycopy(LOW_CIPHER_SUITES, 0, stringArray7, HIGH_CIPHER_SUITES.length + MEDIUM_CIPHER_SUITES.length, LOW_CIPHER_SUITES.length);
                        stringArray = stringArray7;
                    }
                    break block23;
                }
                if (!(n != 2 && n != 5 || n2 != 2 && n2 != 6)) {
                    if (JSSEProviderFactory.isFipsEnabled()) {
                        if (bl) {
                            String[] stringArray8 = new String[MEDIUM_CIPHER_SUITES_FIPS.length + LOW_CIPHER_SUITES_CLIENT_FIPS.length];
                            System.arraycopy(MEDIUM_CIPHER_SUITES_FIPS, 0, stringArray8, 0, MEDIUM_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(LOW_CIPHER_SUITES_CLIENT_FIPS, 0, stringArray8, MEDIUM_CIPHER_SUITES_FIPS.length, LOW_CIPHER_SUITES_CLIENT_FIPS.length);
                            stringArray = stringArray8;
                        } else {
                            String[] stringArray9 = new String[MEDIUM_CIPHER_SUITES_FIPS.length + LOW_CIPHER_SUITES_FIPS.length];
                            System.arraycopy(MEDIUM_CIPHER_SUITES_FIPS, 0, stringArray9, 0, MEDIUM_CIPHER_SUITES_FIPS.length);
                            System.arraycopy(LOW_CIPHER_SUITES_FIPS, 0, stringArray9, MEDIUM_CIPHER_SUITES_FIPS.length, LOW_CIPHER_SUITES_FIPS.length);
                            stringArray = stringArray9;
                        }
                    } else if (bl) {
                        String[] stringArray10 = new String[MEDIUM_CIPHER_SUITES.length + LOW_CIPHER_SUITES_CLIENT.length];
                        System.arraycopy(MEDIUM_CIPHER_SUITES, 0, stringArray10, 0, MEDIUM_CIPHER_SUITES.length);
                        System.arraycopy(LOW_CIPHER_SUITES_CLIENT, 0, stringArray10, MEDIUM_CIPHER_SUITES.length, LOW_CIPHER_SUITES_CLIENT.length);
                        stringArray = stringArray10;
                    } else {
                        String[] stringArray11 = new String[MEDIUM_CIPHER_SUITES.length + LOW_CIPHER_SUITES.length];
                        System.arraycopy(MEDIUM_CIPHER_SUITES, 0, stringArray11, 0, MEDIUM_CIPHER_SUITES.length);
                        System.arraycopy(LOW_CIPHER_SUITES, 0, stringArray11, MEDIUM_CIPHER_SUITES.length, LOW_CIPHER_SUITES.length);
                        stringArray = stringArray11;
                    }
                    break block23;
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal argument for Cipher qop - Client Socket is " + bl);
                throw illegalArgumentException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException(illegalArgumentException, "com.ibm.ws.security.orbssl.SSLCiphers.getCipherSuitesJoin", "381");
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.exception(8L, "com.ibm.ws.security.orbssl.SSLCiphers", "SSLCiphers.getCipherSuitesJoin", (Exception)illegalArgumentException);
                }
                throw illegalArgumentException;
            }
        }
        return stringArray;
    }

    public static String[] coalesceCipherSpecs(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray2.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i].equals(stringArray2[j])) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            stringArray3[n++] = stringArray[i];
        }
        String[] stringArray4 = new String[n];
        System.arraycopy(stringArray3, 0, stringArray4, 0, n);
        return stringArray4;
    }
}

