/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.ltpa.LTPAKeyPair;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public final class LTPADigSignature {
    private static final TraceComponent tc = Tr.register(LTPADigSignature.class, null, "com.ibm.ejs.resources.security");
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    static byte[][] testRawPubKey = null;
    static byte[][] testRawPrivKey = null;
    static MessageDigest md1 = null;
    static MessageDigest md2 = null;
    static MessageDigest md1JCE = null;
    static MessageDigest md2JCE = null;
    private static Object lockObj1 = new Object();
    private static Object lockObj2 = new Object();

    static void generateRSAKeys(byte[][] byArray, byte[][] byArray2) {
        byte[][] byArray3 = LTPACrypto.rsaKey(128, true, true);
        byArray2[2] = byArray3[2];
        byArray2[4] = byArray3[3];
        byArray2[3] = byArray3[4];
        byArray[0] = byArray3[0];
        byArray[1] = byArray3[2];
    }

    static byte[] sign(byte[] byArray, LTPAPrivateKey lTPAPrivateKey) throws NoSuchAlgorithmException {
        return LTPADigSignature.sign(byArray, lTPAPrivateKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] sign(byte[] byArray, LTPAPrivateKey lTPAPrivateKey, boolean bl) throws NoSuchAlgorithmException {
        byte[] byArray2;
        byte[][] byArray3 = lTPAPrivateKey.getRawKey();
        Object object = lockObj1;
        synchronized (object) {
            byArray2 = bl ? md1JCE.digest(byArray) : md1.digest(byArray);
        }
        LTPACrypto.setRSAKey(byArray3);
        object = LTPACrypto.signISO9796(byArray3, byArray2, 0, byArray2.length, bl);
        return object;
    }

    static boolean verify(byte[] byArray, byte[] byArray2, LTPAPublicKey lTPAPublicKey) throws NoSuchAlgorithmException {
        return LTPADigSignature.verify(byArray, byArray2, lTPAPublicKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean verify(byte[] byArray, byte[] byArray2, LTPAPublicKey lTPAPublicKey, boolean bl) throws NoSuchAlgorithmException {
        byte[] byArray3;
        byte[][] byArray4 = lTPAPublicKey.getRawKey();
        Object object = lockObj2;
        synchronized (object) {
            byArray3 = bl ? md2JCE.digest(byArray) : md2.digest(byArray);
        }
        boolean bl2 = LTPACrypto.verifyISO9796(byArray4, byArray3, 0, byArray3.length, byArray2, 0, byArray2.length, bl);
        return bl2;
    }

    static LTPAKeyPair generateLTPAKeyPair() {
        byte[][] byArrayArray = new byte[2][];
        byte[][] byArrayArray2 = new byte[8][];
        LTPADigSignature.generateRSAKeys(byArrayArray, byArrayArray2);
        LTPAPublicKey lTPAPublicKey = new LTPAPublicKey(byArrayArray);
        LTPAPrivateKey lTPAPrivateKey = new LTPAPrivateKey(byArrayArray2);
        return new LTPAKeyPair(lTPAPublicKey, lTPAPrivateKey);
    }

    static {
        try {
            md1JCE = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
            md2JCE = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchAlgorithmException});
            FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPADigSignature", "48");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
            Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchProviderException});
            FFDCFilter.processException(noSuchProviderException, "com.ibm.ws.security.ltpa.LTPADigSignature", "52");
        }
        if (LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA()) {
            try {
                md1 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
                md2 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchAlgorithmException});
                FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPADigSignature", "61");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchProviderException});
                FFDCFilter.processException(noSuchProviderException, "com.ibm.ws.security.ltpa.LTPADigSignature", "65");
            }
        } else {
            try {
                md1 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
                md2 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPADigSignature", "72");
            }
        }
    }
}

