/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.delegation;

import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.UseCallerIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.UseSystemIdentity;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityCollaborator;
import com.ibm.ws.security.delegation.Delegation;
import com.ibm.ws.security.ejb.BeanPermissionRoleMap;
import com.ibm.ws.security.ejb.RunAsMapTable;
import com.ibm.ws.security.ejb.SecurityBeanCookie;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.WCCMHelper;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.wsspi.security.token.PropagationToken;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.common.Identity;
import org.eclipse.jst.j2ee.common.RunAsSpecifiedIdentity;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;

class MethodDelegation
implements Delegation {
    private ContextManager contextManager = ContextManagerFactory.getInstance();
    private static int MAX_EJBNAME_ENTRIES = 200;
    private static HashMap ejbNameCache = new HashMap(MAX_EJBNAME_ENTRIES);
    private static final TraceComponent tc = Tr.register(MethodDelegation.class, "Security", "com.ibm.ejs.resources.security");

    MethodDelegation() {
    }

    protected boolean checkRunAsMethod(SecurityIdentity securityIdentity, String string, String string2) {
        EList eList = securityIdentity.getMethodElements();
        return eList != null && eList.size() != 0 && BeanPermissionRoleMap.findMatchingMethod(string, string2, eList);
    }

    public Subject delegate(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, Subject subject, Subject subject2, SecurityBeanCookie securityBeanCookie, String string) throws CSIException {
        EObject eObject;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runAsDelegation");
        }
        Subject subject3 = subject2;
        EList eList = securityBeanCookie.getRunAsSettings();
        String string2 = securityBeanCookie.getAppName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking RunAs for : App = " + string2 + " Bean = " + securityBeanCookie.getBeanName() + " Method = " + string);
        }
        if (eList != null) {
            int n = eList.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "runAsSettings found in beanCookie: Size: " + n);
            }
            for (int i = 0; i < n; ++i) {
                object = (SecurityIdentity)eList.get(i);
                eObject = object.getRunAsMode();
                if (!this.checkRunAsMethod((SecurityIdentity)object, securityBeanCookie.getBeanName(), string)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "checkRunAsMethod() returned false");
                    continue;
                }
                if (eObject instanceof UseCallerIdentity) {
                    subject3 = subject2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RunAs set to Caller Identity. Subject:" + subject3);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "runAsDelegation");
                    }
                    return subject3;
                }
                if (eObject instanceof UseSystemIdentity) {
                    subject3 = subject;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RunAs set to System Identity. Subject:" + subject3);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "runAsDelegation");
                    }
                    return subject3;
                }
                if (!(eObject instanceof com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity)) continue;
                String string3 = ((com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity)eObject).getRunAsSpecifiedIdentity().getRoleName();
                subject3 = this.getRunAsSpecifiedUserSubject(string3, string2);
                if (subject3 == null) {
                    subject3 = subject2;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject:" + subject3);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "runAsDelegation");
                }
                return subject3;
            }
        }
        EnterpriseBean enterpriseBean = null;
        String string4 = securityBeanCookie.getBeanName();
        object = string4 + ":" + string2 + ":" + securityBeanCookie.getModuleName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ejbNameCache key:" + (String)object);
        }
        if ((enterpriseBean = (EnterpriseBean)ejbNameCache.get(object)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no entry in ejbNameCache");
            }
            enterpriseBean = securityBeanCookie.getEjbJar().getEnterpriseBeanNamed(string4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getEJB:" + enterpriseBean);
            }
            if (ejbNameCache.size() > MAX_EJBNAME_ENTRIES) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Clearing ejbNameCache.");
                }
                ejbNameCache.clear();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "An entry is put to ejbNameCache");
            }
            ejbNameCache.put(object, enterpriseBean);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "EJB object:" + enterpriseBean);
        }
        if (enterpriseBean == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find bean " + securityBeanCookie.getBeanName() + " in the jar. Subject:" + subject3);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runAsDelegation");
            }
            return subject3;
        }
        eObject = enterpriseBean.getSecurityIdentity();
        if (eObject != null) {
            String string5;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SecurityIdentity:" + eObject);
            }
            if (eObject instanceof org.eclipse.jst.j2ee.common.UseCallerIdentity) {
                subject3 = subject2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RunAs set to Caller Identity ");
                }
            } else if (eObject instanceof RunAsSpecifiedIdentity && (subject3 = this.getRunAsSpecifiedUserSubject(string5 = ((RunAsSpecifiedIdentity)eObject).getIdentity().getRoleName(), string2)) == null) {
                subject3 = subject2;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Subject:" + subject3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runAsDelegation");
        }
        return subject3;
    }

    public Subject delegate(Subject subject, String string, WebAccessContext webAccessContext, String string2) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delegate " + string2);
        }
        Subject subject2 = subject;
        WebApp webApp = webAccessContext.getWebApp();
        Servlet servlet = null;
        if (webApp != null && string2 != null) {
            servlet = webApp.getServletNamed(string2);
        }
        if (servlet != null) {
            RunAsSpecifiedIdentity runAsSpecifiedIdentity = servlet.getRunAs();
            if (runAsSpecifiedIdentity != null) {
                String string3;
                Identity identity;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RunAs Specified for servlet" + string2);
                }
                if ((identity = runAsSpecifiedIdentity.getIdentity()) != null && (subject2 = this.getRunAsSpecifiedUserSubject(string3 = identity.getRoleName(), webAccessContext.getEnterpriseAppName())) == null) {
                    subject2 = subject;
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servlet not Specified in DD for servlet" + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delegate");
        }
        return subject2;
    }

    protected static void clearDelegationCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearDelegationCache");
        }
        if (tc.isDebugEnabled()) {
            int n = ejbNameCache.size();
            Tr.debug(tc, "Clearing ejbNameCache. Size:" + n);
        }
        ejbNameCache.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearDelegationCache");
        }
    }

    protected Subject getRunAsSpecifiedUserSubject(String string, final String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsSpecifiedUserSubject");
        }
        BasicAuthData basicAuthData = null;
        Subject subject = null;
        SecurityRole securityRole = WCCMHelper.createSecurityRole(null, string);
        RunAsMap runAsMap = (RunAsMap)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityCollaborator.getRunAsMapTable();
                return RunAsMapTable.getRunAsMap(string2);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RunAs set to Specified Identity : RunAs Role = " + string);
        }
        if (runAsMap != null) {
            basicAuthData = (BasicAuthData)runAsMap.getAuthData(securityRole);
            if (basicAuthData != null) {
                try {
                    subject = this.contextManager.login(this.contextManager.getDefaultRealm(), basicAuthData.getUserId(), basicAuthData.getPassword());
                    this.clearPropagationTokenIfCallerSubjectNullOrUnauthenticated();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityCollaborator.getRunAsSpecifiedUserSubject", "293", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception during user authentication:", exception);
                    }
                    Tr.audit(tc, "security.authn.failed.foruser", new Object[]{basicAuthData.getUserId()});
                    subject = null;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRunAsSpecifiedUserSubject");
                }
                return subject;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Application Identity Not Configured");
                Tr.debug(tc, "Invocation (SPECIFIED) identity is set to ClientIdentity");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunAsSpecifiedUserSubject");
        }
        return subject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void clearPropagationTokenIfCallerSubjectNullOrUnauthenticated() {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "clearPropagationTokenIfCallerSubjectNullOrUnauthenticated");
            }
            if (!WSCredentialTokenMapper.isAnyPropagationEnabled()) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "clearPropagationTokenIfCallerSubjectNullOrUnauthenticated (prop disabled)");
                return;
            }
            try {
                String[] stringArray;
                PropagationToken propagationToken = this.contextManager.getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
                if (propagationToken == null) {
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "clearPropagationTokenIfCallerSubjectNullOrUnauthenticated (no token on the thread)");
                    return;
                }
                Subject subject = this.contextManager.getCallerSubject();
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                if (wSCredential != null && !wSCredential.isUnauthenticated()) {
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "clearPropagationTokenIfCallerSubjectNullOrUnauthenticated (caller not null, prop token already set correctly)");
                    return;
                }
                if ((wSCredential == null || wSCredential.isUnauthenticated()) && (stringArray = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.callers")) != null && stringArray.length == 1) {
                    this.contextManager.setPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1", null);
                    Enumeration enumeration = propagationToken.getAttributeNames();
                    while (enumeration.hasMoreElements()) {
                        String[] stringArray2;
                        String[] stringArray3;
                        String string = (String)enumeration.nextElement();
                        if (string == null || string.equals("com.ibm.wsspi.security.propagation.callers") || string.equals("com.ibm.wsspi.security.propagation.hosts") || (stringArray3 = WSSecurityHelper.getPropagationAttributes(string)) != null || (stringArray2 = propagationToken.getAttributes(string)) == null || stringArray2.length <= 0) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding attributes for " + string + " to existing prop token");
                        }
                        for (int i = 0; i < stringArray2.length; ++i) {
                            WSSecurityHelper.addPropagationAttribute(string, stringArray2[i]);
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityCollaborator.clearPropagationTokenIfCallerSubjectNullOrUnauthenticated", "501", this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Exception determining if propagation token needs to be cleared.", new Object[]{exception});
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "clearPropagationTokenIfCallerSubjectNullOrUnauthenticated");
    }
}

