/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.cred;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import javax.security.auth.AuthPermission;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.Refreshable;
import javax.security.auth.login.CredentialExpiredException;

public abstract class Credential
implements Refreshable,
Destroyable,
Serializable {
    public static final String ACCESS_ID = "access_id";
    public static final String GROUP_IDS = "group_ids";
    public static final String PRIMARY_GROUP_ID = "primary_group_id";
    private boolean destroyed = false;
    byte[] credentialToken;
    String hostname;
    String accessId;
    String[] groupIds;
    String primarygid;
    String realmname;
    String username;
    String password;
    X509Certificate[] certificates;
    String OID;
    boolean forwardable;
    int expirationTime;
    private static final AuthPermission DESTROY_PERMISSION = new AuthPermission("destroyCredential");
    static final AuthPermission REFRESH_PERMISSION = new AuthPermission("refreshCredential");
    private static final TraceComponent tc = Tr.register(Credential.class);

    public Credential(String string, String string2) {
        this.username = string;
        this.password = string2;
    }

    public Credential(String string) {
        this.username = string;
    }

    public Credential(X509Certificate[] x509CertificateArray) {
        this.certificates = x509CertificateArray;
    }

    public Credential(String string, String string2, byte[] byArray, int n, String[] stringArray, String string3, String string4) {
        this.username = string2;
        this.accessId = string3;
        this.primarygid = string4;
        this.groupIds = stringArray;
        this.credentialToken = byArray;
        this.expirationTime = n;
        this.realmname = string;
    }

    public Credential(byte[] byArray) {
        this.credentialToken = byArray;
    }

    public String getRealm() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm()");
        }
        this._assert();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm() -> " + this.realmname);
        }
        return this.realmname;
    }

    public X509Certificate[] getCerts() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCerts()");
        }
        this._assert();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCerts()");
        }
        return this.certificates;
    }

    public String getUserName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserName()");
        }
        this._assert();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserName() -> " + this.username);
        }
        return this.username;
    }

    public String getPassword() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPassword()");
        }
        this._assert();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPassword() -> XXXXXXXX");
        }
        return this.password;
    }

    public byte[] getCredentialToken() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredentialToken()");
        }
        this._assert();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialToken()");
        }
        return this.credentialToken;
    }

    public String getHostName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostName()");
        }
        this._assert();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostName() -> " + this.hostname);
        }
        return this.hostname;
    }

    public Object get(String string) throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get(key = \"" + string + "\")");
        }
        this._assert();
        Object object = null;
        if (string.equals(ACCESS_ID)) {
            object = this.accessId;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "accessId = " + this.accessId);
            }
        } else if (string.equals(GROUP_IDS)) {
            object = this.groupIds;
            if (tc.isDebugEnabled()) {
                if (this.groupIds == null || this.groupIds.length == 0) {
                    Tr.debug(tc, "groupIds = [ ]");
                } else {
                    int n = this.groupIds.length;
                    StringBuffer stringBuffer = new StringBuffer("[ ");
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(this.groupIds[i]).append(i == n - 1 ? "" : ", ");
                    }
                    stringBuffer.append(" ]");
                    Tr.debug(tc, "groupIds = " + stringBuffer.toString());
                }
            }
        } else if (string.equals(PRIMARY_GROUP_ID)) {
            object = this.primarygid;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "primarygid = " + this.primarygid);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get(key)");
        }
        return object;
    }

    public String getOID() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOID()");
        }
        this._assert();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOID() -> " + this.OID);
        }
        return this.OID;
    }

    public boolean getForwardable() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getForwardable()");
        }
        this._assert();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getForwardable() -> " + this.forwardable);
        }
        return this.forwardable;
    }

    public void setForwardable() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setForwardable()");
        }
        this._assert();
        this.forwardable = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setForwardable() -> " + this.forwardable);
        }
    }

    public int getExpiration() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExpiration()");
        }
        this._assert();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpiration() -> " + this.expirationTime);
        }
        return this.expirationTime;
    }

    public boolean isCurrent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCurrent()");
        }
        boolean bl = false;
        if (!this.isDestroyed()) {
            bl = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Credential destroyed, return false");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCurrent() -> " + bl);
        }
        return bl;
    }

    public void destroy() throws DestroyFailedException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(DESTROY_PERMISSION);
        }
        this.destroyed = true;
        this._cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy()");
        }
    }

    public void refresh() {
    }

    public boolean isDestroyed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDestroyed()");
            Tr.exit(tc, "isDestroyed() -> " + this.destroyed);
        }
        return this.destroyed;
    }

    private final void _assert() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_assert()");
        }
        if (this.isDestroyed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_assert() --> destroyed");
            }
            throw new CredentialDestroyedException("Credential is destroyed, can not be used.");
        }
        if (!this.isCurrent()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_assert() --> expired");
            }
            throw new CredentialExpiredException("Credential is expired, please refresh.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_assert() --> normal");
        }
    }

    void _cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_cleanup()");
        }
        this.accessId = null;
        this.groupIds = null;
        this.hostname = null;
        this.credentialToken = null;
        this.realmname = null;
        this.username = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_cleanup()");
        }
    }
}

