/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.core.SecurityAdminHelper;
import com.ibm.ws.security.core.SecurityComponentImpl;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.distSecurityComponentImpl;
import com.ibm.ws.security.zOS.NativeConfiguration;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public final class zOSSecurityComponentImpl
extends distSecurityComponentImpl {
    private static final TraceComponent tc = Tr.register(zOSSecurityComponentImpl.class, "Security", "com.ibm.ejs.resources.security");
    private PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();

    zOSSecurityComponentImpl(SecurityComponentImpl securityComponentImpl) {
        super(securityComponentImpl);
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        try {
            String string = System.getProperty("com.ibm.vm.bitmode");
            int n = Integer.parseInt(string);
            if (n == 64) {
                System.loadLibrary("bbgsec");
            } else {
                System.loadLibrary("bbosec");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Tr.event(tc, "Unable to load BBOSEC DLL", unsatisfiedLinkError);
            throw new ConfigurationError(unsatisfiedLinkError);
        }
        super.initialize(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    void initializeSecurityConfig(Security security2) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "zOS initializeSecurityConfig");
        }
        super.initializeSecurityConfig(security2);
        String string = this.getGenericShortName();
        if (string != null) {
            object = SecurityConfig.getConfig();
            ((SecurityConfig)object).setValue("generic.server.short.name", string);
        }
        object = NativeConfiguration.getConfig();
        ((NativeConfiguration)object).initializeConfiguration(security2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zOS initializeSecurityConfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGenericShortName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGenericShortName");
        }
        String string = null;
        String string2 = null;
        Repository repository2 = null;
        try {
            repository2 = (Repository)this.Proxy.GetService(Repository.class);
            ConfigRoot configRoot = repository2.getConfigRoot();
            string = configRoot.getValue(4);
            Resource resource = repository2.getConfigRoot().getResource(3, "serverindex.xml");
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry = (ServerEntry)iterator.next();
                if (!string.equals(serverEntry.getServerName())) continue;
                string2 = serverEntry.getGenericShortName();
                break;
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "Unable to get generic short name", exception);
            string2 = string;
        }
        finally {
            if (repository2 != null) {
                this.Proxy.ReleaseService(repository2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGenericShortName");
        }
        return string2;
    }

    void configureRoleBasedAuthz(ConfigRoot configRoot, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureRoleBasedAuthz", new Object[]{configRoot, string});
        }
        if (!string.equals("naming-authz")) {
            super.configureRoleBasedAuthz(configRoot, string);
        } else if (string.equals("naming-authz") && this.isController()) {
            super.configureRoleBasedAuthz(configRoot, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureRoleBasedAuthz");
        }
    }

    void initializeSecurityMBeans() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSecurityMBeans");
        }
        super.initializeSecurityMBeans();
        SecurityAdminHelper.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSecurityMBeans");
        }
    }

    boolean isController() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isController");
        }
        boolean bl = this.platformHelper.isControlJvm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isController", new Boolean(bl));
        }
        return bl;
    }
}

