/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.j2c;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.audit.AuditHandler;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.IdentityPrincipal;
import com.ibm.websphere.security.auth.MappingAuthData;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.j2c.WSAuthDataSubjectComparator;
import com.ibm.ws.security.auth.j2c.WSPrincipalMappingCallbackHandler;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.cred.AuthDataCredential;
import com.ibm.ws.security.util.AuthData;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import com.ibm.wsspi.security.auth.callback.WSMappingCallbackHandler;
import com.ibm.wsspi.security.auth.callback.WSMappingCallbackHandlerFactory;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;

public class WSDefaultPrincipalMapping {
    private static final TraceComponent tc = Tr.register(WSDefaultPrincipalMapping.class, null, "com.ibm.ejs.resources.security");
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("getPasswordCredential");
    private static HashMap authDataMap = null;
    private static HashMap authDataPasswordCredentialSubjectMap = new HashMap();
    public static String DEFAULT_PRINCIPAL_MAPPING = "DefaultPrincipalMapping";
    public static String TRUSTED_CONNECTION_MAPPING = "TrustedConnectionMapping";
    public static String KERBEROS_MAPPING = "KerberosMapping";
    public static String UNAUTHENTICATED = "UNAUTHENTICATED";
    private static final String CALLBACK_HANDLER = "CallbackHandler";
    private static boolean isFineGrained = false;
    private static WSMappingCallbackHandlerFactory cbkFactory = null;
    private static Subject unauthSubject = null;
    private static AuditHandler auditHandler = null;
    private static J2EEAuditEventFactory auditFactory = null;
    private static final String providerName = "WebSphere";
    private static AuditService auditService = null;
    private static final boolean providerSuccess = true;
    private static Object authDataSyncObject = new Object();
    private static boolean cacheReadOnlyAuthDataSubjects = false;
    private static int readOnlyAuthDataSubjectCacheSize = 50;
    private static final boolean providerFailure = false;
    private static long cushion = 180000L;
    static /* synthetic */ Class class$com$ibm$ws$security$common$auth$WSPrincipalImpl;

    private WSDefaultPrincipalMapping() {
        Tr.warning(tc, "security.j2c.invalidWSDefaultPrincipalMapping");
    }

    public static Subject getMappedSubject(ManagedConnectionFactory managedConnectionFactory, String string, Map map) throws IOException, LoginException, SecurityException, Exception {
        Serializable serializable;
        String string2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMappedSubject(ManagedConnectionFactory, " + string + ", Map properties)");
        }
        String string3 = string == null ? DEFAULT_PRINCIPAL_MAPPING : string.trim();
        boolean bl = DEFAULT_PRINCIPAL_MAPPING.equals(string3);
        boolean bl2 = TRUSTED_CONNECTION_MAPPING.equals(string3);
        boolean bl3 = KERBEROS_MAPPING.equals(string3);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (bl) {
                Tr.debug(tc, "defaultPrncipalMapping");
            } else if (bl2) {
                Tr.debug(tc, "trustedConnectionMapping");
            } else if (bl3) {
                Tr.debug(tc, "kerberosMapping");
            } else {
                Tr.debug(tc, "unknown login config >>" + string3 + "<<");
            }
        }
        if (auditService == null && (auditService = ContextManagerFactory.getInstance().getAuditService()) != null && (auditFactory = (J2EEAuditEventFactory)(auditHandler = auditService.newAuditHandler(string2 = "WAS.security", string2)).getAuditEventFactory("J2EE")) != null && !((Class)(serializable = Class.forName("com.ibm.wsspi.security.audit.J2EEAuditEventFactory"))).isInstance(auditFactory)) {
            auditFactory = null;
        }
        string2 = null;
        if (bl || bl2 || bl3) {
            Object object;
            Object object2;
            Object object3;
            Subject subject;
            if (map == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "security.j2c.missingParameter", new Object[]{"properties"});
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.entry(tc, "Getting authDataAlias.");
                }
                if ((string2 = (String)map.get("com.ibm.mapping.authDataAlias")) == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "security.j2c.missingParameter", new Object[]{"alias"});
                    }
                } else {
                    string2 = string2.trim();
                }
            }
            if (!ContextManagerFactory.getInstance().isCellSecurityEnabled() && (string2 == null || string2.equals(""))) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security disabled and no authdata alias, returning Unauthenticated Subject.");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMappedSubject");
                }
                return WSDefaultPrincipalMapping.getUnauthenticatedSubjectWithoutCredentials();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating Subject.");
            }
            serializable = ContextManagerFactory.getInstance().getInvocationCredential();
            Subject subject2 = new Subject();
            WSPrincipalImpl wSPrincipalImpl = null;
            String string4 = null;
            if (serializable != null && serializable.getExpiration() > 0L && serializable.getExpiration() - System.currentTimeMillis() < cushion) {
                subject = ContextManagerFactory.getInstance().getInvocationSubject();
                try {
                    wSPrincipalImpl = (WSPrincipalImpl)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return subject.getPrincipals(class$com$ibm$ws$security$common$auth$WSPrincipalImpl == null ? (class$com$ibm$ws$security$common$auth$WSPrincipalImpl = WSDefaultPrincipalMapping.class$("com.ibm.ws.security.common.auth.WSPrincipalImpl")) : class$com$ibm$ws$security$common$auth$WSPrincipalImpl).iterator().next();
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((string2 == null || string2.equals("")) && wSPrincipalImpl == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No authdata alias and current Subject is null or unauthenticated.");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMappedSubject");
                    }
                    return WSDefaultPrincipalMapping.getUnauthenticatedSubjectWithoutCredentials();
                }
                if (wSPrincipalImpl != null) {
                    string4 = wSPrincipalImpl.getName();
                } else {
                    string4 = UNAUTHENTICATED;
                    wSPrincipalImpl = new WSPrincipalImpl(string4);
                }
            } else {
                if ((string2 == null || string2.equals("")) && (serializable == null || serializable.isUnauthenticated())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No authdata alias and current Subject is null or unauthenticated.");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMappedSubject");
                    }
                    return WSDefaultPrincipalMapping.getUnauthenticatedSubjectWithoutCredentials();
                }
                string4 = serializable != null && !serializable.isUnauthenticated() ? serializable.getSecurityName() : UNAUTHENTICATED;
                wSPrincipalImpl = new WSPrincipalImpl(string4);
            }
            if (wSPrincipalImpl != null && string4 != null) {
                subject = null;
                if (cacheReadOnlyAuthDataSubjects && bl && string2 != null && !string2.equals("")) {
                    object3 = new WSAuthDataSubjectComparator(string4, string2, managedConnectionFactory);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting Subject authData uniqueID: " + ((WSAuthDataSubjectComparator)object3).hashCode());
                    }
                    subject = (Subject)authDataPasswordCredentialSubjectMap.get(object3);
                }
                if (subject == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not find subject in the authDataPasswordCredentialSubjectMap cache.");
                    }
                    subject2.getPrincipals().add(wSPrincipalImpl);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found subject in the authDataPasswordCredentialSubjectMap cache.");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMappedSubject");
                    }
                    subject2 = subject;
                    return subject2;
                }
            }
            subject = null;
            if (bl2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating identity principal.");
                }
                object3 = WSDefaultPrincipalMapping.getIdentityPrincipal(map);
                ((IdentityPrincipal)object3).setManagedConnectionFactory(managedConnectionFactory);
                subject2.getPrincipals().add((Principal)object3);
            }
            if (bl3) {
                object3 = WSSubject.getCallerSubject();
                if (object3 != null) {
                    object2 = SubjectHelper.getDefaultKerberosTokenFromSubject((Subject)object3);
                    if (object2 != null) {
                        GSSCredential gSSCredential = object2.getGSSCredential();
                        SubjectHelper.putGSSCredentialInSubject(gSSCredential, subject2);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "getMappedSubject - GSSCredential");
                        }
                        return subject2;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No KerberosToken in caller subject, fall back to " + DEFAULT_PRINCIPAL_MAPPING);
                    }
                    bl = true;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "No caller subject, fall back to " + DEFAULT_PRINCIPAL_MAPPING);
                    }
                    bl = true;
                }
            }
            if (string2 == null || string2.equals("")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No authdatalias, returning subject.");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMappedSubject");
                }
                return subject2;
            }
            object3 = null;
            try {
                object3 = WSDefaultPrincipalMapping.getAuthDataInt(string2);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got authdata info.");
                }
            }
            catch (NullPointerException nullPointerException) {
                Tr.warning(tc, "security.j2c.mappingFailed", (Object)new Object[]{nullPointerException});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMappedSubject");
                }
                return subject2;
            }
            if (object3 == null) {
                Tr.warning(tc, "security.j2c.mappingUnsuccessful");
                throw new LoginException("Incorrect authDataEntry and alias is: " + string2);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating password credential.");
            }
            object2 = new PasswordCredential(((AuthData)object3).uid, ((AuthData)object3).psw.toCharArray());
            ((PasswordCredential)object2).setManagedConnectionFactory(managedConnectionFactory);
            subject2.getPrivateCredentials().add(object2);
            if (cacheReadOnlyAuthDataSubjects) {
                if (authDataPasswordCredentialSubjectMap.size() > readOnlyAuthDataSubjectCacheSize) {
                    authDataPasswordCredentialSubjectMap.clear();
                }
                if (string4 != null && string2 != null) {
                    object = new WSAuthDataSubjectComparator(string4, string2, managedConnectionFactory);
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("com.ibm.wsspi.security.cred.cacheKey", Integer.toString(((WSAuthDataSubjectComparator)object).hashCode()));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting Subject authData uniqueID: " + ((WSAuthDataSubjectComparator)object).hashCode());
                    }
                    if (hashtable != null) {
                        subject2.getPublicCredentials().add(hashtable);
                    }
                    subject2.setReadOnly();
                    boolean bl4 = false;
                    int n = 0;
                    do {
                        try {
                            authDataPasswordCredentialSubjectMap.put(object, subject2);
                            bl4 = true;
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Got a ConcurrentModificationException, retry a few times and then give up.");
                        }
                    } while (!bl4 && ++n <= 5);
                }
            }
            if (auditFactory != null && auditFactory.isActive(2, 0)) {
                object = ContextManagerFactory.getInstance().getDefaultRealm();
                if (bl) {
                    auditFactory.sendMappingAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, string, true, (String)object, string4, "", ((AuthData)object3).uid, "security.audit.mapping.syccess.audit", null);
                } else if (bl2) {
                    auditFactory.sendMappingAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, string, true, (String)object, string4, "", (String)((Object)subject), "security.audit.mapping.syccess.audit", null);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getMappedSubject");
            }
            return subject2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Logging into mapping module: " + string3);
        }
        serializable = managedConnectionFactory;
        try {
            LoginContext loginContext = null;
            if (cbkFactory != null) {
                loginContext = new LoginContext(string3, cbkFactory.getInstance().getCallbackHandler(map, (ManagedConnectionFactory)serializable));
            } else {
                Tr.warning(tc, "security.j2c.initFailureRecovery");
                loginContext = new LoginContext(string3, new WSMappingCallbackHandler(map, (ManagedConnectionFactory)serializable));
            }
            loginContext.login();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getMappedSubject(ManagedConnectionFactory, loginEntry, authDataAlias)");
            }
            if (auditFactory != null && auditFactory.isActive(2, 0)) {
                WSCredential wSCredential = ContextManagerFactory.getInstance().getInvocationCredential();
                String string5 = null;
                String string6 = ContextManagerFactory.getInstance().getDefaultRealm();
                if (wSCredential != null && !wSCredential.isUnauthenticated()) {
                    string5 = wSCredential.getSecurityName();
                }
                String string7 = null;
                String string8 = null;
                String string9 = null;
                byte[] byArray = null;
                Subject subject = loginContext.getSubject();
                if (subject != null) {
                    PasswordCredential passwordCredential;
                    Object object;
                    Iterator<?> iterator = subject.getPrincipals(Class.forName("com.ibm.websphere.security.auth.IdentityPrincipal")).iterator();
                    if (iterator.hasNext() && (object = (IdentityPrincipal)iterator.next()) != null) {
                        string7 = ((IdentityPrincipal)object).getName();
                        string8 = ((IdentityPrincipal)object).getRealm();
                        string9 = ((IdentityPrincipal)object).getOriginalUser();
                        byArray = ((IdentityPrincipal)object).getToken();
                    }
                    if (string7 == null && (object = subject.getPrivateCredentials(Class.forName("javax.resource.spi.security.PasswordCredential")).iterator()).hasNext() && (passwordCredential = (PasswordCredential)object.next()) != null) {
                        string7 = passwordCredential.getUserName();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "IdentityPrincipal current user identity  = " + string7);
                        Tr.debug(tc, "IdentityPrincipal current user realm     = " + string8);
                        Tr.debug(tc, "IdentityPrincipal original user identity = " + string9);
                        if (byArray != null) {
                            Tr.debug(tc, "IdentityPrincipal token length           = " + byArray.length);
                        }
                    }
                    auditFactory.sendMappingAuditEvent(auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, string, true, string6, string5, "", string7, "security.audit.mapping.syccess.audit", null);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning login subject.");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getMappedSubject");
            }
            return loginContext.getSubject();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping.getSubject", "351");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught: " + exception);
            }
            throw exception;
        }
    }

    public static Subject getSubject(ManagedConnectionFactory managedConnectionFactory, String string, String string2) throws IOException, LoginException, SecurityException, Exception {
        String string3;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject(ManagedConnectionFactory, " + string + ", " + string2 + ")");
        }
        String string4 = null;
        if (string2 != null) {
            string4 = string2.trim();
        }
        String string5 = string3 = string == null ? DEFAULT_PRINCIPAL_MAPPING : string.trim();
        if (string3.equals(DEFAULT_PRINCIPAL_MAPPING)) {
            Subject subject = new Subject();
            final Subject subject2 = ContextManagerFactory.getInstance().getInvocationSubject();
            WSPrincipalImpl wSPrincipalImpl = null;
            try {
                wSPrincipalImpl = (WSPrincipalImpl)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return subject2.getPrincipals(class$com$ibm$ws$security$common$auth$WSPrincipalImpl == null ? (class$com$ibm$ws$security$common$auth$WSPrincipalImpl = WSDefaultPrincipalMapping.class$("com.ibm.ws.security.common.auth.WSPrincipalImpl")) : class$com$ibm$ws$security$common$auth$WSPrincipalImpl).iterator().next();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (wSPrincipalImpl != null) {
                subject.getPrincipals().add(wSPrincipalImpl);
            }
            if (string4 == null || string4.equals("")) {
                return subject;
            }
            AuthData authData = null;
            try {
                authData = WSDefaultPrincipalMapping.getAuthDataInt(string4);
            }
            catch (NullPointerException nullPointerException) {
                Tr.warning(tc, "security.j2c.mappingFailed", (Object)new Object[]{nullPointerException});
                return subject;
            }
            if (authData == null) {
                Tr.warning(tc, "security.j2c.mappingUnsuccessful");
                throw new LoginException("Incorrect authDataEntry and alias is: " + string4);
            }
            PasswordCredential passwordCredential = new PasswordCredential(authData.uid, authData.psw.toCharArray());
            passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
            subject.getPrivateCredentials().add(passwordCredential);
            return subject;
        }
        ManagedConnectionFactory managedConnectionFactory2 = managedConnectionFactory;
        try {
            LoginContext loginContext = new LoginContext(string3, new WSPrincipalMappingCallbackHandler(string4, managedConnectionFactory2));
            loginContext.login();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSubject(ManagedConnectionFactory, loginEntry, authDataAlias)");
            }
            return loginContext.getSubject();
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping.getSubject", "351");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught: " + exception);
            }
            throw exception;
        }
    }

    public static AuthDataCredential getAuthData(String string) throws LoginException, SecurityException {
        AuthData authData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getAuthData(uidpswEntry = " + string + ")");
        }
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        try {
            authData = WSDefaultPrincipalMapping.getAuthDataInt(string);
        }
        catch (NullPointerException nullPointerException) {
            return new AuthDataCredential(null, null, 3);
        }
        if (authData != null) {
            return new AuthDataCredential(authData.uid, authData.psw, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Alias not defined on server; local search not enabled or auth.data.props not loaded.");
        }
        return new AuthDataCredential(null, null, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAuthData(HashMap hashMap) throws SecurityException {
        Set set;
        block16: {
            SecurityManager securityManager;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "refreshAuthData");
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + perm.toString());
                }
                securityManager.checkPermission(perm);
            }
            try {
                if (hashMap != null && !hashMap.isEmpty()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Mapping auth data has " + hashMap.size() + " entries");
                    }
                    set = hashMap.keySet();
                    Iterator iterator = set.iterator();
                    Class<?> clazz = Class.forName("com.ibm.ws.security.util.AuthData");
                    Class<?> clazz2 = Class.forName("com.ibm.websphere.security.auth.MappingAuthData");
                    while (iterator.hasNext()) {
                        Object v;
                        Object k = iterator.next();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Mapping auth data alias = " + k);
                        }
                        if ((v = hashMap.get(k)) == null) continue;
                        if (clazz2.isInstance(v)) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Mapping auth data Class is MappingAuthData");
                            }
                            hashMap.put(k, new AuthData(((MappingAuthData)v).getUserName(), ((MappingAuthData)v).getPassword()));
                            continue;
                        }
                        if (clazz.isInstance(v)) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Mapping auth data Class is neither AuthData nor MappingAuthData; set to null");
                        }
                        hashMap.put(k, null);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping.refreshAuthData", "569");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Exception caught: " + exception);
            }
        }
        set = authDataSyncObject;
        synchronized (set) {
            authDataMap = hashMap;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshAuthData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthData getAuthDataInt(String string) throws SecurityException {
        Object object;
        SecurityManager securityManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getOneAuthDataEntry(uidpswEntry = " + string + ")");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (!isFineGrained) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + perm.toString());
                }
                securityManager.checkPermission(perm);
            } else {
                object = new WebSphereRuntimePermission("getPasswordCredential." + string);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check (Fine Grained) ...");
                    Tr.debug(tc, "Expecting : " + ((Permission)object).toString());
                }
                securityManager.checkPermission((Permission)object);
            }
        }
        object = authDataSyncObject;
        synchronized (object) {
            if (authDataMap != null) {
                return (AuthData)authDataMap.get(string);
            }
        }
        return null;
    }

    private static Subject getUnauthenticatedSubjectWithoutCredentials() {
        if (unauthSubject == null) {
            unauthSubject = new Subject();
            WSPrincipalImpl wSPrincipalImpl = new WSPrincipalImpl("UNAUTHENTICATED");
            unauthSubject.getPrincipals().add(wSPrincipalImpl);
        }
        return unauthSubject;
    }

    public static IdentityPrincipal getIdentityPrincipal(Map map) throws WSSecurityException, CredentialDestroyedException, WSLoginFailedException, ClassNotFoundException, CredentialExpiredException {
        boolean bl = false;
        boolean bl2 = false;
        WSCredential wSCredential = null;
        Subject subject = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        byte[] byArray = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting useCallerIdentity.");
        }
        String string4 = (String)map.get("com.ibm.mapping.useCallerIdentity");
        String string5 = "true";
        if (string4 != null) {
            string4 = string4.trim();
            bl = string5.equalsIgnoreCase(string4);
        }
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "useCallerIdentity is true");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "useCallerIdentity is either false or not specified");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting propagateSecAttrs.");
        }
        if ((string4 = (String)map.get("com.ibm.mapping.propagateSecAttrs")) != null) {
            string4 = string4.trim();
            bl2 = string5.equalsIgnoreCase(string4);
        }
        if (bl2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "propagateSecAttrs is true");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "propagateSecAttrs is either false or not specified");
        }
        wSCredential = ContextManagerFactory.getInstance().getInvocationCredential();
        String string6 = null;
        if (bl) {
            Iterator<?> iterator;
            subject = ContextManagerFactory.getInstance().getCallerSubject();
            if (subject != null && (iterator = subject.getPublicCredentials(Class.forName("com.ibm.websphere.security.cred.WSCredential")).iterator()) != null && iterator.hasNext()) {
                wSCredential = (WSCredential)iterator.next();
            }
        } else {
            subject = ContextManagerFactory.getInstance().getInvocationSubject();
        }
        if (wSCredential != null && !wSCredential.isUnauthenticated()) {
            string6 = wSCredential.getSecurityName();
            string = wSCredential.getRealmName();
            if (string6 != null) {
                int n = string6.indexOf(UNAUTHENTICATED);
                if (n > -1 && n < string6.length()) {
                    string3 = new String((String)map.get("com.ibm.mapping.unauthenticatedUser"));
                } else {
                    string3 = string6;
                    int n2 = string3.indexOf(47);
                    if (n2 > -1 && n2 < string3.length()) {
                        string3 = string3.substring(n2 + 1);
                    }
                }
            } else {
                string3 = (String)map.get("com.ibm.mapping.unauthenticatedUser");
            }
        } else {
            string3 = (String)map.get("com.ibm.mapping.unauthenticatedUser");
        }
        string3 = string3 == null || string3 != null && string3.length() == 0 ? UNAUTHENTICATED : string3.trim();
        String string7 = (String)map.get("com.ibm.mapping.targetRealmName");
        if (string7 != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "targetRealm is \"" + string7 + "\" length = " + string7.length());
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "targetRealm is either null or undefined");
        }
        if (string7 != null && string7.length() > 0) {
            string7 = string7.trim();
        }
        if (string7 != null && string7.length() == 0) {
            string7 = null;
        }
        if (string7 == null || string7.equals("") || string7.equals("\"\"")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "targetRealm is null, setting current realm to null.");
            }
            string = null;
        } else if (string7 != null && string != null && string7.length() > 0 && string.length() > 0 && string7.equalsIgnoreCase(string)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "targetRealm is identical to current realm = " + string7);
            }
            string = null;
        }
        string2 = WSSecurityHelper.getFirstCaller();
        if (string2 == null) {
            string2 = UNAUTHENTICATED;
        }
        if (subject != null && bl2) {
            ContextManagerFactory.getInstance().renew(subject, 50, false);
            byArray = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(subject);
        }
        IdentityPrincipal identityPrincipal = new IdentityPrincipal(string3, string, string2, byArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "current user identity  = " + string3);
            Tr.debug(tc, "current user realm     = " + string);
            Tr.debug(tc, "original user identity = " + string2);
            Tr.debug(tc, "propagate security attributes = " + bl2);
            if (byArray != null) {
                Tr.debug(tc, "opaque token length = " + byArray.length);
            } else {
                Tr.debug(tc, "opaque token is null");
            }
        }
        return identityPrincipal;
    }

    public static Map getDefaultTrustedConnectionProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("com.ibm.mapping.useCallerIdentity", "false");
        hashMap.put("com.ibm.mapping.propagateSecAttrs", "false");
        hashMap.put("com.ibm.mapping.targetRealmName", null);
        hashMap.put("com.ibm.mapping.unauthenticatedUser", UNAUTHENTICATED);
        return hashMap;
    }

    static {
        try {
            String string;
            Boolean bl = Boolean.TRUE;
            Class<?> clazz = Class.forName("com.ibm.ws.security.core.SecurityConfig");
            Method method2 = clazz.getMethod("getConfig", null);
            Method method3 = clazz.getMethod("getValue", String.class);
            Object object = method2.invoke(null, new Object[0]);
            String string2 = "security.enforceFineGrainedJCASecurity";
            try {
                bl = (Boolean)method3.invoke(object, string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bl != null) {
                isFineGrained = bl;
            }
            string2 = "security.mappingCallbackHandlerFactoryClass";
            String string3 = "com.ibm.ws.security.auth.callback.WSMappingCallbackHandlerFactoryImpl";
            try {
                string = (String)method3.invoke(object, string2);
                if (string == null) {
                    Tr.info(tc, "security.j2c.calbackHandlerFactoryUndefined", new Object[]{"security.mappingCallbackHandlerFactoryClass"});
                    string = string3;
                }
            }
            catch (Throwable throwable) {
                string = string3;
            }
            if (string != null && string.length() > 0) {
                string = string.trim();
            }
            cbkFactory = WSMappingCallbackHandlerFactory.getInstance(string);
            string2 = "security.CacheCushionMin";
            long l = 0L;
            try {
                l = (Integer)method3.invoke(object, string2) * 60 * 1000;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (l != 0L) {
                cushion = l;
            }
            string2 = "com.ibm.websphere.security.auth.j2c.cacheReadOnlyAuthDataSubjects";
            try {
                Boolean bl2 = (Boolean)method3.invoke(object, string2);
                if (bl2 != null) {
                    cacheReadOnlyAuthDataSubjects = bl2;
                }
                if (cacheReadOnlyAuthDataSubjects) {
                    System.setProperty(string2, "true");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            string2 = "com.ibm.websphere.security.auth.j2c.readOnlyAuthDataSubjectCacheSize";
            try {
                String string4 = (String)method3.invoke(object, string2);
                if (string4 != null) {
                    readOnlyAuthDataSubjectCacheSize = Integer.parseInt(string4);
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping.static", "133");
            Tr.error(tc, "security.j2c.initFailure", new Object[]{exception});
        }
    }
}

