/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import [Ljava.lang.String;;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.scripting.DefaultStringHandler;
import com.ibm.ws.scripting.ExtensionHelper;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.JaclUtilities;
import com.ibm.ws.scripting.JythonUtilities;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ObjectNameHelper;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminCmd;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;

public class AdminCmdScriptGenerator
extends AdminCmd {
    public static String CMD_FRAMEWORK_SCRIPTING_OBJECT = "AdminTask";
    private static TraceComponent tc = Tr.register(AdminCmdScriptGenerator.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private LanguageUtilities _langUtil;
    private DefaultStringHandler _handler;

    public AdminCmdScriptGenerator(String string) throws ScriptingException {
        this.setLanguage(string);
        this._handler = new DefaultStringHandler(this._langUtil);
        ExtensionHelper.processRegisterHandlersInExtensions();
    }

    public void setLanguage(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLanguage", new Object[]{string});
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.scripting.resources.wscpMessage", Locale.getDefault());
        if (string.equalsIgnoreCase("jacl")) {
            this._langUtil = new JaclUtilities(resourceBundle);
        } else if (string.equalsIgnoreCase("jython")) {
            this._langUtil = new JythonUtilities(resourceBundle);
        } else {
            throw new ScriptingException(ObjectNameHelper.getFormattedMessage("WASX8010E", "Invalid scripting language: " + string, new Object[]{string}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLanguage");
        }
    }

    public String getLanguage() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLanguage");
        }
        String string = null;
        if (this._langUtil != null) {
            if (this._langUtil instanceof JaclUtilities) {
                string = "jacl";
            } else if (this._langUtil instanceof JythonUtilities) {
                string = "jython";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLanguage - " + string);
        }
        return string;
    }

    public String generateScriptFromCmd(AdminCommand adminCommand) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateScriptFromCmd", new Object[]{adminCommand.getName()});
        }
        String string = adminCommand.getName();
        Object object = adminCommand.getTargetObject();
        String string2 = null;
        if (object != null && (string2 = this.formDisplayString(object)).indexOf(" ") >= 0 && !string2.startsWith("\"") && !string2.endsWith("\"")) {
            string2 = "\"" + string2 + "\"";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "target object string: " + string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Collection collection = adminCommand.listSetParams();
        String string3 = this.buildParameters(adminCommand, collection);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parameter string: " + string3);
        }
        String string4 = null;
        if (adminCommand instanceof TaskCommand) {
            string4 = this.buildSteps((TaskCommand)adminCommand);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "step string: " + string4);
            }
        }
        String string5 = this._langUtil.buildAdminCmdString(CMD_FRAMEWORK_SCRIPTING_OBJECT, adminCommand.getName(), string2, string3, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateScriptFromCmd - " + string5);
        }
        return string5;
    }

    private String buildParameters(AdminCommand adminCommand, Collection collection) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildParameters", new Object[]{collection});
        }
        Iterator iterator = collection.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        CommandMetadata commandMetadata = adminCommand.getCommandMetadata();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string;
            bl = false;
            String string2 = (String)iterator.next();
            if (string2.toLowerCase().indexOf("password") >= 0 || string2.toLowerCase().indexOf("pwd") >= 0) {
                bl = true;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (string2.toLowerCase().indexOf("path") >= 0) {
                bl2 = true;
            }
            if (stringBuffer.toString().length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("-");
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            Object object = null;
            try {
                object = adminCommand.getParameter(string2);
                if (bl) {
                    object = "*****";
                }
                string = object.toString();
                if (bl2 && string.indexOf(92) >= 0) {
                    string = string.replace('\\', '/');
                    object = string;
                }
            }
            catch (InvalidParameterNameException invalidParameterNameException) {
                throw new ScriptingException();
            }
            string = this.formDisplayString(object);
            if (string.indexOf(" ") >= 0 && !string.startsWith("\"") && !string.endsWith("\"")) {
                string = "\"" + string + "\"";
            }
            stringBuffer.append(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildParameters - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private String buildSteps(TaskCommand taskCommand) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildSteps");
        }
        String[] stringArray = taskCommand.listCommandSteps();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            CommandStep commandStep = taskCommand.getCommandStep(stringArray[i]);
            if (!commandStep.isEnabled()) continue;
            CommandStepMetadata commandStepMetadata = (CommandStepMetadata)commandStep.getCommandMetadata();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (commandStepMetadata.isTable()) {
                for (int j = 0; j < commandStep.getNumberOfRows(); ++j) {
                    object = commandStep.listSetParams(j);
                    String string = this.buildStepParameters((Collection)object, commandStep, commandStepMetadata, j);
                    if (string == null || string.length() == 0) continue;
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(" ");
                    }
                    stringBuffer2.append(this._langUtil.getOpenNestedAttribute());
                    stringBuffer2.append(string);
                    stringBuffer2.append(this._langUtil.getCloseNestedAttribute());
                }
            } else {
                Collection collection = commandStep.listSetParams(0);
                object = this.buildParameters(commandStep, collection);
                stringBuffer2.append((String)object);
                Tr.debug(tc, "aStepParamString " + stringBuffer2);
            }
            if (stringBuffer2.length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("-");
            stringBuffer.append(commandStep.getName());
            stringBuffer.append(" ");
            stringBuffer.append(this._langUtil.getOpenNestedAttribute());
            stringBuffer.append(stringBuffer2.toString());
            stringBuffer.append(this._langUtil.getCloseNestedAttribute());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildSteps - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private String buildStepParameters(Collection collection, CommandStep commandStep, CommandStepMetadata commandStepMetadata, int n) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildStepParameters - " + collection + " " + n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!collection.isEmpty()) {
            EList eList = commandStepMetadata.getParameters();
            for (int i = 0; i < eList.size(); ++i) {
                ParameterMetadata parameterMetadata = (ParameterMetadata)eList.get(i);
                Object object = null;
                try {
                    if (!parameterMetadata.isReadonly() || parameterMetadata.isKeyField()) {
                        object = commandStep.getParameter(parameterMetadata.getName(), n);
                    }
                }
                catch (InvalidParameterNameException invalidParameterNameException) {
                    // empty catch block
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                if (object == null || parameterMetadata.isReadonly() && !parameterMetadata.isKeyField()) {
                    stringBuffer.append("\"\"");
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Param name: " + parameterMetadata.getName() + " " + "value: \"\"");
                    continue;
                }
                String string = this.formDisplayString(object);
                if (string.indexOf(" ") >= 0 && !string.startsWith("\"") && !string.endsWith("\"")) {
                    string = "\"" + string + "\"";
                }
                stringBuffer.append(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildStepParameters - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    protected String formDisplayString(Object object) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formDisplayString", new Object[]{object});
        }
        String string = new String();
        if (object == null) {
            string = new String("null");
        } else {
            StringHandler stringHandler = null;
            Class<?> clazz = object.getClass();
            if (clazz != null) {
                stringHandler = HandlerRegistry.getHandler(clazz);
            }
            if (stringHandler != null) {
                string = stringHandler.formDisplayString(object, this.getLanguage());
                if (clazz == String;.class) {
                    int n;
                    String string2 = System.getProperty("line.separator");
                    while ((n = string.indexOf(string2)) != -1) {
                        StringBuffer stringBuffer = new StringBuffer(string);
                        stringBuffer.replace(n, n + string2.length(), ";");
                        string = stringBuffer.toString();
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formDisplayString - " + string);
        }
        return string;
    }
}

