/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.logging.MessageConverter;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.ScriptingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Locale;

public class MessageLookup {
    protected static final TraceComponent tc = Tr.register(MessageLookup.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static String directory = null;

    public static boolean initializeMessageDB(Locale locale) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeMessageDB ", new Object[]{locale});
        }
        boolean bl = false;
        String string = locale.toString();
        directory = MessageLookup.getDirectory(string);
        if (directory == null && (n = string.lastIndexOf(95)) > 0) {
            string = string.substring(0, n);
            directory = MessageLookup.getDirectory(string);
        }
        if (directory != null) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeMessageDB");
        }
        return bl;
    }

    private static String getDirectory(String string) {
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDirectory " + string);
        }
        String string2 = null;
        String string3 = System.getProperty("was.install.root") + File.separator + "properties" + File.separator + "messages" + File.separator + string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Directory is " + directory);
        }
        if ((file = new File(string3)).exists()) {
            string2 = string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDirectory " + directory);
        }
        return string2;
    }

    public static String getMessages(AbstractShell abstractShell, String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessages " + string);
        }
        abstractShell.setLastException(null);
        StringBuffer stringBuffer = new StringBuffer();
        if (directory == null) {
            abstractShell.setAndThrowScriptingException("WASX7364E", "no help available", new Object[]{string});
        }
        try {
            File file = new File(directory);
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(".xml");
                }
            });
            String string2 = string;
            if (MessageConverter.determineMsgType(string) == MessageConverter.MESSAGE_ID_V6) {
                string2 = MessageConverter.convert(string, MessageConverter.CONVERSION_TYPE_WASV6_TO_WASV5);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                FileInputStream fileInputStream = new FileInputStream(directory + File.separator + stringArray[i]);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                String string3 = MessageLookup.getMessage(new String(byArray), string2);
                fileInputStream.close();
                if (string3 == null) continue;
                String string4 = MessageLookup.getExplanation(string3);
                String string5 = MessageLookup.getUserAction(string3);
                stringBuffer.append(abstractShell.getFormattedMessage("WASX7362I", new Object[]{string4.trim(), string5.trim()}, "Explanation: {0}\n User action: {1}\n"));
                break;
            }
        }
        catch (Exception exception) {
            abstractShell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessages");
        }
        return stringBuffer.toString();
    }

    private static String getMessage(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessage " + string2);
        }
        String string3 = null;
        int n = string.indexOf("<Message ID=\"" + string2);
        if (n != -1) {
            String string4 = string.substring(n);
            int n2 = string4.indexOf("</Message>");
            string3 = string4.substring(0, n2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessage");
        }
        return string3;
    }

    private static String getExplanation(String string) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExplanation " + string);
        }
        String string2 = null;
        int n2 = string.indexOf("<Explanation>");
        if (n2 != -1 && (n = string.indexOf("</Explanation>")) != -1) {
            String string3 = string.substring(n2, n);
            int n3 = string3.indexOf(">");
            string2 = string3.substring(n3 + 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExplanation");
        }
        return string2;
    }

    private static String getUserAction(String string) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserAction " + string);
        }
        String string2 = null;
        int n2 = string.indexOf("<UserResponse>");
        if (n2 != -1 && (n = string.indexOf("</UserResponse>")) != -1) {
            String string3 = string.substring(n2, n);
            int n3 = string3.indexOf(">");
            string2 = string3.substring(n3 + 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserAction");
        }
        return string2;
    }
}

